/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.Debug;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SearchStrategy;
import agg.util.csp.Search_BreadthFirst;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Variable;
import com.objectspace.jgl.HashSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Solution_Backtrack
implements SolutionStrategy {
    private CSP itsCSP;
    private Vector itsQueries = new Vector(20, 10);
    private Dictionary itsVarIndexMap;
    private boolean itsInjectiveFlag;
    private Dictionary itsInstanceVarMap;
    private SearchStrategy itsSearcher = new Search_BreadthFirst();
    private HashSet itsBackjumpTargets = new HashSet();
    private int itsDirection;
    private int itsCurrentIndex;
    private Variable itsCurrentVar;
    private int itsState;
    private int itsInstantiationCounter;
    private int itsBackstepCounter;
    private static final int START = 1;
    private static final int NEXT = 2;
    private static final int INSTANTIATE = 3;
    private static final int BACK = 4;
    private static final int SUCCESS = 5;
    private static final int NO_MORE_SOLUTIONS = 6;
    private static final int BACKJUMP = 7;

    public Solution_Backtrack() {
        this.itsInjectiveFlag = false;
    }

    public Solution_Backtrack(boolean injective) {
        this.itsInjectiveFlag = injective;
    }

    private final boolean initialize(CSP csp) {
        this.itsCSP = csp;
        this.itsQueries.removeAllElements();
        this.itsQueries = this.itsSearcher.execute(this.itsCSP);
        this.itsQueries.trimToSize();
        this.itsInstanceVarMap = new Hashtable(this.itsCSP.getSize());
        this.itsVarIndexMap = new Hashtable(this.itsCSP.getSize());
        for (int i = 0; i < this.itsQueries.size(); ++i) {
            this.itsVarIndexMap.put(((Query)this.itsQueries.elementAt(i)).getTarget(), new Integer(i));
        }
        Enumeration anEnum = this.itsCSP.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = (Variable)anEnum.nextElement();
            if (aVar.getInstance() == null) continue;
            if (aVar.checkConstraints().hasMoreElements()) {
                return false;
            }
            this.itsVarIndexMap.put(aVar, new Integer(-1));
            this.itsInstanceVarMap.put(aVar.getInstance(), aVar);
        }
        return true;
    }

    public final void reset() {
        Debug.println("Resetting!", this);
        this.itsState = 1;
    }

    public final boolean next(CSP csp) {
        if (!csp.equals(this.itsCSP)) {
            Debug.println("Got new CSP!", this);
            if (!this.initialize(csp)) {
                return false;
            }
            this.itsState = 1;
        }
        if (this.itsState == 5) {
            this.itsState = 4;
            ++this.itsCurrentIndex;
        }
        block9: while (true) {
            switch (this.itsState) {
                case 1: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- START", this);
                    this.itsInstantiationCounter = 0;
                    this.itsBackstepCounter = 0;
                    this.itsCurrentIndex = -1;
                    this.itsState = 2;
                    continue block9;
                }
                case 2: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- NEXT", this);
                    if (this.itsCurrentIndex >= this.itsQueries.size() - 1) {
                        this.itsState = 5;
                    } else {
                        this.itsBackjumpTargets.clear();
                        Query aCurrentQuery = (Query)this.itsQueries.elementAt(++this.itsCurrentIndex);
                        this.itsCurrentVar = aCurrentQuery.getTarget();
                        if (aCurrentQuery.isApplicable()) {
                            Debug.println("used Query: " + aCurrentQuery, this);
                            this.itsCurrentVar.setDomainEnum(aCurrentQuery.execute());
                            if (aCurrentQuery.getDomainSize() > 0) {
                                this.addToBackjumpTargets(aCurrentQuery.getSources());
                            }
                        } else {
                            this.itsState = 6;
                        }
                        this.itsState = 3;
                    }
                    this.itsDirection = 2;
                    continue block9;
                }
                case 3: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- INSTANTIATE", this);
                    this.itsState = 4;
                    Enumeration aDomain = this.itsCurrentVar.getDomainEnum();
                    while (true) {
                        if (!aDomain.hasMoreElements()) continue block9;
                        ++this.itsInstantiationCounter;
                        this.itsCurrentVar.setInstance(aDomain.nextElement());
                        Variable aConflictVar = this.checkInjection(this.itsCurrentVar);
                        if (aConflictVar != null) {
                            this.itsCurrentVar.setInstance(null);
                            this.itsBackjumpTargets.add(aConflictVar);
                            continue;
                        }
                        Enumeration allConflictVars = this.itsCurrentVar.checkConstraints();
                        if (!allConflictVars.hasMoreElements()) {
                            this.itsState = 2;
                            this.addInjection(this.itsCurrentVar);
                            continue block9;
                        }
                        if (this.itsState != 7) continue;
                        this.itsBackjumpTargets.add(this.getFirstOf(allConflictVars));
                    }
                }
                case 4: {
                    ++this.itsBackstepCounter;
                    Debug.println("[" + this.itsCurrentIndex + "] -- BACK", this);
                    if (this.itsCurrentIndex == 0) {
                        if (this.itsCurrentVar != null && this.itsCurrentVar.getDomainEnum().hasMoreElements()) {
                            this.removeInjection(this.itsCurrentVar);
                            this.itsCurrentVar.setInstance(null);
                            this.itsState = 3;
                            this.itsDirection = 2;
                            continue block9;
                        }
                        this.itsState = 6;
                        this.itsDirection = 4;
                        continue block9;
                    }
                    this.removeInjection(this.itsCurrentVar);
                    this.itsCurrentVar.setInstance(null);
                    this.itsCurrentVar = ((Query)this.itsQueries.elementAt(--this.itsCurrentIndex)).getTarget();
                    this.removeInjection(this.itsCurrentVar);
                    this.itsState = 3;
                    this.itsDirection = 4;
                    continue block9;
                }
                case 7: {
                    ++this.itsBackstepCounter;
                    int aStepCounter = 0;
                    Debug.println("[" + this.itsCurrentIndex + "] -- BACKJUMP: ", this);
                    this.itsState = 6;
                    while (this.itsCurrentIndex > 0) {
                        ++aStepCounter;
                        this.removeInjection(this.itsCurrentVar);
                        this.itsCurrentVar.setInstance(null);
                        this.itsCurrentVar = ((Query)this.itsQueries.elementAt(--this.itsCurrentIndex)).getTarget();
                        this.removeInjection(this.itsCurrentVar);
                        if (this.itsBackjumpTargets.find(this.itsCurrentVar).equals(this.itsBackjumpTargets.end())) continue;
                        this.itsState = 3;
                        break;
                    }
                    if (this.itsCurrentIndex == 0 && this.itsState != 3) {
                        this.itsState = 3;
                    }
                    Debug.println("Jumped " + aStepCounter + " steps.", this);
                    this.itsDirection = 4;
                    continue block9;
                }
                case 5: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- SUCCESS. " + this.itsInstantiationCounter + " variable instantiations so far.", this);
                    return true;
                }
                case 6: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- NO_MORE_SOLUTIONS after " + this.itsInstantiationCounter + " variable instantiations", this);
                    Debug.println("\t\t\tand " + this.itsBackstepCounter + " backsteps.", this);
                    return false;
                }
            }
            System.out.println("Should have never come here..." + this.itsState);
        }
    }

    public boolean hasMoreSolutions() {
        return this.itsState != 6;
    }

    private final Variable getFirstOf(Enumeration vars) {
        Variable aFirstVar = (Variable)vars.nextElement();
        int aFirstIndex = this.itsQueries.size();
        while (vars.hasMoreElements()) {
            Variable aCurrentVar = (Variable)vars.nextElement();
            int aCurrentIndex = (Integer)this.itsVarIndexMap.get(aCurrentVar);
            if (aCurrentIndex >= aFirstIndex) continue;
            aFirstIndex = aCurrentIndex;
            aFirstVar = aCurrentVar;
        }
        return aFirstVar;
    }

    private final void addInjection(Variable var) {
        if (this.itsInjectiveFlag) {
            this.itsInstanceVarMap.put(var.getInstance(), var);
        }
    }

    private final void removeInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            this.itsInstanceVarMap.remove(var.getInstance());
        }
    }

    private final Variable checkInjection(Variable var) {
        if (this.itsInjectiveFlag) {
            return (Variable)this.itsInstanceVarMap.get(var.getInstance());
        }
        return null;
    }

    private final void addToBackjumpTargets(Enumeration en) {
        while (en.hasMoreElements()) {
            this.itsBackjumpTargets.add(en.nextElement());
        }
    }
}

