/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.convert.ConverterXML;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Graph;
import agg.xt_basis.LayeredGraTraImpl;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import java.io.File;

public class AGGBasicAppl
implements GraTraEventListener {
    private static GraGra gragra;
    private static Graph impGraph;
    private static GraTra gratra;
    private int msgGraTra;
    private static boolean layered;
    private static boolean didTransformation;
    private static String fileName;
    private static String impFileName;
    private static String outputFileName;
    private static String error;
    static XMLHelper h;

    public AGGBasicAppl() {
    }

    public AGGBasicAppl(String filename) {
        fileName = filename;
        System.out.println("File name:  " + fileName);
        gragra = AGGBasicAppl.load(fileName);
        if (gragra != null) {
            int levelOfTGcheck = gragra.getLevelOfTypeGraphCheck();
            AGGBasicAppl.transform(gragra, this);
            if (didTransformation) {
                String out = "_out.ggx";
                AGGBasicAppl.save(gragra, out);
                System.out.println("Output file:  " + outputFileName);
                if (gratra instanceof DefaultGraTraImpl) {
                    System.out.println("Transformation protocol: " + ((DefaultGraTraImpl)gratra).getProtocolName());
                } else if (gratra instanceof LayeredGraTraImpl) {
                    System.out.println("Transformation protocol: " + ((LayeredGraTraImpl)gratra).getProtocolName());
                }
            } else {
                System.out.println("Grammar:  " + gragra.getName() + "   could not perform any transformations!");
            }
        } else {
            System.out.println("Grammar:  " + filename + "   FAILED!");
        }
    }

    public AGGBasicAppl(String filename, String impFilename) {
        fileName = filename;
        impFileName = impFilename;
        System.out.println("File name:  " + fileName);
        gragra = AGGBasicAppl.load(fileName);
        if (gragra != null) {
            int levelOfTGcheck = gragra.getLevelOfTypeGraphCheck();
            System.out.println("Import file name:  " + impFileName);
            impGraph = AGGBasicAppl.importGraph(impFilename);
            if (impGraph != null) {
                gragra.setLevelOfTypeGraphCheck(0);
                if (!gragra.importGraph(impGraph)) {
                    System.out.println("Error:  Import graph has failed! Please check types of the import. ");
                    return;
                }
                System.out.println("Importing graph was successful.");
                if (gragra.getTypeSet().hasInheritance()) {
                    if (levelOfTGcheck != 0) {
                        gragra.setLevelOfTypeGraphCheck(levelOfTGcheck);
                    } else {
                        gragra.setLevelOfTypeGraphCheck(10);
                    }
                } else {
                    gragra.setLevelOfTypeGraphCheck(levelOfTGcheck);
                }
                AGGBasicAppl.save(gragra, "Impot_" + fileName);
                System.out.println("Import is written into:  Impot_" + fileName);
                AGGBasicAppl.transform(gragra, this);
                if (didTransformation) {
                    String out = "_out.ggx";
                    AGGBasicAppl.save(gragra, out);
                    System.out.println("Output file:  " + outputFileName);
                    if (gratra instanceof DefaultGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((DefaultGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof LayeredGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((LayeredGraTraImpl)gratra).getProtocolName());
                    }
                } else {
                    System.out.println("Grammar:  " + gragra.getName() + "   could not perform any transformations!");
                }
            } else {
                System.out.println(impFilename + "   FAILED!");
            }
        } else {
            System.out.println("Grammar:  " + filename + "   FAILED!");
        }
    }

    public static void main(String[] args) {
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.4.2") < 0) {
            System.out.println("WARNING : Swing must be run with the 1.4.2 version of the JVM.");
        }
        if (args.length == 0) {
            System.out.println("Usage unaliased: java -oss3m -Xmx1000m agg.xt_basis.AGGBasicAppl grammar [import]");
            System.out.println("Usage aliased:");
            System.out.println("aggengine grammar [import]");
            System.out.println("(aggengine:     aliased to java -oss3m -Xmx1000m agg.xt_basis.AGGBasicAppl)");
            System.out.println("");
            System.out.println("grammar is a full file name of  '.ggx'  file in XML format.");
            System.out.println("import is a full file name of a GXL file '.gxl' in XML format that contains a graph to import into grammar as a host graph.");
            System.out.println("");
            return;
        }
        if (args.length == 1) {
            AGGBasicAppl appl = new AGGBasicAppl(args[0]);
        } else if (args.length == 2) {
            AGGBasicAppl aGGBasicAppl = new AGGBasicAppl(args[0], args[1]);
        }
    }

    public static GraGra load(String fileName) {
        if (fileName.endsWith(".ggx")) {
            h = null;
            h = new XMLHelper();
            h.read_from_xml(fileName);
            GraGra gra = BaseFactory.theFactory().createGraGra();
            h.getTopObject(gra);
            gra.setFileName(fileName);
            return gra;
        }
        return null;
    }

    public static Graph importGraph(String filename) {
        if (filename.endsWith(".ggx")) {
            return AGGBasicAppl.importGraphGGX(filename);
        }
        if (filename.endsWith(".gxl")) {
            return AGGBasicAppl.importGraphGXL(filename);
        }
        if (filename.endsWith(".gtxl")) {
            return AGGBasicAppl.importGraphGTXL(filename);
        }
        error = "Import failed!   < " + filename + " >  is not < .ggx > , < .gxl >  or  < .gtxl >  file.";
        return null;
    }

    private static Graph importGraphGGX(String filename) {
        GraGra impGra = AGGBasicAppl.load(filename);
        if (impGra != null) {
            return impGra.getGraph();
        }
        return null;
    }

    private static Graph importGraphGTXL(String filename) {
        return null;
    }

    private static Graph importGraphGXL(String filename) {
        String fd = ".";
        String fn = filename;
        String fnOut = "";
        File gxldtd = null;
        File gtsdtd = null;
        File source = null;
        File layout = null;
        error = "";
        File f = new File(fn);
        if (f.exists() && f.isFile()) {
            fd = f.getParent();
        }
        fd = fd != null ? fd + File.separator : "." + File.separator;
        ConverterXML converter = new ConverterXML();
        fnOut = fn.substring(0, fn.length() - 4) + "_gxl.ggx";
        source = converter.copyFile(fd, "gxl2ggx.xsl");
        gxldtd = converter.copyFile(fd, "gxl.dtd");
        gtsdtd = converter.copyFile(fd, "gts.dtd");
        layout = converter.copyFile(fd, "agglayout.dtd");
        if (source == null) {
            error = "Import is failed! File   < gxl2ggx.xsl >  is not found.";
            return null;
        }
        if (gxldtd == null) {
            error = "Import is failed! File   < gxl.dtd >  is not found.";
            return null;
        }
        if (gtsdtd == null) {
            error = "Import is failed! File   < gts.dtd >  is not found.";
            return null;
        }
        if (layout == null) {
            error = "Import is failed! File   < agglayout.dtd >  is not found.";
            return null;
        }
        String in = fn;
        String out = fnOut;
        GraGra impGra = null;
        if (converter.gxl2ggx(in, out, fd + "gxl2ggx.xsl") && out.endsWith(".ggx")) {
            XMLHelper h = null;
            h = new XMLHelper();
            h.read_from_xml(out);
            impGra = (GraGra)h.getTopObject(BaseFactory.theFactory().createGraGra());
            if (impGra != null) {
                return impGra.getGraph();
            }
        }
        error = "Import is failed! Please check format of the  GXL  file.";
        return null;
    }

    public static void transform(GraGra gragra, GraTraEventListener l) {
        if (gragra == null) {
            return;
        }
        if (gragra.getGraTraOptions().contains("layered")) {
            gratra = new LayeredGraTraImpl();
            layered = true;
            System.out.println("Layered transformation ...");
        } else {
            gratra = new DefaultGraTraImpl();
            System.out.println("Transformation ...");
        }
        gratra.addGraTraListener(l);
        gratra.setGraGra(gragra);
        gratra.setHostGraph(gragra.getGraph());
        MorphCompletionStrategy strategy = CompletionStrategySelector.getDefault();
        if (gragra.getGraTraOptions().isEmpty()) {
            gragra.setGraTraOptions(strategy);
            gratra.setCompletionStrategy(strategy);
        } else {
            if (gragra.getGraTraOptions().contains("showGraphAfterStep")) {
                gragra.getGraTraOptions().remove("showGraphAfterStep");
            }
            gratra.setGraTraOptions(gragra.getGraTraOptions());
            System.out.println("Options:  " + gragra.getGraTraOptions());
            System.out.println();
        }
        System.out.println("Please wait ....");
        if (layered) {
            ((LayeredGraTraImpl)gratra).transform();
        } else {
            ((DefaultGraTraImpl)gratra).transform();
        }
    }

    public static void save(GraGra gra, String outFileName) {
        outputFileName = outFileName.equals("") ? gragra.getName() + "_out.ggx" : (outFileName.equals("_out.ggx") ? fileName.substring(0, fileName.length() - 4) + "_out.ggx" : (outFileName.indexOf(".ggx") == -1 ? outFileName.concat(".ggx") : (outFileName.equals(fileName) ? fileName.substring(0, fileName.length() - 4) + "_out.ggx" : outFileName)));
        if (outputFileName.endsWith(".ggx")) {
            XMLHelper xmlh = new XMLHelper();
            xmlh.addTopObject(gra);
            xmlh.save_to_xml(outputFileName);
        }
    }

    public void graTraEventOccurred(GraTraEvent event) {
        Match match = event.getMatch();
        String ruleName = "Rule";
        if (match != null) {
            ruleName = match.getRule().getName();
        }
        this.msgGraTra = event.getMessage();
        if (this.msgGraTra == 5) {
            gratra.stop();
            didTransformation = gratra.didTransformation();
            System.out.println("GraTraEvent message : TRANSFORM_FINISHED");
        } else if (this.msgGraTra == 1) {
            System.out.println("GraTraEvent message : PARAMETER_NOT_SET");
        } else if (this.msgGraTra == 2) {
            System.out.println("Rule : " + ruleName + "  ==> STEP_COMPLETED");
        }
    }

    static {
        layered = false;
        didTransformation = false;
    }
}

