/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Solution_Backjump;
import agg.util.csp.Solution_InjBackjump;
import agg.util.csp.Variable;
import agg.xt_basis.Arc;
import agg.xt_basis.Constraint_Attribute;
import agg.xt_basis.Constraint_Source;
import agg.xt_basis.Constraint_Target;
import agg.xt_basis.Constraint_Type;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Query_Incoming;
import agg.xt_basis.Query_Outgoing;
import agg.xt_basis.Query_Source;
import agg.xt_basis.Query_Target;
import agg.xt_basis.Query_Type;
import agg.xt_basis.Type;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ALR_CSP
extends CSP {
    private AttrContext itsAttrContext;
    private Dictionary itsObjVarMap = new Hashtable(20, 10.0f);
    private Dictionary itsTypeMap = new Hashtable(20, 10.0f);

    public ALR_CSP(Graph vargraph, AttrContext ac, boolean injective) {
        super(injective ? new Solution_InjBackjump() : new Solution_Backjump());
        this.itsAttrContext = ac;
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Graph vargraph, AttrContext ac, SolutionStrategy st) {
        super(st);
        this.itsAttrContext = ac;
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Graph vargraph, AttrContext ac, boolean injective, boolean nonDeterministicSearch) {
        super(injective ? new Solution_InjBackjump() : new Solution_Backjump());
        this.itsAttrContext = ac;
        this.buildConstraintGraph(vargraph);
    }

    public ALR_CSP(Graph vargraph, AttrContext ac, SolutionStrategy st, boolean nonDeterministicSearch) {
        super(st);
        this.itsAttrContext = ac;
        this.buildConstraintGraph(vargraph);
    }

    private final synchronized void buildConstraintGraph(Graph vargraph) {
        Variable anObjVar;
        GraphObject anObj;
        Enumeration anEnum = vargraph.getElements();
        int count = 0;
        while (anEnum.hasMoreElements()) {
            anObj = (GraphObject)anEnum.nextElement();
            ++count;
            String keystr = this.convertToKey(anObj);
            if (this.itsTypeMap.get(keystr) == null) {
                this.itsTypeMap.put(keystr, new Vector(10, 10));
            }
            anObjVar = new Variable();
            if (anObj.isNode()) {
                anObjVar.setKind(0);
                anObjVar.addWeight(50);
            } else {
                anObjVar.setKind(1);
            }
            this.itsObjVarMap.put(anObj, anObjVar);
        }
        anEnum = vargraph.getElements();
        while (anEnum.hasMoreElements()) {
            anObj = (GraphObject)anEnum.nextElement();
            anObjVar = (Variable)this.itsObjVarMap.get(anObj);
            Query q = new Query_Type(this.getTypeQuerySet(anObj), anObjVar);
            new Constraint_Type(anObj, anObjVar);
            new Constraint_Attribute(anObj, anObjVar, this.itsAttrContext, vargraph.getAttrManager());
            if (!anObj.isArc()) continue;
            Variable aSrcObjVar = (Variable)this.itsObjVarMap.get(((Arc)anObj).getSource());
            Variable aTarObjVar = (Variable)this.itsObjVarMap.get(((Arc)anObj).getTarget());
            q = new Query_Outgoing(aSrcObjVar, anObjVar);
            aSrcObjVar.addWeight(q.getWeight() * 2);
            q = new Query_Incoming(aTarObjVar, anObjVar);
            aTarObjVar.addWeight(q.getWeight());
            q = new Query_Source(anObjVar, aSrcObjVar);
            q = new Query_Target(anObjVar, aTarObjVar);
            new Constraint_Source(aSrcObjVar, anObjVar);
            new Constraint_Target(aTarObjVar, anObjVar);
        }
    }

    protected final synchronized void preprocessDomain(Object domaingraph) {
        this.fillTypeMap((Graph)domaingraph);
    }

    public final Enumeration getVariables() {
        return this.itsObjVarMap.elements();
    }

    public final int getSize() {
        return this.itsObjVarMap.size();
    }

    public final Variable getVariable(GraphObject obj) {
        return (Variable)this.itsObjVarMap.get(obj);
    }

    private void fillTypeMap(Graph domaingraph) {
        Enumeration anEnum = domaingraph.getElements();
        if (anEnum == null) {
            return;
        }
        while (anEnum.hasMoreElements()) {
            Vector anObjVec;
            GraphObject anObj = (GraphObject)anEnum.nextElement();
            String keystr = this.convertToKey(anObj);
            Type anObjType = anObj.getType();
            if (anObj.isNode()) {
                Vector myParents = anObjType.getAllParents();
                if (myParents == null) continue;
                for (int i = 0; i < myParents.size(); ++i) {
                    anObjType = (Type)myParents.get(i);
                    keystr = anObjType.convertToKey();
                    if (this.itsTypeMap.get(keystr) == null) continue;
                    anObjVec = (Vector)this.itsTypeMap.get(keystr);
                    anObjVec.addElement(anObj);
                }
                continue;
            }
            Type mySrcType = ((Arc)anObj).getSource().getType();
            Type myTarType = ((Arc)anObj).getTarget().getType();
            Vector mySrcParents = mySrcType.getAllParents();
            Vector myTarParents = myTarType.getAllParents();
            for (int i = 0; i < mySrcParents.size(); ++i) {
                mySrcType = (Type)mySrcParents.get(i);
                for (int j = 0; j < myTarParents.size(); ++j) {
                    myTarType = (Type)myTarParents.get(j);
                    keystr = mySrcType.convertToKey() + anObjType.convertToKey() + myTarType.convertToKey();
                    if (this.itsTypeMap.get(keystr) == null) continue;
                    anObjVec = (Vector)this.itsTypeMap.get(keystr);
                    anObjVec.addElement(anObj);
                }
            }
        }
    }

    private final Vector getTypeQuerySet(GraphObject obj) {
        return (Vector)this.itsTypeMap.get(this.convertToKey(obj));
    }

    private String convertToKey(GraphObject o) {
        if (o.isNode()) {
            return ((Node)o).getType().convertToKey();
        }
        Arc a = (Arc)o;
        Type aType = a.getType();
        String keystr = a.getSource().getType().convertToKey() + aType.convertToKey() + a.getTarget().getType().convertToKey();
        return keystr;
    }

    private void showTypeMap(Dictionary d, int sort) {
        if (sort == 0) {
            System.out.println("******  NODE_TYPE DOMAINS  *****");
        } else {
            System.out.println("******  ARC_TYPE DOMAINS  ******");
        }
        Enumeration keys = d.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.println(key);
            Vector v = (Vector)d.get(key);
            for (int i = 0; i < v.size(); ++i) {
                GraphObject o;
                GraphObject go = (GraphObject)v.elementAt(i);
                if (sort == 0 && go.isNode()) {
                    o = (Node)go;
                    System.out.print(o + "  ");
                    continue;
                }
                if (sort == 0 || go.isNode()) continue;
                o = (Arc)go;
                System.out.print(o + "  ");
            }
            System.out.println();
        }
        System.out.println("***********");
    }

    private void showVarWeight(Graph vargraph) {
        System.out.println(" *** VARIABLES ***");
        int count = 0;
        Enumeration anEnum = vargraph.getElements();
        while (anEnum.hasMoreElements()) {
            ++count;
            GraphObject anObj = (GraphObject)anEnum.nextElement();
            Variable anObjVar = (Variable)this.itsObjVarMap.get(anObj);
            System.out.println("isNode: " + anObj.isNode() + "   " + anObj.getType().getName() + "   " + anObjVar.getWeight());
        }
        System.out.println("vars size: " + count);
    }
}

