/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.AttrType;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.Debug;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import com.objectspace.jgl.Pair;

public class Arc
extends GraphObject
implements XMLObject {
    private boolean inheritance = false;
    private boolean directed = true;

    public Arc(AttrInstance attr, Type type, GraphObject src, GraphObject tar, Graph context) {
        super(attr, type, src, tar, context);
    }

    protected void setInheritance(boolean inherit) {
        this.inheritance = inherit;
    }

    protected void setInherited(boolean inherit) {
        this.inheritance = inherit;
    }

    public boolean isInheritance() {
        return this.inheritance;
    }

    public boolean isInherited() {
        return this.inheritance;
    }

    public final boolean isArc() {
        return true;
    }

    public final boolean isNode() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public final GraphObject getSource() {
        return this.itsSource;
    }

    public final GraphObject getTarget() {
        return this.itsTarget;
    }

    public void setSource(Node n) {
        this.itsSource = n;
    }

    public void setTarget(Node n) {
        this.itsTarget = n;
    }

    public void setDirected(boolean b) {
        this.directed = b;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean compareTo(GraphObject o) {
        if (!o.isArc()) {
            return false;
        }
        Arc a = (Arc)o;
        if (!this.getType().isParentOf(a.getType())) {
            return false;
        }
        if (!((Node)this.getSource()).compareTo((Node)a.getSource())) {
            return false;
        }
        if (!((Node)this.getTarget()).compareTo((Node)a.getTarget())) {
            return false;
        }
        if (!this.getAttribute().compareTo(a.getAttribute())) {
            return false;
        }
        boolean result = true;
        if (this.itsContext.isTypeGraph()) {
            Type sourceType = this.getSource().getType();
            Type targetType = this.getTarget().getType();
            Type a_sourceType = a.getSource().getType();
            Type a_targetType = a.getTarget().getType();
            int minmax = this.getType().getSourceMin(sourceType, targetType);
            int a_minmax = a.getType().getSourceMin(a_sourceType, a_targetType);
            if (result && minmax != a_minmax) {
                result = false;
            } else {
                minmax = this.getType().getTargetMin(sourceType, targetType);
                a_minmax = a.getType().getTargetMin(a_sourceType, a_targetType);
                if (result && minmax != a_minmax) {
                    result = false;
                } else {
                    minmax = this.getType().getSourceMax(sourceType, targetType);
                    a_minmax = a.getType().getSourceMax(a_sourceType, a_targetType);
                    if (result && minmax != a_minmax) {
                        result = false;
                    } else {
                        minmax = this.getType().getTargetMax(sourceType, targetType);
                        a_minmax = a.getType().getTargetMax(a_sourceType, a_targetType);
                        if (result && minmax != a_minmax) {
                            result = false;
                        }
                    }
                }
            }
        }
        return result;
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Edge", this);
        if (!this.directed) {
            h.addAttr("directed", "false");
        }
        if (!this.visible) {
            h.addAttr("visible", "false");
        }
        h.addObject("type", this.getType(), false);
        h.addObject("source", this.getSource(), false);
        h.addObject("target", this.getTarget(), false);
        h.addObject("", this.getAttribute(), true);
        if (this.itsContext.isTypeGraph()) {
            Type sourceType = this.getSource().getType();
            Type targetType = this.getTarget().getType();
            int minmax = this.getType().getSourceMin(sourceType, targetType);
            if (minmax != -1) {
                h.addAttr("sourcemin", Integer.toString(minmax));
            }
            if ((minmax = this.getType().getTargetMin(sourceType, targetType)) != -1) {
                h.addAttr("targetmin", Integer.toString(minmax));
            }
            if ((minmax = this.getType().getSourceMax(sourceType, targetType)) != -1) {
                h.addAttr("sourcemax", Integer.toString(minmax));
            }
            if ((minmax = this.getType().getTargetMax(sourceType, targetType)) != -1) {
                h.addAttr("targetmax", Integer.toString(minmax));
            }
        }
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("Edge", this)) {
            String str = h.readAttr("directed");
            this.directed = str != null ? !str.equals("false") : true;
            str = h.readAttr("visible");
            this.visible = str != null ? !str.equals("false") : true;
            AttrInstance attri = this.getAttribute();
            if (attri == null) {
                System.out.println("Arc.XreadObject: no AttrInstance");
            } else {
                if (Debug.HASHCODE) {
                    AttrType attrType = this.getType().getAttrType();
                    if (!((DeclTuple)attrType).containsName("HASHCODE")) {
                        attrType.addMember(DefaultInformationFacade.self().getJavaHandler(), "String", "HASHCODE");
                    }
                    ValueMember mem = ((ValueTuple)attri).getValueMemberAt("HASHCODE");
                    String hc = String.valueOf(this.hashCode());
                    mem.setExprAsObject(hc);
                    mem.checkValidity();
                }
                h.enrichObject(attri);
            }
            h.close();
            if (this.itsContext.getAttrContext() != null) {
                ValueTuple value = (ValueTuple)this.getAttribute();
                for (int i = 0; i < value.getSize(); ++i) {
                    ValueMember val = value.getValueMemberAt(i);
                    if (!val.isSet() || !val.getExpr().isVariable()) continue;
                    ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                    VarTuple variable = (VarTuple)viewContext.getVariables();
                    VarMember var = variable.getVarMemberAt(val.getExprAsText());
                    if (this.getContext().isNacGraph()) {
                        var.setMark(2);
                        continue;
                    }
                    if (viewContext.doesAllowComplexExpressions()) {
                        var.setMark(1);
                        continue;
                    }
                    var.setMark(0);
                }
            }
        }
    }

    public String toString() {
        String result = "";
        String t = this.getType().getStringRepr();
        String tSrc = this.getSource().getType().getStringRepr();
        String tTrg = this.getTarget().getType().getStringRepr();
        result = " ([" + this.hashCode() + "] " + "Edge: " + tSrc + "---" + t + "--->" + tTrg + ") ";
        return result;
    }

    public void attributeChanged(AttrEvent ev) {
        Pair p = new Pair(this, new Integer(ev.getID()));
        this.itsContext.propagateChange(new Change(11, p));
    }
}

