/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.facade.impl.DefaultEditorFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.SymbolTable;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ASTExpression;
import agg.attribute.parser.javaExpr.ASTPrimaryExpression;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.attribute.view.AttrViewSetting;
import agg.cons.AtomConstraint;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.CopyMemory;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BaseFactory {
    private Vector itsGraGras = new Vector(5);
    protected static BaseFactory theBaseFactory;

    public static BaseFactory theFactory() {
        if (theBaseFactory != null) {
            return theBaseFactory;
        }
        theBaseFactory = new BaseFactory();
        return theBaseFactory;
    }

    public GraGra createGraGra() {
        GraGra gg = new GraGra(new TypeSet());
        this.itsGraGras.addElement(gg);
        return gg;
    }

    public void destroyGraGra(GraGra gg) {
        if (this.itsGraGras.contains(gg)) {
            this.itsGraGras.removeElement(gg);
            gg.dispose();
        }
    }

    public Enumeration getGraGras() {
        return this.itsGraGras.elements();
    }

    public void notify(GraGra gg) {
        if (!this.isElement(gg)) {
            this.itsGraGras.addElement(gg);
        }
    }

    private boolean isElement(GraGra gg) {
        return this.itsGraGras.contains(gg);
    }

    public GraTra createGraTra() {
        return new DefaultGraTraImpl();
    }

    public final Graph createGraph() {
        return new Graph();
    }

    public final Graph createGraph(TypeSet types) {
        return new Graph(types);
    }

    public final TypeSet createTypeSet() {
        return new TypeSet();
    }

    public final void destroyGraph(Graph graph) {
        graph.dispose();
    }

    public Rule constructRuleFromMorph(OrdinaryMorphism h) {
        Rule rule = new Rule(h.getOriginal(), h.getImage());
        Enumeration dom = h.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = (GraphObject)dom.nextElement();
            rule.addMapping(obj, h.getImage(obj));
        }
        AttrHandler javaHandler = DefaultInformationFacade.self().getJavaHandler();
        VarTuple varsMorph = (VarTuple)h.getAttrContext().getVariables();
        VarTuple vars = (VarTuple)rule.getAttrContext().getVariables();
        for (int j = 0; j < varsMorph.getSize(); ++j) {
            VarMember vm = varsMorph.getVarMemberAt(j);
            DeclMember dm = (DeclMember)vm.getDeclaration();
            if (vars.isDeclared(dm.getTypeName(), dm.getName())) continue;
            vars.declare(javaHandler, dm.getTypeName(), dm.getName());
        }
        CondTuple condsMorph = (CondTuple)h.getAttrContext().getConditions();
        CondTuple conds = (CondTuple)rule.getAttrContext().getConditions();
        for (int j = 0; j < condsMorph.getSize(); ++j) {
            CondMember cm = condsMorph.getCondMemberAt(j);
            if (cm.getExprAsText().equals("")) continue;
            conds.addCondition(cm.getExprAsText());
        }
        vars = (VarTuple)rule.getAttrContext().getVariables();
        int count = vars.getSize();
        String mark = "r";
        Enumeration objs = rule.getRight().getElements();
        while (objs.hasMoreElements()) {
            GraphObject o = (GraphObject)objs.nextElement();
            Enumeration inverseImg = rule.getInverseImage(o);
            if (inverseImg.hasMoreElements()) continue;
            ValueTuple value = (ValueTuple)o.getAttribute();
            for (int i = 0; i < value.getSize(); ++i) {
                ValueMember vm = value.getValueMemberAt(i);
                if (vm.isSet()) continue;
                String t = vm.getName() + String.valueOf(count) + mark;
                ++count;
                vm.setExprAsText(t);
                vm.setTransient(true);
            }
        }
        return rule;
    }

    public Pair constructIsomorphicRule(OrdinaryMorphism h) {
        OrdinaryMorphism isoL = h.getSource().isomorphicCopy();
        OrdinaryMorphism isoR = h.getTarget().isomorphicCopy();
        Rule rule = new Rule(isoL.getTarget(), isoR.getTarget());
        Enumeration dom = h.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = (GraphObject)dom.nextElement();
            GraphObject img = h.getImage(obj);
            rule.addMapping(isoL.getImage(obj), isoR.getImage(img));
        }
        Pair p = new Pair(rule, new Pair(isoL, isoR));
        rule.makeAttributeContext();
        AttrHandler javaHandler = DefaultInformationFacade.self().getJavaHandler();
        VarTuple vars = (VarTuple)rule.getAttrContext().getVariables();
        VarTuple varsMorph = (VarTuple)h.getAttrContext().getVariables();
        for (int j = 0; j < varsMorph.getSize(); ++j) {
            VarMember vm = varsMorph.getVarMemberAt(j);
            DeclMember dm = (DeclMember)vm.getDeclaration();
            if (vars.isDeclared(dm.getTypeName(), dm.getName())) continue;
            vars.declare(javaHandler, dm.getTypeName(), dm.getName());
        }
        CondTuple condsMorph = (CondTuple)h.getAttrContext().getConditions();
        CondTuple conds = (CondTuple)rule.getAttrContext().getConditions();
        for (int j = 0; j < condsMorph.getSize(); ++j) {
            CondMember cm = condsMorph.getCondMemberAt(j);
            if (cm.getExprAsText().equals("")) continue;
            conds.addCondition(cm.getExprAsText());
        }
        vars = (VarTuple)rule.getAttrContext().getVariables();
        int count = vars.getSize();
        String mark = "r";
        Enumeration objs = rule.getRight().getElements();
        while (objs.hasMoreElements()) {
            GraphObject o = (GraphObject)objs.nextElement();
            Enumeration inverseImg = rule.getInverseImage(o);
            if (inverseImg.hasMoreElements()) continue;
            ValueTuple value = (ValueTuple)o.getAttribute();
            for (int i = 0; i < value.getSize(); ++i) {
                String t;
                ValueMember vm = value.getValueMemberAt(i);
                if (!vm.isSet()) {
                    t = vm.getName() + String.valueOf(count) + mark;
                    ++count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                    continue;
                }
                if (!vm.getExpr().isComplex()) continue;
                t = vm.getName() + String.valueOf(count) + mark;
                ++count;
                vm.setExprAsText(t);
                vm.setTransient(true);
            }
        }
        return p;
    }

    public Rule constructRule(OrdinaryMorphism h) {
        Rule rule = new Rule(h.getOriginal().getTypeSet());
        Graph lgraph = h.getOriginal();
        Graph rgraph = h.getImage();
        Graph left = rule.getLeft();
        Graph right = rule.getRight();
        Hashtable<GraphObject, GraphObject> ltable = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, GraphObject> rtable = new Hashtable<GraphObject, GraphObject>();
        Enumeration rnodes = rgraph.getNodes();
        while (rnodes.hasMoreElements()) {
            Node rNode = (Node)rnodes.nextElement();
            Node itsRNode = null;
            try {
                itsRNode = right.createNode(rNode);
                itsRNode.setContextUsage(rNode.getContextUsage());
                rtable.put(rNode, itsRNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration lnodes = lgraph.getNodes();
        while (lnodes.hasMoreElements()) {
            GraphObject rn;
            Node lNode = (Node)lnodes.nextElement();
            Node itsLNode = null;
            try {
                itsLNode = left.createNode(lNode);
                itsLNode.setContextUsage(lNode.getContextUsage());
                ltable.put(lNode, itsLNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            if ((rn = h.getImage(lNode)) == null) continue;
            rule.addMapping(itsLNode, (GraphObject)rtable.get(rn));
        }
        Enumeration rarcs = rgraph.getArcs();
        while (rarcs.hasMoreElements()) {
            Arc rArc = (Arc)rarcs.nextElement();
            Node itsRSource = (Node)rtable.get(rArc.getSource());
            Node itsRTarget = (Node)rtable.get(rArc.getTarget());
            Arc itsRArc = null;
            try {
                itsRArc = right.createArc(rArc, itsRSource, itsRTarget);
                rtable.put(rArc, itsRArc);
            }
            catch (TypeException ex) {}
        }
        Enumeration larcs = lgraph.getArcs();
        while (larcs.hasMoreElements()) {
            GraphObject ra;
            Arc lArc = (Arc)larcs.nextElement();
            Node itsLSource = (Node)ltable.get(lArc.getSource());
            Node itsLTarget = (Node)ltable.get(lArc.getTarget());
            Arc itsLArc = null;
            try {
                itsLArc = left.createArc(lArc, itsLSource, itsLTarget);
                ltable.put(lArc, itsLArc);
            }
            catch (TypeException ex) {
                // empty catch block
            }
            if ((ra = h.getImage(lArc)) == null) continue;
            rule.addMapping(itsLArc, (GraphObject)rtable.get(ra));
        }
        VarTuple vars = (VarTuple)rule.getAttrContext().getVariables();
        int count = vars.getSize();
        String mark = "r";
        Enumeration objs = right.getElements();
        while (objs.hasMoreElements()) {
            GraphObject o = (GraphObject)objs.nextElement();
            Enumeration inverseImg = rule.getInverseImage(o);
            if (inverseImg.hasMoreElements()) continue;
            ValueTuple value = (ValueTuple)o.getAttribute();
            for (int i = 0; i < value.getSize(); ++i) {
                ValueMember vm = value.getValueMemberAt(i);
                if (vm.isSet()) continue;
                String t = vm.getName() + String.valueOf(count) + mark;
                ++count;
                vm.setExprAsText(t);
                vm.setTransient(true);
            }
        }
        ltable.clear();
        ltable = null;
        rtable.clear();
        rtable = null;
        return rule;
    }

    public Pair makeAbstractInverseRule(Rule r) {
        ValueTuple value;
        GraphObject grob;
        if (!r.isInjective()) {
            return null;
        }
        OrdinaryMorphism isoRight = r.getRight().isomorphicCopy();
        Graph left = isoRight.getTarget();
        OrdinaryMorphism isoLeft = r.getLeft().isomorphicCopy();
        Graph right = isoLeft.getTarget();
        OrdinaryMorphism morph = this.createMorphism(left, right);
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        Enumeration e = left.getElements();
        while (e.hasMoreElements()) {
            grob = (GraphObject)e.nextElement();
            value = (ValueTuple)grob.getAttribute();
            for (int i = 0; i < value.getSize(); ++i) {
                String varname;
                String num = i == 0 ? "" : "" + i;
                ValueMember val = value.getValueMemberAt(i);
                if (!val.isSet()) continue;
                if (val.getExpr().isComplex()) {
                    val.setExpr(null);
                    varname = "expr" + num;
                    vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
                    val.setExprAsText(varname);
                    continue;
                }
                if (!val.getExpr().isVariable() || vars.getVarMemberAt(val.getExprAsText()) != null) continue;
                varname = val.getExprAsText();
                vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
            }
        }
        if (r.isInjective()) {
            Enumeration dom = r.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject obj = (GraphObject)dom.nextElement();
                GraphObject img = r.getImage(obj);
                GraphObject img1 = isoLeft.getImage(obj);
                GraphObject obj1 = isoRight.getImage(img);
                try {
                    morph.addMapping(obj1, img1);
                }
                catch (BadMappingException ex) {
                    // empty catch block
                }
                ValueTuple valueLeft = (ValueTuple)obj1.getAttribute();
                ValueTuple valueRight = (ValueTuple)img1.getAttribute();
                for (int i = 0; i < valueLeft.getSize(); ++i) {
                    ValueMember mLeft = valueLeft.getValueMemberAt(i);
                    ValueMember mRight = valueRight.getValueMemberAt(i);
                    if (mLeft.isSet() || !mRight.isSet()) continue;
                    mLeft.setExprAsText(mRight.getExprAsText());
                }
            }
        }
        e = right.getElements();
        while (e.hasMoreElements()) {
            grob = (GraphObject)e.nextElement();
            if (morph.getInverseImage(grob).hasMoreElements()) continue;
            value = (ValueTuple)grob.getAttribute();
            for (int i = 0; i < value.getSize(); ++i) {
                String varname;
                ValueMember val = value.getValueMemberAt(i);
                if (!val.isSet()) {
                    varname = "r" + i;
                    vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
                    val.setExprAsText(varname);
                    continue;
                }
                if (!val.getExpr().isVariable() || vars.getVarMemberAt(val.getExprAsText()) != null) continue;
                varname = val.getExprAsText();
                vars.declare(DefaultInformationFacade.self().getJavaHandler(), val.getDeclaration().getTypeName(), varname);
            }
        }
        Rule absInvert = BaseFactory.theFactory().constructRuleFromMorph(morph);
        absInvert.setName(r.getName() + "_INVERT");
        return new Pair(absInvert, new Pair(isoLeft, isoRight));
    }

    public Graph cloneGraph(Graph graph) {
        Graph g = graph.copy();
        CopyMemory.UNSET();
        return g;
    }

    public Rule cloneRule(Rule rule) {
        Rule ruleClone = new Rule(rule.getOriginal().getTypeSet());
        ruleClone.setName(rule.getName() + "_clone");
        ruleClone.setLayer(rule.getLayer());
        AttrContext ac = ruleClone.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        AttrContext acOther = rule.getAttrContext();
        VarTuple avtOther = (VarTuple)acOther.getVariables();
        for (int i = 0; i < avtOther.getSize(); ++i) {
            VarMember varOther = avtOther.getVarMemberAt(i);
            VarMember var = avt.getVarMemberAt(varOther.getName());
            if (var != null) {
                var.setMark(varOther.getMark());
                var.setInputParameter(varOther.isInputParameter());
                continue;
            }
            avt.declare(DefaultInformationFacade.self().getJavaHandler(), varOther.getDeclaration().getTypeName(), varOther.getDeclaration().getName());
            var = avt.getVarMemberAt(varOther.getName());
            if (var == null) continue;
            var.setMark(varOther.getMark());
            var.setInputParameter(varOther.isInputParameter());
        }
        Graph lgraph = rule.getLeft();
        Graph rgraph = rule.getRight();
        Graph left = ruleClone.getLeft();
        Graph right = ruleClone.getRight();
        Hashtable<GraphObject, GraphObject> ltable = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, GraphObject> rtable = new Hashtable<GraphObject, GraphObject>();
        Enumeration rnodes = rgraph.getNodes();
        while (rnodes.hasMoreElements()) {
            Node rNode = (Node)rnodes.nextElement();
            Node itsRNode = null;
            try {
                itsRNode = right.createNode(rNode);
                itsRNode.setContextUsage(rNode.getContextUsage());
                rtable.put(rNode, itsRNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration lnodes = lgraph.getNodes();
        while (lnodes.hasMoreElements()) {
            GraphObject rn;
            Node lNode = (Node)lnodes.nextElement();
            Node itsLNode = null;
            try {
                itsLNode = left.createNode(lNode);
                itsLNode.setContextUsage(lNode.getContextUsage());
                ltable.put(lNode, itsLNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            if ((rn = rule.getImage(lNode)) == null) continue;
            ruleClone.addMapping(itsLNode, (GraphObject)rtable.get(rn));
        }
        Enumeration rarcs = rgraph.getArcs();
        while (rarcs.hasMoreElements()) {
            Arc rArc = (Arc)rarcs.nextElement();
            Node itsRSource = (Node)rtable.get(rArc.getSource());
            Node itsRTarget = (Node)rtable.get(rArc.getTarget());
            Arc itsRArc = null;
            try {
                itsRArc = right.createArc(rArc, itsRSource, itsRTarget);
                rtable.put(rArc, itsRArc);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration larcs = lgraph.getArcs();
        while (larcs.hasMoreElements()) {
            GraphObject ra;
            Arc lArc = (Arc)larcs.nextElement();
            Node itsLSource = (Node)ltable.get(lArc.getSource());
            Node itsLTarget = (Node)ltable.get(lArc.getTarget());
            Arc itsLArc = null;
            try {
                itsLArc = left.createArc(lArc, itsLSource, itsLTarget);
                ltable.put(lArc, itsLArc);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            if ((ra = rule.getImage(lArc)) == null) continue;
            ruleClone.addMapping(itsLArc, (GraphObject)rtable.get(ra));
        }
        Hashtable<GraphObject, GraphObject> nactable = new Hashtable<GraphObject, GraphObject>();
        Enumeration nacs = rule.getNACs();
        while (nacs.hasMoreElements()) {
            Arc itsNACArc;
            OrdinaryMorphism nac = (OrdinaryMorphism)nacs.nextElement();
            Graph nacGraph = nac.getImage();
            OrdinaryMorphism nacClone = ruleClone.createNAC();
            Graph nacCloneGraph = nacClone.getImage();
            nacCloneGraph.setName(nacGraph.getName());
            nacClone.setName(nac.getName());
            nactable.clear();
            Enumeration nacNodes = nacGraph.getNodes();
            while (nacNodes.hasMoreElements()) {
                Node nacNode = (Node)nacNodes.nextElement();
                Node itsNACNode = null;
                try {
                    itsNACNode = nacCloneGraph.createNode(nacNode);
                    itsNACNode.setContextUsage(nacNode.getContextUsage());
                    nactable.put(nacNode, itsNACNode);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            Enumeration nacArcs = nacGraph.getArcs();
            while (nacArcs.hasMoreElements()) {
                Arc nacArc = (Arc)nacArcs.nextElement();
                Node itsNACSource = (Node)nactable.get(nacArc.getSource());
                Node itsNACTarget = (Node)nactable.get(nacArc.getTarget());
                itsNACArc = null;
                try {
                    itsNACArc = nacCloneGraph.createArc(nacArc, itsNACSource, itsNACTarget);
                    nactable.put(nacArc, itsNACArc);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            lnodes = lgraph.getNodes();
            while (lnodes.hasMoreElements()) {
                Node lNode = (Node)lnodes.nextElement();
                GraphObject nacNode = nac.getImage(lNode);
                if (nacNode == null) continue;
                Node itsLNode = (Node)ltable.get(lNode);
                Node itsNACNode = (Node)nactable.get(nacNode);
                nacClone.addMapping(itsLNode, itsNACNode);
            }
            larcs = lgraph.getArcs();
            while (larcs.hasMoreElements()) {
                Arc lArc = (Arc)larcs.nextElement();
                GraphObject nacArc = nac.getImage(lArc);
                if (nacArc == null) continue;
                Arc itsLArc = (Arc)ltable.get(lArc);
                itsNACArc = (Arc)nactable.get(nacArc);
                nacClone.addMapping(itsLArc, itsNACArc);
            }
        }
        CondTuple act = (CondTuple)ac.getConditions();
        CondTuple actOther = (CondTuple)acOther.getConditions();
        for (int i = 0; i < actOther.getSize(); ++i) {
            CondMember condOther = actOther.getCondMemberAt(i);
            CondMember cond = (CondMember)act.addCondition(condOther.getExprAsText());
            cond.setMark(condOther.getMark());
        }
        ltable.clear();
        ltable = null;
        rtable.clear();
        rtable = null;
        nactable.clear();
        nactable = null;
        return ruleClone;
    }

    public Rule cloneRule(Rule rule, TypeSet types) {
        int i;
        Rule ruleClone = new Rule(types);
        ruleClone.setName(rule.getName() + "_clone");
        Graph lgraph = rule.getLeft();
        Graph rgraph = rule.getRight();
        Graph left = ruleClone.getLeft();
        Graph right = ruleClone.getRight();
        Hashtable<GraphObject, GraphObject> ltable = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, GraphObject> rtable = new Hashtable<GraphObject, GraphObject>();
        Enumeration rnodes = rgraph.getNodes();
        while (rnodes.hasMoreElements()) {
            Node rNode = (Node)rnodes.nextElement();
            Node itsRNode = null;
            try {
                itsRNode = right.createNode(rNode);
                itsRNode.setContextUsage(rNode.getContextUsage());
                rtable.put(rNode, itsRNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration lnodes = lgraph.getNodes();
        while (lnodes.hasMoreElements()) {
            GraphObject rn;
            Node lNode = (Node)lnodes.nextElement();
            Node itsLNode = null;
            try {
                itsLNode = left.createNode(lNode);
                itsLNode.setContextUsage(lNode.getContextUsage());
                ltable.put(lNode, itsLNode);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            if ((rn = rule.getImage(lNode)) == null) continue;
            ruleClone.addMapping(itsLNode, (GraphObject)rtable.get(rn));
        }
        Enumeration rarcs = rgraph.getArcs();
        while (rarcs.hasMoreElements()) {
            Arc rArc = (Arc)rarcs.nextElement();
            Node itsRSource = (Node)rtable.get(rArc.getSource());
            Node itsRTarget = (Node)rtable.get(rArc.getTarget());
            Arc itsRArc = null;
            try {
                itsRArc = right.createArc(rArc, itsRSource, itsRTarget);
                rtable.put(rArc, itsRArc);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        Enumeration larcs = lgraph.getArcs();
        while (larcs.hasMoreElements()) {
            GraphObject ra;
            Arc lArc = (Arc)larcs.nextElement();
            Node itsLSource = (Node)ltable.get(lArc.getSource());
            Node itsLTarget = (Node)ltable.get(lArc.getTarget());
            Arc itsLArc = null;
            try {
                itsLArc = left.createArc(lArc, itsLSource, itsLTarget);
                ltable.put(lArc, itsLArc);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            if ((ra = rule.getImage(lArc)) == null) continue;
            ruleClone.addMapping(itsLArc, (GraphObject)rtable.get(ra));
        }
        Hashtable<GraphObject, GraphObject> nactable = new Hashtable<GraphObject, GraphObject>();
        Enumeration nacs = rule.getNACs();
        while (nacs.hasMoreElements()) {
            Arc itsNACArc;
            OrdinaryMorphism nac = (OrdinaryMorphism)nacs.nextElement();
            Graph nacGraph = nac.getImage();
            OrdinaryMorphism nacClone = ruleClone.createNAC();
            Graph nacCloneGraph = nacClone.getImage();
            nacCloneGraph.setName(nacGraph.getName());
            nacClone.setName(nac.getName());
            nactable.clear();
            Enumeration nacNodes = nacGraph.getNodes();
            while (nacNodes.hasMoreElements()) {
                Node nacNode = (Node)nacNodes.nextElement();
                Node itsNACNode = null;
                try {
                    itsNACNode = nacCloneGraph.createNode(nacNode);
                    itsNACNode.setContextUsage(nacNode.getContextUsage());
                    nactable.put(nacNode, itsNACNode);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            Enumeration nacArcs = nacGraph.getArcs();
            while (nacArcs.hasMoreElements()) {
                Arc nacArc = (Arc)nacArcs.nextElement();
                Node itsNACSource = (Node)nactable.get(nacArc.getSource());
                Node itsNACTarget = (Node)nactable.get(nacArc.getTarget());
                itsNACArc = null;
                try {
                    itsNACArc = nacCloneGraph.createArc(nacArc, itsNACSource, itsNACTarget);
                    nactable.put(nacArc, itsNACArc);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            lnodes = lgraph.getNodes();
            while (lnodes.hasMoreElements()) {
                Node lNode = (Node)lnodes.nextElement();
                GraphObject nacNode = nac.getImage(lNode);
                if (nacNode == null) continue;
                Node itsLNode = (Node)ltable.get(lNode);
                Node itsNACNode = (Node)nactable.get(nacNode);
                nacClone.addMapping(itsLNode, itsNACNode);
            }
            larcs = lgraph.getArcs();
            while (larcs.hasMoreElements()) {
                Arc lArc = (Arc)larcs.nextElement();
                GraphObject nacArc = nac.getImage(lArc);
                if (nacArc == null) continue;
                Arc itsLArc = (Arc)ltable.get(lArc);
                itsNACArc = (Arc)nactable.get(nacArc);
                nacClone.addMapping(itsLArc, itsNACArc);
            }
        }
        AttrContext ac = ruleClone.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        CondTuple act = (CondTuple)ac.getConditions();
        AttrContext acOther = rule.getAttrContext();
        VarTuple avtOther = (VarTuple)acOther.getVariables();
        CondTuple actOther = (CondTuple)acOther.getConditions();
        for (i = 0; i < avtOther.getSize(); ++i) {
            VarMember varOther = avtOther.getVarMemberAt(i);
            VarMember var = avt.getVarMemberAt(varOther.getName());
            if (var == null) continue;
            var.setMark(varOther.getMark());
            var.setInputParameter(varOther.isInputParameter());
        }
        for (i = 0; i < actOther.getSize(); ++i) {
            CondMember condOther = actOther.getCondMemberAt(i);
            CondMember cond = (CondMember)act.addCondition(condOther.getExprAsText());
            cond.setMark(condOther.getMark());
        }
        ltable.clear();
        ltable = null;
        rtable.clear();
        rtable = null;
        nactable.clear();
        nactable = null;
        return ruleClone;
    }

    public final AtomConstraint createAtomic(TypeSet types, String name) {
        Graph g1 = this.createGraph(types);
        Graph g2 = this.createGraph(types);
        return new AtomConstraint(g1, g2, AttrTupleManager.getDefaultManager().newContext(0), name);
    }

    public final OrdinaryMorphism createMorphism(Graph orig, Graph img) {
        AttrContext aRuleContext = AttrTupleManager.getDefaultManager().newContext(0);
        AttrTupleManager.getDefaultManager().newLeftContext(aRuleContext);
        AttrTupleManager.getDefaultManager().newRightContext(aRuleContext);
        OrdinaryMorphism output = new OrdinaryMorphism(orig, img, aRuleContext);
        return output;
    }

    public final OrdinaryMorphism createMorphism(Graph orig, Graph img, boolean implicit) {
        return this.createMorphism(orig, img, implicit, "");
    }

    public final OrdinaryMorphism createMorphism(Graph orig, Graph img, boolean implicit, String helpMarkOfVars) {
        OrdinaryMorphism m = this.createMorphism(orig, img);
        int count = m.getAttrContext().getVariables().getSize();
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        if (implicit) {
            String mark = "_" + helpMarkOfVars;
            AttrViewSetting attrView = DefaultEditorFacade.self().getTopEditor().getViewSetting();
            Enumeration elements = img.getElements();
            while (elements.hasMoreElements()) {
                GraphObject grob = (GraphObject)elements.nextElement();
                AttrInstance attrs = grob.getAttribute();
                ValueTuple values = (ValueTuple)attrs;
                for (int i = 0; i < values.getNumberOfEntries(); ++i) {
                    ValueMember vm = values.getValueMemberAt(i);
                    if (!vm.isSet()) {
                        String t = vm.getName() + String.valueOf(count) + mark;
                        vm.setExprAsText(t);
                        vm.setTransient(true);
                        ++count;
                    }
                    if (!vm.getExpr().isVariable()) continue;
                }
            }
        }
        return m;
    }

    private VarMember declareVariable(AttrHandler attrHandler, String typeName, String name, VarTuple tuple) {
        VarMember var = null;
        VarMember test = (VarMember)tuple.getEntryAt(name);
        if (test == null) {
            tuple.declare(attrHandler, typeName, name);
            var = (VarMember)tuple.getEntryAt(name);
        } else if (!test.getDeclaration().getTypeName().equals(typeName)) {
            tuple.declare(attrHandler, typeName, name);
            var = (VarMember)tuple.getEntryAt(name);
        } else {
            var = test;
        }
        return var;
    }

    private void declareVariable(Graph g, VarTuple tuple) {
        Enumeration elements = g.getElements();
        while (elements.hasMoreElements()) {
            GraphObject grob = (GraphObject)elements.nextElement();
            AttrInstance attrs = grob.getAttribute();
            ValueTuple values = (ValueTuple)attrs;
            for (int i = 0; i < values.getNumberOfEntries(); ++i) {
                ValueMember vm = values.getValueMemberAt(i);
                if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), vm.getExprAsText(), tuple);
            }
        }
    }

    public final OrdinaryMorphism createMatchfromMorph(OrdinaryMorphism base, AttrContext base_context) {
        OrdinaryMorphism match = new OrdinaryMorphism(base.getOriginal(), base.getImage(), base.getAttrManager().newContext(1, base_context));
        this.declareVariable(match.getImage(), (VarTuple)match.getAttrContext().getVariables());
        Enumeration elems = match.getOriginal().getElements();
        while (elems.hasMoreElements()) {
            GraphObject o = (GraphObject)elems.nextElement();
            GraphObject i = base.getImage(o);
            if (i == null) continue;
            try {
                match.addMapping(o, i);
            }
            catch (BadMappingException ex) {}
        }
        return match;
    }

    public final OrdinaryMorphism createMorphfromMorph(OrdinaryMorphism base, AttrContext base_context) {
        OrdinaryMorphism match = new OrdinaryMorphism(base.getOriginal(), base.getImage(), base.getAttrManager().newContext(0, base_context));
        Enumeration elems = match.getOriginal().getElements();
        while (elems.hasMoreElements()) {
            GraphObject o = (GraphObject)elems.nextElement();
            GraphObject i = base.getImage(o);
            if (i == null) continue;
            try {
                match.addMapping(o, i);
            }
            catch (BadMappingException ex) {}
        }
        return match;
    }

    public final void destroyMorphism(OrdinaryMorphism morph) {
        if (morph != null) {
            morph.dispose();
        }
    }

    public final Match createMatch(Rule rule, Graph graph) {
        Match match = new Match(rule, graph);
        if (match.getImage().getVariableNamesOfAttributes().size() != 0) {
            ((ContextView)match.getAttrContext()).setVariableContext(true);
        }
        return match;
    }

    public final Match createMatch(Rule rule, Graph graph, boolean implicit) {
        return this.createMatch(rule, graph, implicit, "");
    }

    public final Match createMatch(Rule rule, Graph graph, boolean implicit, String helpMarkOfVars) {
        Match match = new Match(rule, graph);
        int count = match.getAttrContext().getVariables().getSize();
        VarTuple vars = (VarTuple)match.getAttrContext().getVariables();
        if (implicit) {
            String mark = "_" + helpMarkOfVars;
            AttrViewSetting attrView = DefaultEditorFacade.self().getTopEditor().getViewSetting();
            Enumeration elements = graph.getElements();
            while (elements.hasMoreElements()) {
                GraphObject grob = (GraphObject)elements.nextElement();
                AttrInstance attrs = grob.getAttribute();
                ValueTuple values = (ValueTuple)attrs;
                for (int i = 0; i < values.getNumberOfEntries(); ++i) {
                    ValueMember vm = values.getValueMemberAt(i);
                    if (vm.isSet()) continue;
                    String t = vm.getName() + String.valueOf(count) + mark;
                    this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), t, vars);
                    ++count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                }
            }
        }
        return match;
    }

    public Match makeMatch(Rule rule, OrdinaryMorphism morph) {
        return this.makeMatch(rule, morph, "");
    }

    public Match makeMatch(Rule rule, OrdinaryMorphism morph, String helpMarkOfVars) {
        String mark = "";
        if (!helpMarkOfVars.equals("")) {
            mark = "_" + helpMarkOfVars;
        }
        AttrViewSetting attrView = DefaultEditorFacade.self().getTopEditor().getViewSetting();
        Match m = this.createMatch(rule, morph.getImage(), true);
        boolean variableContext = false;
        if (m.getImage().getVariableNamesOfAttributes().size() != 0 || ((ContextView)morph.getAttrContext()).isVariableContext()) {
            ((ContextView)m.getAttrContext()).setVariableContext(true);
            variableContext = true;
        }
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        int count = vars.getSize();
        Enumeration elements = morph.getDomain();
        while (elements.hasMoreElements()) {
            GraphObject obj = (GraphObject)elements.nextElement();
            GraphObject img = morph.getImage(obj);
            if (img == null) continue;
            if (variableContext) {
                AttrInstance objAttrs = obj.getAttribute();
                ValueTuple objValues = (ValueTuple)objAttrs;
                AttrInstance attrs = img.getAttribute();
                ValueTuple values = (ValueTuple)attrs;
                for (int i = 0; i < values.getNumberOfEntries(); ++i) {
                    String t;
                    ValueMember objvm = objValues.getValueMemberAt(i);
                    ValueMember vm = values.getValueMemberAt(i);
                    if (objvm.isSet() && !vm.isSet()) {
                        if (objvm.getExpr().isVariable()) {
                            t = vm.getName() + String.valueOf(count) + mark;
                            this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), t, vars);
                            ++count;
                            vm.setExprAsText(t);
                            vm.setTransient(true);
                            continue;
                        }
                        t = objvm.getExprAsText();
                        vm.setExprAsText(t);
                        vm.setTransient(true);
                        continue;
                    }
                    if (!objvm.isSet() && vm.isSet() || objvm.isSet() || vm.isSet()) continue;
                    t = vm.getName() + String.valueOf(count) + mark;
                    this.declareVariable(vm.getDeclaration().getHandler(), vm.getDeclaration().getTypeName(), t, vars);
                    ++count;
                    vm.setExprAsText(t);
                    vm.setTransient(true);
                }
            }
            try {
                m.addMapping(obj, img);
            }
            catch (BadMappingException e) {
                this.destroyMatch(m);
                m = null;
                return null;
            }
        }
        return m;
    }

    public final void destroyMatch(OrdinaryMorphism match) {
        this.destroyMorphism(match);
    }

    public void renameSimilarVariable(Rule r1, Rule r2) {
        int index = 1;
        String mark = String.valueOf(index);
        VarTuple varsm1 = (VarTuple)r1.getAttrContext().getVariables();
        VarTuple varsm2 = (VarTuple)r2.getAttrContext().getVariables();
        for (int i = 0; i < varsm1.getSize(); ++i) {
            VarMember vm1 = varsm1.getVarMemberAt(i);
            VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
            if (vm2 == null) continue;
            String from = vm2.getName();
            String to = vm2.getName() + mark;
            while (varsm2.getVarMemberAt(to) != null) {
                mark = String.valueOf(index++);
                to = vm2.getName() + mark;
            }
            vm2.getDeclaration().setName(to);
            this.setAttributeVariable(r2.getSource(), from, to, varsm2);
            this.setAttributeVariable(r2.getTarget(), from, to, varsm2);
            CondTuple conds = (CondTuple)r2.getAttrContext().getConditions();
            this.renameVariableInCondition(conds, from, to);
            Enumeration e = r2.getNACs();
            while (e.hasMoreElements()) {
                OrdinaryMorphism nac = (OrdinaryMorphism)e.nextElement();
                this.setAttributeVariable(nac.getTarget(), from, to, varsm2);
            }
        }
    }

    public void renameSimilarVariable(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        int index = 1;
        String mark = String.valueOf(index);
        VarTuple varsm1 = (VarTuple)m1.getAttrContext().getVariables();
        VarTuple varsm2 = (VarTuple)m2.getAttrContext().getVariables();
        for (int i = 0; i < varsm1.getSize(); ++i) {
            VarMember vm1 = varsm1.getVarMemberAt(i);
            VarMember vm2 = varsm2.getVarMemberAt(vm1.getName());
            if (vm2 == null || !vm1.getDeclaration().getTypeName().equals(vm2.getDeclaration().getTypeName())) continue;
            String from = vm2.getName();
            String to = vm2.getName() + mark;
            while (varsm2.getVarMemberAt(to) != null) {
                mark = String.valueOf(index++);
                to = vm2.getName() + mark;
            }
            vm2.getDeclaration().setName(to);
            this.setAttributeVariable(m2.getSource(), from, to, varsm2);
            this.setAttributeVariable(m2.getTarget(), from, to, varsm2);
            CondTuple conds = (CondTuple)m2.getAttrContext().getConditions();
            this.renameVariableInCondition(conds, from, to);
        }
    }

    private void renameVariableInCondition(CondTuple conds, String from, String to) {
        for (int j = 0; j < conds.getSize(); ++j) {
            CondMember cm = conds.getCondMemberAt(j);
            String condStr = cm.getExprAsText();
            Vector v1 = cm.getAllVariables();
            if (!v1.contains(from)) continue;
            JexExpr oldExpr = (JexExpr)cm.getExpr();
            Vector variables = new Vector();
            oldExpr.getAllVariables(variables);
            this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, null);
        }
    }

    private void setAttributeVariable(Graph g, String from, String to, VarTuple vars) {
        Enumeration e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject obj = (GraphObject)e.nextElement();
            ValueTuple fromObj = (ValueTuple)obj.getAttribute();
            for (int i = 0; i < fromObj.getSize(); ++i) {
                ValueMember fromVM = fromObj.getValueMemberAt(i);
                if (!fromVM.isSet()) continue;
                if (fromVM.getExpr().isVariable()) {
                    if (!fromVM.getExprAsText().equals(from) || vars.getVarMemberAt(to) == null) continue;
                    fromVM.setExprAsText(to);
                    continue;
                }
                if (!fromVM.getExpr().isComplex()) continue;
                VarMember toVM = vars.getVarMemberAt(to);
                JexExpr oldExpr = (JexExpr)fromVM.getExpr();
                Vector variables = new Vector();
                oldExpr.getAllVariables(variables);
                this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, vars);
            }
        }
    }

    private void findPrimaryAndReplace(SimpleNode node, String from, String to, VarTuple vars) {
        for (int j = 0; j < node.jjtGetNumChildren(); ++j) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(j);
            if (n instanceof ASTPrimaryExpression) {
                SimpleNode test;
                HandlerExpr expression;
                HandlerType t;
                VarMember vm;
                int i;
                for (int j1 = 0; j1 < n.jjtGetNumChildren(); ++j1) {
                    SimpleNode n1 = (SimpleNode)n.jjtGetChild(j1);
                    if (!(n1 instanceof ASTExpression)) continue;
                    this.findPrimaryAndReplace(n1, from, to, vars);
                }
                String ident = ((ASTPrimaryExpression)n).getIdentifier();
                if (!n.getString().equals(from)) continue;
                SymbolTable symbs = SimpleNode.getSymbolTable();
                boolean to_found = false;
                ContextView context = (ContextView)symbs;
                VarTuple vt = (VarTuple)context.getVariables();
                for (i = 0; i < vt.getSize(); ++i) {
                    vm = vt.getVarMemberAt(i);
                    if (!vm.getName().equals(to)) continue;
                    to_found = true;
                    t = vm.getDeclaration().getType();
                    try {
                        expression = vm.getHandler().newHandlerExpr(t, to);
                        test = (SimpleNode)expression.getAST().jjtGetChild(0);
                        node.replaceChildWith(n, test);
                        continue;
                    }
                    catch (AttrHandlerException ex) {
                        // empty catch block
                    }
                }
                if (to_found) continue;
                for (i = 0; i < vars.getSize(); ++i) {
                    vm = vars.getVarMemberAt(i);
                    if (!vm.getName().equals(to)) continue;
                    to_found = true;
                    t = vm.getDeclaration().getType();
                    try {
                        expression = vm.getHandler().newHandlerExpr(t, to);
                        test = (SimpleNode)expression.getAST().jjtGetChild(0);
                        node.replaceChildWith(n, test);
                        continue;
                    }
                    catch (AttrHandlerException ex) {
                        // empty catch block
                    }
                }
                if (to_found) continue;
                System.out.println("Something wrong again:  " + to + "  NOT FOUND! CANNOT replace.");
                continue;
            }
            this.findPrimaryAndReplace(n, from, to, vars);
        }
    }
}

