/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.impl.ContextView;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueTuple;
import agg.util.Debug;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import colim.ALPHA_DIAGRAM;
import colim.COLIM_DEFS;
import colim.COLIM_VECTOR;
import colim.INT_VECTOR;
import colim.SET_DIAGRAM;
import com.objectspace.jgl.Pair;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ColimDiagram
implements COLIM_DEFS {
    private Graph itsColimGraph;
    private Dictionary itsGraphIndexMap;
    private ALPHA_DIAGRAM itsDiagram = new ALPHA_DIAGRAM();
    private Vector itsColimMorphisms;
    private boolean itsInplaceFlag;
    private TypeException typeException;
    private Vector newNodes;
    private Vector newArcs;
    private Vector oldNodes;
    private Vector oldArcs;
    private Vector remNodes;
    private Vector remArcs;
    private boolean colimitFailed;
    private boolean adoptEntriesWhereEmpty = false;

    public ColimDiagram(Graph result) {
        this.itsColimGraph = result;
        this.itsColimMorphisms = new Vector();
        this.itsGraphIndexMap = new Hashtable(8);
        this.itsInplaceFlag = false;
        this.newNodes = new Vector();
        this.newArcs = new Vector();
        this.oldNodes = new Vector();
        this.oldArcs = new Vector();
        this.remNodes = new Vector();
        this.remArcs = new Vector();
    }

    public void addNode(Graph graph) {
        GraphObject anObject;
        COLIM_VECTOR allObjects = new COLIM_VECTOR(32);
        COLIM_VECTOR allObjectsRefs = new COLIM_VECTOR(32);
        COLIM_VECTOR allObjectsAttrs = new COLIM_VECTOR(32);
        Hashtable<GraphObject, Integer> anIndexMap = new Hashtable<GraphObject, Integer>(32);
        if (graph == this.itsColimGraph) {
            this.itsInplaceFlag = true;
        }
        Enumeration anObjectIter = graph.getElements();
        int i = 0;
        while (anObjectIter.hasMoreElements()) {
            anObject = (GraphObject)anObjectIter.nextElement();
            allObjects.push_back(anObject);
            ((Dictionary)anIndexMap).put(anObject, new Integer(i));
            ++i;
        }
        allObjectsRefs.ensureCapacity(allObjects.size());
        for (i = 0; i < allObjects.size(); ++i) {
            anObject = (GraphObject)allObjects.at(i);
            INT_VECTOR anObjectsRefs = new INT_VECTOR(2);
            if (anObject.isNode()) {
                anObjectsRefs.push_back(i);
                anObjectsRefs.push_back(i);
            } else {
                anObjectsRefs.push_back((Integer)((Dictionary)anIndexMap).get(((Arc)anObject).getSource()));
                anObjectsRefs.push_back((Integer)((Dictionary)anIndexMap).get(((Arc)anObject).getTarget()));
            }
            allObjectsRefs.push_back(anObjectsRefs);
            COLIM_VECTOR anObjectsAttrs = new COLIM_VECTOR(1);
            anObjectsAttrs.push_back(anObject.getType());
            allObjectsAttrs.push_back(anObjectsAttrs);
        }
        i = this.itsDiagram.insert_object(allObjects, allObjectsRefs, allObjectsAttrs, graph.getName());
        this.itsGraphIndexMap.put(graph, new Integer(i));
    }

    public void addEdge(Morphism morph) {
        Graph aSourceGraph = morph.getOriginal();
        Graph aTargetGraph = morph.getImage();
        Hashtable aTargetIndexMap = new Hashtable(32);
        Enumeration anObjectIter = aTargetGraph.getElements();
        GraphObject anObject = null;
        int i = 0;
        while (anObjectIter.hasMoreElements()) {
            ((Dictionary)aTargetIndexMap).put(anObjectIter.nextElement(), new Integer(i));
            ++i;
        }
        INT_VECTOR aMorphism = new INT_VECTOR(64);
        anObjectIter = aSourceGraph.getElements();
        while (anObjectIter.hasMoreElements()) {
            anObject = morph.getImage((GraphObject)anObjectIter.nextElement());
            if (anObject != null) {
                if (((Dictionary)aTargetIndexMap).get(anObject) != null) {
                    aMorphism.push_back((Integer)((Dictionary)aTargetIndexMap).get(anObject));
                    continue;
                }
                aMorphism.push_back(-1);
                continue;
            }
            aMorphism.push_back(-1);
        }
        this.itsDiagram.insert_morphism(aMorphism, (Integer)this.itsGraphIndexMap.get(aSourceGraph), (Integer)this.itsGraphIndexMap.get(aTargetGraph));
    }

    public final void computeColimit() throws TypeException {
        this.adoptEntriesWhereEmpty = false;
        COLIM_VECTOR items = this.itsDiagram.get_colimit_items_total();
        COLIM_VECTOR refs = this.itsDiagram.get_colimit_refs_total();
        COLIM_VECTOR attrs = this.itsDiagram.get_colimit_attrs_total();
        this.convertColimit(items, refs, attrs);
    }

    public final void computeColimit(boolean adoptEntries) throws TypeException {
        this.adoptEntriesWhereEmpty = adoptEntries;
        COLIM_VECTOR items = this.itsDiagram.get_colimit_items_total();
        COLIM_VECTOR refs = this.itsDiagram.get_colimit_refs_total();
        COLIM_VECTOR attrs = this.itsDiagram.get_colimit_attrs_total();
        this.convertColimit(items, refs, attrs);
    }

    public final void requestEdge(OrdinaryMorphism morph) {
        Graph aTargetGraph = morph.getImage();
        if (aTargetGraph == this.itsColimGraph) {
            this.itsColimMorphisms.add(morph);
        }
    }

    private final void convertColimit(COLIM_VECTOR items, COLIM_VECTOR refs, COLIM_VECTOR attrs) throws TypeException {
        int anObjIndex;
        this.newNodes = new Vector();
        this.newArcs = new Vector();
        this.oldNodes = new Vector();
        this.oldArcs = new Vector();
        this.remNodes = new Vector();
        this.remArcs = new Vector();
        this.colimitFailed = false;
        SET_DIAGRAM anItemDiagram = this.itsDiagram.get_item_diagram();
        Vector allColimItems = null;
        if (this.itsInplaceFlag) {
            int i;
            boolean anObjectLeftToCreate;
            Vector allOrigs = new Vector(items.size());
            for (int i2 = 0; i2 < items.size(); ++i2) {
                allOrigs.addElement(new Vector(2));
            }
            Debug.println("after init Vector allOrigs' size is " + allOrigs.size(), this);
            int aColimGraphIndex = (Integer)this.itsGraphIndexMap.get(this.itsColimGraph);
            int aFirstIndex = anItemDiagram.set_at_node((int)aColimGraphIndex).lower;
            int aLastIndex = anItemDiagram.set_at_node((int)aColimGraphIndex).upper;
            for (anObjIndex = aFirstIndex; anObjIndex <= aLastIndex; ++anObjIndex) {
                GraphObject anOrigObj = (GraphObject)anItemDiagram.get_element(anObjIndex);
                int anImgIndex = anItemDiagram.get_colimit_pos(anObjIndex);
                if (anImgIndex == -1) {
                    if (anOrigObj.isNode()) {
                        this.oldNodes.add(anOrigObj);
                        this.itsColimGraph.destroyNode((Node)anOrigObj, false);
                        continue;
                    }
                    this.oldArcs.add(anOrigObj);
                    this.itsColimGraph.destroyArc((Arc)anOrigObj, false);
                    continue;
                }
                ((Vector)allOrigs.elementAt(anImgIndex)).addElement(anOrigObj);
                if (anOrigObj.isNode()) {
                    this.remNodes.add(anOrigObj);
                    continue;
                }
                this.remArcs.add(anOrigObj);
            }
            do {
                anObjectLeftToCreate = false;
                block9: for (i = 0; i < items.size(); ++i) {
                    Vector aCurOrigs = (Vector)allOrigs.elementAt(i);
                    switch (aCurOrigs.size()) {
                        case 0: {
                            INT_VECTOR anObjectsRefs = (INT_VECTOR)refs.item(i);
                            Vector aSrcOrigs = (Vector)allOrigs.elementAt(anObjectsRefs.item(0));
                            Vector aTarOrigs = (Vector)allOrigs.elementAt(anObjectsRefs.item(1));
                            GraphObject gobj = (GraphObject)items.item(i);
                            Type aType = gobj.getType();
                            if (gobj.isNode()) {
                                Node n = this.itsColimGraph.createNode(aType);
                                n.setContextUsage(gobj.getContextUsage());
                                this.newNodes.addElement(n);
                                ((Vector)allOrigs.elementAt(i)).addElement(n);
                            } else if (aSrcOrigs.size() > 0 && aTarOrigs.size() > 0) {
                                try {
                                    Arc a = this.itsColimGraph.createArc(aType, (Node)aSrcOrigs.firstElement(), (Node)aTarOrigs.firstElement());
                                    this.newArcs.addElement(a);
                                    ((Vector)allOrigs.elementAt(i)).addElement(a);
                                }
                                catch (TypeException ex) {
                                    this.typeException = ex;
                                    i = items.size();
                                    anObjectLeftToCreate = false;
                                    this.colimitFailed = true;
                                    this.destroyNewGraphObjects();
                                    this.restoreDestroyedGraphObjects();
                                    this.clearRestoreContainers();
                                    throw ex;
                                }
                            } else {
                                anObjectLeftToCreate = true;
                            }
                            if (!anObjectLeftToCreate) continue block9;
                            Debug.println("Delaying object creation!", this);
                            continue block9;
                        }
                        case 1: {
                            continue block9;
                        }
                        default: {
                            Debug.println("glue this object!", this);
                            for (int j = 1; j < aCurOrigs.size(); ++j) {
                                this.itsColimGraph.glue((GraphObject)aCurOrigs.elementAt(0), (GraphObject)aCurOrigs.elementAt(j));
                            }
                        }
                    }
                }
            } while (anObjectLeftToCreate);
            if (!this.colimitFailed) {
                allColimItems = allOrigs;
                for (i = 0; i < allColimItems.size(); ++i) {
                    allColimItems.setElementAt(((Vector)allColimItems.elementAt(i)).firstElement(), i);
                }
            }
        } else {
            System.out.println("agg.xt_basis.ColimDiagram:  Sorry, only inplace computation is supported yet");
            allColimItems = null;
            return;
        }
        Enumeration aMorphIter = this.itsColimMorphisms.elements();
        while (aMorphIter.hasMoreElements()) {
            OrdinaryMorphism aColimMorph = (OrdinaryMorphism)aMorphIter.nextElement();
            int aSrcGraph = (Integer)this.itsGraphIndexMap.get(aColimMorph.getOriginal());
            Debug.println("Computing colimit morphism " + aColimMorph.getName(), this);
            for (anObjIndex = anItemDiagram.set_at_node((int)aSrcGraph).lower; anObjIndex <= anItemDiagram.set_at_node((int)aSrcGraph).upper; ++anObjIndex) {
                int aTarPos = anItemDiagram.get_colimit_pos(anObjIndex);
                if (aTarPos == -1) continue;
                GraphObject aSrc = (GraphObject)anItemDiagram.get_element(anObjIndex);
                GraphObject aTar = (GraphObject)allColimItems.elementAt(aTarPos);
                aColimMorph.addMapping(aSrc, aTar);
                if (!this.adoptEntriesWhereEmpty) continue;
                this.adoptEntriesWhereEmpty(aColimMorph, aSrc, aTar);
            }
        }
    }

    private void adoptEntriesWhereEmpty(OrdinaryMorphism morph, GraphObject from, GraphObject to) {
        ContextView context;
        Vector mappings;
        if (morph.getImage(from) != null && (mappings = (context = (ContextView)morph.getAttrContext()).getMappingsToTarget((ValueTuple)to.getAttribute())) != null) {
            ((TupleMapping)mappings.elementAt(0)).adoptEntriesWhereEmpty((ValueTuple)from.getAttribute(), (ValueTuple)to.getAttribute());
        }
    }

    public void undoColimit() {
        this.destroyNewGraphObjects();
        this.restoreDestroyedGraphObjects();
        this.restorRemainedGraphObjects();
        this.clearRestoreContainers();
    }

    private void destroyNewGraphObjects() {
        int k;
        Enumeration aMorphIter = this.itsColimMorphisms.elements();
        while (aMorphIter.hasMoreElements()) {
            int k2;
            OrdinaryMorphism aColimMorph = (OrdinaryMorphism)aMorphIter.nextElement();
            for (k2 = 0; k2 < this.newArcs.size(); ++k2) {
                Arc a = (Arc)this.newArcs.elementAt(k2);
                aColimMorph.removeMapping(a);
            }
            for (k2 = 0; k2 < this.newNodes.size(); ++k2) {
                Node n = (Node)this.newNodes.elementAt(k2);
                aColimMorph.removeMapping(n);
            }
        }
        for (k = 0; k < this.newArcs.size(); ++k) {
            Arc a = (Arc)this.newArcs.elementAt(k);
            try {
                this.itsColimGraph.destroyArc(a);
                continue;
            }
            catch (TypeException ex) {
                ex.printStackTrace();
            }
        }
        for (k = 0; k < this.newNodes.size(); ++k) {
            Node n = (Node)this.newNodes.elementAt(k);
            try {
                this.itsColimGraph.destroyNode(n);
                continue;
            }
            catch (TypeException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void restoreDestroyedGraphObjects() {
        int k;
        Vector<Pair> tmp = new Vector<Pair>();
        for (k = 0; k < this.oldNodes.size(); ++k) {
            Node n = (Node)this.oldNodes.elementAt(k);
            try {
                Node nn = this.itsColimGraph.createNode(n);
                tmp.add(new Pair(n, nn));
                continue;
            }
            catch (TypeException ex) {
                ex.printStackTrace();
            }
        }
        for (k = 0; k < this.oldArcs.size(); ++k) {
            Arc a = (Arc)this.oldArcs.elementAt(k);
            Node s = null;
            Node t = null;
            for (int k1 = 0; k1 < tmp.size(); ++k1) {
                Pair p = (Pair)tmp.elementAt(k1);
                if (((Node)a.getSource()).equals((Node)p.first)) {
                    s = (Node)p.second;
                }
                if (!((Node)a.getTarget()).equals((Node)p.first)) continue;
                t = (Node)p.second;
            }
            if (s == null || t == null) continue;
            try {
                this.itsColimGraph.createArc(a, s, t);
                continue;
            }
            catch (TypeException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void restorRemainedGraphObjects() {
        Enumeration e = this.itsColimGraph.getElements();
        block0: while (e.hasMoreElements()) {
            int k;
            GraphObject o = (GraphObject)e.nextElement();
            if (o.isNode()) {
                for (k = 0; k < this.remNodes.size(); ++k) {
                    Node n = (Node)this.remNodes.elementAt(k);
                    if (!((Node)o).equals(n)) continue;
                    o.getAttribute().copyEntries(n.getAttribute());
                    continue block0;
                }
                continue;
            }
            for (k = 0; k < this.remArcs.size(); ++k) {
                Arc a = (Arc)this.remArcs.elementAt(k);
                if (!((Arc)o).equals(a)) continue;
                o.getAttribute().copyEntries(a.getAttribute());
                continue block0;
            }
        }
    }

    public void clearRestoreContainers() {
        this.newNodes.removeAllElements();
        this.newArcs.removeAllElements();
        this.oldNodes.removeAllElements();
        this.oldArcs.removeAllElements();
        this.remNodes.removeAllElements();
        this.remArcs.removeAllElements();
    }
}

