/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Solution_Backjump;
import agg.util.csp.Variable;
import agg.xt_basis.ALR_CSP;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.OrdinaryMorphism;
import com.objectspace.jgl.Pair;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class Completion_CSP
extends MorphCompletionStrategy {
    private ALR_CSP itsCSP;
    private Morphism itsMorph;
    private boolean nonDeterministic;
    private HashMap mapInputParameter = new HashMap(1);
    private String errorMsg;
    private static final BitSet itsSupportedProperties = new BitSet(1);

    public Completion_CSP() {
        super(itsSupportedProperties);
        this.nonDeterministic = true;
    }

    public Completion_CSP(boolean nonDeterministicSearch) {
        super(itsSupportedProperties);
        this.nonDeterministic = nonDeterministicSearch;
    }

    private final void initialize(OrdinaryMorphism morph) throws BadMappingException {
        this.itsMorph = morph;
        AttrContext aContext = morph instanceof Match ? morph.getAttrManager().newContext(1, ((Match)morph).getRule().getAttrContext()) : (morph instanceof NACStarMorphism ? morph.getAttrManager().newContext(1, ((NACStarMorphism)morph).getRelatedMatchContext()) : morph.getAttrManager().newContext(0));
        this.itsCSP = this.nonDeterministic ? new ALR_CSP(morph.getOriginal(), aContext, this.createSolutionStrategy()) : new ALR_CSP(morph.getOriginal(), aContext, this.createSolutionStrategy(), false);
        this.itsCSP.setDomain(morph.getImage());
        Enumeration anEnum = morph.getOriginal().getElements();
        while (anEnum.hasMoreElements()) {
            GraphObject anObj = (GraphObject)anEnum.nextElement();
            GraphObject anImage = this.itsMorph.getImage(anObj);
            if (anImage == null) continue;
            Variable anObjVar = this.itsCSP.getVariable(anObj);
            anObjVar.setInstance(anImage);
            if (!anObjVar.checkConstraints().hasMoreElements()) continue;
            throw new BadMappingException("Partial morphism conflicts with some constraint!");
        }
    }

    protected SolutionStrategy createSolutionStrategy() {
        return new Solution_Backjump(this.getProperties().get(0));
    }

    protected final void reset() {
        this.itsMorph = null;
    }

    protected final boolean next(OrdinaryMorphism morph) {
        if (morph != this.itsMorph) {
            try {
                this.initialize(morph);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        boolean flag = false;
        this.errorMsg = "";
        this.storeValueOfInputParameter(morph);
        while (this.itsCSP.nextSolution()) {
            flag = true;
            this.errorMsg = "";
            Enumeration anObjIter = morph.getOriginal().getElements();
            anObjIter = morph.getOriginal().getElements();
            while (flag && anObjIter.hasMoreElements()) {
                GraphObject anImage;
                GraphObject anOrig = (GraphObject)anObjIter.nextElement();
                Variable imageVariable = this.itsCSP.getVariable(anOrig);
                if (imageVariable == null || (anImage = (GraphObject)imageVariable.getInstance()) == null || anOrig == null || anImage.equals(morph.getImage(anOrig))) continue;
                try {
                    morph.addMapping(anOrig, anImage);
                    if (morph.getImage(anOrig) != null) continue;
                    flag = false;
                }
                catch (BadMappingException ex) {
                    flag = false;
                }
            }
            if (!flag) continue;
            if (flag && !this.checkInputParameter(morph)) {
                flag = false;
            }
            if (flag && !this.checkObjectsWithSameVariable(morph)) {
                flag = false;
            }
            if (flag && !(morph instanceof NACStarMorphism) && !this.checkAttrCondition(morph)) {
                flag = false;
            }
            this.restoreValueOfInputParameter(morph);
            if (flag) break;
            if (!(morph instanceof Match)) continue;
            ((Match)morph).errorMsg = this.errorMsg;
        }
        return flag;
    }

    private void storeValueOfInputParameter(OrdinaryMorphism morph) {
        this.mapInputParameter = new HashMap(1);
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (avt != null) {
            int num = avt.getSize();
            for (int i = 0; i < num; ++i) {
                String val;
                VarMember var = avt.getVarMemberAt(i);
                if (!var.isInputParameter() || (val = var.getExprAsText()) == null) continue;
                this.mapInputParameter.put(var.getName(), val);
            }
        }
    }

    private void restoreValueOfInputParameter(OrdinaryMorphism morph) {
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (!this.mapInputParameter.isEmpty()) {
            for (String name : this.mapInputParameter.keySet()) {
                VarMember var;
                String val1;
                String val = (String)this.mapInputParameter.get(name);
                if (val.equals(val1 = (var = avt.getVarMemberAt(name)).getExprAsText())) continue;
                var.setExprAsText(val);
            }
        }
    }

    private boolean checkInputParameter(OrdinaryMorphism morph) {
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (!this.mapInputParameter.isEmpty()) {
            for (String name : this.mapInputParameter.keySet()) {
                String val = (String)this.mapInputParameter.get(name);
                VarMember var = avt.getVarMemberAt(name);
                if (!var.isInputParameter()) continue;
                String val1 = var.getExprAsText();
                if (!(morph instanceof NACStarMorphism)) {
                    if (val1 == null || var.getMark() == 2 || val.equals(val1)) continue;
                    this.errorMsg = "Value of the input parameter  [ " + var.getName() + " ] not found.";
                    return false;
                }
                if (val1 == null || var.getMark() != 2 || val.equals(val1)) continue;
                this.errorMsg = "Value of the input parameter  [ " + var.getName() + " ] not found.";
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectsWithSameVariable(OrdinaryMorphism morph) {
        VarTuple variables = (VarTuple)morph.getAttrContext().getVariables();
        for (int i = 0; i < variables.getSize(); ++i) {
            ValueMember mem;
            VarMember var = variables.getVarMemberAt(i);
            Vector<Pair> v = new Vector<Pair>();
            Enumeration iter = morph.getOriginal().getElements();
            while (iter.hasMoreElements()) {
                GraphObject orig = (GraphObject)iter.nextElement();
                ValueTuple origVal = (ValueTuple)orig.getAttribute();
                for (int k = 0; k < origVal.getSize(); ++k) {
                    mem = origVal.getValueMemberAt(k);
                    if (!mem.isSet() || !mem.getExpr().isVariable() || !mem.getExprAsText().equals(var.getName()) || !mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) continue;
                    v.add(new Pair(orig, new Integer(k)));
                }
            }
            if (v.size() <= 1) continue;
            Pair p = (Pair)v.elementAt(0);
            GraphObject img = morph.getImage((GraphObject)p.first);
            ValueTuple val = (ValueTuple)img.getAttribute();
            mem = val.getValueMemberAt((Integer)p.second);
            for (int j = 1; j < v.size(); ++j) {
                Pair pj = (Pair)v.elementAt(j);
                GraphObject imgj = morph.getImage((GraphObject)pj.first);
                ValueTuple valj = (ValueTuple)imgj.getAttribute();
                ValueMember memj = valj.getValueMemberAt((Integer)pj.second);
                if (mem.getExprAsText().equals(memj.getExprAsText())) continue;
                this.errorMsg = "Attribute match is failed.";
                return false;
            }
        }
        return true;
    }

    private boolean checkAttrCondition(OrdinaryMorphism morph) {
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        CondTuple conds = (CondTuple)morph.getAttrContext().getConditions();
        for (int i = 0; i < conds.getSize(); ++i) {
            CondMember cond = conds.getCondMemberAt(i);
            if (!cond.isDefinite() || cond.isTrue()) continue;
            this.errorMsg = "Attribute condition  [ " + cond.getExprAsText() + " ]  failed.";
            return false;
        }
        return true;
    }

    static {
        itsSupportedProperties.set(0);
        itsSupportedProperties.set(1);
        itsSupportedProperties.set(2);
    }
}

