/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.impl.VarTuple;
import agg.util.Debug;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public class Completion_NAC
extends MorphCompletionStrategy {
    private MorphCompletionStrategy itsStrategy;
    private transient Vector itsSavedState;
    private transient boolean globalNAC;
    private transient int countNACs;

    public Completion_NAC(MorphCompletionStrategy strat) {
        BitSet aSupportedBits = (BitSet)strat.getSupportedProperties().clone();
        aSupportedBits.set(3);
        this.initialize(aSupportedBits, strat.getProperties());
        this.getProperties().set(3);
        Debug.println("created.", this);
        this.itsStrategy = strat;
    }

    public Object clone() {
        Object aClone = super.clone();
        ((Completion_NAC)aClone).itsStrategy = (MorphCompletionStrategy)this.itsStrategy.clone();
        ((Completion_NAC)aClone).itsSavedState = null;
        return aClone;
    }

    protected final boolean next(OrdinaryMorphism morph) {
        if (morph instanceof Match && this.getProperties().get(3)) {
            Match aMatch = (Match)morph;
            this.saveState(aMatch);
            if (this.itsStrategy.next(aMatch)) {
                while (!this.areNACsSatisfied(aMatch)) {
                    if (this.globalNAC && ((VarTuple)aMatch.getAttrContext().getVariables()).getSize() == 0) {
                        return false;
                    }
                    if (this.itsStrategy.next(aMatch)) continue;
                    this.restoreState(aMatch);
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.itsStrategy.next(morph);
    }

    private final boolean areNACsSatisfied(Match match) {
        int i = 0;
        this.globalNAC = true;
        this.countNACs = 0;
        Enumeration allNACs = match.getRule().getNACs();
        while (allNACs.hasMoreElements()) {
            ++this.countNACs;
            Debug.println("Checking " + i++ + ". NAC", this);
            OrdinaryMorphism nac = (OrdinaryMorphism)allNACs.nextElement();
            if (!nac.isEnabled()) continue;
            if (nac.getSize() != 0) {
                this.globalNAC = false;
            }
            if (match.checkNAC(nac) == null) continue;
            Debug.println("NACs not satisfied!", this);
            return false;
        }
        Debug.println("NACs are satisfied!", this);
        return true;
    }

    private final void saveState(OrdinaryMorphism morph) {
        this.itsSavedState = new Vector();
        Enumeration aDomainEnum = morph.getDomain();
        while (aDomainEnum.hasMoreElements()) {
            GraphObject anObj = (GraphObject)aDomainEnum.nextElement();
            this.itsSavedState.addElement(anObj);
            this.itsSavedState.addElement(morph.getImage(anObj));
        }
    }

    private final void restoreState(OrdinaryMorphism morph) {
        morph.clear();
        if (this.itsSavedState == null) {
            return;
        }
        for (int i = 0; i < this.itsSavedState.size() - 1; i += 2) {
            morph.addMapping((GraphObject)this.itsSavedState.elementAt(i), (GraphObject)this.itsSavedState.elementAt(i + 1));
        }
        this.itsSavedState = null;
    }
}

