/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.StackItem;
import com.objectspace.jgl.Deque;
import com.objectspace.jgl.Pair;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class Completion_SimpleBT
extends MorphCompletionStrategy {
    private boolean itsInjectiveFlag;
    private OrdinaryMorphism itsMorphism;
    private Deque itsObjectsToMap;
    private Stack itsStack;
    private int itsState = 1;
    private Vector itsPreviousCompletion;
    private HashMap mapInputParameter = new HashMap(1);
    private String errorMsg;
    private static final int START = 1;
    private static final int SELECT = 2;
    private static final int MAP_NEXT = 3;
    private static final int BACK = 4;
    private static final int SUCCESS = 5;
    private static final int NO_MORE_COMPLETIONS = 6;

    public Completion_SimpleBT() {
        super(new BitSet(1));
        this.itsInjectiveFlag = false;
    }

    public Completion_SimpleBT(boolean injective) {
        super(new BitSet(1));
        this.itsInjectiveFlag = injective;
    }

    private final void initialize(OrdinaryMorphism morph) {
        this.itsMorphism = morph;
        this.itsStack = new Stack();
        this.itsObjectsToMap = new Deque();
        this.itsState = 1;
        this.itsPreviousCompletion = null;
        Enumeration iter = this.itsMorphism.getOriginal().getElements();
        while (iter.hasMoreElements()) {
            GraphObject obj = (GraphObject)iter.nextElement();
            if (this.itsMorphism.getImage(obj) != null) continue;
            this.itsObjectsToMap.pushBack(obj);
        }
    }

    private final GraphObject nextMapping() {
        if (this.itsStack.empty()) {
            return null;
        }
        GraphObject obj = ((StackItem)this.itsStack.peek()).object;
        Enumeration iter = ((StackItem)this.itsStack.peek()).iter;
        while (iter.hasMoreElements()) {
            try {
                GraphObject image = (GraphObject)iter.nextElement();
                Enumeration e = this.itsMorphism.getInverseImage(image);
                GraphObject o = null;
                if (e.hasMoreElements()) {
                    o = (GraphObject)e.nextElement();
                }
                if (this.itsInjectiveFlag && o != null) continue;
                this.itsMorphism.addMapping(obj, image);
                if (this.itsMorphism.getImage(obj) == null) continue;
                return image;
            }
            catch (BadMappingException exc) {
            }
        }
        return null;
    }

    protected final void reset() {
        this.itsMorphism = null;
    }

    protected final boolean next(OrdinaryMorphism morph) {
        this.storeValueOfInputParameter(morph);
        if (morph != this.itsMorphism) {
            this.initialize(morph);
        }
        if (this.itsState == 5) {
            this.savePreviousCompletion();
            this.itsState = 3;
        }
        block8: while (true) {
            switch (this.itsState) {
                case 1: {
                    if (this.itsMorphism.getOriginal().isEmpty()) {
                        this.itsState = 5;
                        continue block8;
                    }
                    this.itsState = 2;
                    continue block8;
                }
                case 2: {
                    GraphObject obj = this.selectObjectToMap();
                    if (obj == null) {
                        this.itsState = 5;
                        continue block8;
                    }
                    this.itsStack.push(new StackItem(obj, this.itsMorphism.getImage().getElements()));
                    this.itsState = 3;
                    continue block8;
                }
                case 3: {
                    GraphObject obj = this.nextMapping();
                    if (obj != null) {
                        this.itsState = 2;
                        continue block8;
                    }
                    this.itsState = 4;
                    continue block8;
                }
                case 4: {
                    if (this.itsStack.size() > 1) {
                        this.back();
                        this.itsState = 3;
                        continue block8;
                    }
                    this.itsState = 6;
                    continue block8;
                }
                case 5: {
                    if (!this.checkInputParameter(morph)) {
                        this.restoreValueOfInputParameter(morph);
                        this.itsState = 3;
                        continue block8;
                    }
                    if (!this.checkObjectsWithSameVariable(morph)) {
                        this.itsState = 3;
                        continue block8;
                    }
                    if (!(morph instanceof NACStarMorphism) && !this.checkAttrCondition(morph)) {
                        this.itsState = 3;
                        continue block8;
                    }
                    return true;
                }
                case 6: {
                    if (this.itsPreviousCompletion != null) {
                        this.restorePreviousCompletion();
                    }
                    return false;
                }
            }
        }
    }

    private final void back() {
        GraphObject obj = ((StackItem)this.itsStack.pop()).object;
        this.itsObjectsToMap.pushFront(obj);
        if (this.itsMorphism.getImage(obj) != null) {
            this.itsMorphism.removeMapping(obj);
        }
    }

    private final GraphObject selectObjectToMap() {
        if (this.itsObjectsToMap.isEmpty()) {
            return null;
        }
        GraphObject obj = (GraphObject)this.itsObjectsToMap.popFront();
        if (this.areReferencesMapped(obj)) {
            return obj;
        }
        this.itsObjectsToMap.pushBack(obj);
        return this.selectObjectToMap();
    }

    private final boolean areReferencesMapped(GraphObject obj) {
        if (obj.isArc()) {
            return this.itsMorphism.getImage(((Arc)obj).getSource()) != null && this.itsMorphism.getImage(((Arc)obj).getTarget()) != null;
        }
        return true;
    }

    private final void savePreviousCompletion() {
        this.itsPreviousCompletion = new Vector(2 * this.itsStack.size());
        for (int i = 0; i < this.itsStack.size(); ++i) {
            GraphObject obj = ((StackItem)this.itsStack.elementAt((int)i)).object;
            this.itsPreviousCompletion.addElement(obj);
            this.itsPreviousCompletion.addElement(this.itsMorphism.getImage(obj));
        }
    }

    private final void restorePreviousCompletion() {
        int i = 0;
        while (i < this.itsPreviousCompletion.size()) {
            this.itsMorphism.addMapping((GraphObject)this.itsPreviousCompletion.elementAt(i++), (GraphObject)this.itsPreviousCompletion.elementAt(i++));
        }
    }

    private void storeValueOfInputParameter(OrdinaryMorphism morph) {
        this.mapInputParameter = new HashMap(1);
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (avt != null) {
            int num = avt.getSize();
            for (int i = 0; i < num; ++i) {
                String val;
                VarMember var = avt.getVarMemberAt(i);
                if (!var.isInputParameter() || (val = var.getExprAsText()) == null) continue;
                Integer key = new Integer(i);
                this.mapInputParameter.put(key, val);
            }
        }
    }

    private void restoreValueOfInputParameter(OrdinaryMorphism morph) {
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (!this.mapInputParameter.isEmpty()) {
            for (Integer key : this.mapInputParameter.keySet()) {
                VarMember var;
                String val1;
                String val = (String)this.mapInputParameter.get(key);
                if (val.equals(val1 = (var = avt.getVarMemberAt(key)).getExprAsText())) continue;
                var.setExprAsText(val);
                var.checkValidity();
            }
        }
    }

    private boolean checkInputParameter(OrdinaryMorphism morph) {
        AttrVariableTuple avt = morph.getAttrContext().getVariables();
        if (!this.mapInputParameter.isEmpty()) {
            for (Integer key : this.mapInputParameter.keySet()) {
                String val = (String)this.mapInputParameter.get(key);
                VarMember var = avt.getVarMemberAt(key);
                if (!var.isInputParameter()) continue;
                String val1 = var.getExprAsText();
                if (!(morph instanceof NACStarMorphism)) {
                    if (val1 == null || var.getMark() == 2 || val.equals(val1)) continue;
                    this.errorMsg = "Value of the input parameter  [ " + var.getName() + " ] not found.";
                    return false;
                }
                if (val1 == null || var.getMark() != 2 || val.equals(val1)) continue;
                this.errorMsg = "Value of the input parameter  [ " + var.getName() + " ] not found.";
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectsWithSameVariable(OrdinaryMorphism morph) {
        VarTuple variables = (VarTuple)morph.getAttrContext().getVariables();
        for (int i = 0; i < variables.getSize(); ++i) {
            ValueMember mem;
            VarMember var = variables.getVarMemberAt(i);
            Vector<Pair> v = new Vector<Pair>();
            Enumeration iter = morph.getOriginal().getElements();
            while (iter.hasMoreElements()) {
                GraphObject orig = (GraphObject)iter.nextElement();
                ValueTuple origVal = (ValueTuple)orig.getAttribute();
                for (int k = 0; k < origVal.getSize(); ++k) {
                    mem = origVal.getValueMemberAt(k);
                    if (!mem.isSet() || !mem.getExpr().isVariable() || !mem.getExprAsText().equals(var.getName()) || !mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) continue;
                    v.add(new Pair(orig, new Integer(k)));
                }
            }
            if (v.size() <= 1) continue;
            Pair p = (Pair)v.elementAt(0);
            GraphObject img = morph.getImage((GraphObject)p.first);
            ValueTuple val = (ValueTuple)img.getAttribute();
            mem = val.getValueMemberAt((Integer)p.second);
            for (int j = 1; j < v.size(); ++j) {
                Pair pj = (Pair)v.elementAt(j);
                GraphObject imgj = morph.getImage((GraphObject)pj.first);
                ValueTuple valj = (ValueTuple)imgj.getAttribute();
                ValueMember memj = valj.getValueMemberAt((Integer)pj.second);
                if (mem.getExprAsText().equals(memj.getExprAsText())) continue;
                this.errorMsg = "Attribute match is failed.";
                return false;
            }
        }
        return true;
    }

    private boolean checkAttrCondition(OrdinaryMorphism morph) {
        CondTuple conds = (CondTuple)morph.getAttrContext().getConditions();
        for (int i = 0; i < conds.getSize(); ++i) {
            CondMember cond = conds.getCondMemberAt(i);
            if (!cond.isDefinite() || cond.isTrue()) continue;
            this.errorMsg = "Attribute condition  [ " + cond.getExprAsText() + " ]  failed.";
            return false;
        }
        return true;
    }
}

