/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrManager;
import agg.attribute.AttrMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Debug;
import agg.util.csp.BinaryConstraint;
import agg.util.csp.InstantiationHook;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import java.util.Vector;

public class Constraint_Attribute
extends BinaryConstraint
implements InstantiationHook {
    private GraphObject itsGraphObj;
    private AttrContext itsAttrContext;
    private AttrManager itsAttrManager;
    private AttrMapping itsAttrMapping;

    public Constraint_Attribute(GraphObject graphobj, Variable var, AttrContext ac, AttrManager man) {
        super(var, 1);
        var.addInstantiationHook(this);
        this.itsGraphObj = graphobj;
        this.itsAttrContext = ac;
        this.itsAttrManager = man;
        int fact = this.getWeightFactor();
        if (fact > 1) {
            this.itsWeight *= fact;
            var.addWeight(this.itsWeight);
        }
    }

    private int getWeightFactor() {
        if (this.itsGraphObj == null) {
            return 1;
        }
        VarTuple vars = null;
        if (this.itsAttrContext != null) {
            vars = (VarTuple)this.itsAttrContext.getVariables();
        }
        ValueTuple vt = (ValueTuple)this.itsGraphObj.getAttribute();
        for (int i = 0; i < vt.getSize(); ++i) {
            VarMember var;
            ValueMember vm = vt.getValueMemberAt(i);
            if (!vm.isSet()) continue;
            if (vm.getExpr().isConstant()) {
                return 100;
            }
            if (!vm.getExpr().isVariable() || vars == null || (var = vars.getVarMemberAt(vm.getExprAsText())) == null || !var.isInputParameter()) continue;
            return 200;
        }
        return 1;
    }

    public final boolean execute() {
        boolean result = this.itsAttrMapping != null;
        return result;
    }

    public final void instantiate(Variable var) {
        if (var.getInstance() instanceof GraphObject) {
            try {
                Debug.println("Checking Attribute match of these AttrInstances:\n\t" + this.itsGraphObj.getAttribute() + "\n\t" + ((GraphObject)var.getInstance()).getAttribute(), this);
                Debug.println("AttrContext: " + this.itsAttrContext, this);
                if (this.itsGraphObj.getAttribute().getType().compareTo(((GraphObject)var.getInstance()).getAttribute().getType())) {
                    this.unsetUsedVariable(this.itsGraphObj);
                    this.itsAttrMapping = this.itsAttrManager.newMapping(this.itsAttrContext, this.itsGraphObj.getAttribute(), ((GraphObject)var.getInstance()).getAttribute());
                } else {
                    Debug.println("AttrTypes don't match!", this);
                }
            }
            catch (AttrException exc) {
                this.unsetUsedVariable(this.itsGraphObj);
                this.itsAttrMapping = null;
                Debug.println("instantiate:: AttrTypes don't match!", this, Debug.MATCH);
            }
        }
    }

    public final void uninstantiate(Variable var) {
        if (var.getInstance() instanceof GraphObject) {
            GraphObject go = (GraphObject)var.getInstance();
            if (this.itsAttrContext != null) {
                this.unsetUsedVariable(go);
            }
            if (this.itsAttrMapping != null) {
                this.itsAttrMapping.remove();
                this.itsAttrMapping = null;
            }
        }
    }

    private void unsetUsedVariable(GraphObject go) {
        Vector attrVars = ((ValueTuple)go.getAttribute()).getAllVariableNames();
        VarTuple varTup = (VarTuple)this.itsAttrContext.getVariables();
        for (int i = 0; i < attrVars.size(); ++i) {
            String name = (String)attrVars.elementAt(i);
            VarMember vm = varTup.getVarMemberAt(name);
            if (vm == null) continue;
            vm.setExpr(null);
        }
    }
}

