/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.cons.AtomConstraint;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.Match;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.Version;
import com.objectspace.jgl.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class DefaultGraTraImpl
extends GraTra {
    Random ran = new Random();
    private boolean appliedOnes;
    private boolean allRulesEnabled = false;
    File f;
    FileOutputStream os;
    String protocolFileName = "";

    public Pair derivation(Match m) {
        return null;
    }

    public boolean apply() {
        if (this.grammar == null) {
            return false;
        }
        if (!this.allRulesEnabled) {
            for (int j = 0; j < this.currentRuleSet.size(); ++j) {
                if (((Rule)this.currentRuleSet.elementAt(j)).isEnabled()) continue;
                this.currentRuleSet.removeElementAt(j);
                --j;
            }
            this.allRulesEnabled = true;
        }
        boolean applied = false;
        while (!this.stopping && this.currentRuleSet.size() > 0 && !applied) {
            int i = this.ran.nextInt(this.currentRuleSet.size());
            this.currentRule = (Rule)this.currentRuleSet.elementAt(i);
            applied = this.apply(this.currentRule);
            String s0 = this.currentRule.getName() + " \t applied:  " + applied;
            this.writeTransformProtocol(s0);
            String s1 = "";
            if (!applied) {
                s1 = s1 + this.getErrorMsg();
                this.writeTransformProtocol(s1);
                this.currentRuleSet.removeElementAt(i);
                String ss1 = this.getRuleNames(this.currentRuleSet);
                this.writeTransformProtocol(ss1);
                continue;
            }
            this.appliedOnes = true;
            if (this.isGraphConsistent()) continue;
            this.stopping = true;
        }
        return applied;
    }

    public void transform(Vector rules) {
        Vector ruleSet = (Vector)rules.clone();
        for (int j = 0; j < ruleSet.size(); ++j) {
            if (((Rule)ruleSet.elementAt(j)).isEnabled()) continue;
            ruleSet.removeElementAt(j);
            --j;
        }
        this.allRulesEnabled = true;
        boolean applicable = true;
        while (!this.stopping && applicable) {
            String ss = this.getRuleNames(ruleSet);
            this.writeTransformProtocol(ss);
            this.currentRuleSet = (Vector)ruleSet.clone();
            applicable = this.apply();
        }
    }

    public void transform() {
        String dirName = this.grammar.getDirName();
        String fileName = this.grammar.getFileName();
        if (fileName == null || fileName.equals("")) {
            fileName = this.grammar.getName();
        }
        this.openTransformProtocol(dirName, fileName);
        String version = "Version:  AGG " + Version.getID() + "\n";
        this.writeTransformProtocol(version);
        String s0 = "Graph transformation of : " + this.grammar.getName();
        String s1 = "on graph : " + this.grammar.getGraph().getName();
        String s2 = this.getRuleNames(this.currentRuleSet);
        this.writeTransformProtocol(s0);
        this.writeTransformProtocol(s1);
        this.writeTransformProtocol(s2);
        this.writeTransformProtocol("\n");
        Pair pair = this.grammar.isReadyToTransform();
        Object test = null;
        if (pair != null) {
            test = pair.first;
        }
        if (test != null) {
            if (test instanceof Type) {
                s0 = (String)pair.second + "\nTransformation is stopped.";
                this.fireGraTra(new GraTraEvent((Object)this, 15, s0));
                System.out.println(s0);
                this.writeTransformProtocol(s0);
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            if (test instanceof Rule) {
                s0 = (String)pair.second + "\nTransformation is stopped.";
                this.fireGraTra(new GraTraEvent((Object)this, 9, s0));
                System.out.println(s0);
                this.writeTransformProtocol(s0);
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            if (test instanceof AtomConstraint) {
                s0 = (String)pair.second + "\nTransformation is stopped.";
                this.fireGraTra(new GraTraEvent((Object)this, 14, s0));
                System.out.println(s0);
                this.writeTransformProtocol(s0);
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
        } else if (!this.grammar.isGraphReadyForTransform()) {
            s0 = "Graph of the grammar is not fine.\nPlease check attribute settings of the objects. \nTransformation is stopped.";
            this.fireGraTra(new GraTraEvent((Object)this, 10, s0));
            System.out.println(s0);
            this.writeTransformProtocol(s0);
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return;
        }
        long time0 = System.currentTimeMillis();
        this.transform(this.currentRuleSet);
        if (this.appliedOnes) {
            long time1 = System.currentTimeMillis();
            long timeMillis = time1 - time0;
            long time_sec = timeMillis / 1000L;
            long msec = timeMillis - time_sec * 1000L;
            long time_min = time_sec / 60L;
            long sec = time_sec - time_min * 60L;
            long hour = time_min / 60L;
            long min = time_min - hour * 60L;
            System.out.println("Used time for graph transformation: " + hour + "h " + min + "m " + sec + "s " + msec + "ms");
            this.writeTransformProtocol("\nUsed time: " + hour + "h " + min + "m " + sec + "s " + msec + "ms");
        }
        this.writeTransformProtocol("\nGraph transformation is finished");
        this.fireGraTra(new GraTraEvent(this, 5));
        this.closeTransformProtocol();
    }

    public boolean didTransformation() {
        return this.appliedOnes;
    }

    public String getProtocolName() {
        return this.protocolFileName;
    }

    private String getRuleNames(Vector rules) {
        String names = "[ ";
        for (int j = 0; j < rules.size(); ++j) {
            Rule r = (Rule)rules.elementAt(j);
            names = names + r.getName() + " ";
        }
        names = names + "]";
        return names;
    }

    private void openTransformProtocol(String dirName, String fileName) {
        String fName = "DefaultGraTra.log";
        if (fileName != null && !fileName.equals("")) {
            fName = fileName.endsWith(".ggx") ? fileName.substring(0, fileName.length() - 4) + "_GraTra.log" : fileName + "_GraTra.log";
        }
        if (dirName != null && !dirName.equals("")) {
            this.f = new File(dirName);
            dirName = this.f.exists() ? (this.f.isFile() ? (this.f.getParent() != null ? this.f.getParent() + File.separator : "." + File.separator) : (this.f.isDirectory() ? this.f.getPath() + File.separator : "." + File.separator)) : "." + File.separator;
            this.f = new File(dirName + fName);
        } else {
            this.f = new File(fName);
        }
        try {
            this.os = new FileOutputStream(this.f);
            this.protocolFileName = this.f.getName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.writeTransformProtocol(new Date().toString());
    }

    private void writeTransformProtocol(String s) {
        if (this.os == null) {
            return;
        }
        try {
            if (!s.equals("\n")) {
                this.os.write(s.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void closeTransformProtocol() {
        if (this.os == null) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

