/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrType;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomConstraint;
import agg.cons.ConstraintLayer;
import agg.cons.Formula;
import agg.util.Debug;
import agg.util.Disposable;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionPropertyBits;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.Completion_CSP_NoBJ;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Completion_NAC;
import agg.xt_basis.Completion_SimpleBT;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.Step;
import agg.xt_basis.SubGraGra;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeImpl;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GraGra
implements Disposable,
XMLObject {
    protected Vector itsGraphs = new Vector(5);
    protected Vector itsRules = new Vector();
    protected MorphCompletionStrategy strategy;
    protected Vector itsAtomics = new Vector(5);
    protected Vector itsConstraints = new Vector(5);
    private String errConsistencyMsg;
    protected Vector gratraOptions;
    protected Vector itsMatches = new Vector(5);
    protected Vector itsPackages = new Vector(5);
    protected Graph itsGraph;
    protected Graph itsStartGraph;
    protected TypeSet typeSet;
    protected String itsName;
    protected String dirName;
    protected String fileName;
    protected Vector itsSubGraGras = new Vector(0);

    protected GraGra() {
        this(new Graph(true));
    }

    public GraGra(TypeSet newTypeSet) {
        this.setName("unnamed.gragra");
        this.typeSet = newTypeSet;
        this.gratraOptions = new Vector();
        this.itsGraph = new Graph(this.typeSet, true);
        this.itsGraphs.add(this.itsGraph);
        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
        this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
    }

    public GraGra(Graph g) {
        this.setName("unnamed.gragra");
        this.typeSet = g.getTypeSet();
        this.gratraOptions = new Vector();
        this.itsGraph = g;
        this.itsGraphs.add(this.itsGraph);
        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
        this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
    }

    public Vector getPackages() {
        return this.itsPackages;
    }

    public void setPackages(Vector n) {
        this.itsPackages = n;
    }

    public void addPackage(Pair p) {
        if (!this.itsPackages.contains(p)) {
            this.itsPackages.addElement(p);
        }
    }

    public void removePackage(Pair p) {
        if (this.itsPackages.contains(p)) {
            this.itsPackages.removeElement(p);
        }
    }

    private Graph createGraph() {
        Graph g = new Graph(this.typeSet, true);
        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
        g.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
        this.itsGraphs.add(g);
        return g;
    }

    public boolean addGraph(Graph g) {
        if (!this.itsGraphs.contains(g)) {
            this.itsGraphs.addElement(g);
            return true;
        }
        return false;
    }

    public void destroyGraph(Graph g) {
        if (this.itsGraphs.removeElement(g)) {
            g.dispose();
            g = null;
        }
    }

    public boolean removeGraph(Graph g) {
        return this.itsGraphs.removeElement(g);
    }

    public boolean isElement(Rule r) {
        int s = this.itsRules.size();
        for (int counter = 0; counter < s; ++counter) {
            Rule x = (Rule)this.itsRules.elementAt(counter);
            if (!x.equals(r)) continue;
            return true;
        }
        return false;
    }

    public boolean isElement(Graph g) {
        if (this.itsGraph.equals(g)) {
            return true;
        }
        return this.itsGraphs.contains(g);
    }

    public boolean isLayered() {
        return this.gratraOptions != null && this.gratraOptions.contains("layered");
    }

    public Vector getLayers() {
        Vector<String> v = new Vector<String>(5);
        RuleLayer layer = new RuleLayer(this.itsRules.elements());
        Hashtable invertedRuleLayer = layer.invertLayer();
        Enumeration e = invertedRuleLayer.keys();
        while (e.hasMoreElements()) {
            v.add(((Integer)e.nextElement()).toString());
        }
        return v;
    }

    public synchronized boolean resetGraph(Graph g) {
        if (this.typeSet != null && g.getTypeSet() != null && this.typeSet.compareTo(g.getTypeSet())) {
            int indxOther = this.itsGraphs.indexOf(g);
            int indx = this.itsGraphs.indexOf(this.itsGraph);
            if (indxOther == -1 && indx != -1) {
                this.itsGraphs.remove(this.itsGraph);
            }
            this.itsGraph = g;
            if (!this.itsGraphs.contains(this.itsGraph)) {
                if (indx != -1) {
                    this.itsGraphs.add(indx, this.itsGraph);
                } else {
                    this.itsGraphs.add(this.itsGraph);
                }
            }
            if (this.itsGraph.getAttrContext() == null || ((ContextView)this.itsGraph.getAttrContext()).getAllowedMapping() != 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            this.itsGraph.graphDidChange();
            return true;
        }
        return false;
    }

    public synchronized boolean resetGraph() {
        if (this.typeSet != null && this.itsStartGraph.getTypeSet() != null && this.typeSet.equals(this.itsStartGraph.getTypeSet())) {
            int indx = this.itsGraphs.indexOf(this.itsGraph);
            if (indx != -1) {
                this.itsGraphs.remove(this.itsGraph);
            }
            this.itsGraph = this.itsStartGraph.copy();
            if (indx != -1) {
                this.itsGraphs.add(indx, this.itsGraph);
            } else {
                this.itsGraphs.add(this.itsGraph);
            }
            if (this.itsGraph.getAttrContext() == null || ((ContextView)this.itsGraph.getAttrContext()).getAllowedMapping() != 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            this.itsGraph.graphDidChange();
            return true;
        }
        return false;
    }

    public synchronized boolean resetGraphWithoutGuarantee(Graph g) {
        if (g != null) {
            int indx = this.itsGraphs.indexOf(this.itsGraph);
            if (indx != -1) {
                this.itsGraphs.remove(this.itsGraph);
            }
            this.itsGraph = g.copy(this.typeSet);
            if (!this.itsGraphs.contains(this.itsGraph)) {
                if (indx != -1) {
                    this.itsGraphs.add(indx, this.itsGraph);
                } else {
                    this.itsGraphs.add(this.itsGraph);
                }
            }
            if (this.itsGraph.getAttrContext() == null || ((ContextView)this.itsGraph.getAttrContext()).getAllowedMapping() != 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            this.itsGraph.graphDidChange();
            return true;
        }
        return false;
    }

    public synchronized boolean importTypeGraph(Graph g, boolean rewrite) {
        if (!g.isTypeGraph()) {
            return false;
        }
        if (this.typeSet.getTypeGraph() == null) {
            this.typeSet.createTypeGraph();
        }
        if (rewrite) {
            this.typeSet.adaptTypes(g.getTypeSet().getTypes(), false);
        }
        Hashtable valueTable = this.storeAttrValueOfAttrTypeObserver(this.itsGraph);
        if (this.typeSet.importTypeGraph(g, rewrite)) {
            this.typeSet.refreshInheritanceArcs();
            this.restoreAttrValueOfObserver(valueTable);
            this.typeSet.getTypeGraph().graphDidChange();
            return true;
        }
        return false;
    }

    private Hashtable storeAttrValueOfAttrTypeObserver(Graph g) {
        Hashtable attrStore = new Hashtable();
        Enumeration<Type> types = this.typeSet.getTypes();
        while (types.hasMoreElements()) {
            TypeImpl t = (TypeImpl)types.nextElement();
            Enumeration observers = ((DeclTuple)t.getAttrType()).getObservers();
            while (observers.hasMoreElements()) {
                Object obs = observers.nextElement();
                if (!(obs instanceof ValueTuple)) continue;
                boolean hasAttrValue = false;
                ValueTuple valTuple = (ValueTuple)obs;
                for (int i = 0; i < valTuple.getSize(); ++i) {
                    ValueMember mem = valTuple.getValueMemberAt(i);
                    if (!mem.isSet()) continue;
                    hasAttrValue = true;
                    break;
                }
                if (!hasAttrValue) continue;
                DeclTuple dt = new DeclTuple((AttrTupleManager)AttrTupleManager.getDefaultManager());
                DeclTuple declTuple = (DeclTuple)t.getAttrType();
                for (int i = 0; i < declTuple.getSize(); ++i) {
                    DeclMember mem = (DeclMember)declTuple.getMemberAt(i);
                    dt.addMember(mem.getHandler(), mem.getTypeName(), mem.getName());
                }
                ValueTuple vt = new ValueTuple((AttrTupleManager)AttrTupleManager.getDefaultManager(), dt, (ContextView)valTuple.getContext());
                for (int i = 0; i < valTuple.getSize(); ++i) {
                    ValueMember mem = valTuple.getValueMemberAt(i);
                    ValueMember vm = vt.getValueMemberAt(mem.getName());
                    if (vm == null || !mem.isSet()) continue;
                    vm.setExprAsText(mem.getExprAsText());
                }
                if (!hasAttrValue) continue;
                attrStore.put(obs, vt);
            }
        }
        return attrStore;
    }

    private void restoreAttrValueOfObserver(Hashtable attrStore) {
        Enumeration<Type> types = this.typeSet.getTypes();
        while (types.hasMoreElements()) {
            TypeImpl t = (TypeImpl)types.nextElement();
            Enumeration observers = ((DeclTuple)t.getAttrType()).getObservers();
            while (observers.hasMoreElements()) {
                ValueTuple vt;
                Object obs = observers.nextElement();
                if (!(obs instanceof ValueTuple) || (vt = (ValueTuple)attrStore.get(obs)) == null) continue;
                ValueTuple valTuple = (ValueTuple)obs;
                for (int i = 0; i < valTuple.getSize(); ++i) {
                    ValueMember mem = valTuple.getValueMemberAt(i);
                    ValueMember vm = vt.getValueMemberAt(mem.getName());
                    if (vm == null || !vm.isSet()) continue;
                    mem.setExprAsText(vm.getExprAsText());
                }
            }
        }
    }

    public synchronized boolean importGraph(Graph g) {
        if (g.getTypeSet().getTypeGraph() != null && (this.typeSet.getTypeGraph() == null || this.typeSet.getTypeGraph().isEmpty() && this.getLevelOfTypeGraphCheck() == 0)) {
            if (!this.importTypeGraph(g.getTypeSet().getTypeGraph(), true)) {
                return false;
            }
            return this.importGraph(g, false);
        }
        return this.importGraph(g, false);
    }

    public synchronized boolean addImportGraph(Graph g) {
        return this.addImportGraph(g, false);
    }

    public synchronized boolean importGraph(Graph g, boolean adapt) {
        Graph impGraph = this.makeImportGraph(g, adapt);
        if (impGraph == null) {
            return false;
        }
        int indx = this.itsGraphs.indexOf(this.itsGraph);
        if (indx != -1) {
            this.itsGraphs.remove(this.itsGraph);
            this.itsGraphs.add(indx, impGraph);
        } else {
            this.itsGraphs.add(impGraph);
        }
        this.itsGraph = impGraph;
        this.itsGraph.graphDidChange();
        return true;
    }

    public synchronized boolean addImportGraph(Graph g, boolean adapt) {
        Graph impGraph = this.makeImportGraph(g, adapt);
        if (impGraph == null) {
            return false;
        }
        this.itsGraphs.add(impGraph);
        this.itsGraph = impGraph;
        this.itsGraph.graphDidChange();
        return true;
    }

    private synchronized Graph makeImportGraph(Graph g, boolean adapt) {
        if (this.typeSet != null && g.getTypeSet() != null) {
            if (this.typeSet.isEmpty()) {
                if (this.adoptTypes(g.getTypeSet().getTypes())) {
                    Graph impGraph = g.copy(this.typeSet);
                    impGraph.setName(g.getName() + "_import");
                    if (impGraph.getAttrContext() == null || ((ContextView)impGraph.getAttrContext()).getAllowedMapping() != 2) {
                        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                        impGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                    }
                    return impGraph;
                }
                return null;
            }
            if (this.typeSet.contains(g.getTypeSet())) {
                Graph impGraph = g.copy(this.typeSet);
                impGraph.setName(g.getName() + "_import");
                if (impGraph.getAttrContext() == null || ((ContextView)impGraph.getAttrContext()).getAllowedMapping() != 2) {
                    AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                    impGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                }
                return impGraph;
            }
            if (this.typeSet.getTypeGraph() == null || this.typeSet.getLevelOfTypeGraphCheck() == 0) {
                Graph impGraph;
                Vector<Type> typesToAdapt = new Vector<Type>(1);
                Enumeration<Type> other = g.getTypeSet().getTypes();
                while (other.hasMoreElements()) {
                    Type t = other.nextElement();
                    if (this.typeSet.containsType(t) || !g.getElementsOfType(t).hasMoreElements()) continue;
                    typesToAdapt.add(t);
                }
                if (adapt) {
                    this.typeSet.adaptTypes(g.getTypeSet().getTypes(), false);
                    impGraph = g.copyLight(this.typeSet);
                    impGraph.setName(g.getName() + "_import");
                    if (impGraph.getAttrContext() == null || ((ContextView)impGraph.getAttrContext()).getAllowedMapping() != 2) {
                        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                        impGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                    }
                    return impGraph;
                }
                if (this.adoptTypes(typesToAdapt.elements())) {
                    impGraph = g.copy(this.typeSet);
                    impGraph.setName(g.getName() + "_import");
                    if (impGraph.getAttrContext() == null || ((ContextView)impGraph.getAttrContext()).getAllowedMapping() != 2) {
                        AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                        impGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                    }
                    return impGraph;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public boolean adoptTypes(Enumeration types) {
        while (types.hasMoreElements()) {
            Type t = (Type)types.nextElement();
            if (this.typeSet.adoptType(t) != null) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        Enumeration anEnum = this.itsMatches.elements();
        while (anEnum.hasMoreElements()) {
            this.destroyMatch((Match)anEnum.nextElement());
        }
        anEnum = this.itsRules.elements();
        while (anEnum.hasMoreElements()) {
            this.destroyRule((Rule)anEnum.nextElement());
        }
        anEnum = this.itsConstraints.elements();
        while (anEnum.hasMoreElements()) {
            this.destroyConstraint((Formula)anEnum.nextElement());
        }
        anEnum = this.itsAtomics.elements();
        while (anEnum.hasMoreElements()) {
            this.destroyAtomic((AtomConstraint)anEnum.nextElement());
        }
        if (this.itsStartGraph != null) {
            this.itsStartGraph.dispose();
            this.itsStartGraph = null;
        }
        anEnum = this.itsGraphs.elements();
        while (anEnum.hasMoreElements()) {
            this.destroyGraph((Graph)anEnum.nextElement());
        }
        this.itsGraph = null;
    }

    public boolean addRule(Rule r) {
        if (!this.itsRules.contains(r)) {
            this.itsRules.addElement(r);
            return true;
        }
        return false;
    }

    public boolean removeRule(Rule r) {
        return this.itsRules.removeElement(r);
    }

    public final void setName(String n) {
        this.itsName = n;
    }

    public final String getName() {
        return this.itsName;
    }

    public void setDirName(String str) {
        this.dirName = str;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setFileName(String str) {
        this.fileName = str;
    }

    public String getFileName() {
        return this.fileName;
    }

    public final Graph getGraph() {
        return this.itsGraph;
    }

    public int getIndexOfGraph() {
        return this.itsGraphs.indexOf(this.itsGraph);
    }

    public final Graph getGraph(String name) {
        for (int i = 0; i < this.itsGraphs.size(); ++i) {
            Graph g = (Graph)this.itsGraphs.elementAt(i);
            if (!g.getName().equals(name)) continue;
            return g;
        }
        return null;
    }

    public final Graph getGraph(int indx) {
        for (int i = 0; i < this.itsGraphs.size(); ++i) {
            Graph g = (Graph)this.itsGraphs.elementAt(i);
            if (i != indx) continue;
            return g;
        }
        return null;
    }

    public final Enumeration getGraphs() {
        return this.itsGraphs.elements();
    }

    public final Vector getGraphsVec() {
        return this.itsGraphs;
    }

    public final Graph getStartGraph() {
        return this.itsStartGraph;
    }

    public void setStartGraph(Graph g) {
        if (g == null) {
            this.destroyStartGraph();
        }
        if (g.getTypeSet().equals(this.typeSet)) {
            if (this.itsStartGraph != null) {
                this.itsStartGraph.dispose();
                this.itsStartGraph = null;
            }
            this.itsStartGraph = g;
        }
    }

    public void destroyStartGraph() {
        this.itsStartGraph.dispose();
        this.itsStartGraph = null;
    }

    public final Enumeration getRules() {
        return this.itsRules.elements();
    }

    public final Vector getRulesVec() {
        return this.itsRules;
    }

    public Vector getRulesForLayer(int l) {
        Vector<Rule> v = new Vector<Rule>(5);
        for (int i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.get(i);
            if (r.getLayer() != l) continue;
            v.add(r);
        }
        return v;
    }

    public void enableRuleLayer(int l, boolean enabled) {
        for (int i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.get(i);
            if (r.getLayer() != l) continue;
            r.setEnabled(enabled);
        }
    }

    public boolean isRuleLayerEnabled(int l) {
        for (int i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.get(i);
            if (r.getLayer() != l || !r.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public final Rule getRule(int ruleIndx) {
        if (ruleIndx < this.itsRules.size()) {
            return (Rule)this.itsRules.elementAt(ruleIndx);
        }
        return null;
    }

    public final Rule getRule(String name) {
        for (int i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.elementAt(i);
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public MorphCompletionStrategy getMorphismCompletionStrategy() {
        return this.strategy;
    }

    public final Vector getAtomicsVec() {
        return this.itsAtomics;
    }

    public final Enumeration getAtomics() {
        return this.itsAtomics.elements();
    }

    private final Vector getAtomicNames() {
        Vector<String> names = new Vector<String>(this.itsAtomics.size());
        for (int i = 0; i < this.itsAtomics.size(); ++i) {
            names.addElement(((AtomConstraint)this.itsAtomics.elementAt(i)).getAtomicName());
        }
        return names;
    }

    public final Enumeration getConstraints() {
        return this.itsConstraints.elements();
    }

    public final Vector getConstraintsVec() {
        return this.itsConstraints;
    }

    public Vector getGlobalConstraints() {
        return this.getConstraintsForLayer(-1);
    }

    public Vector getConstraintsForLayer(int l) {
        Vector<Formula> v = new Vector<Formula>(5);
        block0: for (int i = 0; i < this.itsConstraints.size(); ++i) {
            Formula c = (Formula)this.itsConstraints.get(i);
            Vector layer = c.getLayer();
            if (l == -1 && layer.isEmpty()) {
                v.add(c);
                continue;
            }
            if (l <= -1 || layer.isEmpty()) continue;
            for (int j = 0; j < layer.size(); ++j) {
                Integer I = (Integer)layer.get(j);
                if (I != l) continue;
                v.add(c);
                continue block0;
            }
        }
        return v;
    }

    public void refreshConstraintsForLayer() {
        Vector itsLayers = this.getLayers();
        for (int i = 0; i < this.itsConstraints.size(); ++i) {
            Formula c = (Formula)this.itsConstraints.get(i);
            Vector layer = c.getLayer();
            Enumeration e = layer.elements();
            while (e.hasMoreElements()) {
                Integer l = (Integer)e.nextElement();
                boolean found = false;
                for (int j = 0; j < itsLayers.size(); ++j) {
                    Integer I = new Integer((String)itsLayers.get(j));
                    if (I.intValue() != l.intValue()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                layer.remove(l);
                e = layer.elements();
            }
        }
    }

    public Rule createRule() {
        Rule aNewRule = new Rule(this.typeSet);
        this.itsRules.addElement(aNewRule);
        return aNewRule;
    }

    public void sortRulesByLayer() {
        RuleLayer layer = new RuleLayer(this.itsRules.elements());
        Integer startLayer = layer.getStartLayer();
        Hashtable invertedRuleLayer = layer.invertLayer();
        OrderedSet ruleLayer = new OrderedSet();
        Enumeration en = invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            ruleLayer.add(en.nextElement());
        }
        this.itsRules.removeAllElements();
        Integer currentLayer = startLayer;
        boolean nextLayerExists = true;
        while (nextLayerExists && currentLayer != null) {
            HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
            Enumeration en2 = rulesForLayer.elements();
            while (en2.hasMoreElements()) {
                Rule r = (Rule)en2.nextElement();
                this.itsRules.addElement(r);
            }
            OrderedSetIterator osi = ruleLayer.find(currentLayer);
            if (osi == null || osi.atEnd()) {
                nextLayerExists = false;
                continue;
            }
            osi.advance();
            currentLayer = (Integer)osi.get();
        }
    }

    public void sortConstraintsByLayer() {
        ConstraintLayer layer = new ConstraintLayer(this.itsConstraints.elements());
        Integer startLayer = layer.getStartLayer();
        Hashtable invertedLayer = layer.invertLayer();
        OrderedSet formulaLayer = new OrderedSet();
        Enumeration en = invertedLayer.keys();
        while (en.hasMoreElements()) {
            formulaLayer.add(en.nextElement());
        }
        this.itsConstraints.removeAllElements();
        Integer currentLayer = startLayer;
        boolean nextLayerExists = true;
        while (nextLayerExists && currentLayer != null) {
            HashSet constraintsForLayer = (HashSet)invertedLayer.get(currentLayer);
            Enumeration en2 = constraintsForLayer.elements();
            while (en2.hasMoreElements()) {
                Formula f = (Formula)en2.nextElement();
                this.itsConstraints.addElement(f);
            }
            OrderedSetIterator osi = formulaLayer.find(currentLayer);
            if (osi == null || osi.atEnd()) {
                nextLayerExists = false;
                continue;
            }
            osi.advance();
            currentLayer = (Integer)osi.get();
        }
    }

    public Graph cloneGraph() {
        return BaseFactory.theFactory().cloneGraph(this.itsGraph);
    }

    public Rule cloneRule(Rule r) {
        Rule aNewRule = BaseFactory.theFactory().cloneRule(r);
        this.itsRules.addElement(aNewRule);
        return aNewRule;
    }

    public AtomConstraint createAtomic(String name) {
        this.clearRuleConstraints();
        AtomConstraint a = BaseFactory.theFactory().createAtomic(this.typeSet, name);
        a.setMorphismCompletionStrategy(this.strategy);
        this.itsAtomics.addElement(a);
        a.setName(name);
        return a;
    }

    public boolean addAtomic(AtomConstraint ac) {
        if (!this.itsAtomics.contains(ac)) {
            this.clearRuleConstraints();
            ac.setMorphismCompletionStrategy(this.strategy);
            this.itsAtomics.addElement(ac);
            return true;
        }
        return false;
    }

    public boolean removeAtomic(AtomConstraint ac) {
        return this.itsAtomics.remove(ac);
    }

    public Formula createConstraint(String name) {
        this.clearRuleConstraints();
        Formula f = new Formula(true);
        f.setName(name);
        this.itsConstraints.addElement(f);
        return f;
    }

    public boolean addConstraint(Formula f) {
        if (!this.itsConstraints.contains(f)) {
            this.clearRuleConstraints();
            this.itsConstraints.addElement(f);
            return true;
        }
        return false;
    }

    public void destroyTypeGraph() {
        this.typeSet.getTypeGraph().dispose();
        this.typeSet.setTypeGraph(null);
        this.typeSet.setLevelOfTypeGraphCheck(0);
    }

    public void destroyRule(Rule rule) {
        if (this.itsRules.removeElement(rule)) {
            rule.dispose(true, true);
            rule = null;
        }
    }

    public void destroyAtomic(AtomConstraint a) {
        this.clearRuleConstraints();
        if (this.itsAtomics.contains(a)) {
            this.itsAtomics.removeElement(a);
        }
        for (int i = 0; i < this.itsConstraints.size(); ++i) {
            ((Formula)this.itsConstraints.get(i)).patchOutEvaluable(a, true);
        }
        a.dispose(true, true);
        a = null;
    }

    public void destroyConstraint(Formula f) {
        this.clearRuleConstraints();
        this.itsConstraints.removeElement(f);
    }

    public boolean removeConstraint(Formula f) {
        if (this.itsConstraints.contains(f)) {
            this.clearRuleConstraints();
            this.itsConstraints.removeElement(f);
            return true;
        }
        return false;
    }

    public Vector destroyGraphObjectsOfType(Type t, boolean fromTypeGraph) {
        Vector<String> failed = new Vector<String>(5);
        for (int i = 0; i < this.itsGraphs.size(); ++i) {
            Graph g = (Graph)this.itsGraphs.get(i);
            if (g.destroyObjectsOfType(t)) continue;
            failed.add(g.getName());
        }
        Enumeration rules = this.itsRules.elements();
        while (rules.hasMoreElements()) {
            Rule r = (Rule)rules.nextElement();
            if (r.destroyObjectsOfType(t)) continue;
            failed.add(r.getName());
        }
        Enumeration atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = (AtomConstraint)atomics.nextElement();
            a.getSource().destroyObjectsOfType(t);
            Enumeration conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = (AtomConstraint)conclusions.nextElement();
                if (c.getTarget().destroyObjectsOfType(t)) continue;
                failed.add(c.getName());
            }
        }
        if (this.typeSet.getTypeGraph() != null && fromTypeGraph && !this.typeSet.getTypeGraph().destroyObjectsOfType(t)) {
            failed.add(this.typeSet.getTypeGraph().getName());
        }
        return failed;
    }

    public Vector destroyGraphObjectsOfTypes(Vector ts, boolean fromTypeGraph) {
        Vector failed = new Vector(5);
        if (this.itsStartGraph != null) {
            this.itsStartGraph.destroyObjectsOfTypes(ts);
        }
        Vector v = new Vector();
        for (int i = 0; i < this.itsGraphs.size(); ++i) {
            Graph g = (Graph)this.itsGraphs.get(i);
            v = g.destroyObjectsOfTypes(ts);
            if (v.isEmpty()) continue;
            failed.addAll(v);
        }
        Enumeration rules = this.itsRules.elements();
        while (rules.hasMoreElements()) {
            Rule r = (Rule)rules.nextElement();
            v = r.destroyObjectsOfTypes(ts);
            if (v.isEmpty()) continue;
            failed.addAll(v);
        }
        Enumeration atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = (AtomConstraint)atomics.nextElement();
            a.getSource().destroyObjectsOfTypes(ts);
            Enumeration conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = (AtomConstraint)conclusions.nextElement();
                v = c.getTarget().destroyObjectsOfTypes(ts);
                if (v.isEmpty()) continue;
                failed.addAll(v);
            }
        }
        if (this.typeSet.getTypeGraph() != null && fromTypeGraph && !(v = this.typeSet.getTypeGraph().destroyObjectsOfTypes(ts)).isEmpty()) {
            failed.addAll(v);
        }
        return failed;
    }

    public boolean destroyGraphObjectsOfTypeFromHostGraph(Type t) {
        return this.itsGraph.destroyObjectsOfType(t);
    }

    public Vector destroyGraphObjectsOfTypesFromHostGraph(Vector ts) {
        return this.itsGraph.destroyObjectsOfTypes(ts);
    }

    public Vector destroyGraphObjectsOfTypeFromRules(Type t) {
        Vector<String> failed = new Vector<String>(5);
        Enumeration rules = this.itsRules.elements();
        while (rules.hasMoreElements()) {
            Rule r = (Rule)rules.nextElement();
            if (r.destroyObjectsOfType(t)) continue;
            failed.add(r.getName());
        }
        return failed;
    }

    public Vector destroyGraphObjectsOfTypesFromRules(Vector ts) {
        Vector failed = new Vector(5);
        Enumeration rules = this.itsRules.elements();
        while (rules.hasMoreElements()) {
            Rule r = (Rule)rules.nextElement();
            Vector v = r.destroyObjectsOfTypes(ts);
            if (v.isEmpty()) continue;
            failed.addAll(v);
        }
        return failed;
    }

    public Vector destroyGraphObjectsOfTypeFromGraphConstraints(Type t) {
        Vector<String> failed = new Vector<String>(5);
        Enumeration atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = (AtomConstraint)atomics.nextElement();
            a.getSource().destroyObjectsOfType(t);
            Enumeration conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = (AtomConstraint)conclusions.nextElement();
                if (c.getTarget().destroyObjectsOfType(t)) continue;
                failed.add(c.getName());
            }
        }
        return failed;
    }

    public Vector destroyGraphObjectsOfTypesFromGraphConstraints(Vector ts) {
        Vector failed = new Vector(5);
        Enumeration atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = (AtomConstraint)atomics.nextElement();
            a.getSource().destroyObjectsOfTypes(ts);
            Enumeration conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = (AtomConstraint)conclusions.nextElement();
                Vector v = c.getTarget().destroyObjectsOfTypes(ts);
                if (v.isEmpty()) continue;
                failed.addAll(v);
            }
        }
        return failed;
    }

    public final Enumeration getMatches(Rule rule) {
        Vector<Match> mtchs = new Vector<Match>();
        for (int i = 0; i < this.itsMatches.size(); ++i) {
            Match m = (Match)this.itsMatches.elementAt(i);
            if (!m.getRule().equals(rule)) continue;
            mtchs.addElement(m);
        }
        return mtchs.elements();
    }

    public Match createMatch(Rule rule) {
        Match aNewMatch = new Match(rule, this.itsGraph);
        this.itsMatches.addElement(aNewMatch);
        return aNewMatch;
    }

    public void destroyMatch(Match match) {
        if (match == null) {
            return;
        }
        if (!this.itsMatches.removeElement(match)) {
            // empty if block
        }
        this.itsGraph.removeUsingMorph(match);
        match.dispose();
        match = null;
    }

    public Type createType() {
        return this.typeSet.createType();
    }

    public boolean isUsingType(GraphObject t) {
        if (this.itsGraph.isUsingType(t)) {
            return true;
        }
        for (int i = 0; i < this.itsRules.size(); ++i) {
            if (!((Rule)this.itsRules.elementAt(i)).isUsingType(t)) continue;
            return true;
        }
        Enumeration e = this.itsAtomics.elements();
        while (e.hasMoreElements()) {
            AtomConstraint atom = (AtomConstraint)e.nextElement();
            if (atom.getSource().isUsingType(t)) {
                return true;
            }
            if (!atom.getTarget().isUsingType(t)) continue;
            return true;
        }
        return false;
    }

    public TypeSet getTypeSet() {
        return this.typeSet;
    }

    public Enumeration getTypes() {
        return this.typeSet.getTypes();
    }

    public Graph getTypeGraph() {
        return this.typeSet.getTypeGraph();
    }

    public void destroyType(Type type) throws TypeException {
        this.typeSet.destroyType(type);
    }

    public Collection setLevelOfTypeGraphCheck(int level) {
        int oldLevel = this.typeSet.getLevelOfTypeGraphCheck();
        Collection checkResult = this.typeSet.setLevelOfTypeGraphCheck(level);
        if (checkResult.isEmpty()) {
            Vector errors = new Vector();
            errors.addAll(this.typeSet.checkType(this.itsGraph));
            if (level != 0) {
                Enumeration en = this.itsRules.elements();
                while (en.hasMoreElements()) {
                    errors.addAll(this.typeSet.checkType((Rule)en.nextElement()));
                }
                en = this.itsAtomics.elements();
                while (en.hasMoreElements()) {
                    errors.addAll(this.typeSet.checkType((AtomConstraint)en.nextElement()));
                }
            }
            if (!errors.isEmpty()) {
                if (oldLevel == level) {
                    oldLevel = 10;
                }
                this.typeSet.setLevelOfTypeGraphCheck(oldLevel);
            }
            return errors;
        }
        if (oldLevel == level) {
            oldLevel = 0;
        }
        return checkResult;
    }

    public int getLevelOfTypeGraphCheck() {
        return this.typeSet.getLevelOfTypeGraphCheck();
    }

    public void putMorphismCompletionStrategyToGraphConstraints() {
        for (int i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            a.setMorphismCompletionStrategy(this.strategy);
        }
    }

    public boolean checkGraphConstraints(boolean validity) {
        int i;
        for (i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            a.setMorphismCompletionStrategy(this.strategy);
        }
        this.errConsistencyMsg = "";
        for (i = 0; i < this.itsConstraints.size(); ++i) {
            Formula f = (Formula)this.itsConstraints.get(i);
            if (!f.isValid()) {
                String fn = f.getAsString(this.itsAtomics, this.getAtomicNames());
                this.errConsistencyMsg = fn.indexOf("[") != -1 ? this.errConsistencyMsg + " < " + f.getName() + " : " + fn.substring(1, fn.length() - 1) + " > " : this.errConsistencyMsg + " < " + f.getName() + " : " + fn.substring(1, fn.length() - 1) + " > ";
                return false;
            }
            if (validity || f.eval(this.itsGraph)) continue;
            String fn = f.getAsString(this.itsAtomics, this.getAtomicNames());
            this.errConsistencyMsg = fn.indexOf("[") != -1 ? this.errConsistencyMsg + " < " + f.getName() + " : " + fn.substring(1, fn.length() - 1) + " > " : this.errConsistencyMsg + " < " + f.getName() + " : " + fn.substring(0, fn.length()) + " > ";
            return false;
        }
        return true;
    }

    public boolean checkGraphConsistency(Graph g) {
        return this.checkGraphConsistency(g, this.itsConstraints);
    }

    public boolean checkGraphConsistency(Graph g, Vector constraints) {
        int i;
        for (i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            a.setMorphismCompletionStrategy(this.strategy);
        }
        if (constraints == null) {
            constraints = this.itsConstraints;
        }
        for (i = 0; i < constraints.size(); ++i) {
            Formula f = (Formula)constraints.get(i);
            if (!f.isValid()) {
                return false;
            }
            if (f.eval(g)) continue;
            return !f.isEvaluable();
        }
        return true;
    }

    public boolean checkAtomics(boolean validity) {
        for (int i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            a.setMorphismCompletionStrategy(this.strategy);
        }
        this.errConsistencyMsg = "";
        boolean all_valid = true;
        boolean all_good = true;
        for (int i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            if (!a.isValid()) {
                this.errConsistencyMsg = this.errConsistencyMsg + " < " + a.getAtomicName() + " > ";
                all_valid = false;
            }
            if (!all_valid || validity || a.eval((Object)this.itsGraph)) continue;
            this.errConsistencyMsg = this.errConsistencyMsg + " < " + a.getAtomicName() + " > ";
            all_good = false;
        }
        if (validity) {
            return all_valid;
        }
        return all_good;
    }

    public String getConsistencyErrorMsg() {
        return this.errConsistencyMsg;
    }

    public String convertConstraints() {
        String msg = "";
        if (this.itsAtomics.size() <= 0 || this.itsConstraints.size() <= 0) {
            msg = "Atomics or constraints do not exist.";
            return msg;
        }
        Vector<Rule> rs = new Vector<Rule>();
        Enumeration en = this.getRules();
        while (en.hasMoreElements()) {
            rs.add((Rule)en.nextElement());
        }
        boolean broken = false;
        for (int i = 0; i < rs.size(); ++i) {
            for (int j = 0; j < this.itsAtomics.size(); ++j) {
                AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(j);
                if (a.isValid()) continue;
                msg = "Atomic  \"" + a.getAtomicName() + "\"  is not valid";
                return msg;
            }
            Rule r = (Rule)rs.elementAt(i);
            r.clearConstraints();
            r.setUsedFormulas(this.itsConstraints);
            String msg0 = r.convertUsedFormulas();
            if (msg0.equals("")) continue;
            msg = "Rule  \"" + r.getName() + "\" : \n" + msg0 + "\nConverting constraints to post application conditions failed.";
            return msg;
        }
        return msg;
    }

    private String convertConstraint(Formula f) {
        String msg = "";
        if (this.itsAtomics.size() <= 0 || this.itsConstraints.size() <= 0) {
            msg = "Atomics or constraint do not exist.";
            return msg;
        }
        Vector<Rule> rs = new Vector<Rule>();
        Enumeration en = this.getRules();
        while (en.hasMoreElements()) {
            rs.add((Rule)en.nextElement());
        }
        boolean broken = false;
        for (int i = 0; i < rs.size(); ++i) {
            for (int j = 0; j < this.itsAtomics.size(); ++j) {
                AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(j);
                if (a.isValid()) continue;
                msg = "Atomic  \"" + a.getAtomicName() + "\"  is not valid";
                return msg;
            }
            Rule r = (Rule)rs.elementAt(i);
            r.clearConstraints();
            Vector<Formula> v = new Vector<Formula>(1);
            v.addElement(f);
            r.setUsedFormulas(v);
            String msg0 = r.convertUsedFormulas();
            if (msg0.equals("")) continue;
            msg = "Rule  \"" + r.getName() + "\" : \n" + msg0 + "\nConverting constraint to post application conditions failed.";
            return msg;
        }
        return msg;
    }

    public void clearRuleConstraints() {
        Enumeration en = this.getRules();
        while (en.hasMoreElements()) {
            ((Rule)en.nextElement()).clearConstraints();
        }
    }

    public final SubGraGra createSubGraGra() {
        SubGraGra anSG = new SubGraGra(this);
        this.itsSubGraGras.addElement(anSG);
        return anSG;
    }

    public final boolean destroySubGraGra(SubGraGra sg) {
        if (this.itsSubGraGras.removeElement(sg)) {
            sg.dispose();
            sg = null;
            return true;
        }
        return false;
    }

    public final Enumeration getSubGraGras() {
        return this.itsSubGraGras.elements();
    }

    public void setRuleLayer(RuleLayer rl) {
        Enumeration keys = this.getRules();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer layer = (Integer)rl.getRuleLayer().get(key);
            ((Rule)key).setLayer(layer);
        }
    }

    public void unsetLayerTriggerRule() {
        for (int i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.elementAt(i);
            r.setTriggerForLayer(false);
        }
    }

    public Vector getGraTraOptions() {
        if (this.gratraOptions == null) {
            this.gratraOptions = new Vector();
        }
        return this.gratraOptions;
    }

    public void setGraTraOptions(Vector opts) {
        this.gratraOptions = opts;
    }

    private void setMorphismCompletionStrategy() {
        if (this.gratraOptions.contains("CSP")) {
            this.strategy = new Completion_NAC(new Completion_InjCSP());
        } else if (this.gratraOptions.contains("CSP w/o BJ")) {
            this.strategy = new Completion_NAC(new Completion_CSP_NoBJ());
        } else if (this.gratraOptions.contains("Simple BT")) {
            this.strategy = new Completion_NAC(new Completion_SimpleBT());
        }
        if (this.strategy != null) {
            if (!this.gratraOptions.contains("injective")) {
                this.strategy.getProperties().clear(0);
            }
            if (!this.gratraOptions.contains("dangling")) {
                this.strategy.getProperties().clear(1);
            }
            if (!this.gratraOptions.contains("NACs")) {
                this.strategy.getProperties().clear(3);
            }
        } else {
            this.strategy = new Completion_NAC(new Completion_InjCSP());
            this.gratraOptions.add("CSP");
            this.gratraOptions.add("injective");
            this.gratraOptions.add("dangling");
            this.gratraOptions.add("NACs");
        }
        this.putMorphismCompletionStrategyToGraphConstraints();
    }

    public void addGraTraOption(String opt) {
        if (!this.gratraOptions.contains(opt)) {
            this.gratraOptions.add(opt);
        }
    }

    public void removeGraTraOption(String opt) {
        if (this.gratraOptions.contains(opt)) {
            this.gratraOptions.remove(opt);
        }
    }

    public void setGraTraOptions(MorphCompletionStrategy strat) {
        if (strat == null) {
            return;
        }
        Vector<String> v = new Vector<String>(0);
        if (this.gratraOptions == null) {
            this.gratraOptions = new Vector(0);
        } else {
            if (this.gratraOptions.indexOf("consistency") != -1) {
                v.add("consistency");
            }
            if (this.gratraOptions.indexOf("layered") != -1) {
                v.add("layered");
            }
            if (this.gratraOptions.indexOf("stopLayer") != -1) {
                v.add("stopLayer");
            }
            if (this.gratraOptions.indexOf("layeredLoop") != -1) {
                v.add("layeredLoop");
            }
            if (this.gratraOptions.indexOf("checkRuleApplicability") != -1) {
                v.add("checkRuleApplicability");
            }
            if (this.gratraOptions.indexOf("showGraphAfterStep") != -1) {
                v.add("showGraphAfterStep");
            }
            this.gratraOptions.removeAllElements();
        }
        this.strategy = strat;
        String stratName = CompletionStrategySelector.getName(this.strategy);
        this.gratraOptions.addElement(stratName);
        BitSet activebits = this.strategy.getProperties();
        for (int j = 0; j < CompletionPropertyBits.BITNAME.length; ++j) {
            String bitName = CompletionPropertyBits.BITNAME[j];
            if (!activebits.get(j)) continue;
            this.gratraOptions.addElement(bitName);
        }
        for (int i = 0; i < v.size(); ++i) {
            this.gratraOptions.add((String)v.elementAt(i));
        }
        this.putMorphismCompletionStrategyToGraphConstraints();
    }

    public boolean compareTo(GraGra gragra, boolean transOption) {
        if (gragra == null) {
            return false;
        }
        boolean checkLayer = false;
        if (transOption) {
            for (int i = 0; i < this.gratraOptions.size(); ++i) {
                String op = (String)this.gratraOptions.get(i);
                if (!gragra.getGraTraOptions().contains(op)) {
                    return false;
                }
                if (!op.equals("layered")) continue;
                checkLayer = true;
            }
        }
        if (!this.compareRulesTo(gragra, checkLayer)) {
            return false;
        }
        return this.compareConstraintsTo(gragra);
    }

    public boolean compareTo(GraGra gragra) {
        int i;
        if (!this.getName().equals(gragra.getName())) {
            return false;
        }
        if (!this.getTypeSet().compareTo(gragra.getTypeSet())) {
            return false;
        }
        if (!this.itsGraph.compareTo(gragra.getGraph())) {
            return false;
        }
        Enumeration e = gragra.getRules();
        Vector<Object> another = new Vector<Object>();
        while (e.hasMoreElements()) {
            another.add((Rule)e.nextElement());
        }
        if (this.itsRules.size() != another.size()) {
            return false;
        }
        for (i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.elementAt(i);
            Rule r1 = gragra.getRule(r.getName());
            if (r1 == null || !r.compareTo(r1)) continue;
            another.remove(r1);
        }
        if (another.size() != 0) {
            return false;
        }
        e = gragra.getAtomics();
        another = new Vector();
        while (e.hasMoreElements()) {
            another.add((AtomConstraint)e.nextElement());
        }
        if (this.itsAtomics.size() != another.size()) {
            return false;
        }
        block3: for (i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                AtomConstraint a1 = (AtomConstraint)another.elementAt(j);
                if (!a.compareTo(a1)) continue;
                another.remove(a1);
                continue block3;
            }
        }
        if (another.size() != 0) {
            return false;
        }
        e = gragra.getConstraints();
        another = new Vector();
        while (e.hasMoreElements()) {
            another.add((Formula)e.nextElement());
        }
        if (this.itsConstraints.size() != another.size()) {
            return false;
        }
        block6: for (i = 0; i < this.itsConstraints.size(); ++i) {
            Formula f = (Formula)this.itsConstraints.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                Formula f1 = (Formula)another.elementAt(j);
                if (!f.compareTo(f1)) continue;
                another.remove(f1);
                continue block6;
            }
        }
        return another.size() == 0;
    }

    public boolean compareRulesTo(GraGra gragra, boolean checkLayer) {
        String errMsgHolder = null;
        Enumeration e = gragra.getRules();
        Vector<Rule> another = new Vector<Rule>();
        while (e.hasMoreElements()) {
            another.add((Rule)e.nextElement());
        }
        if (this.itsRules.size() != another.size()) {
            errMsgHolder = "Number of rules is different.";
            return false;
        }
        Rule r = null;
        for (int i = 0; i < this.itsRules.size(); ++i) {
            r = (Rule)this.itsRules.elementAt(i);
            Rule r1 = gragra.getRule(r.getName());
            if (r1 != null && r.compareTo(r1)) {
                another.remove(r1);
            } else {
                System.out.println(r.getName());
            }
            if (!checkLayer || r.getLayer() == r1.getLayer()) continue;
            errMsgHolder = "Rule layer is different.";
            return false;
        }
        if (another.size() != 0) {
            errMsgHolder = "Rule:  " + r.getName() + "  is different.";
            return false;
        }
        return true;
    }

    public boolean compareConstraintsTo(GraGra gragra) {
        String errMsgHolder = null;
        Enumeration e = gragra.getAtomics();
        Vector<XMLObject> another = new Vector<XMLObject>();
        while (e.hasMoreElements()) {
            another.add((AtomConstraint)e.nextElement());
        }
        if (this.itsAtomics.size() != another.size()) {
            errMsgHolder = errMsgHolder + "Number of graph constraints is different";
            return false;
        }
        AtomConstraint a = null;
        block1: for (int i = 0; i < this.itsAtomics.size(); ++i) {
            a = (AtomConstraint)this.itsAtomics.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                AtomConstraint a1 = (AtomConstraint)another.elementAt(j);
                if (!a.compareTo(a1)) continue;
                another.remove(a1);
                continue block1;
            }
        }
        if (another.size() != 0) {
            errMsgHolder = errMsgHolder + "Graph constraint;  " + a.getAtomicName() + "  is different";
            return false;
        }
        e = gragra.getConstraints();
        another = new Vector();
        while (e.hasMoreElements()) {
            another.add((Formula)e.nextElement());
        }
        if (this.itsConstraints.size() != another.size()) {
            errMsgHolder = errMsgHolder + "Number of constraints (formulae) is different";
            return false;
        }
        Formula f = null;
        block4: for (int i = 0; i < this.itsConstraints.size(); ++i) {
            f = (Formula)this.itsConstraints.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                Formula f1 = (Formula)another.elementAt(j);
                if (!f.compareTo(f1)) continue;
                another.remove(f1);
                continue block4;
            }
        }
        if (another.size() != 0) {
            errMsgHolder = errMsgHolder + "Formula:  " + f.toString() + "  is different";
            return false;
        }
        return true;
    }

    public Vector getNonInjectiveRules() {
        Vector<Rule> result = new Vector<Rule>(1);
        Enumeration en = this.getRules();
        while (en.hasMoreElements()) {
            Rule r = (Rule)en.nextElement();
            if (r.isInjective()) continue;
            result.add(r);
        }
        return result;
    }

    public boolean isGraphReadyForTransform() {
        return this.itsGraph.isReadyForTransform();
    }

    public Pair isReadyToTransform() {
        String msg = "";
        Enumeration<Type> e = this.typeSet.getTypes();
        while (e.hasMoreElements()) {
            Type t = e.nextElement();
            if (this.doesAttrTypeExist(t)) continue;
            msg = "Not all attribute members of the type :  \"" + t.getName() + "\"  are declared correctly.";
            return new Pair(t, msg);
        }
        Pair p = this.isInheritedAttributesValid();
        if (p != null) {
            return p;
        }
        Enumeration en = this.getRules();
        while (en.hasMoreElements()) {
            Rule r = (Rule)en.nextElement();
            if (!r.isReadyToTransform()) {
                msg = "Rule  \"" + r.getName() + "\" : " + r.getErrorMsg();
                return new Pair(r, msg);
            }
            if (this.typeSet.getLevelOfTypeGraphCheck() != 0 || !this.typeSet.hasInheritance()) continue;
            Enumeration nacs = r.getNACs();
            while (nacs.hasMoreElements()) {
                OrdinaryMorphism nac = (OrdinaryMorphism)nacs.nextElement();
                if (r.isNACValid(nac)) continue;
                msg = "Rule  \"" + r.getName() + "\" : " + r.getErrorMsg();
                return new Pair(r, msg);
            }
        }
        return this.isGraphConstraintReadyForTransform();
    }

    public Pair isGraphConstraintReadyForTransform() {
        for (int i = 0; i < this.itsAtomics.size(); ++i) {
            AtomConstraint a = (AtomConstraint)this.itsAtomics.elementAt(i);
            if (a.isValid()) continue;
            String msg = "Atomic graph constraint  \"" + a.getAtomicName() + "\" is not valid. " + "\nPlease check: " + "\n  - graph morphism ( injective and total )  " + "\n  - attribute context ( variable and condition declarations ).";
            return new Pair(a, msg);
        }
        return null;
    }

    public Type doAttrTypesExist() {
        Enumeration<Type> e = this.typeSet.getTypes();
        while (e.hasMoreElements()) {
            Type t = e.nextElement();
            if (this.doesAttrTypeExist(t)) continue;
            return t;
        }
        return null;
    }

    private boolean doesAttrTypeExist(Type type) {
        boolean isClass = false;
        DeclTuple declTupl = (DeclTuple)type.getAttrType();
        for (int i = 0; i < declTupl.getSize(); ++i) {
            DeclMember decl = (DeclMember)declTupl.getMemberAt(i);
            String t = decl.getTypeName();
            if (this.isPrimitiveType(t)) continue;
            try {
                Class<?> c = Class.forName(t);
                isClass = true;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            if (isClass) continue;
            AttrHandler[] attrHandlers = AttrTupleManager.getDefaultManager().getHandlers();
            for (int h = 0; h < attrHandlers.length; ++h) {
                AttrHandler attrh = attrHandlers[h];
                Vector packs = ((JexHandler)attrh).getClassResolver().getPackages();
                for (int pi = 0; pi < packs.size(); ++pi) {
                    String pack = (String)packs.get(pi);
                    try {
                        Class<?> c = Class.forName(pack + "." + t);
                        isClass = true;
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        continue;
                    }
                }
                if (isClass) break;
            }
            if (isClass) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimitiveType(String t) {
        return t.equals("int") || t.equals("long") || t.equals("short") || t.equals("double") || t.equals("float") || t.equals("boolean") || t.equals("char") || t.equals("byte");
    }

    public Pair isInheritedAttributesValid() {
        if (this.typeSet.getLevelOfTypeGraphCheck() <= 0 && this.typeSet.hasInheritance()) {
            Enumeration<Type> e = this.typeSet.getTypes();
            while (e.hasMoreElements()) {
                Type t = e.nextElement();
                for (int i = 0; i < t.getParents().size(); ++i) {
                    Type p = t.getParents().get(i);
                    AttrType attrType = p.getAttrType();
                    if (attrType.getNumberOfEntries() == 0) continue;
                    String msg = "Type  \"" + t.getName() + "\"  has inheritance conflict : inherited attributes while disabled type graph.";
                    return new Pair(t, msg);
                }
            }
        }
        return null;
    }

    public Vector getApplicableRules(MorphCompletionStrategy strategy) {
        return this.getApplicableRules(this.itsGraph, strategy);
    }

    public Vector getApplicableRules(Graph g, MorphCompletionStrategy strategy) {
        Vector<Rule> applicableRules = new Vector<Rule>();
        if (!g.isReadyForTransform()) {
            return applicableRules;
        }
        for (int i = 0; i < this.itsRules.size(); ++i) {
            Rule r = (Rule)this.itsRules.elementAt(i);
            if (r.isReadyToTransform()) {
                Match m = BaseFactory.theFactory().createMatch(r, g);
                if (m != null) {
                    boolean mOK = false;
                    m.setCompletionStrategy(strategy);
                    while (m.nextCompletion()) {
                        if (!m.isWeakValid(true)) continue;
                        mOK = true;
                        r.setApplicable(true);
                        applicableRules.addElement(r);
                        break;
                    }
                    if (!mOK) {
                        if (!((VarTuple)m.getAttrContext().getVariables()).areInputParametersSet()) {
                            r.setApplicable(true);
                            applicableRules.addElement(r);
                        } else {
                            r.setApplicable(false);
                        }
                    }
                }
                BaseFactory.theFactory().destroyMatch(m);
                continue;
            }
            r.setApplicable(false);
        }
        return applicableRules;
    }

    private boolean checkGraphConsistency(Match m) {
        boolean result = true;
        BaseFactory bf = BaseFactory.theFactory();
        OrdinaryMorphism copy = m.getImage().isoToCopy(2);
        copy.getImage().setCompleteGraph(true);
        OrdinaryMorphism com = m.compose(copy);
        Match m2 = bf.makeMatch(m.getRule(), com);
        m2.adaptAttrContextValues(m.getAttrContext());
        if (m2 != null) {
            Step s = new Step();
            try {
                OrdinaryMorphism co_match = (OrdinaryMorphism)s.execute(m2, true);
                if (co_match != null) {
                    result = this.checkGraphConsistency(m2.getImage());
                    bf.destroyMorphism(co_match);
                    co_match = null;
                } else {
                    result = false;
                }
            }
            catch (TypeException e) {
                result = false;
            }
            bf.destroyMatch(m2);
            m2 = null;
        } else {
            result = false;
        }
        com.dispose();
        com = null;
        copy.dispose(false, true);
        copy = null;
        return result;
    }

    private boolean checkGraphConsistency(Match m, Vector constraints) {
        boolean result = true;
        BaseFactory bf = BaseFactory.theFactory();
        OrdinaryMorphism copy = m.getImage().isoToCopy(2);
        copy.getImage().setCompleteGraph(true);
        OrdinaryMorphism com = m.compose(copy);
        Match m2 = bf.makeMatch(m.getRule(), com);
        m2.adaptAttrContextValues(m.getAttrContext());
        if (m2 != null) {
            Step s = new Step();
            try {
                OrdinaryMorphism co_match = (OrdinaryMorphism)s.execute(m2, true);
                if (co_match != null) {
                    if (this.isLayered()) {
                        Vector commonConstraints = this.getConstraintsForLayer(-1);
                        result = this.checkGraphConsistency(m2.getImage(), commonConstraints);
                    }
                    if (constraints == null) {
                        constraints = this.itsConstraints;
                    }
                    result = this.checkGraphConsistency(m2.getImage(), constraints);
                    bf.destroyMorphism(co_match);
                    co_match = null;
                } else {
                    result = false;
                }
            }
            catch (TypeException e) {
                result = false;
            }
            bf.destroyMatch(m2);
            m2 = null;
        } else {
            result = false;
        }
        com.dispose();
        com = null;
        copy.dispose(false, true);
        copy = null;
        return result;
    }

    public void storeUsedClassPackages() {
        this.itsPackages.removeAllElements();
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler[] attrHandlers = info.getAttrManager().getHandlers();
        for (int i = 0; i < attrHandlers.length; ++i) {
            AttrHandler attrHandler = attrHandlers[i];
            Pair p = new Pair(attrHandler.getName(), ((JexHandler)attrHandler).getClassResolver().getPackages());
            this.addPackage(p);
        }
    }

    public void setUsedClassPackages() {
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler[] attrHandlers = info.getAttrManager().getHandlers();
        for (int i = 0; i < this.itsPackages.size(); ++i) {
            Pair p = (Pair)this.itsPackages.elementAt(i);
            String handler = (String)p.first;
            boolean found = false;
            AttrHandler attrHandler = null;
            Vector hPacks = new Vector(0);
            for (int h = 0; h < attrHandlers.length; ++h) {
                attrHandler = attrHandlers[h];
                String hName = attrHandler.getName();
                hPacks = ((JexHandler)attrHandler).getClassResolver().getPackages();
                if (!hName.equals(handler)) continue;
                found = true;
            }
            if (!found) continue;
            Vector packs = (Vector)p.second;
            for (int j = 0; j < packs.size(); ++j) {
                String pack = (String)packs.elementAt(j);
                if (hPacks.contains(pack)) continue;
                ((JexHandler)attrHandler).appendPackage(pack);
            }
        }
    }

    public final void showTree() {
        int i;
        System.out.println("\n*** GraGra Tree ***");
        System.out.println(this);
        for (i = 0; i < this.itsSubGraGras.size(); ++i) {
            SubGraGra sg = (SubGraGra)this.itsSubGraGras.elementAt(i);
            System.out.println("--" + sg + "  -->  " + sg.getSuperGraGra());
        }
        this.itsGraph.showTree();
        for (i = 0; i < this.itsRules.size(); ++i) {
            ((Rule)this.itsRules.elementAt(i)).showTree();
        }
        System.out.println("*******************");
    }

    public void save(String filename) {
        this.storeUsedClassPackages();
        String outfileName = "";
        if (filename.equals("")) {
            outfileName = this.itsName + "_out.ggx";
        } else {
            outfileName = filename;
            if (outfileName.indexOf(".ggx") == -1) {
                outfileName = outfileName.concat(".ggx");
            }
        }
        if (outfileName.endsWith(".ggx")) {
            XMLHelper xmlh = new XMLHelper();
            xmlh.addTopObject(this);
            xmlh.save_to_xml(outfileName);
            File f = new File(outfileName);
            if (f.exists()) {
                this.fileName = f.getName();
                this.dirName = f.getParent() != null ? f.getParent() + File.separator : "." + File.separator;
            }
        }
    }

    public void load(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            if (filename.endsWith(".ggx")) {
                XMLHelper h = null;
                h = new XMLHelper();
                h.read_from_xml(filename);
                h.getTopObject(this);
                this.fileName = f.getName();
                this.dirName = f.getParent() != null ? f.getParent() + File.separator : "." + File.separator;
                this.setUsedClassPackages();
            } else {
                System.out.println("GraGra.load:: File  \"" + filename + "\"  is not  \".ggx\"  file!");
            }
        } else {
            System.out.println("GraGra.load:: File  \"" + filename + "\"  does not exist!");
        }
    }

    public void read(String filename) throws Exception {
        File f = new File(filename);
        if (f.exists()) {
            if (!filename.endsWith(".ggx")) {
                throw new Exception("File  \"" + filename + "\"  is not a  \".ggx\"  file!");
            }
        } else {
            throw new Exception("File  \"" + filename + "\"  does not exist!");
        }
        XMLHelper h = null;
        h = new XMLHelper();
        h.read_from_xml(filename);
        h.getTopObject(this);
        this.fileName = f.getName();
        this.dirName = f.getParent() != null ? f.getParent() + File.separator : "." + File.separator;
        this.setUsedClassPackages();
    }

    private void saveXML(XMLHelper h) {
        int i;
        this.storeUsedClassPackages();
        if (this.itsPackages != null && !this.itsPackages.isEmpty()) {
            for (i = 0; i < this.itsPackages.size(); ++i) {
                Pair p = (Pair)this.itsPackages.elementAt(i);
                String attrHand = (String)p.first;
                h.openSubTag("TaggedValue");
                h.addAttr("Tag", "AttrHandler");
                h.addAttr("TagValue", attrHand);
                Vector v = (Vector)p.second;
                for (int j = 0; j < v.size(); ++j) {
                    String n = (String)v.elementAt(j);
                    h.openSubTag("TaggedValue");
                    h.addAttr("Tag", "Package");
                    h.addAttr("TagValue", n);
                    h.close();
                }
                h.close();
            }
        }
        if (this.gratraOptions != null && !this.gratraOptions.isEmpty()) {
            for (i = 0; i < this.gratraOptions.size(); ++i) {
                h.openSubTag("TaggedValue");
                h.addAttr("Tag", (String)this.gratraOptions.elementAt(i));
                h.addAttr("TagValue", "true");
                h.close();
            }
        }
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "TypeGraphLevel");
        switch (this.typeSet.getLevelOfTypeGraphCheck()) {
            case 10: {
                h.addAttr("TagValue", "ENABLED");
                break;
            }
            case 20: {
                h.addAttr("TagValue", "ENABLED_MAX");
                break;
            }
            case 30: {
                h.addAttr("TagValue", "ENABLED_MAX_MIN");
                break;
            }
            default: {
                h.addAttr("TagValue", "DISABLED");
            }
        }
        h.close();
        h.openSubTag("Types");
        h.addEnumeration("", this.getTypes(), true);
        h.addObject("", this.typeSet.getTypeGraph(), true);
        h.close();
        h.addEnumeration("", this.getGraphs(), true);
        if (this.itsAtomics.size() != 0) {
            h.openSubTag("Constraints");
            h.addEnumeration("", this.getAtomics(), true);
            if (this.getConstraints().hasMoreElements()) {
                Enumeration en = this.getConstraints();
                while (en.hasMoreElements()) {
                    Formula f = (Formula)en.nextElement();
                    String s = f.getAsString(this.getAtomicsVec());
                    h.addObjectSub(f);
                    h.peekObject(f, null);
                    h.addAttr("f", s);
                    h.addAttr("name", f.getName());
                    h.close();
                }
            }
            h.close();
        }
        h.addEnumeration("", this.getRules(), true);
        if (!this.itsMatches.isEmpty()) {
            h.openSubTag("Matches");
            for (int i2 = 0; i2 < this.itsMatches.size(); ++i2) {
                Object m = this.itsMatches.elementAt(i2);
                if (m == null) continue;
                ((Match)m).setName("MatchOf_" + ((Match)m).getRule().getName());
                h.openSubTag("MatchOf");
                h.addObject("Rule", ((Match)m).getRule(), false);
                h.addObject("", (Match)m, true);
                h.close();
            }
            h.close();
        }
        int tgl_check = this.typeSet.getLevelOfTypeGraphCheck();
        if (this.typeSet.getLevelOfTypeGraphCheck() == 30) {
            this.typeSet.setLevelOfTypeGraphCheck(20);
        }
        this.itsStartGraph = this.cloneGraph();
        this.typeSet.setLevelOfTypeGraphCheck(tgl_check);
    }

    private void loadXML(XMLHelper h) {
        String s;
        Formula f;
        this.setUsedClassPackages();
        if (this.itsPackages == null) {
            this.itsPackages = new Vector(0);
        }
        int loadedLevel = 0;
        boolean tgl_ENABLED_MAX_MIN = false;
        if (this.gratraOptions == null) {
            this.gratraOptions = new Vector(0);
        }
        String v = null;
        String v1 = "";
        String tag = "";
        boolean taggedvalue = true;
        while (taggedvalue) {
            if (tag.equals("AttrHandler")) {
                Pair p = new Pair();
                p.first = v;
                Vector<String> packs = new Vector<String>(0);
                boolean isPackage = true;
                while (isPackage && h.readSubTag("TaggedValue")) {
                    v = null;
                    String tag1 = h.readAttr("Tag").trim();
                    if (tag1.equals("Package")) {
                        v1 = h.readAttr("TagValue");
                        if (v1 != null) {
                            packs.addElement(v1.trim());
                        }
                        h.close();
                        continue;
                    }
                    isPackage = false;
                }
                p.second = packs;
                this.itsPackages.addElement(p);
                h.close();
                this.setUsedClassPackages();
            }
            if (h.readSubTag("TaggedValue")) {
                v = null;
                tag = h.readAttr("Tag").trim();
                v1 = h.readAttr("TagValue");
                if (v1 != null) {
                    v = v1.trim();
                }
                if (tag.equals("AttrHandler")) continue;
                if (tag.equalsIgnoreCase("TypeGraphLevel")) {
                    if (v != null && !v.equals("")) {
                        if (v.equalsIgnoreCase("ENABLED")) {
                            loadedLevel = 10;
                        } else if (v.equalsIgnoreCase("ENABLED_MAX")) {
                            loadedLevel = 20;
                        } else if (v.equalsIgnoreCase("ENABLED_MAX_MIN")) {
                            loadedLevel = 20;
                            tgl_ENABLED_MAX_MIN = true;
                        } else if (v.equalsIgnoreCase("DISABLED")) {
                            loadedLevel = 0;
                        }
                    } else {
                        loadedLevel = 0;
                    }
                } else if (v != null && !v.equals("")) {
                    if (v.equalsIgnoreCase("true")) {
                        this.gratraOptions.addElement(tag);
                    }
                } else {
                    this.gratraOptions.addElement(tag);
                }
                h.close();
                continue;
            }
            taggedvalue = false;
        }
        if (h.readSubTag("Types")) {
            Type t;
            Enumeration en = h.getEnumeration("", null, true, "Type");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                h.loadObject(this.createType());
                h.close();
            }
            en = h.getEnumeration("", null, true, "NodeType");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = this.createType();
                h.loadObject(t);
                h.close();
                if (!t.getAdditionalRepr().equals("")) continue;
                t.setAdditionalRepr("[NODE]");
            }
            en = h.getEnumeration("", null, true, "EdgeType");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = this.createType();
                h.loadObject(t);
                h.close();
                if (!t.getAdditionalRepr().equals("")) continue;
                t.setAdditionalRepr("[EDGE]");
            }
            if (h.readSubTag("Graph")) {
                h.loadObject(this.typeSet.createTypeGraph());
                h.close();
                this.typeSet.setLevelOfTypeGraphCheck(0);
            }
            h.close();
            this.typeSet.refreshInheritanceArcs();
        }
        if (this.typeSet.getTypeGraph() == null) {
            this.typeSet.setLevelOfTypeGraphCheck(0);
        } else if (loadedLevel != 0 && loadedLevel != -1) {
            this.typeSet.setLevelOfTypeGraphCheck(10);
        }
        this.itsGraphs.clear();
        Enumeration enGraphs = h.getEnumeration("", null, true, "Graph");
        while (enGraphs.hasMoreElements()) {
            h.peekElement(enGraphs.nextElement());
            Graph g = this.createGraph();
            h.loadObject(g);
            h.close();
        }
        this.itsGraph = (Graph)this.itsGraphs.firstElement();
        boolean gcAtomicsLoaded = false;
        Enumeration en = h.getEnumeration("", null, true, "Graphconstraint_Atomic");
        if (en.hasMoreElements()) {
            gcAtomicsLoaded = true;
        }
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            h.loadObject(this.createAtomic(""));
            h.close();
        }
        if (gcAtomicsLoaded) {
            if (h.readSubTag("Constraints")) {
                en = h.getEnumeration("", null, true, "Formula");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    f = (Formula)h.loadObject(this.createConstraint(""));
                    if (f != null) {
                        s = h.readAttr("f");
                        f.setFormula(this.getAtomicsVec(), s);
                        s = h.readAttr("name");
                        f.setName(s);
                    }
                    h.close();
                }
                h.close();
            }
        } else if (h.readSubTag("Constraints")) {
            en = h.getEnumeration("", null, true, "Graphconstraint_Atomic");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                h.loadObject(this.createAtomic(""));
                h.close();
            }
            en = h.getEnumeration("", null, true, "Formula");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                f = (Formula)h.loadObject(this.createConstraint(""));
                if (f != null) {
                    s = h.readAttr("f");
                    f.setFormula(this.getAtomicsVec(), s);
                    s = h.readAttr("name");
                    f.setName(s);
                }
                h.close();
            }
            h.close();
        }
        Enumeration en1 = h.getEnumeration("", null, true, "Rule");
        while (en1.hasMoreElements()) {
            h.peekElement(en1.nextElement());
            Rule r = this.createRule();
            h.loadObject(r);
            h.close();
        }
        if (h.readSubTag("Matches")) {
            boolean nextMatch = true;
            while (nextMatch) {
                if (h.readSubTag("MatchOf")) {
                    XMLObject obj = h.getObject("Rule", null, false);
                    if (obj instanceof Rule) {
                        Rule r = (Rule)obj;
                        Match m = this.createMatch(r);
                        h.getObject("Match", m, true);
                    }
                    h.close();
                    continue;
                }
                nextMatch = false;
            }
            h.close();
        }
        this.itsStartGraph = this.cloneGraph();
        if (tgl_ENABLED_MAX_MIN) {
            loadedLevel = 30;
        }
        this.typeSet.setLevelOfTypeGraphCheck(loadedLevel);
        this.setLevelOfTypeGraphCheck(loadedLevel);
        this.setMorphismCompletionStrategy();
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("GraphTransformationSystem", this);
        h.addAttr("name", this.itsName);
        this.saveXML(h);
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        Debug.HASHCODE = false;
        if (h.isTag("GraphTransformationSystem", this)) {
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            this.loadXML(h);
            h.close();
        }
    }
}

