/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.VarMember;
import agg.util.Debug;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionPropertyBits;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.GraTraOptions;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.Pair;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public abstract class GraTra {
    protected String name;
    protected GraGra grammar;
    protected Graph hostgraph;
    protected Graph graphUndo = null;
    protected Rule currentRule;
    protected Vector currentRuleSet = new Vector();
    protected Match currentMatch;
    protected MorphCompletionStrategy strategy;
    protected Vector graTraListeners;
    protected boolean stopping = false;
    protected boolean stoppingRule = false;
    protected boolean consistentGraph = true;
    protected GraTraOptions options;
    protected String errorMsg = "";

    public boolean setName(String n) {
        if (this.name == null) {
            this.name = n;
            return true;
        }
        this.name = n;
        return false;
    }

    public String getName() {
        if (this.name == null) {
            return "undef";
        }
        return this.name;
    }

    public boolean setGraGra(GraGra gg) {
        if (this.grammar == null) {
            this.grammar = gg;
            this.setRuleSet();
            return true;
        }
        this.grammar = gg;
        this.setRuleSet();
        return false;
    }

    public GraGra getGraGra() {
        return this.grammar;
    }

    public boolean setHostGraph(Graph g) {
        if (this.hostgraph == null) {
            this.hostgraph = g;
            return true;
        }
        this.hostgraph = g;
        return false;
    }

    public Graph getHostGraph() {
        return this.hostgraph;
    }

    public GraTraOptions getGraTraOptions() {
        if (this.options == null) {
            this.options = new GraTraOptions();
        }
        if (this.strategy != null) {
            this.options.addOption(CompletionStrategySelector.getName(this.strategy));
            BitSet activebits = this.strategy.getProperties();
            for (int i = 0; i < CompletionPropertyBits.BITNAME.length; ++i) {
                if (!activebits.get(i)) continue;
                String bitName = CompletionPropertyBits.BITNAME[i];
                this.options.addOption(bitName);
            }
        }
        return this.options;
    }

    public void setGraTraOptions(GraTraOptions newOptions) {
        this.options = newOptions;
        this.options.update();
        this.setCompletionStrategy(this.options.getCompletionStrategy());
    }

    public void setGraTraOptions(Vector newOptions) {
        GraTraOptions nOptions = new GraTraOptions();
        for (int i = 0; i < newOptions.size(); ++i) {
            String opt = (String)newOptions.elementAt(i);
            nOptions.addOption(opt);
        }
        this.options = nOptions;
        this.options.update();
        this.setCompletionStrategy(this.options.getCompletionStrategy());
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
    }

    public MorphCompletionStrategy getCompletionStrategy() {
        return this.strategy;
    }

    public Enumeration getMatches(Rule r) {
        Enumeration rules = this.grammar.getRules();
        boolean indicator = false;
        while (rules.hasMoreElements()) {
            if (r != rules.nextElement()) continue;
            indicator = true;
        }
        if (!indicator) {
            System.out.println("GraTra error: input rule is not member of my grammar!");
            return null;
        }
        return this.grammar.getMatches(r);
    }

    public Match createMatch(Rule r) {
        Enumeration rules = this.grammar.getRules();
        boolean indicator = false;
        while (rules.hasMoreElements()) {
            if (r != rules.nextElement()) continue;
            indicator = true;
        }
        if (!indicator) {
            System.out.println("GraTra error: input rule is not member of my grammar!");
            return null;
        }
        return this.grammar.createMatch(r);
    }

    public void destroyMatch(Match m) {
        this.grammar.destroyMatch(m);
    }

    public Morphism apply(Match m) {
        this.errorMsg = "";
        Step step = new Step();
        Morphism co = null;
        this.consistentGraph = true;
        if (this.options == null) {
            this.options = this.getGraTraOptions();
        }
        try {
            if (!this.options.hasOption("consistency")) {
                co = step.execute(m);
                if (co != null && !this.grammar.isGraphReadyForTransform()) {
                    this.fireGraTra(new GraTraEvent((Object)this, 13, this.currentMatch));
                }
                if (co != null && !this.checkGraphConsistency(m.getRule(), m.getTarget())) {
                    this.consistentGraph = false;
                }
            } else {
                boolean validStep = this.checkGraphConsistency(m);
                while (!validStep && m.nextCompletion()) {
                    if (!m.isValid()) continue;
                    validStep = this.checkGraphConsistency(m);
                }
                this.consistentGraph = validStep;
                if (validStep) {
                    co = step.execute(m);
                } else {
                    this.errorMsg = "Graph inconsistency after transformation.";
                }
            }
        }
        catch (TypeException e) {
            this.fireGraTra(new GraTraEvent((Object)this, 4, m, e.getMessage()));
            this.errorMsg = "Type graph constraints are not satisfied after transformation.";
            return null;
        }
        if (co != null) {
            this.hostgraph = co.getImage();
            this.fireGraTra(new GraTraEvent((Object)this, 2, m, co));
        }
        if (!this.consistentGraph) {
            this.fireGraTra(new GraTraEvent((Object)this, 11, m));
        }
        return co;
    }

    public boolean step(Match m) {
        Morphism co = this.apply(m);
        return co != null;
    }

    public boolean apply(Rule r) {
        Debug.DEBUG = false;
        Debug.MATCH = false;
        Debug.println("apply:  " + r.getName(), this, Debug.MATCH);
        boolean result = false;
        if (this.stopping) {
            return false;
        }
        this.stoppingRule = false;
        boolean valid = false;
        this.currentMatch = this.grammar.createMatch(r);
        this.currentMatch.setCompletionStrategy(this.strategy);
        if (!this.currentMatch.canComplete()) {
            this.fireGraTra(new GraTraEvent((Object)this, 4, this.currentMatch));
            this.grammar.destroyMatch(this.currentMatch);
            return false;
        }
        this.fireGraTra(new GraTraEvent((Object)this, 7, this.currentMatch));
        AttrContext ac = this.currentMatch.getAttrContext();
        AttrVariableTuple avt = ac.getVariables();
        if (!this.areInputParameterSet(r.getLeft(), true, this.currentMatch)) {
            this.fireGraTra(new GraTraEvent((Object)this, 1, this.currentMatch));
        }
        if (this.stopping || this.stoppingRule) {
            this.grammar.destroyMatch(this.currentMatch);
            return false;
        }
        valid = false;
        while (!(valid || this.stopping || this.stoppingRule)) {
            if (this.currentMatch.nextCompletion()) {
                if (this.stopping || this.stoppingRule) {
                    this.grammar.destroyMatch(this.currentMatch);
                    return false;
                }
                if (this.currentMatch.isValid()) {
                    valid = true;
                    continue;
                }
                this.errorMsg = this.currentMatch.getErrorMsg();
                continue;
            }
            this.errorMsg = !this.stopping && !this.stoppingRule ? this.currentMatch.getErrorMsg() : "";
            break;
        }
        if (valid && !this.stopping && !this.stoppingRule) {
            this.fireGraTra(new GraTraEvent((Object)this, 8, this.currentMatch));
            if (!this.areInputParameterSet(r.getRight(), false, this.currentMatch)) {
                this.fireGraTra(new GraTraEvent((Object)this, 1, this.currentMatch));
            }
            if (!this.stopping && !this.stoppingRule) {
                try {
                    boolean checkVarsOnly = true;
                    avt.getAttrManager().checkIfReadyToTransform(ac, checkVarsOnly);
                }
                catch (AttrException ex) {
                    this.fireGraTra(new GraTraEvent((Object)this, 6, r.getName()));
                    this.errorMsg = "Rule  \"" + r.getName() + "\"  not ready to transform. Maybe attributes or rule context are not correct.";
                    this.grammar.destroyMatch(this.currentMatch);
                    return false;
                }
            } else {
                this.grammar.destroyMatch(this.currentMatch);
                return false;
            }
            Morphism co = this.apply(this.currentMatch);
            if (co != null) {
                this.grammar.destroyMatch(this.currentMatch);
                result = true;
            } else {
                this.fireGraTra(new GraTraEvent((Object)this, 4, this.currentMatch));
                valid = false;
                while (!valid && !this.stopping) {
                    while (!valid && !this.stopping && this.currentMatch.nextCompletion()) {
                        if (this.currentMatch.isValid()) {
                            valid = true;
                            continue;
                        }
                        this.currentMatch.clearErrorMsg();
                    }
                    if (valid && !this.stopping && !this.stoppingRule) {
                        co = this.apply(this.currentMatch);
                        if (co != null) {
                            this.grammar.destroyMatch(this.currentMatch);
                            result = true;
                            continue;
                        }
                        valid = false;
                        continue;
                    }
                    this.fireGraTra(new GraTraEvent((Object)this, 3, this.currentMatch));
                    this.grammar.destroyMatch(this.currentMatch);
                    return false;
                }
            }
        } else {
            this.fireGraTra(new GraTraEvent((Object)this, 3, this.currentMatch));
            this.grammar.destroyMatch(this.currentMatch);
            result = false;
        }
        Debug.DEBUG = false;
        Debug.MATCH = false;
        return result;
    }

    public abstract boolean apply();

    public abstract Pair derivation(Match var1);

    public abstract void transform(Vector var1);

    public abstract void transform();

    public abstract boolean didTransformation();

    public boolean isGraphConsistent() {
        return this.consistentGraph;
    }

    public void stop() {
        this.stopping = true;
    }

    public void stopRule() {
        this.stoppingRule = true;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public synchronized void removeGraTraListener(GraTraEventListener l) {
        if (this.graTraListeners != null && this.graTraListeners.contains(l)) {
            Vector v = (Vector)this.graTraListeners.clone();
            v.removeElement(l);
            this.graTraListeners = v;
        }
    }

    public synchronized void addGraTraListener(GraTraEventListener l) {
        Vector v;
        Vector vector = v = this.graTraListeners == null ? new Vector(2) : (Vector)this.graTraListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.graTraListeners = v;
        }
    }

    protected void fireGraTra(GraTraEvent e) {
        if (this.graTraListeners != null) {
            Vector listeners = this.graTraListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((GraTraEventListener)listeners.elementAt(i)).graTraEventOccurred(e);
            }
        }
    }

    protected void setRuleSet() {
        if (this.grammar != null) {
            Enumeration rules = this.grammar.getRules();
            while (rules.hasMoreElements()) {
                Rule r = (Rule)rules.nextElement();
                this.currentRuleSet.addElement(r);
            }
        }
    }

    private boolean areInputParameterSet(Graph g, boolean leftOfRule, Match match) {
        if (match == null) {
            return true;
        }
        AttrContext ac = match.getAttrContext();
        AttrVariableTuple avt = ac.getVariables();
        if (avt == null || avt.getNumberOfEntries() == 0) {
            return true;
        }
        AttrConditionTuple act = ac.getConditions();
        for (int i = 0; i < avt.getNumberOfEntries(); ++i) {
            VarMember v = avt.getVarMemberAt(i);
            if (!v.isInputParameter() || v.isSet()) continue;
            if (g.isUsingVariable(v)) {
                return false;
            }
            if (!leftOfRule) continue;
            Enumeration nacs = match.getRule().getNACs();
            while (nacs.hasMoreElements()) {
                OrdinaryMorphism nac = (OrdinaryMorphism)nacs.nextElement();
                if (nac.getTarget().isUsingVariable(v)) {
                    return false;
                }
                Vector nacVars = nac.getTarget().getVariableNamesOfAttributes();
                for (int j = 0; j < nacVars.size(); ++j) {
                    String varName = (String)nacVars.get(j);
                    for (int k = 0; k < act.getNumberOfEntries(); ++k) {
                        CondMember cond = (CondMember)act.getMemberAt(k);
                        Vector condVars = cond.getAllVariables();
                        if (!condVars.contains(varName) || !condVars.contains(v.getName())) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected boolean checkGraphConsistency(Rule r, Graph g) {
        if (this.grammar.isLayered()) {
            Vector constraints = this.grammar.getConstraintsForLayer(-1);
            if (this.grammar.checkGraphConsistency(g, constraints)) {
                constraints = this.grammar.getConstraintsForLayer(r.getLayer());
                return this.grammar.checkGraphConsistency(g, constraints);
            }
            return false;
        }
        return this.grammar.checkGraphConsistency(g);
    }

    protected boolean checkGraphConsistency(Match m) {
        BaseFactory bf = BaseFactory.theFactory();
        OrdinaryMorphism copy = m.getImage().isoToCopy(2);
        copy.getImage().setCompleteGraph(true);
        OrdinaryMorphism com = m.compose(copy);
        Match m2 = bf.makeMatch(m.getRule(), com);
        m2.adaptAttrContextValues(m.getAttrContext());
        if (m2 != null) {
            Step s = new Step();
            try {
                OrdinaryMorphism co_match = (OrdinaryMorphism)s.execute(m2);
                if (co_match != null) {
                    if (this.grammar.isLayered()) {
                        Vector constraints = this.grammar.getConstraintsForLayer(-1);
                        if (this.grammar.checkGraphConsistency(co_match.getImage(), constraints)) {
                            constraints = this.grammar.getConstraintsForLayer(m.getRule().getLayer());
                            return this.grammar.checkGraphConsistency(co_match.getImage(), constraints);
                        }
                        return false;
                    }
                    return this.grammar.checkGraphConsistency(co_match.getImage());
                }
                return false;
            }
            catch (TypeException e) {
                return false;
            }
        }
        return false;
    }
}

