/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.xt_basis.CompletionPropertyBits;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.MorphCompletionStrategy;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public class GraTraOptions {
    private Vector options = new Vector();
    private MorphCompletionStrategy strategy;

    public void addOption(String name) {
        if (!this.options.contains(name)) {
            this.options.addElement(name);
        }
    }

    public void removeOption(String name) {
        if (this.options.contains(name)) {
            this.options.removeElement(name);
        }
    }

    public boolean hasOption(String name) {
        return this.options.contains(name);
    }

    public Vector getOptions() {
        return this.options;
    }

    public MorphCompletionStrategy getCompletionStrategy() {
        this.update();
        return this.strategy;
    }

    public String toString() {
        int l = this.options.size();
        String result = (String)this.options.elementAt(0);
        result = result + " [ ";
        for (int i = 1; i < l - 1; ++i) {
            result = result + (String)this.options.elementAt(i);
            result = result + ", ";
        }
        result = result + (String)this.options.elementAt(l - 1);
        result = result + " ]";
        return result;
    }

    public void update() {
        String stratName = "";
        if (this.options.contains("CSP")) {
            stratName = "CSP";
        } else if (this.options.contains("CSP w/o BJ")) {
            stratName = "CSP w/o BJ";
        } else if (this.options.contains("Simple BT")) {
            stratName = "Simple BT";
        }
        Enumeration strats = CompletionStrategySelector.getStrategies();
        while (strats.hasMoreElements()) {
            MorphCompletionStrategy mcs = (MorphCompletionStrategy)strats.nextElement();
            String name = CompletionStrategySelector.getName(mcs);
            if (!stratName.equals(name)) continue;
            this.strategy = mcs;
        }
        if (this.strategy == null) {
            return;
        }
        this.strategy.getSupportedProperties();
        BitSet activebits = this.strategy.getProperties();
        for (int j = 0; j < CompletionPropertyBits.BITNAME.length; ++j) {
            String bitName = CompletionPropertyBits.BITNAME[j];
            if (this.options.contains(bitName)) {
                activebits.set(j);
                continue;
            }
            activebits.clear(j);
        }
    }
}

