/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.Debug;
import agg.util.ExtObservable;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.CopyMemory;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.SubGraph;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeImpl;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.DList;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.UnaryFunction;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends ExtObservable
implements Observer,
XMLObject,
UnaryFunction {
    String itsName = "Graph";
    private Sequence itsNodes = new DList();
    private Sequence itsArcs = new DList();
    private Sequence itsSubGraphs = new DList();
    private Sequence itsUsingMorphs = new DList();
    private AttrContext itsAttrContext = null;
    private AttrManager itsAttrManager = AttrTupleManager.getDefaultManager();
    private List observer = new Vector();
    private TypeSet itsTypes;
    private boolean completeGraph = false;
    private boolean nacGraph = false;
    public String info = "";

    @Override
    public synchronized void addObserver(Observer o) {
        this.observer.add(o);
        super.addObserver(o);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        if (this.observer != null) {
            this.observer.remove(o);
        }
        super.deleteObserver(o);
    }

    public List getObservers() {
        if (this.observer == null) {
            return Collections.EMPTY_LIST;
        }
        return this.observer;
    }

    public void setObservers(List o) {
        if (o == null) {
            return;
        }
        this.observer.addAll(o);
    }

    public Graph() {
        this.itsTypes = new TypeSet();
    }

    public Graph(TypeSet aTypeSet) {
        this.itsTypes = aTypeSet;
    }

    public Graph(boolean completeGraph) {
        this.itsTypes = new TypeSet();
        this.completeGraph = completeGraph;
    }

    public Graph(TypeSet aTypeSet, boolean completeGraph) {
        this.itsTypes = aTypeSet;
        this.completeGraph = completeGraph;
    }

    public void setTypeSet(TypeSet types) {
        this.itsTypes = types;
    }

    public TypeSet getTypeSet() {
        return this.itsTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCopyOfGraph(Graph g, boolean disabledTypeGraphOnly) {
        Graph graph = this;
        synchronized (graph) {
            int n = 1;
            Object typeError = null;
            if (!disabledTypeGraphOnly || this.itsTypes.getLevelOfTypeGraphCheck() == 0) {
                Type type;
                boolean failed = false;
                Enumeration arcList = g.getArcs();
                Enumeration vtxList = g.getNodes();
                CopyMemory.RESET(n);
                CopyMemory.INSTALL(n);
                while (vtxList.hasMoreElements()) {
                    Node vtxOrig = (Node)((GraphObject)vtxList.nextElement());
                    Node vtxCopy = null;
                    type = this.itsTypes.getSimilarType(vtxOrig.getType());
                    if (type == null) {
                        type = this.itsTypes.getTypeForName(vtxOrig.getType().getName());
                    }
                    try {
                        if (type == null || (vtxCopy = this.createNode(type)) == null) continue;
                        if (this.itsTypes.getTypeGraph() == this) {
                            for (int i = 0; i < vtxOrig.getType().getParents().size(); ++i) {
                                Type parentOrig = vtxOrig.getType().getParents().get(i);
                                Type parent = this.itsTypes.getSimilarType(parentOrig);
                                if (parent == null) {
                                    parent = this.itsTypes.getTypeForName(parentOrig.getName());
                                }
                                if (parent == null) continue;
                                this.itsTypes.addInheritanceRelation(type, parent);
                            }
                        }
                        vtxCopy.getAttribute().copyEntries(vtxOrig.getAttribute());
                        this.propagateChange(new Change(10, vtxCopy));
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        CopyMemory.STORE(vtxOrig, vtxCopy, n);
                        ((TypeImpl)vtxCopy.getType()).addUsingGraphObject(vtxCopy);
                    }
                    catch (TypeException e) {
                        if (this.itsTypes.getTypeGraph() != this) continue;
                        Node node = this.itsTypes.getTypeGraphNode(type);
                        CopyMemory.STORE(vtxOrig, node, n);
                    }
                }
                while (arcList.hasMoreElements()) {
                    Arc arcOrig = (Arc)arcList.nextElement();
                    Arc arcCopy = null;
                    type = this.itsTypes.getSimilarType(arcOrig.getType());
                    if (type == null) {
                        type = this.itsTypes.getTypeForName(arcOrig.getType().getName());
                    }
                    try {
                        Node tgtImg;
                        if (type == null) continue;
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)CopyMemory.SELECT(source, n);
                        arcCopy = this.createArc(type, srcImg, tgtImg = (Node)CopyMemory.SELECT(target, n));
                        if (arcCopy == null) continue;
                        arcCopy.getAttribute().copyEntries(arcOrig.getAttribute());
                        this.propagateChange(new Change(10, arcCopy));
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                        ((TypeImpl)arcCopy.getType()).addUsingGraphObject(arcCopy);
                        if (this.itsTypes.getTypeGraph() != this) continue;
                        Type srctype = arcCopy.getSource().getType();
                        Type tartype = arcCopy.getTarget().getType();
                        int m1 = arcOrig.getType().getSourceMin(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                        type.setSourceMin(srctype, tartype, m1);
                        m1 = arcOrig.getType().getSourceMax(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                        type.setSourceMax(srctype, tartype, m1);
                        m1 = arcOrig.getType().getTargetMin(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                        type.setTargetMin(srctype, tartype, m1);
                        m1 = arcOrig.getType().getTargetMax(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                        type.setTargetMax(srctype, tartype, m1);
                    }
                    catch (TypeException e) {}
                }
                if (!failed) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph copyLight(TypeSet typeSet) {
        Graph graph = this;
        synchronized (graph) {
            Type type;
            int n = 1;
            TypeError typeError = null;
            int tglevel = typeSet.getLevelOfTypeGraphCheck();
            if (tglevel == 30) {
                typeSet.setLevelOfTypeGraphCheck(20);
            }
            boolean failed = false;
            Enumeration arcList = this.getArcs();
            Enumeration vtxList = this.getNodes();
            Graph theCopy = new Graph(typeSet);
            theCopy.setCompleteGraph(this.isCompleteGraph());
            if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            CopyMemory.RESET(n);
            CopyMemory.INSTALL(n);
            while (vtxList.hasMoreElements() && !failed) {
                Node vtxOrig = (Node)((GraphObject)vtxList.nextElement());
                Node vtxCopy = null;
                type = typeSet.getSimilarType(vtxOrig.getType());
                if (type == null) {
                    type = typeSet.getTypeForName(vtxOrig.getType().getName());
                }
                try {
                    if (type == null || (vtxCopy = theCopy.createNode(type)) == null) continue;
                    ((ValueTuple)vtxCopy.getAttribute()).copyEntriesToSimilarMembers(vtxOrig.getAttribute());
                    this.propagateChange(new Change(10, vtxCopy));
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    CopyMemory.STORE(vtxOrig, vtxCopy, n);
                    if (!this.isTypeGraph()) {
                        typeError = typeSet.checkType(vtxCopy, this.isCompleteGraph());
                    }
                    if (typeError != null) {
                        theCopy.dispose();
                        theCopy = null;
                        CopyMemory.UNSET();
                        throw new TypeException(typeError);
                    }
                    ((TypeImpl)vtxCopy.getType()).addUsingGraphObject(vtxCopy, theCopy);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            while (arcList.hasMoreElements() && !failed) {
                Arc arcOrig = (Arc)arcList.nextElement();
                Arc arcCopy = null;
                type = typeSet.getSimilarType(arcOrig.getType());
                if (type == null) {
                    type = typeSet.getTypeForName(arcOrig.getType().getName());
                }
                try {
                    Node tgtImg;
                    if (type == null) continue;
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)CopyMemory.SELECT(source, n);
                    arcCopy = theCopy.createArc(type, srcImg, tgtImg = (Node)CopyMemory.SELECT(target, n));
                    if (arcCopy == null) continue;
                    ((ValueTuple)arcCopy.getAttribute()).copyEntriesToSimilarMembers(arcOrig.getAttribute());
                    this.propagateChange(new Change(10, arcCopy));
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    if (!this.isTypeGraph()) {
                        typeError = typeSet.checkType(arcCopy, this.isCompleteGraph());
                    }
                    if (typeError != null) {
                        theCopy.dispose();
                        theCopy = null;
                        CopyMemory.UNSET();
                        throw new TypeException(typeError);
                    }
                    ((TypeImpl)arcCopy.getType()).addUsingGraphObject(arcCopy);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            if (!failed && tglevel == 30) {
                typeSet.setLevelOfTypeGraphCheck(30);
            }
            Iterator it = this.getObservers().iterator();
            while (it.hasNext()) {
                theCopy.addObserver((Observer)it.next());
            }
            return theCopy;
        }
    }

    public Graph copy(TypeSet types) {
        return this.graphcopy(1, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph graphcopy(int n, TypeSet typeSet) {
        Graph graph = this;
        synchronized (graph) {
            Type type;
            TypeError typeError = null;
            int tglevel = typeSet.getLevelOfTypeGraphCheck();
            if (tglevel == 30) {
                typeSet.setLevelOfTypeGraphCheck(20);
            }
            boolean failed = false;
            Enumeration arcList = this.getArcs();
            Enumeration vtxList = this.getNodes();
            Graph theCopy = new Graph(typeSet);
            theCopy.setCompleteGraph(this.isCompleteGraph());
            if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            CopyMemory.RESET(n);
            CopyMemory.INSTALL(n);
            while (vtxList.hasMoreElements() && !failed) {
                Node vtxOrig = (Node)((GraphObject)vtxList.nextElement());
                Node vtxCopy = null;
                try {
                    type = typeSet.getSimilarType(vtxOrig.getType());
                    if (type == null || (vtxCopy = theCopy.createNode(type)) == null) continue;
                    vtxCopy.getAttribute().copyEntries(vtxOrig.getAttribute());
                    this.propagateChange(new Change(10, vtxCopy));
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    CopyMemory.STORE(vtxOrig, vtxCopy, n);
                    if (!this.isTypeGraph()) {
                        typeError = typeSet.checkType(vtxCopy, this.isCompleteGraph());
                    }
                    if (typeError != null) {
                        theCopy.dispose();
                        theCopy = null;
                        CopyMemory.UNSET();
                        throw new TypeException(typeError);
                    }
                    ((TypeImpl)vtxCopy.getType()).addUsingGraphObject(vtxCopy, theCopy);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            while (arcList.hasMoreElements() && !failed) {
                Arc arcOrig = (Arc)arcList.nextElement();
                Arc arcCopy = null;
                try {
                    Node tgtImg;
                    type = typeSet.getSimilarType(arcOrig.getType());
                    if (type == null) continue;
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)CopyMemory.SELECT(source, n);
                    arcCopy = theCopy.createArc(type, srcImg, tgtImg = (Node)CopyMemory.SELECT(target, n));
                    if (arcCopy == null) continue;
                    arcCopy.getAttribute().copyEntries(arcOrig.getAttribute());
                    this.propagateChange(new Change(10, arcCopy));
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    if (!this.isTypeGraph()) {
                        typeError = typeSet.checkType(arcCopy, this.isCompleteGraph());
                    }
                    if (typeError != null) {
                        theCopy.dispose();
                        theCopy = null;
                        CopyMemory.UNSET();
                        throw new TypeException(typeError);
                    }
                    ((TypeImpl)arcCopy.getType()).addUsingGraphObject(arcCopy);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            if (!failed && tglevel == 30) {
                typeSet.setLevelOfTypeGraphCheck(30);
            }
            Iterator it = this.getObservers().iterator();
            while (it.hasNext()) {
                theCopy.addObserver((Observer)it.next());
            }
            return theCopy;
        }
    }

    public Graph copy(Hashtable outmapping) {
        return this.graphcopy(1, outmapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph graphcopy(int n, Hashtable mapping) {
        Graph graph = this;
        synchronized (graph) {
            if (mapping == null) {
                mapping = new Hashtable<GraphObject, GraphObject>(this.getSize());
            }
            boolean failed = false;
            Enumeration arcList = this.getArcs();
            Enumeration vtxList = this.getNodes();
            Graph theCopy = new Graph(this.getTypeSet());
            if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            CopyMemory.RESET(n);
            CopyMemory.INSTALL(n);
            while (!failed && vtxList.hasMoreElements()) {
                Node vtxOrig = (Node)((GraphObject)vtxList.nextElement());
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.createNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    CopyMemory.STORE(vtxOrig, vtxCopy, n);
                    mapping.put(vtxOrig, vtxCopy);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            while (!failed && arcList.hasMoreElements()) {
                try {
                    Node tgtImg;
                    Arc arcOrig = (Arc)arcList.nextElement();
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)CopyMemory.SELECT(source, n);
                    Arc arcCopy = theCopy.createArc(arcOrig, srcImg, tgtImg = (Node)CopyMemory.SELECT(target, n));
                    if (arcCopy == null) continue;
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    mapping.put(arcOrig, arcCopy);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            Iterator it = this.getObservers().iterator();
            while (it.hasNext()) {
                theCopy.addObserver((Observer)it.next());
            }
            return theCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph graphcopy(int n) {
        Graph graph = this;
        synchronized (graph) {
            boolean failed = false;
            Enumeration arcList = this.getArcs();
            Enumeration vtxList = this.getNodes();
            Graph theCopy = new Graph(this.getTypeSet());
            if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            theCopy.setCompleteGraph(this.isCompleteGraph());
            CopyMemory.RESET(n);
            CopyMemory.INSTALL(n);
            while (!failed && vtxList.hasMoreElements()) {
                Node vtxOrig = (Node)((GraphObject)vtxList.nextElement());
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.createNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    CopyMemory.STORE(vtxOrig, vtxCopy, n);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            while (!failed && arcList.hasMoreElements()) {
                try {
                    Node tgtImg;
                    Arc arcOrig = (Arc)arcList.nextElement();
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)CopyMemory.SELECT(source, n);
                    Arc arcCopy = theCopy.createArc(arcOrig, srcImg, tgtImg = (Node)CopyMemory.SELECT(target, n));
                    if (arcCopy == null) continue;
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                }
                catch (TypeException e) {
                    e.printStackTrace();
                    failed = true;
                    theCopy.dispose();
                    theCopy = null;
                    CopyMemory.UNSET();
                }
            }
            Iterator it = this.getObservers().iterator();
            while (it.hasNext()) {
                theCopy.addObserver((Observer)it.next());
            }
            return theCopy;
        }
    }

    public Graph copy() {
        return this.graphcopy(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph graphcopy(Graph g) {
        Graph graph = g;
        synchronized (graph) {
            Enumeration arcList = g.getArcs();
            Enumeration vtxList = g.getNodes();
            Graph theCopy = this;
            if (g.getAttrContext() != null && ((ContextView)g.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            int n = 1;
            CopyMemory.RESET(n);
            CopyMemory.INSTALL(n);
            while (vtxList.hasMoreElements()) {
                Node vtxOrig = (Node)((GraphObject)vtxList.nextElement());
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.createNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    CopyMemory.STORE(vtxOrig, vtxCopy, n);
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            while (arcList.hasMoreElements()) {
                try {
                    Node tgtImg;
                    Arc arcOrig = (Arc)arcList.nextElement();
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)CopyMemory.SELECT(source, n);
                    Arc arcCopy = theCopy.createArc(arcOrig, srcImg, tgtImg = (Node)CopyMemory.SELECT(target, n));
                    if (arcCopy == null) continue;
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
            }
            Iterator it = this.getObservers().iterator();
            while (it.hasNext()) {
                theCopy.addObserver((Observer)it.next());
            }
            CopyMemory.UNSET();
            return theCopy;
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.itsUsingMorphs.size(); ++i) {
            ((OrdinaryMorphism)this.itsUsingMorphs.at(i)).clear();
        }
        this.itsUsingMorphs.clear();
        this.itsSubGraphs.clear();
        this.completeGraph = false;
        Enumeration arcs = this.getArcs();
        while (arcs.hasMoreElements()) {
            try {
                this.destroyArc((Arc)arcs.nextElement());
            }
            catch (TypeException e) {}
        }
        Enumeration nodes = this.getNodes();
        while (nodes.hasMoreElements()) {
            try {
                this.destroyNode((Node)nodes.nextElement());
            }
            catch (TypeException typeException) {}
        }
        this.itsNodes.clear();
        this.itsArcs.clear();
        this.observer.removeAll(this.observer);
        super.dispose();
    }

    @Override
    public final void update(Observable obs, Object change) {
    }

    public final void setName(String n) {
        this.itsName = n;
    }

    public final String getName() {
        return this.itsName;
    }

    public final Type createType() {
        return this.itsTypes.createType();
    }

    public void destroyType(Type type) throws TypeException {
        this.itsTypes.destroyType(type);
    }

    public final Enumeration getTypes() {
        return this.itsTypes.getTypes();
    }

    public Vector getUsedTypes() {
        Vector<Type> vec = new Vector<Type>();
        Enumeration en = this.getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            if (vec.contains(o.getType())) continue;
            vec.add(o.getType());
        }
        return vec;
    }

    public Vector getUsedAndInheritedTypes() {
        Vector<Type> vec = new Vector<Type>();
        Enumeration en = this.getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            Type t = o.getType();
            if (!vec.contains(t)) {
                vec.add(t);
            }
            Vector pars = t.getAllParents();
            for (int i = 0; i < pars.size(); ++i) {
                Type pt = (Type)pars.get(i);
                if (vec.contains(pt)) continue;
                vec.add(pt);
            }
        }
        return vec;
    }

    public final Node createNode(Type type) throws TypeException {
        TypeError typeError;
        Type t = null;
        if (!this.itsTypes.containsType(type) && (t = this.itsTypes.getSimilarType(type)) == null) {
            this.itsTypes.addType(type);
        }
        if ((t = type).getAdditionalRepr().indexOf("[NODE]") == -1) {
            t.setAdditionalRepr("[NODE]");
        }
        AttrInstance anAttr = this.itsAttrManager.newInstance(t.getAttrType(), this.itsAttrContext);
        Node aNode = new Node(anAttr, t, this);
        if (this.isTypeGraph()) {
            typeError = this.itsTypes.addTypeGraphObject(aNode);
        } else {
            ((TypeImpl)aNode.getType()).addUsingGraphObject(aNode, this);
            typeError = this.itsTypes.checkType(aNode, this.isCompleteGraph());
        }
        if (typeError != null) {
            if (!this.isTypeGraph()) {
                ((TypeImpl)aNode.getType()).removeUsingGraphObject(aNode);
            }
            aNode.dispose();
            throw new TypeException(typeError);
        }
        this.itsNodes.add(aNode);
        this.propagateChange(new Change(10, aNode));
        return aNode;
    }

    public final Node createNode(Node orig) throws TypeException {
        Node aNode = this.createNode(orig.getType());
        if (aNode != null) {
            ((ValueTuple)aNode.getAttribute()).copyEntries(orig.getAttribute());
            this.propagateChange(new Change(10, aNode));
        }
        return aNode;
    }

    public final void destroyNode(Node node) throws TypeException {
        this.destroyNode(node, true);
    }

    public final synchronized void destroyNode(Node node, boolean checkFirst) throws TypeException {
        this.destroyNode(node, checkFirst, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void destroyNode(Node node, boolean checkFirst, boolean forceDestroy) throws TypeException {
        TypeError typeError;
        if (this.isTypeGraph()) {
            typeError = this.itsTypes.removeTypeGraphObject(node);
            if (!forceDestroy && typeError != null) {
                throw new TypeException(typeError);
            }
            boolean clanUsed = this.itsTypes.isClanUsed(node.getType());
            if (clanUsed && this.itsTypes.getLevelOfTypeGraphCheck() != 0) {
                typeError = new TypeError(4, "\nThe type \"" + node.getType().getName() + "\" cannot be deleted from the type graph," + "\nbecause at least one graph object uses it." + "\nPlease disable the type graph before delete a type.", node, node.getType());
                typeError.setContainingGraph(this);
            }
            if (!forceDestroy && typeError != null) {
                throw new TypeException(typeError);
            }
            Type myType = node.getType();
            if (myType.checkIfRemovable(node, this.itsTypes.getLevelOfTypeGraphCheck()) != null) throw new TypeException(new TypeError(0, "Something gone wrong during removing inheritance relation!. \nCannot delete this type graph node!"));
            Enumeration en = this.itsTypes.getTypeGraph().getNodes();
            this.itsTypes.removeAllInheritanceRelations(myType);
            while (en.hasMoreElements()) {
                Node currentNode = (Node)en.nextElement();
                Type currentType = currentNode.getType();
                for (int i = 0; i < currentType.getParents().size(); ++i) {
                    Type p = currentType.getParents().get(i);
                    if (p != myType) continue;
                    this.itsTypes.removeInheritanceRelation(currentType, p);
                    ((ValueTuple)currentNode.getAttribute()).refreshParents();
                }
            }
        } else {
            if (checkFirst && this.isCompleteGraph() && (typeError = this.itsTypes.checkIfRemovable(node)) != null) {
                typeError.setContainingGraph(this);
                throw new TypeException(typeError);
            }
            node.getType().removeUsingGraphObject(node);
        }
        for (int i = 0; i < this.itsUsingMorphs.size(); ++i) {
            ((OrdinaryMorphism)this.itsUsingMorphs.at(i)).removeMapping(node);
        }
        if (this.isCompleteGraph() && checkFirst) {
            TypeError error = null;
            Enumeration anIter = node.getIncomingArcs();
            while (anIter.hasMoreElements()) {
                Arc aNeighbor = (Arc)anIter.nextElement();
                error = this.itsTypes.checkIfRemovableFromSource(aNeighbor);
                if (error == null) continue;
                error.setContainingGraph(this);
                throw new TypeException(error);
            }
            anIter = node.getOutgoingArcs();
            while (anIter.hasMoreElements()) {
                Arc aNeighbor = (Arc)anIter.nextElement();
                error = this.itsTypes.checkIfRemovableFromTarget(aNeighbor);
                if (error == null) continue;
                error.setContainingGraph(this);
                throw new TypeException(error);
            }
        }
        Enumeration anIter = node.getIncomingArcs();
        while (anIter.hasMoreElements()) {
            Arc aNeighbor = (Arc)anIter.nextElement();
            this.destroyArc(aNeighbor, false);
        }
        anIter = node.getOutgoingArcs();
        while (anIter.hasMoreElements()) {
            Arc aNeighbor = (Arc)anIter.nextElement();
            this.destroyArc(aNeighbor, false);
        }
        Enumeration e = this.getSubGraphs();
        while (e.hasMoreElements()) {
            SubGraph g = (SubGraph)((Graph)e.nextElement());
            Enumeration en = g.getElements();
            while (en.hasMoreElements()) {
                GraphObject o = (GraphObject)en.nextElement();
                if (!node.equals(o)) continue;
                g.removeObject(o);
                en = g.getElements();
            }
        }
        this.itsNodes.remove(node);
        this.propagateChange(new Change(12, node));
        node.dispose();
    }

    public final Arc createArc(Type type, Node src, Node tar) throws TypeException {
        TypeError typeError;
        if (src == null || tar == null) {
            return null;
        }
        if (!this.isElement(src) || !this.isElement(tar)) {
            return null;
        }
        Type t = null;
        if (!this.itsTypes.containsType(type) && (t = this.itsTypes.getSimilarType(type)) == null) {
            this.itsTypes.addType(type);
        }
        t = type;
        if (type.getAdditionalRepr().indexOf("[EDGE]") == -1) {
            type.setAdditionalRepr("[EDGE]");
        }
        AttrInstance anAttr = this.itsAttrManager.newInstance(t.getAttrType(), this.itsAttrContext);
        Arc anArc = new Arc(anAttr, t, src, tar, this);
        if (this.isTypeGraph()) {
            typeError = this.itsTypes.addTypeGraphObject(anArc);
        } else {
            ((TypeImpl)anArc.getType()).addUsingGraphObject(anArc);
            typeError = this.itsTypes.checkType(anArc, this.isCompleteGraph());
        }
        if (typeError != null) {
            anArc.getSource().removeOut(anArc);
            anArc.getTarget().removeIn(anArc);
            if (!this.isTypeGraph()) {
                ((TypeImpl)anArc.getType()).removeUsingGraphObject(anArc);
            }
            anArc.dispose();
            throw new TypeException(typeError);
        }
        this.itsArcs.add(anArc);
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    public final Arc createArc(Arc orig, Node src, Node tar) throws TypeException {
        Arc anArc = this.createArc(orig.getType(), src, tar);
        if (anArc != null) {
            ((ValueTuple)anArc.getAttribute()).copyEntries(orig.getAttribute());
            this.propagateChange(new Change(10, anArc));
        }
        return anArc;
    }

    public final void destroyArc(Arc arc) throws TypeException {
        this.destroyArc(arc, true);
    }

    public final synchronized void destroyArc(Arc arc, boolean checkFirst) throws TypeException {
        this.destroyArc(arc, checkFirst, false);
    }

    public final synchronized void destroyArc(Arc arc, boolean checkFirst, boolean forceDestroy) throws TypeException {
        TypeError typeError;
        if (arc == null) {
            return;
        }
        if (this.isTypeGraph()) {
            typeError = this.itsTypes.removeTypeGraphObject(arc);
            if (!forceDestroy && typeError != null) {
                throw new TypeException(typeError);
            }
        } else {
            if (checkFirst && this.isCompleteGraph() && (typeError = this.itsTypes.checkIfRemovable(arc)) != null) {
                typeError.setContainingGraph(this);
                throw new TypeException(typeError);
            }
            arc.getType().removeUsingGraphObject(arc);
        }
        for (int i = 0; i < this.itsUsingMorphs.size(); ++i) {
            ((OrdinaryMorphism)this.itsUsingMorphs.at(i)).removeMapping(arc);
        }
        Enumeration e = this.getSubGraphs();
        while (e.hasMoreElements()) {
            SubGraph g = (SubGraph)((Graph)e.nextElement());
            Enumeration en = g.getElements();
            while (en.hasMoreElements()) {
                GraphObject o = (GraphObject)en.nextElement();
                if (!arc.equals(o)) continue;
                g.removeObject(o);
                en = g.getElements();
            }
        }
        arc.getSource().removeOut(arc);
        arc.getTarget().removeIn(arc);
        this.itsArcs.remove(arc);
        this.propagateChange(new Change(12, arc));
        arc.dispose();
        arc = null;
    }

    public final void destroyObject(GraphObject obj) throws TypeException {
        if (obj.isNode()) {
            this.destroyNode((Node)obj);
        } else if (obj.isArc()) {
            this.destroyArc((Arc)obj);
        }
    }

    public final void forceDestroyObject(GraphObject obj) throws TypeException {
        if (obj.isNode()) {
            this.destroyNode((Node)obj, true, true);
        } else if (obj.isArc()) {
            this.destroyArc((Arc)obj, true, true);
        }
    }

    public boolean destroyObjectsOfType(Type t) {
        GraphObject go;
        Enumeration en = this.getArcs();
        while (en.hasMoreElements()) {
            go = (GraphObject)en.nextElement();
            if (!go.getType().compareTo(t)) continue;
            try {
                this.destroyArc((Arc)go, false, true);
            }
            catch (TypeException e) {
                System.out.println("Graph.destroyObjectsOfType : " + e.getMessage());
            }
        }
        en = this.getNodes();
        while (en.hasMoreElements()) {
            go = (GraphObject)en.nextElement();
            if (!go.getType().compareTo(t)) continue;
            try {
                this.destroyNode((Node)go, false, true);
            }
            catch (TypeException e) {
                System.out.println("Graph.destroyObjectsOfType : " + e.getMessage());
            }
        }
        return true;
    }

    public Vector destroyObjectsOfTypes(Vector types) {
        Vector<String> failed = new Vector<String>(5);
        for (int i = 0; i < types.size(); ++i) {
            Type t = (Type)types.get(i);
            if (this.destroyObjectsOfType(t)) continue;
            String s = "Graph:  " + this.getName() + "   Type:  " + t.getName();
            failed.add(s);
        }
        return failed;
    }

    public Enumeration getNodes() {
        return this.itsNodes.elements();
    }

    public Enumeration getArcs() {
        return this.itsArcs.elements();
    }

    public Vector<Arc> getArcs(GraphObject src, GraphObject tar) {
        Vector<Arc> res = new Vector<Arc>();
        Enumeration incoming = tar.getIncomingArcs();
        while (incoming.hasMoreElements()) {
            GraphObject go = (GraphObject)incoming.nextElement();
            if (((Arc)go).getSource() != src) continue;
            res.add((Arc)go);
        }
        return res;
    }

    public Vector<Arc> getArcs(Type t, GraphObject src, GraphObject tar) {
        Vector<Arc> res = new Vector<Arc>();
        Enumeration incoming = tar.getIncomingArcs();
        while (incoming.hasMoreElements()) {
            GraphObject go = (GraphObject)incoming.nextElement();
            if (((Arc)go).getSource() != src || !go.getType().compareTo(t)) continue;
            res.add((Arc)go);
        }
        return res;
    }

    public Enumeration getElements() {
        int i;
        Vector<Object> elems = new Vector<Object>();
        if (this.itsNodes != null) {
            for (i = 0; i < this.itsNodes.size(); ++i) {
                elems.addElement(this.itsNodes.at(i));
            }
        }
        if (this.itsArcs != null) {
            for (i = 0; i < this.itsArcs.size(); ++i) {
                elems.addElement(this.itsArcs.at(i));
            }
        }
        return elems.elements();
    }

    public Enumeration getElementsOfType(String typeName) {
        return this.getElementsOfTypeAsVector(typeName).elements();
    }

    public Vector getElementsOfTypeAsVector(String typeName) {
        GraphObject obj;
        int i;
        Vector<GraphObject> elems = new Vector<GraphObject>();
        for (i = 0; i < this.itsNodes.size(); ++i) {
            obj = (Node)this.itsNodes.at(i);
            if (!obj.getType().getName().equals(typeName)) continue;
            elems.addElement(obj);
        }
        if (!elems.isEmpty()) {
            return elems;
        }
        for (i = 0; i < this.itsArcs.size(); ++i) {
            obj = (Arc)this.itsArcs.at(i);
            if (!obj.getType().getName().equals(typeName)) continue;
            elems.addElement(obj);
        }
        return elems;
    }

    public Enumeration getElementsOfType(Type type) {
        return this.getElementsOfTypeAsVector(type).elements();
    }

    public Vector getElementsOfTypeAsVector(Type type) {
        GraphObject obj;
        int i;
        Vector<GraphObject> elems = new Vector<GraphObject>();
        for (i = 0; i < this.itsNodes.size(); ++i) {
            obj = (Node)this.itsNodes.at(i);
            if (!obj.getType().compareTo(type) && !obj.getType().isChildOf(type)) continue;
            elems.addElement(obj);
        }
        if (!elems.isEmpty()) {
            return elems;
        }
        for (i = 0; i < this.itsArcs.size(); ++i) {
            obj = (Arc)this.itsArcs.at(i);
            if (!obj.getType().compareTo(type)) continue;
            elems.addElement(obj);
        }
        return elems;
    }

    public Vector getElementsOfTypeAsVector(Type type, boolean parentOnly) {
        GraphObject obj;
        int i;
        Vector<GraphObject> elems = new Vector<GraphObject>();
        for (i = 0; i < this.itsNodes.size(); ++i) {
            obj = (Node)this.itsNodes.at(i);
            if (obj.getType().compareTo(type)) {
                elems.addElement(obj);
            }
            if (parentOnly || !obj.getType().isChildOf(type)) continue;
            elems.addElement(obj);
        }
        if (!elems.isEmpty()) {
            return elems;
        }
        for (i = 0; i < this.itsArcs.size(); ++i) {
            obj = (Arc)this.itsArcs.at(i);
            if (!obj.getType().compareTo(type)) continue;
            elems.addElement(obj);
        }
        return elems;
    }

    public Enumeration getElementsOfType(Type type, Type src, Type tar) {
        return this.getElementsOfTypeAsVector(type, src, tar).elements();
    }

    public Vector getElementsOfTypeAsVector(Type type, Type src, Type tar) {
        Vector<Arc> elems = new Vector<Arc>();
        for (int i = 0; i < this.itsArcs.size(); ++i) {
            Arc obj = (Arc)this.itsArcs.at(i);
            if (!obj.getType().compareTo(type) || !obj.getSource().getType().compareTo(src) && !obj.getSource().getType().isChildOf(src) || !obj.getTarget().getType().compareTo(tar) && !obj.getTarget().getType().isChildOf(tar)) continue;
            elems.addElement(obj);
        }
        return elems;
    }

    public Enumeration getElementsOfType(GraphObject type) {
        return this.getElementsOfTypeAsVector(type).elements();
    }

    public Vector getElementsOfTypeAsVector(GraphObject type) {
        Vector elems = new Vector();
        if (type.isNode() ? !(elems = this.getElementsOfTypeAsVector(type.getType())).isEmpty() : !(elems = this.getElementsOfTypeAsVector(type.getType(), ((Arc)type).getSource().getType(), ((Arc)type).getTarget().getType())).isEmpty()) {
            return elems;
        }
        return elems;
    }

    public void setAttrContext(AttrContext context) {
        this.itsAttrContext = context;
    }

    public AttrContext getAttrContext() {
        return this.itsAttrContext;
    }

    public final AttrManager getAttrManager() {
        return this.itsAttrManager;
    }

    protected final void propagateChange(Change ch) {
        this.setChanged();
        this.notifyObservers(ch);
    }

    public void addUsingMorph(OrdinaryMorphism m) {
        this.itsUsingMorphs.add(m);
    }

    public boolean removeUsingMorph(OrdinaryMorphism m) {
        if (this.itsUsingMorphs != null && this.itsUsingMorphs.contains(m)) {
            this.itsUsingMorphs.remove(m);
            return true;
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.itsNodes == null || this.itsNodes.isEmpty();
    }

    public boolean isElement(GraphObject obj) {
        boolean res = false;
        if (obj instanceof Node) {
            res = this.itsNodes.contains(obj);
        }
        if (obj instanceof Arc) {
            res = this.itsArcs.contains(obj);
        }
        return res;
    }

    public boolean isUsingType(GraphObject t) {
        if (t.isArc()) {
            Arc o;
            boolean hasTypeGraphArc = ((TypeImpl)t.getType()).hasTypeGraphArc(((Arc)t).getSource().getType(), ((Arc)t).getTarget().getType());
            Vector<Type> clan = this.itsTypes.getClan(t.getType());
            if (!hasTypeGraphArc && !clan.isEmpty()) {
                Type child;
                for (int i = 0; i < clan.size() && !(hasTypeGraphArc = ((TypeImpl)(child = clan.get(i))).hasTypeGraphArc(((Arc)t).getSource().getType(), ((Arc)t).getTarget().getType())); ++i) {
                }
            }
            if (hasTypeGraphArc) {
                Enumeration en = this.getArcs();
                while (en.hasMoreElements()) {
                    o = (Arc)en.nextElement();
                    if (!o.getType().compareTo(t.getType()) || !o.getSource().getType().compareTo(((Arc)t).getSource().getType()) && !o.getSource().getType().isChildOf(((Arc)t).getSource().getType()) || !o.getTarget().getType().compareTo(((Arc)t).getTarget().getType()) && !o.getTarget().getType().isChildOf(((Arc)t).getTarget().getType())) continue;
                    return true;
                }
            } else {
                Enumeration en = this.getArcs();
                while (en.hasMoreElements()) {
                    o = (Arc)en.nextElement();
                    if (!o.getType().compareTo(t.getType())) continue;
                    return true;
                }
            }
        } else {
            Enumeration en = this.getNodes();
            while (en.hasMoreElements()) {
                Node o = (Node)en.nextElement();
                if (o.getType().compareTo(t.getType())) {
                    return true;
                }
                if (!o.getType().isChildOf(t.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUsingType(Type t) {
        Enumeration en = this.getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            if (o.getType().compareTo(t)) {
                return true;
            }
            if (!o.getType().isChildOf(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingVariable(VarMember v) {
        ValueMember mem;
        int j;
        ValueTuple val;
        int i;
        for (i = 0; i < this.itsNodes.size(); ++i) {
            val = (ValueTuple)((Node)this.itsNodes.at(i)).getAttribute();
            for (j = 0; j < val.getSize(); ++j) {
                mem = val.getValueMemberAt(j);
                if (mem.getExpr() == null || !(mem.getExpr().isVariable() ? mem.getDeclaration().getTypeName().equals(v.getDeclaration().getTypeName()) && mem.getExprAsText().equals(v.getName()) : mem.getExpr().isComplex() && mem.getAllVariableNamesOfExpression().contains(v.getName()))) continue;
                return true;
            }
        }
        for (i = 0; i < this.itsArcs.size(); ++i) {
            val = (ValueTuple)((Arc)this.itsArcs.at(i)).getAttribute();
            for (j = 0; j < val.getSize(); ++j) {
                mem = val.getValueMemberAt(j);
                if (mem.getExpr() == null || !(mem.getExpr().isVariable() ? mem.getDeclaration().getTypeName().equals(v.getDeclaration().getTypeName()) && mem.getExprAsText().equals(v.getName()) : mem.getExpr().isComplex() && mem.getAllVariableNamesOfExpression().contains(v.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    public final void clear() {
        GraphObject o;
        int i;
        for (i = 0; i < this.itsNodes.size(); ++i) {
            o = (Node)this.itsNodes.at(i);
            try {
                this.destroyNode((Node)o);
                continue;
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        for (i = 0; i < this.itsArcs.size(); ++i) {
            o = (Arc)this.itsArcs.at(i);
            try {
                this.destroyArc((Arc)o);
                continue;
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        this.itsNodes.clear();
        this.itsArcs.clear();
        this.propagateChange(new Change(12, null));
    }

    public synchronized boolean glue(GraphObject keep, GraphObject glue) {
        Arc arc;
        if (keep.equals(glue)) {
            return true;
        }
        if (keep.isArc()) {
            this.glue(((Arc)keep).getSource(), ((Arc)glue).getSource());
            this.glue(((Arc)keep).getTarget(), ((Arc)glue).getTarget());
        }
        for (int i = 0; i < ((ValueTuple)keep.getAttribute()).getNumberOfEntries(); ++i) {
            ValueMember amKeep = ((ValueTuple)keep.getAttribute()).getValueMemberAt(i);
            ValueMember amGlue = ((ValueTuple)glue.getAttribute()).getValueMemberAt(i);
            if (!amKeep.isSet() || !amGlue.isSet() || amKeep.getExpr().isConstant() && amGlue.getExpr().isConstant() && !amKeep.getExprAsText().equals(amGlue.getExprAsText())) continue;
            if (!amKeep.isSet() || amKeep.getExpr().isVariable()) {
                if (!amGlue.isSet() || amGlue.getExpr().isConstant() || !amGlue.getExpr().isVariable()) continue;
                continue;
            }
            return false;
        }
        Enumeration anObjectIter = glue.getIncomingArcs();
        while (anObjectIter.hasMoreElements()) {
            arc = (Arc)anObjectIter.nextElement();
            if (this.itsTypes.checkIfRemovableFromTarget(arc) == null && this.itsTypes.checkIfEdgeCreatable(arc.getType(), (Node)arc.getSource(), (Node)keep) == null) {
                arc.setTarget((Node)keep);
                keep.addIn(arc);
                glue.removeIn(arc);
                continue;
            }
            return false;
        }
        anObjectIter = glue.getOutgoingArcs();
        while (anObjectIter.hasMoreElements()) {
            arc = (Arc)anObjectIter.nextElement();
            if (this.itsTypes.checkIfRemovableFromSource(arc) == null && this.itsTypes.checkIfEdgeCreatable(arc.getType(), (Node)keep, (Node)arc.getTarget()) == null) {
                arc.setSource((Node)keep);
                keep.addOut(arc);
                glue.removeOut(arc);
                continue;
            }
            return false;
        }
        for (int i = 0; i < ((ValueTuple)keep.getAttribute()).getNumberOfEntries(); ++i) {
            ValueMember amKeep = ((ValueTuple)keep.getAttribute()).getValueMemberAt(i);
            ValueMember amGlue = ((ValueTuple)glue.getAttribute()).getValueMemberAt(i);
            if (amKeep.isSet() && !amKeep.getExpr().isVariable() || !amGlue.isSet() || !amGlue.getExpr().isConstant()) continue;
            amKeep.setExprAsText(amGlue.getExprAsText());
        }
        this.propagateChange(new Change(13, new Pair(keep, glue)));
        try {
            this.destroyObject(glue);
            this.propagateChange(new Change(12, glue));
        }
        catch (TypeException e) {
            System.out.println(e.getMessage());
        }
        return true;
    }

    public boolean isReadyForTransform() {
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            ValueTuple value = (ValueTuple)o.getAttribute();
            for (int i = 0; i < value.getSize(); ++i) {
                ValueMember vm = value.getValueMemberAt(i);
                if (vm.isSet() && !vm.getExpr().isVariable()) continue;
                System.out.println("Graph.isReadyForTransform::  Type: " + o.getType().getName() + " ::  attr. member: " + vm.getName() + "  is not set!");
                return false;
            }
        }
        return true;
    }

    public boolean isReadyForTransform(Vector<GraphObject> storeOfFailedObjs) {
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            ValueTuple value = (ValueTuple)o.getAttribute();
            boolean failed = false;
            for (int i = 0; i < value.getSize(); ++i) {
                ValueMember vm = value.getValueMemberAt(i);
                if (vm.isSet() && !vm.getExpr().isVariable()) continue;
                failed = true;
                break;
            }
            if (!failed || storeOfFailedObjs == null) continue;
            storeOfFailedObjs.add(o);
        }
        return true;
    }

    public final SubGraph createSubGraph() {
        SubGraph aSubGraph = new SubGraph(this);
        this.itsSubGraphs.add(aSubGraph);
        return aSubGraph;
    }

    public final boolean destroySubGraph(SubGraph sg) {
        if (this.itsSubGraphs.contains(sg)) {
            this.itsSubGraphs.remove(sg);
            return true;
        }
        return false;
    }

    public final Enumeration getSubGraphs() {
        return this.itsSubGraphs.elements();
    }

    public boolean isIsomorphicWith(Graph g) {
        Enumeration myNodes = this.getNodes();
        Enumeration myArcs = this.getArcs();
        Enumeration gNodes = g.getNodes();
        Enumeration gArcs = g.getArcs();
        while (myNodes.hasMoreElements()) {
            if (gNodes.hasMoreElements()) {
                myNodes.nextElement();
                gNodes.nextElement();
                continue;
            }
            return false;
        }
        if (gNodes.hasMoreElements()) {
            return false;
        }
        while (myArcs.hasMoreElements()) {
            if (gArcs.hasMoreElements()) {
                myArcs.nextElement();
                gArcs.nextElement();
                continue;
            }
            return false;
        }
        if (gArcs.hasMoreElements()) {
            return false;
        }
        boolean result = false;
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        result = h.nextCompletion();
        h.dispose();
        h = null;
        return result;
    }

    public OrdinaryMorphism getIsomorphicWith(Graph g) {
        Enumeration myNodes = this.getNodes();
        Enumeration myArcs = this.getArcs();
        Enumeration gNodes = g.getNodes();
        Enumeration gArcs = g.getArcs();
        while (myNodes.hasMoreElements()) {
            if (gNodes.hasMoreElements()) {
                myNodes.nextElement();
                gNodes.nextElement();
                continue;
            }
            return null;
        }
        if (gNodes.hasMoreElements()) {
            return null;
        }
        while (myArcs.hasMoreElements()) {
            if (gArcs.hasMoreElements()) {
                myArcs.nextElement();
                gArcs.nextElement();
                continue;
            }
            return null;
        }
        if (gArcs.hasMoreElements()) {
            return null;
        }
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        if (h.nextCompletion()) {
            return h;
        }
        return null;
    }

    public Vector getIsomorphicWith(Graph g, Hashtable map) {
        Enumeration myNodes = this.getNodes();
        Enumeration myArcs = this.getArcs();
        Enumeration gNodes = g.getNodes();
        Enumeration gArcs = g.getArcs();
        while (myNodes.hasMoreElements()) {
            if (gNodes.hasMoreElements()) {
                myNodes.nextElement();
                gNodes.nextElement();
                continue;
            }
            return null;
        }
        if (gNodes.hasMoreElements()) {
            return null;
        }
        while (myArcs.hasMoreElements()) {
            if (gArcs.hasMoreElements()) {
                myArcs.nextElement();
                gArcs.nextElement();
                continue;
            }
            return null;
        }
        if (gArcs.hasMoreElements()) {
            return null;
        }
        Vector<OrdinaryMorphism> isos = new Vector<OrdinaryMorphism>(5);
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            GraphObject o = (GraphObject)keys.nextElement();
            GraphObject i = (GraphObject)map.get(o);
            try {
                h.addMapping(o, i);
            }
            catch (BadMappingException exc) {
                return null;
            }
        }
        while (h.nextCompletion()) {
            OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(this, g);
            Enumeration e = h.getDomain();
            while (e.hasMoreElements()) {
                GraphObject o = (GraphObject)e.nextElement();
                m.addMapping(o, h.getImage(o));
            }
            isos.add(m);
        }
        return isos;
    }

    public Vector getIsomorphicWith(Graph g, boolean all) {
        if (!all) {
            this.getIsomorphicWith(g);
        }
        Vector<OrdinaryMorphism> allIsos = new Vector<OrdinaryMorphism>(5);
        if (!all) {
            OrdinaryMorphism h = this.getIsomorphicWith(g);
            if (h != null) {
                allIsos.add(this.getIsomorphicWith(g));
            }
            return allIsos;
        }
        Enumeration myNodes = this.getNodes();
        Enumeration myArcs = this.getArcs();
        Enumeration gNodes = g.getNodes();
        Enumeration gArcs = g.getArcs();
        while (myNodes.hasMoreElements()) {
            if (gNodes.hasMoreElements()) {
                myNodes.nextElement();
                gNodes.nextElement();
                continue;
            }
            return null;
        }
        if (gNodes.hasMoreElements()) {
            return null;
        }
        while (myArcs.hasMoreElements()) {
            if (gArcs.hasMoreElements()) {
                myArcs.nextElement();
                gArcs.nextElement();
                continue;
            }
            return null;
        }
        if (gArcs.hasMoreElements()) {
            return null;
        }
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        while (h.nextCompletion()) {
            OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(this, g);
            Enumeration e = h.getDomain();
            while (e.hasMoreElements()) {
                GraphObject o = (GraphObject)e.nextElement();
                m.addMapping(o, h.getImage(o));
            }
            allIsos.add(m);
        }
        return allIsos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism isomorphicCopy() {
        Graph graph = this;
        synchronized (graph) {
            CopyMemory.RESET(2);
            return this.isoToCopy(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism isoToCopy(int n) {
        Graph graph = this;
        synchronized (graph) {
            boolean failed = false;
            Enumeration arcList = this.getArcs();
            Enumeration vtxList = this.getNodes();
            Graph theCopy = new Graph(this.getTypeSet());
            theCopy.setName(this.getName().concat("_copy"));
            OrdinaryMorphism iso = BaseFactory.theFactory().createMorphism(this, theCopy);
            iso.setName("IsoMorph");
            CopyMemory.INSTALL(n);
            int nm = 0;
            while (!failed && vtxList.hasMoreElements()) {
                Node vtxOrig = (Node)vtxList.nextElement();
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.createNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    try {
                        iso.addMapping(vtxOrig, vtxCopy);
                    }
                    catch (BadMappingException bme) {
                        failed = true;
                        CopyMemory.UNSET();
                        iso.dispose();
                        theCopy.dispose();
                        iso = null;
                        theCopy = null;
                    }
                    CopyMemory.STORE(vtxOrig, vtxCopy, n);
                    ++nm;
                }
                catch (TypeException e) {
                    failed = true;
                    CopyMemory.UNSET();
                    iso.dispose();
                    theCopy.dispose();
                    iso = null;
                    theCopy = null;
                }
            }
            nm = 0;
            while (!failed && arcList.hasMoreElements()) {
                Arc arcOrig = (Arc)arcList.nextElement();
                Node source = (Node)arcOrig.getSource();
                Node target = (Node)arcOrig.getTarget();
                Node srcImg = (Node)CopyMemory.SELECT(source, n);
                Node tgtImg = (Node)CopyMemory.SELECT(target, n);
                Arc arcCopy = null;
                if (srcImg == null || tgtImg == null) continue;
                try {
                    arcCopy = theCopy.createArc(arcOrig, srcImg, tgtImg);
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    try {
                        iso.addMapping(arcOrig, arcCopy);
                    }
                    catch (BadMappingException bme) {
                        failed = true;
                        CopyMemory.UNSET();
                        iso.dispose();
                        theCopy.dispose();
                        iso = null;
                        theCopy = null;
                    }
                    ++nm;
                }
                catch (TypeException e) {
                    failed = true;
                    CopyMemory.UNSET();
                    iso.dispose();
                    theCopy.dispose();
                    iso = null;
                    theCopy = null;
                }
            }
            CopyMemory.UNSET();
            return iso;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism reverseIsomorphicCopy() {
        Graph graph = this;
        synchronized (graph) {
            boolean failed = false;
            Enumeration arcList = this.getArcs();
            Enumeration vtxList = this.getNodes();
            Graph theCopy = new Graph(this.getTypeSet());
            theCopy.setName(this.getName().concat("_copy"));
            OrdinaryMorphism iso = BaseFactory.theFactory().createMorphism(theCopy, this);
            iso.setName("IsoMorph");
            CopyMemory.INSTALL(2);
            int nm = 0;
            while (vtxList.hasMoreElements()) {
                Node vtxOrig = (Node)vtxList.nextElement();
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.createNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    iso.addMapping(vtxCopy, vtxOrig);
                    CopyMemory.STORE(vtxOrig, vtxCopy, 2);
                    ++nm;
                }
                catch (TypeException e) {
                    failed = true;
                    iso.dispose();
                    theCopy.dispose();
                    iso = null;
                    theCopy = null;
                }
            }
            nm = 0;
            while (!failed && arcList.hasMoreElements()) {
                Arc arcOrig = (Arc)arcList.nextElement();
                Node source = (Node)arcOrig.getSource();
                Node target = (Node)arcOrig.getTarget();
                Node srcImg = (Node)CopyMemory.SELECT(source, 2);
                Node tgtImg = (Node)CopyMemory.SELECT(target, 2);
                Arc arcCopy = null;
                if (srcImg == null || tgtImg == null) continue;
                try {
                    arcCopy = theCopy.createArc(arcOrig, srcImg, tgtImg);
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    iso.addMapping(arcCopy, arcOrig);
                    ++nm;
                }
                catch (TypeException e) {
                    failed = true;
                    iso.dispose();
                    theCopy.dispose();
                    iso = null;
                    theCopy = null;
                }
            }
            CopyMemory.UNSET();
            return iso;
        }
    }

    public Enumeration overlapSet(Graph g, int memoNumber, boolean withIsomorphic) {
        return this.overlapSet(g, memoNumber, false, withIsomorphic);
    }

    public Enumeration overlapSet(Graph g, int memoNumber, boolean union, boolean withIsomorphic) {
        return this.overlapSet(g, -1, memoNumber, union, withIsomorphic);
    }

    public Enumeration overlapSet(Graph g, int sizeOfInclusions, int memoNumber, boolean union, boolean withIsomorphic) {
        Vector<Pair> oSet = new Vector<Pair>();
        Vector subs = new Vector();
        Enumeration itsGOs = this.getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        int size = 0;
        boolean nextMatch = true;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement((GraphObject)itsGOs.nextElement());
            ++size;
        }
        if (sizeOfInclusions == -1) {
            for (int i = minGraphSize; i <= size; ++i) {
                subs = this.generateAllSubgraphsWithInclusionsOfSize(i, itsGOSet, subs, withIsomorphic);
            }
        } else if (sizeOfInclusions >= minGraphSize) {
            subs = this.generateAllSubgraphsWithInclusionsOfSize(sizeOfInclusions, itsGOSet, subs, withIsomorphic);
        } else {
            return oSet.elements();
        }
        boolean injective = true;
        Completion_InjCSP strategy = new Completion_InjCSP();
        for (int i = 0; i < subs.size(); ++i) {
            OrdinaryMorphism h = (OrdinaryMorphism)subs.elementAt(i);
            Pair rulePair = BaseFactory.theFactory().constructIsomorphicRule(h);
            Rule r = (Rule)rulePair.first;
            OrdinaryMorphism tmpG = (OrdinaryMorphism)((Pair)rulePair.second).second;
            AttrContext ac = r.getAttrContext();
            AttrVariableTuple avt = ac.getVariables();
            AttrSession.logAttrInstance(AttrSession.logTrace, avt, "");
            AttrSession.logAttrContext(AttrSession.logTrace, ac, "Regelkontext");
            int co = 1;
            nextMatch = true;
            while (nextMatch) {
                OrdinaryMorphism rStar = g.isoToCopy(memoNumber);
                Match m = BaseFactory.theFactory().createMatch(r, rStar.getImage(), true);
                m.setCompletionStrategy(strategy);
                for (int k = 1; k <= co; ++k) {
                    nextMatch = m.nextCompletion();
                    Debug.printlnGraph(rStar.getImage(), "Arbeitsgraph rStar.getImage()", Debug.PARSING);
                    Debug.printlnMorph(h, "Morphismus fuer Regel", Debug.PARSING);
                    Debug.printlnMorph(m, "Match", Debug.PARSING);
                }
                if (nextMatch && m.isValid(true)) {
                    Step s = new Step();
                    try {
                        OrdinaryMorphism ms = (OrdinaryMorphism)s.execute(m, true);
                        if (ms != null) {
                            OrdinaryMorphism mStar = null;
                            tmpG.setCompletionStrategy(strategy);
                            mStar = tmpG.compose(ms);
                            if (mStar != null && rStar != null) {
                                Pair p = new Pair(mStar, rStar);
                                oSet.addElement(p);
                            }
                            BaseFactory.theFactory().destroyMorphism(ms);
                            ms = null;
                        }
                    }
                    catch (TypeException e) {
                        // empty catch block
                    }
                    ++co;
                } else {
                    nextMatch = false;
                }
                m.dispose();
                m = null;
            }
            subs.removeElement(h);
            --i;
            strategy.reset();
            strategy = null;
            OrdinaryMorphism h1 = (OrdinaryMorphism)((Pair)rulePair.second).first;
            OrdinaryMorphism h2 = (OrdinaryMorphism)((Pair)rulePair.second).second;
            Graph tmp1 = r.getSource();
            Graph tmp2 = r.getTarget();
            Graph tmp3 = h.getSource();
            h1.dispose();
            h2.dispose();
            r.dispose();
            h.dispose();
            tmpG.dispose();
            tmp1.dispose();
            tmp1 = null;
            tmp2.dispose();
            tmp2 = null;
            tmp3.dispose();
            tmp3 = null;
            r = null;
            h = null;
            h1 = null;
            h2 = null;
            tmpG = null;
            rulePair = null;
            System.gc();
        }
        return oSet.elements();
    }

    public Enumeration getOverlappings(Graph g, boolean withIsomorphic) {
        return this.getOverlappings(g, false, withIsomorphic);
    }

    public Enumeration getOverlappings(Graph g, boolean disjunion, boolean withIsomorphic) {
        return this.overlapSet(g, 2, disjunion, withIsomorphic);
    }

    public Enumeration getOverlappings(Graph g, int sizeOfInclusions, boolean withIsomorphic) {
        return this.overlapSet(g, sizeOfInclusions, 2, false, withIsomorphic);
    }

    public Enumeration getOverlappings(Graph g, int sizeOfInclusions, boolean disjunion, boolean withIsomorphic) {
        return this.overlapSet(g, sizeOfInclusions, 2, disjunion, withIsomorphic);
    }

    public final void showTree() {
        System.out.println("-" + this);
        Enumeration subgs = this.getSubGraphs();
        while (subgs.hasMoreElements()) {
            SubGraph sg = (SubGraph)subgs.nextElement();
            System.out.println("--" + sg + "  -->  " + sg.getSuperGraph());
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Graph", this);
        h.addAttr("name", this.getName());
        if (!this.info.equals("")) {
            h.addAttr("info", this.info);
        }
        h.addEnumeration("", this.getNodes(), true);
        h.addEnumeration("", this.getArcs(), true);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Graph", this)) {
            Type t;
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            this.info = h.readAttr("info");
            Enumeration en = h.getEnumeration("", null, true, "Node");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = (Type)h.getObject("type", null, false);
                if (t != null) {
                    Node n = null;
                    try {
                        n = this.createNode(t);
                        n = (Node)h.loadObject(n);
                    }
                    catch (TypeException e) {
                        e.printStackTrace();
                    }
                    if (this.isTypeGraph()) {
                        String m = h.readAttr("sourcemin");
                        try {
                            t.setSourceMin(Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMin(-1);
                        }
                        m = h.readAttr("sourcemax");
                        try {
                            t.setSourceMax(Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMax(-1);
                        }
                    }
                }
                h.close();
            }
            en = h.getEnumeration("", null, true, "Edge");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = (Type)h.getObject("type", null, false);
                Node n1 = (Node)h.getObject("source", null, false);
                Node n2 = (Node)h.getObject("target", null, false);
                if (t != null && n1 != null && n2 != null) {
                    try {
                        Arc a = this.createArc(t, n1, n2);
                        a = (Arc)h.loadObject(a);
                    }
                    catch (TypeException e) {
                        e.printStackTrace();
                    }
                    if (this.isTypeGraph()) {
                        Type sourceType = n1.getType();
                        Type targetType = n2.getType();
                        String m = h.readAttr("sourcemin");
                        try {
                            t.setSourceMin(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMin(sourceType, targetType, -1);
                        }
                        m = h.readAttr("sourcemax");
                        try {
                            t.setSourceMax(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMax(sourceType, targetType, -1);
                        }
                        m = h.readAttr("targetmin");
                        try {
                            t.setTargetMin(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setTargetMin(sourceType, targetType, -1);
                        }
                        m = h.readAttr("targetmax");
                        try {
                            t.setTargetMax(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setTargetMax(sourceType, targetType, -1);
                        }
                    }
                }
                h.close();
            }
            h.close();
            this.observer = new Vector();
        }
    }

    public String toString() {
        return this.showGraph();
    }

    public String showGraph() {
        Enumeration e;
        String result = this.getName();
        result = "\nGraph: " + this.getName() + " {\n";
        if (this.itsArcs != null) {
            e = this.getArcs();
            while (e.hasMoreElements()) {
                Arc arc = (Arc)e.nextElement();
                result = result + ((Node)arc.getSource()).toString() + arc.toString() + ((Node)arc.getTarget()).toString();
            }
        }
        if (this.isTypeGraph()) {
            Vector<Arc> inheritArcs = this.getTypeSet().getInheritanceArcs();
            Enumeration<Arc> e2 = inheritArcs.elements();
            while (e2.hasMoreElements()) {
                Arc arc = e2.nextElement();
                result = result + ((Node)arc.getSource()).toString() + "--inherits-->" + ((Node)arc.getTarget()).toString();
            }
        }
        if (this.itsNodes != null) {
            e = this.getNodes();
            while (e.hasMoreElements()) {
                Node node = (Node)e.nextElement();
                if (node.getIncomingArcs().hasMoreElements() || node.getOutgoingArcs().hasMoreElements()) continue;
                result = result + node.toString();
            }
        }
        result = result + " }\n";
        return result;
    }

    public String attributesToString() {
        String result = "\nGraph: " + this.getName() + " {\n";
        Enumeration e = this.getNodes();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            result = result + node.toString();
            result = result + this.attributeToString(node);
        }
        result = result + "\n}";
        return result;
    }

    public String attributeToString(GraphObject o) {
        return o.attributeToString();
    }

    public Vector generateAllSubgraphs(int sizeOfInclusions, boolean union, boolean withIsomorphic) {
        Vector subs = new Vector(0);
        Enumeration itsGOs = this.getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        int size = 0;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement((GraphObject)itsGOs.nextElement());
            ++size;
        }
        if (sizeOfInclusions == -1) {
            for (int i = minGraphSize; i <= size; ++i) {
                subs = this.generateAllSubgraphsWithInclusionsOfSize(i, itsGOSet, subs, withIsomorphic);
            }
        } else if (sizeOfInclusions >= minGraphSize) {
            subs = this.generateAllSubgraphsWithInclusionsOfSize(sizeOfInclusions, itsGOSet, subs, withIsomorphic);
        }
        return subs;
    }

    public Vector generateAllSubgraphsWithInclusionsOfSize(int i, Vector itsGOSet, Vector inclusions, boolean withIsomorphic) {
        String text = "Graph.generateAllSubgraphsWithInclusionsOfSize  " + i + "   itsGOSet.size:  " + itsGOSet.size() + "\n" + new Date().toString();
        Vector<Integer> select = new Vector<Integer>();
        if (i == 0) {
            return this.putInclusion(select, inclusions);
        }
        if (i <= itsGOSet.size()) {
            for (int j = 1; j <= i; ++j) {
                select.addElement(new Integer(j - 1));
            }
            this.computeSelection(1, itsGOSet, select, inclusions);
        }
        if (!withIsomorphic) {
            this.checkIsomorphicInclusions(inclusions);
        }
        text = "Graph.generateAllSubgraphsWithInclusionsOfSize :: returns\n\t  " + inclusions.size() + "  inclusions  of size " + i + "  from  " + itsGOSet.size() + "\n" + new Date().toString();
        return inclusions;
    }

    private Vector computeSelection(int s, Vector itsGOSet, Vector select, Vector inclusions) {
        int max = itsGOSet.size();
        int selSize = select.size();
        if (s <= selSize && s >= 1) {
            try {
                int v = (Integer)select.elementAt(s - 1);
                while (v < max - selSize + s) {
                    Vector goSet;
                    int tmp = max - selSize + s;
                    inclusions = this.computeSelection(s + 1, itsGOSet, select, inclusions);
                    if (s == selSize && this.isGraph(goSet = this.makeGraphObjectSet(select, itsGOSet))) {
                        inclusions = this.putInclusion(goSet, inclusions);
                    }
                    select.setElementAt(new Integer(v + 1), s - 1);
                    v = (Integer)select.elementAt(s - 1);
                }
                if (s > 1 && (v = ((Integer)select.elementAt(s - 2)).intValue()) < max - selSize + s + 1) {
                    select.setElementAt(new Integer(v + 1), s - 2);
                    for (int j = 1; j <= selSize - s + 1; ++j) {
                        select.setElementAt(new Integer(v + 1 + j), s + j - 2);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                System.out.println("ArrayIndexOutOfBounds Exception");
            }
        }
        return inclusions;
    }

    private Vector makeGraphObjectSet(Vector select, Vector itsGOSet) {
        Vector<GraphObject> tmp = new Vector<GraphObject>();
        for (int i = 1; i <= select.size(); ++i) {
            int v = (Integer)select.elementAt(i - 1);
            tmp.addElement((GraphObject)itsGOSet.elementAt(v));
        }
        return tmp;
    }

    public boolean isGraph(Vector goSet) {
        Object next;
        Graph g = new Graph(this.getTypeSet());
        Enumeration en = goSet.elements();
        HashMap newNodes = new HashMap();
        while (en.hasMoreElements()) {
            next = en.nextElement();
            if (!(next instanceof Node)) continue;
            try {
                newNodes.put(next, g.createNode((Node)next));
            }
            catch (TypeException e) {
                g.dispose();
                g = null;
                return false;
            }
        }
        en = goSet.elements();
        while (en.hasMoreElements()) {
            next = en.nextElement();
            if (!(next instanceof Arc)) continue;
            Node source = (Node)newNodes.get(((Arc)next).getSource());
            Node target = (Node)newNodes.get(((Arc)next).getTarget());
            if (source == null || target == null) {
                g.dispose();
                g = null;
                return false;
            }
            try {
                g.createArc((Arc)next, source, target);
            }
            catch (TypeException e) {
                g.dispose();
                g = null;
                return false;
            }
        }
        g.dispose();
        g = null;
        return true;
    }

    public boolean isTypeGraph() {
        if (this.itsTypes == null) {
            return false;
        }
        return this.equals(this.itsTypes.getTypeGraph());
    }

    public boolean isCompleteGraph() {
        return this.completeGraph;
    }

    public void setCompleteGraph(boolean isComplete) {
        this.completeGraph = isComplete;
    }

    public boolean isNacGraph() {
        return this.nacGraph;
    }

    public void setNacGraph(boolean isNAC) {
        this.nacGraph = isNAC;
    }

    public boolean compareTo(Graph g) {
        boolean result = true;
        OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(this, g);
        m.setCompletionStrategy(new Completion_InjCSP());
        if (m.nextCompletionWithConstantsChecking()) {
            GraphObject o;
            Enumeration e = g.getElements();
            while (result && e.hasMoreElements()) {
                o = (GraphObject)e.nextElement();
                if (m.getInverseImage(o).hasMoreElements()) continue;
                result = false;
            }
            e = this.getElements();
            while (result && e.hasMoreElements()) {
                GraphObject i;
                o = (GraphObject)e.nextElement();
                if (o.compareTo(i = m.getImage(o))) continue;
                result = false;
            }
        } else {
            result = false;
        }
        BaseFactory.theFactory().destroyMorphism(m);
        m = null;
        return result;
    }

    public boolean contains(Graph g) {
        boolean result = false;
        OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(g, this);
        while (m.nextCompletionWithConstantsChecking() && !result) {
            result = true;
            Enumeration e = g.getElements();
            while (result && e.hasMoreElements()) {
                GraphObject i;
                GraphObject o = (GraphObject)e.nextElement();
                if (o.compareTo(i = m.getImage(o))) continue;
                result = false;
            }
        }
        BaseFactory.theFactory().destroyMorphism(m);
        m = null;
        return result;
    }

    public int getSize() {
        return ((DList)this.itsNodes).size() + ((DList)this.itsArcs).size();
    }

    public int getSizeOfNodes() {
        return ((DList)this.itsNodes).size();
    }

    public int getSizeOfArcs() {
        return ((DList)this.itsArcs).size();
    }

    private Vector putInclusion(Vector goSet, Vector inclusions) {
        Node source = null;
        Node target = null;
        Graph subGraph = new Graph(this.getTypeSet());
        OrdinaryMorphism inclusion = BaseFactory.theFactory().createMorphism(subGraph, this);
        for (int i = 1; i <= goSet.size(); ++i) {
            Enumeration targets;
            GraphObject go = (GraphObject)goSet.elementAt(i - 1);
            if (go.isNode()) {
                Node n = null;
                try {
                    n = subGraph.createNode((Node)go);
                    n.setContextUsage(((Node)go).getContextUsage());
                }
                catch (TypeException e) {
                    e.printStackTrace();
                }
                try {
                    inclusion.addMapping(n, (Node)go);
                }
                catch (BadMappingException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Enumeration sources = inclusion.getInverseImage(((Arc)go).getSource());
            if (sources.hasMoreElements()) {
                source = (Node)sources.nextElement();
            }
            if ((targets = inclusion.getInverseImage(((Arc)go).getTarget())).hasMoreElements()) {
                target = (Node)targets.nextElement();
            }
            Arc a = null;
            try {
                a = subGraph.createArc((Arc)go, source, target);
                a.setContextUsage(((Arc)go).getContextUsage());
            }
            catch (TypeException e) {
                System.out.println(e);
                e.printStackTrace();
            }
            try {
                inclusion.addMapping(a, (Arc)go);
                continue;
            }
            catch (BadMappingException e) {
                e.printStackTrace();
            }
        }
        inclusions.addElement(inclusion);
        return inclusions;
    }

    public void checkIsomorphicInclusions(Vector inclusions) {
        int size = inclusions.size();
        for (int i = 0; i < size; ++i) {
            OrdinaryMorphism inclusion = (OrdinaryMorphism)inclusions.elementAt(i);
            for (int j = i + 1; j < size; ++j) {
                OrdinaryMorphism inc = (OrdinaryMorphism)inclusions.elementAt(j);
                if (!inclusion.getSource().isIsomorphicWith(inc.getSource())) continue;
                inclusions.removeElement(inc);
                --j;
                size = inclusions.size();
                BaseFactory.theFactory().destroyMorphism(inc);
                inc = null;
            }
        }
    }

    public Vector getVariableNamesOfAttributes() {
        Vector<String> result = new Vector<String>();
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            Vector vars = o.getVariableNamesOfAttribute();
            for (int j = 0; j < vars.size(); ++j) {
                String name = (String)vars.elementAt(j);
                if (result.contains(name)) continue;
                result.addElement(name);
            }
        }
        return result;
    }

    public Vector getSameVariablesOfAttributes() {
        AttrContext ac = this.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        Hashtable<VarMember, Boolean> used = new Hashtable<VarMember, Boolean>(avt.getSize());
        for (int i = 0; i < avt.getSize(); ++i) {
            VarMember var = avt.getVarMemberAt(i);
            used.put(var, new Boolean(false));
        }
        Vector<VarMember> result = new Vector<VarMember>();
        if (used.isEmpty()) {
            return result;
        }
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            for (int k = 0; k < vt.getSize(); ++k) {
                VarMember var;
                ValueMember vm = vt.getValueMemberAt(k);
                if (!vm.isSet() || !vm.getExpr().isVariable() || (var = avt.getVarMemberAt(vm.getExprAsText())).isInputParameter()) continue;
                if (!((Boolean)used.get(var)).booleanValue()) {
                    used.put(var, new Boolean(true));
                    continue;
                }
                if (result.contains(var)) continue;
                result.add(var);
            }
        }
        return result;
    }

    @Override
    public final Object execute(Object obj) {
        try {
            if (((GraphObject)obj).isNode()) {
                return this.createNode((Node)obj);
            }
            return this.createArc((Arc)obj, (Node)((Arc)obj).getSource(), (Node)((Arc)obj).getTarget());
        }
        catch (TypeException e) {
            System.out.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public void graphDidChange() {
        this.propagateChange(new Change(22));
    }

    public void unsetCriticalObjects() {
        GraphObject o;
        Enumeration e = this.getArcs();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            o.setCritical(false);
        }
        e = this.getNodes();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            o.setCritical(false);
        }
    }

    public void unsetTransientAttrValues() {
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            GraphObject obj = (GraphObject)e.nextElement();
            ValueTuple value = (ValueTuple)obj.getAttribute();
            for (int i = 0; i < value.getNumberOfEntries(); ++i) {
                ValueMember valuem = value.getValueMemberAt(i);
                if (!valuem.isTransient()) continue;
                valuem.setExpr(null);
            }
        }
    }

    public Vector<Hashtable> getPartialMorphismIntoSet(Vector<GraphObject> set) {
        if (set.isEmpty() || set.size() > this.getSize()) {
            return null;
        }
        System.out.println("Graph.getPartialMorphismIntoSet...");
        Vector<Hashtable> result = new Vector<Hashtable>();
        Hashtable<GraphObject, GraphObject> store = new Hashtable<GraphObject, GraphObject>();
        Graph g = new Graph(this.getTypeSet());
        for (int i = 0; i < set.size(); ++i) {
            GraphObject go = set.get(i);
            if (go.isNode()) {
                try {
                    Node n = g.createNode((Node)go);
                    store.put(n, go);
                }
                catch (TypeException e) {}
                continue;
            }
            try {
                Arc a = g.createArc((Arc)go, (Node)((Arc)go).getSource(), (Node)((Arc)go).getTarget());
                store.put(a, go);
                continue;
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        System.out.println("Graph from set - done,  size: " + g.getSize());
        OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(g, this);
        ((AttrTupleManager)m.getAttrManager()).setVariableContext(true);
        while (m.nextCompletion()) {
            System.out.println("next completion of m: g -> this - found");
            Hashtable table = new Hashtable();
            Enumeration en = m.getDomain();
            while (en.hasMoreElements()) {
                GraphObject obj = (GraphObject)en.nextElement();
                GraphObject img = m.getImage(obj);
                table.put(img, store.get(obj));
                System.out.println("add mapping to table - done,  size: " + table.size());
            }
            result.add(table);
        }
        System.out.println("result vector done,  size: " + result.size());
        return result;
    }
}

