/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.util.Change;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Graph;
import agg.xt_basis.Type;
import com.objectspace.jgl.DList;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Sequence;
import java.util.Enumeration;
import java.util.Vector;

public abstract class GraphObject
implements XMLObject,
AttrObserver {
    protected Graph itsContext;
    protected Type itsType;
    protected AttrInstance itsAttr;
    protected Sequence itsOutgoingArcs;
    protected Sequence itsIncomingArcs;
    protected GraphObject itsSource;
    protected GraphObject itsTarget;
    protected String itsContextUsage;
    protected boolean critical = false;
    protected int criticalKind;
    protected boolean visible = true;

    protected GraphObject(AttrInstance attr, Type type, GraphObject src, GraphObject tar, Graph context) {
        this.itsContext = context;
        this.itsContextUsage = Integer.toString(this.hashCode());
        this.itsType = type;
        this.itsAttr = attr;
        this.itsAttr.addObserver(this);
        this.itsOutgoingArcs = new DList();
        this.itsIncomingArcs = new DList();
        this.itsSource = src;
        this.itsTarget = tar;
        if (src != null && tar != null) {
            src.addOut(this);
            tar.addIn(this);
        }
    }

    protected void dispose() {
        this.itsAttr.removeObserver(this);
        ((ValueTuple)this.itsAttr).dispose();
        if (this.itsOutgoingArcs != null) {
            this.itsOutgoingArcs.clear();
        }
        if (this.itsIncomingArcs != null) {
            this.itsIncomingArcs.clear();
        }
        if (this.itsSource != null && this.itsTarget != null) {
            this.itsTarget.removeOut(this);
            this.itsSource.removeIn(this);
        }
    }

    protected void finalize() throws Throwable {
    }

    public final String getContextUsage() {
        return this.itsContextUsage;
    }

    public final void setContextUsage(String aContextUsage) {
        this.itsContextUsage = aContextUsage;
    }

    public final Graph getContext() {
        return this.itsContext;
    }

    public void setCritical(boolean b) {
        this.critical = b;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract boolean isArc();

    public abstract boolean isNode();

    public abstract boolean compareTo(GraphObject var1);

    public abstract void XwriteObject(XMLHelper var1);

    public abstract void XreadObject(XMLHelper var1);

    public final Type getType() {
        return this.itsType;
    }

    public final void setType(Type type) {
        this.itsType = type;
    }

    public final Enumeration getIncomingArcs() {
        return this.itsIncomingArcs.elements();
    }

    public final int getNumberOfIncomingArcs() {
        return this.itsIncomingArcs.size();
    }

    public Enumeration getOutgoingArcs() {
        return this.itsOutgoingArcs.elements();
    }

    public int getNumberOfOutgoingArcs() {
        return this.itsOutgoingArcs.size();
    }

    public int getNumberOfInOutArcs() {
        int nb = ((DList)this.itsIncomingArcs).size() + ((DList)this.itsOutgoingArcs).size();
        return nb;
    }

    protected final synchronized void addOut(GraphObject obj) {
        this.itsOutgoingArcs.add(obj);
    }

    protected final synchronized void addIn(GraphObject obj) {
        this.itsIncomingArcs.add(obj);
    }

    protected final synchronized void removeOut(GraphObject obj) {
        if (this.itsOutgoingArcs.contains(obj)) {
            this.itsOutgoingArcs.remove(obj);
        }
    }

    protected final synchronized void removeIn(GraphObject obj) {
        if (this.itsIncomingArcs.contains(obj)) {
            this.itsIncomingArcs.remove(obj);
        }
    }

    public final AttrInstance getAttribute() {
        return this.itsAttr;
    }

    public final Vector getVariableNamesOfAttribute() {
        return ((ValueTuple)this.itsAttr).getAllVariableNames();
    }

    public synchronized void copyAttributes(GraphObject orig) {
        this.getAttribute().copyEntries(orig.getAttribute());
    }

    public void attributeChanged(AttrEvent ev) {
        Pair p = new Pair(this, new Integer(ev.getID()));
        this.itsContext.propagateChange(new Change(11, p));
    }

    public String attributeToString() {
        String result = "\nAttributes of : " + this.getType().getName() + " {\n";
        for (int i = 0; i < this.itsAttr.getNumberOfEntries(); ++i) {
            ValueMember mem = (ValueMember)this.itsAttr.getMemberAt(i);
            result = result + "name: " + mem.getName() + "   value: " + mem.getExpr() + "\n";
        }
        result = result + " }\n";
        return result;
    }

    public boolean isPersistentFor(AttrTuple at) {
        return false;
    }
}

