/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.cons.AtomConstraint;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.Match;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.Type;
import agg.xt_basis.Version;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class LayeredGraTraImpl
extends GraTra {
    Random ran = new Random();
    private boolean appliedOnes;
    private boolean stopCurrentLayerOnly = false;
    private boolean stopLayer = false;
    private boolean nextLayerExists = true;
    private boolean layeredLoop = false;
    private Integer startLayer;
    private RuleLayer layer;
    private Hashtable invertedRuleLayer;
    private OrderedSet ruleLayer;
    private Integer currentLayer;
    private boolean startTransform = true;
    private boolean allRulesEnabled = false;
    private long time0;
    File f;
    FileOutputStream os;
    String protocolFileName = "";

    public void stop() {
        if (this.stopCurrentLayerOnly) {
            this.stopping = false;
            this.stopLayer = true;
        } else {
            this.stopping = true;
            this.stopLayer = false;
        }
    }

    public void nextLayer() {
        this.stopping = false;
        this.stopLayer = false;
        this.transformLayers(true);
    }

    public Pair derivation(Match m) {
        return null;
    }

    public boolean apply() {
        String s2;
        String s1;
        String s0;
        if (this.grammar == null) {
            return false;
        }
        if (!this.allRulesEnabled) {
            for (int j = 0; j < this.currentRuleSet.size(); ++j) {
                if (((Rule)this.currentRuleSet.elementAt(j)).isEnabled()) continue;
                this.currentRuleSet.removeElementAt(j);
                --j;
            }
            this.allRulesEnabled = true;
        }
        if (this.currentRuleSet.isEmpty()) {
            return false;
        }
        boolean applied = false;
        int i = 0;
        String trigger = "";
        this.currentRule = (Rule)this.currentRuleSet.elementAt(i);
        if (this.currentRule.isTriggerOfLayer()) {
            if (this.currentRule.isEnabled()) {
                trigger = "(trigger of layer)";
                applied = this.apply(this.currentRule);
                s0 = "";
                s1 = "";
                s2 = "";
                if (applied) {
                    this.appliedOnes = true;
                    if (!this.isGraphConsistent()) {
                        this.stopping = true;
                    }
                    this.currentRule.setEnabled(false);
                    this.currentRuleSet.removeElementAt(i);
                    s0 = this.currentRule.getName() + " " + trigger + " \t applied:  " + applied;
                    this.writeTransformProtocol(s0);
                } else {
                    s0 = this.currentRule.getName() + " " + trigger + " \t applied:  " + applied;
                    this.writeTransformProtocol(s0);
                    s1 = s1 + this.getErrorMsg();
                    this.writeTransformProtocol(s1);
                    this.currentRuleSet.removeAllElements();
                    s2 = "The trigger rule of the current layer is failed. \nContinue with the next layer.";
                    this.writeTransformProtocol(s2);
                }
                applied = false;
            } else {
                this.currentRuleSet.removeElement(this.currentRule);
            }
        }
        while (!this.stopping && !applied && this.currentRuleSet.size() > 0) {
            i = this.ran.nextInt(this.currentRuleSet.size());
            this.currentRule = (Rule)this.currentRuleSet.elementAt(i);
            applied = this.apply(this.currentRule);
            s0 = this.currentRule.getName() + " \t applied:  " + applied;
            this.writeTransformProtocol(s0);
            s1 = "";
            if (!applied) {
                s1 = s1 + this.getErrorMsg();
                this.writeTransformProtocol(s1);
                this.currentRuleSet.removeElementAt(i);
                s2 = this.getRuleNames(this.currentRuleSet);
                this.writeTransformProtocol(s2);
            } else {
                this.appliedOnes = true;
                if (!this.isGraphConsistent()) {
                    this.stopping = true;
                }
            }
            if (!this.stopLayer) continue;
            return false;
        }
        return applied;
    }

    public void transform(Vector ruleSet) {
        this.layer = new RuleLayer(ruleSet.elements());
        this.startLayer = this.layer.getStartLayer();
        this.invertedRuleLayer = this.layer.invertLayer();
        this.ruleLayer = new OrderedSet();
        Enumeration en = this.invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            this.ruleLayer.add(en.nextElement());
        }
        this.transformLayers(true);
    }

    private void transformLayers(boolean oneApplicable) {
        while (oneApplicable) {
            if (this.startTransform) {
                this.currentLayer = this.startLayer;
            }
            this.startTransform = false;
            oneApplicable = false;
            this.nextLayerExists = true;
            while (!this.stopping && this.nextLayerExists && this.currentLayer != null) {
                HashSet rulesForLayer = (HashSet)this.invertedRuleLayer.get(this.currentLayer);
                Vector<Rule> rules = new Vector<Rule>();
                Enumeration en = rulesForLayer.elements();
                while (en.hasMoreElements()) {
                    Rule rule = (Rule)en.nextElement();
                    if (rule.isTriggerOfLayer()) {
                        rules.add(0, rule);
                        continue;
                    }
                    rules.add(rule);
                }
                for (int j = 0; j < rules.size(); ++j) {
                    if (((Rule)rules.elementAt(j)).isEnabled()) continue;
                    rules.removeElementAt(j);
                    --j;
                }
                this.writeTransformProtocol("\n");
                this.writeTransformProtocol("Layer: " + this.currentLayer.toString());
                this.allRulesEnabled = true;
                boolean applicable = true;
                while (!this.stopping && applicable) {
                    String s = this.getRuleNames(rules);
                    this.writeTransformProtocol(s);
                    this.currentRuleSet = this.copyVector(rules);
                    applicable = this.apply();
                    if (!applicable) continue;
                    oneApplicable = true;
                }
                this.enableTriggerRuleOfLayer(rules);
                this.writeLayerToProtocol(this.time0);
                OrderedSetIterator osi = this.ruleLayer.find(this.currentLayer);
                if (osi == null || osi.atEnd()) {
                    this.nextLayerExists = false;
                } else {
                    osi.advance();
                    this.currentLayer = (Integer)osi.get();
                }
                if (this.nextLayerExists) {
                    this.fireGraTra(new GraTraEvent(this, 16));
                }
                if (!this.stopLayer) continue;
                break;
            }
            if (!this.nextLayerExists) {
                this.writeFinishToProtocol(this.time0);
            }
            if (this.layeredLoop) continue;
            break;
        }
    }

    public void transform() {
        String dirName = this.grammar.getDirName();
        String fileName = this.grammar.getFileName();
        if (fileName == null || fileName.equals("")) {
            fileName = this.grammar.getName();
        }
        this.openTransformProtocol(dirName, fileName);
        String version = "Version:  AGG " + Version.getID() + "\n";
        this.writeTransformProtocol(version);
        String s0 = "Layered graph transformation of : " + this.grammar.getName();
        String s1 = "on graph : " + this.grammar.getGraph().getName();
        String s2 = this.getRuleNames(this.currentRuleSet);
        this.writeTransformProtocol(s0);
        this.writeTransformProtocol(s1);
        this.writeTransformProtocol(s2);
        Pair pair = this.grammar.isReadyToTransform();
        Object test = null;
        if (pair != null) {
            test = pair.first;
        }
        if (test != null) {
            if (test instanceof Type) {
                s0 = (String)pair.second + "\nTransformation is stopped.";
                this.fireGraTra(new GraTraEvent((Object)this, 15, s0));
                System.out.println(s0);
                this.writeTransformProtocol(s0);
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            if (test instanceof Rule) {
                s0 = (String)pair.second + "\nTransformation is stopped.";
                this.fireGraTra(new GraTraEvent((Object)this, 9, s0));
                System.out.println(s0);
                this.writeTransformProtocol(s0);
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            if (test instanceof AtomConstraint) {
                s0 = (String)pair.second + "\nTransformation is stopped.";
                this.fireGraTra(new GraTraEvent((Object)this, 14, s0));
                System.out.println(s0);
                this.writeTransformProtocol(s0);
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
        } else if (!this.grammar.isGraphReadyForTransform()) {
            s0 = "Graph of the grammar is not fine.\nPlease check attribute settings of the objects. \nTransformation is stopped.";
            this.fireGraTra(new GraTraEvent((Object)this, 10, s0));
            System.out.println(s0);
            this.writeTransformProtocol(s0);
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return;
        }
        this.time0 = System.currentTimeMillis();
        this.transform(this.grammar.getRulesVec());
    }

    private void writeLayerToProtocol(long time) {
        long time1 = System.currentTimeMillis();
        long timeMillis = time1 - time;
        long time_sec = timeMillis / 1000L;
        long msec = timeMillis - time_sec * 1000L;
        long time_min = time_sec / 60L;
        long sec = time_sec - time_min * 60L;
        long hour = time_min / 60L;
        long min = time_min - hour * 60L;
        System.out.println("Used time for layer " + this.currentLayer + " : " + hour + "h " + min + "m " + sec + "s " + msec + "ms");
        this.writeTransformProtocol("\nUsed time for layer " + this.currentLayer + " : " + hour + "h " + min + "m " + sec + "s " + msec + "ms");
        this.time0 = time1;
    }

    private void writeFinishToProtocol(long time0) {
        this.writeTransformProtocol("\nNo more layer.\nGraph transformation is finished");
        this.fireGraTra(new GraTraEvent(this, 5));
        this.closeTransformProtocol();
    }

    public void setLayeredLoop(boolean b) {
        this.layeredLoop = b;
    }

    public void setStopCurrentLayerOnly(boolean b) {
        this.stopCurrentLayerOnly = b;
    }

    public boolean didTransformation() {
        return this.appliedOnes;
    }

    public String getProtocolName() {
        return this.protocolFileName;
    }

    private Vector copyVector(Vector v) {
        Vector<Rule> out = new Vector<Rule>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            out.add((Rule)v.get(i));
        }
        return out;
    }

    private void enableTriggerRuleOfLayer(Vector rules) {
        for (int j = 0; j < rules.size(); ++j) {
            Rule r = (Rule)rules.elementAt(j);
            if (!r.isTriggerOfLayer()) continue;
            r.setEnabled(true);
            break;
        }
    }

    private String getRuleNames(Vector rules) {
        String names = "[ ";
        for (int j = 0; j < rules.size(); ++j) {
            Rule r = (Rule)rules.elementAt(j);
            names = names + r.getName() + " ";
        }
        names = names + "]";
        return names;
    }

    private void openTransformProtocol(String dirName, String fileName) {
        String fName = "LayeredGraTra.log";
        if (fileName != null && !fileName.equals("")) {
            fName = fileName.endsWith(".ggx") ? fileName.substring(0, fileName.length() - 4) + "_GraTra.log" : fileName + "_GraTra.log";
        }
        if (dirName != null && !dirName.equals("")) {
            this.f = new File(dirName);
            dirName = this.f.exists() ? (this.f.isFile() ? (this.f.getParent() != null ? this.f.getParent() + File.separator : "." + File.separator) : (this.f.isDirectory() ? this.f.getPath() + File.separator : "." + File.separator)) : "." + File.separator;
            this.f = new File(dirName + fName);
        } else {
            this.f = new File(fName);
        }
        try {
            this.os = new FileOutputStream(this.f);
            this.protocolFileName = this.f.getName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.writeTransformProtocol(new Date().toString());
    }

    private void writeTransformProtocol(String s) {
        if (this.os == null) {
            return;
        }
        if (!this.os.getChannel().isOpen()) {
            return;
        }
        try {
            if (!s.equals("\n")) {
                this.os.write(s.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void closeTransformProtocol() {
        if (this.os == null) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

