/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomApplConstraint;
import agg.cons.EvalSet;
import agg.cons.Formula;
import agg.util.Debug;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.NACStarMorphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.SubGraGra;
import agg.xt_basis.SubGraph;
import agg.xt_basis.SubMatch;
import agg.xt_basis.SubRule;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.Pair;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class Match
extends OrdinaryMorphism
implements XMLObject {
    private Rule itsRule;
    private transient OrdinaryMorphism itsCurrentNACstar;
    private Vector itsSubMatches = new Vector(1, 2);
    protected transient String errorMsg;
    private transient boolean nacsValid = true;
    private transient boolean globalNAC;

    protected Match() {
    }

    protected Match(Rule rule, Graph graph) {
        super(rule.getLeft(), graph);
        this.setAttrContext(this.getAttrManager().newContext(1, rule.getAttrContext()));
        this.itsRule = rule;
        String name = "MatchOf_" + rule.getName();
        this.setName(name);
        this.errorMsg = null;
        this.errors = new Vector(5);
    }

    public final Rule getRule() {
        return this.itsRule;
    }

    public String getErrorMsg() {
        String error0 = super.getErrorMsg();
        if (this.errors.size() >= 2) {
            error0 = this.errors.elementAt(this.errors.size() - 2) + "\n" + this.errors.elementAt(this.errors.size() - 1);
        }
        if (this.errorMsg == null) {
            return "[ " + error0 + " ]";
        }
        if (this.errorMsg != null && !this.errorMsg.equals("")) {
            return "[ " + this.errorMsg + " ]";
        }
        if (error0 != null && !error0.equals("")) {
            return "[ " + error0 + " ]";
        }
        return "";
    }

    public void clearErrorMsg() {
        super.clearErrorMsg();
        this.errorMsg = "";
    }

    public boolean isReadyToTransform() {
        AttrContext ac = this.getAttrContext();
        AttrVariableTuple avt = ac.getVariables();
        AttrConditionTuple act = ac.getConditions();
        Vector names = avt.getVariableNames();
        Vector vars = this.getVariableDeclarations();
        for (int i = 0; i < vars.size(); ++i) {
            Pair p = (Pair)vars.elementAt(i);
            String n = (String)p.second;
            if (!names.contains(n)) {
                String className = this.isClassName(n);
                if (className != null) continue;
                this.errorMsg = "Variable:  " + n + "  is not declared!";
                this.errors.add(this.errorMsg);
                return false;
            }
            String t = (String)p.first;
            VarMember vm = avt.getVarMemberAt(n);
            String t_vm = vm.getDeclaration().getTypeName();
            if (t.equals(t_vm)) continue;
            this.errorMsg = "The type of the variable: " + n + "  is wrong!";
            this.errors.add(this.errorMsg);
            return false;
        }
        try {
            ac.getVariables().getAttrManager().checkIfReadyToTransform(ac);
        }
        catch (AttrException ex) {
            this.errorMsg = ex.getLocalizedMessage();
            this.errors.add(this.errorMsg);
            return false;
        }
        return true;
    }

    public final boolean isValid() {
        return this.isValid(false);
    }

    public final boolean isValid(boolean allowVariables) {
        if (!this.satisfiesIdentification()) {
            this.errorMsg = "Identification condition is violated!";
            this.errors.add(this.errorMsg);
            return false;
        }
        if (!this.satisfiesDangling()) {
            this.errorMsg = "Dangling condition is violated!";
            this.errors.add(this.errorMsg);
            return false;
        }
        if (!this.isGlueAllowed()) {
            this.errorMsg = "Non-injective match failed. Glueing objects mismatch: \n" + this.errorMsg;
            this.errors.add(this.errorMsg);
            return false;
        }
        if (!this.checkVariableToNullMappping()) {
            return false;
        }
        boolean result = true;
        int typeLevel = this.getImage().getTypeSet().getLevelOfTypeGraphCheck();
        if (typeLevel > 0 || !this.getRule().getConstraints().isEmpty()) {
            BaseFactory bf = BaseFactory.theFactory();
            OrdinaryMorphism copy = this.getImage().isoToCopy(2);
            copy.getImage().setCompleteGraph(this.getImage().isCompleteGraph());
            OrdinaryMorphism com = this.compose(copy);
            Match m2 = bf.makeMatch(this.getRule(), com);
            OrdinaryMorphism comatch = null;
            if (m2 != null) {
                comatch = this.makeTestStep(m2, true);
            }
            result = comatch == null ? false : result && this.isConsistent(comatch, m2);
            bf.destroyMorphism(comatch);
            comatch = null;
            bf.destroyMatch(m2);
            m2 = null;
            bf.destroyMorphism(com);
            com = null;
            copy.dispose(false, true);
            copy = null;
        }
        if (result) {
            this.clearErrorMsg();
        }
        return result;
    }

    public final boolean isWeakValid(boolean allowVariables) {
        if (!this.satisfiesIdentification()) {
            this.errorMsg = "Identification condition is violated!";
            this.errors.add(this.errorMsg);
            return false;
        }
        if (!this.satisfiesDangling()) {
            this.errorMsg = "Dangling condition is violated!";
            this.errors.add(this.errorMsg);
            return false;
        }
        if (!this.isGlueAllowed()) {
            this.errorMsg = "During non-injective matching glue objects mismatch occured : \n" + this.errorMsg;
            this.errors.add(this.errorMsg);
            return false;
        }
        return true;
    }

    public boolean areNACsSatisfied() {
        this.nacsValid = true;
        if (this.getCompletionStrategy().getProperties().get(3)) {
            Enumeration allNACs = this.itsRule.getNACs();
            this.globalNAC = false;
            while (allNACs.hasMoreElements()) {
                OrdinaryMorphism aNAC = (OrdinaryMorphism)allNACs.nextElement();
                if (!aNAC.isEnabled()) continue;
                if (aNAC.getSize() == 0) {
                    this.globalNAC = true;
                }
                if (this.checkNAC(aNAC) == null) continue;
                this.errorMsg = "NAC  \"" + aNAC.getName() + "\"  is violated!";
                this.nacsValid = false;
                this.errors.add(this.errorMsg);
                return false;
            }
        }
        return true;
    }

    public boolean areNACsSatisfied(boolean withVars) {
        this.nacsValid = true;
        if (withVars) {
            if (this.getCompletionStrategy().getProperties().get(3)) {
                Enumeration allNACs = this.itsRule.getNACs();
                this.globalNAC = false;
                while (allNACs.hasMoreElements()) {
                    OrdinaryMorphism nacMorph;
                    OrdinaryMorphism aNAC = (OrdinaryMorphism)allNACs.nextElement();
                    if (!aNAC.isEnabled()) continue;
                    if (aNAC.getSize() == 0) {
                        this.globalNAC = true;
                    }
                    if ((nacMorph = (OrdinaryMorphism)this.checkNAC(aNAC, true)) == null) continue;
                    this.errorMsg = "NAC  \"" + aNAC.getName() + "\"  is violated!";
                    this.nacsValid = false;
                    this.errors.add(this.errorMsg);
                    return false;
                }
            }
            return true;
        }
        return this.areNACsSatisfied();
    }

    public final Morphism checkNAC(OrdinaryMorphism nac) {
        this.nacsValid = true;
        this.destroyNACstar(this.itsCurrentNACstar);
        this.itsCurrentNACstar = this.createNACstar(nac);
        Morphism m = this.checkNACstar(this.itsCurrentNACstar, nac, false);
        if (m != null) {
            this.nacsValid = false;
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  is violated!";
            this.errors.add(this.errorMsg);
        }
        return m;
    }

    public final Morphism checkNAC(OrdinaryMorphism nac, boolean withVars) {
        this.nacsValid = true;
        this.destroyNACstar(this.itsCurrentNACstar);
        if (withVars) {
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(true);
        }
        this.itsCurrentNACstar = this.createNACstar(nac, withVars);
        Morphism m = this.checkNACstar(this.itsCurrentNACstar, nac, withVars);
        if (withVars) {
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        }
        if (m != null) {
            this.nacsValid = false;
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  is violated!";
            this.errors.add(this.errorMsg);
        }
        return m;
    }

    private final OrdinaryMorphism createNACstar(OrdinaryMorphism nac) {
        NACStarMorphism aNACstar = new NACStarMorphism(nac.getImage(), this.getImage(), this.getAttrManager().newContext(1, this.getAttrContext()));
        aNACstar.itsNAC = nac;
        aNACstar.setName("NACstar");
        aNACstar.setCompletionStrategy(new Completion_InjCSP());
        return aNACstar;
    }

    private final OrdinaryMorphism createNACstar(OrdinaryMorphism nac, boolean withVars) {
        if (withVars) {
            ContextView attrcontxt = (ContextView)this.getAttrManager().newContext(0, this.getAttrContext());
            attrcontxt.setVariableContext(true);
            ((ContextView)((CondTuple)attrcontxt.getConditions()).getContext()).setVariableContext(true);
            NACStarMorphism aNACstar = new NACStarMorphism(nac.getImage(), this.getImage(), attrcontxt);
            aNACstar.itsNAC = nac;
            aNACstar.setName("NACstar");
            aNACstar.setCompletionStrategy(new Completion_InjCSP());
            return aNACstar;
        }
        return this.createNACstar(nac);
    }

    private final void destroyNACstar(OrdinaryMorphism nacstar) {
        if (nacstar != null) {
            nacstar.dispose();
        }
    }

    private final Morphism checkNACstar(OrdinaryMorphism aNACstar, OrdinaryMorphism nac, boolean withVars) {
        GraphObject nacStarObj;
        GraphObject nacObj;
        GraphObject leftObj;
        Debug.DEBUG = false;
        Debug.println("checkNACstar::", this);
        Enumeration aNACDomain = nac.getDomain();
        try {
            while (aNACDomain.hasMoreElements()) {
                leftObj = (GraphObject)aNACDomain.nextElement();
                Debug.println("\t" + leftObj.toString(), this);
                if (!leftObj.isNode()) continue;
                nacObj = nac.getImage(leftObj);
                Debug.println("\t" + nacObj.toString(), this);
                Debug.println("Trying to map these two objects:", this);
                nacStarObj = aNACstar.getImage(nacObj);
                if (nacStarObj == null) {
                    aNACstar.addMapping(nacObj, this.getImage(leftObj));
                    if (aNACstar.getImage(nacObj) != null) continue;
                    return null;
                }
                if (nacStarObj.equals(this.getImage(leftObj))) continue;
                Debug.println("Mapping (not the same!) already exists! NACstar FAILED!", this);
                Debug.DEBUG = false;
                return null;
            }
        }
        catch (BadMappingException exc) {
            Debug.println("BadMapping: " + exc.getMessage(), this);
            Debug.DEBUG = false;
            return null;
        }
        aNACDomain = nac.getDomain();
        try {
            while (aNACDomain.hasMoreElements()) {
                leftObj = (GraphObject)aNACDomain.nextElement();
                Debug.println("\t" + leftObj.toString(), this);
                if (!leftObj.isArc()) continue;
                nacObj = nac.getImage(leftObj);
                Debug.println("Trying to map these two objects:", this);
                Debug.println("\t" + nacObj.toString(), this);
                Debug.println("Trying to map these two objects:", this);
                nacStarObj = aNACstar.getImage(nacObj);
                if (nacStarObj == null) {
                    aNACstar.addMapping(nacObj, this.getImage(leftObj));
                    if (aNACstar.getImage(nacObj) != null) continue;
                    return null;
                }
                if (nacStarObj.equals(this.getImage(leftObj))) continue;
                Debug.println("Mapping (not the same!) already exists! aNACstar FAILED!", this);
                Debug.DEBUG = false;
                return null;
            }
        }
        catch (BadMappingException exc) {
            Debug.println("BadMapping: " + exc.getMessage(), this);
            Debug.DEBUG = false;
            return null;
        }
        Debug.println("Commuting nacstar found!", this);
        Debug.println("My strategy is " + this.getCompletionStrategy(), this);
        Debug.println("aNACstar strategy is " + aNACstar.getCompletionStrategy(), this);
        Debug.println("aNACstar of  " + nac.getName(), this);
        Debug.println("aNACstar mapping size: " + aNACstar.getSize(), this);
        OrdinaryMorphism result = null;
        result = !withVars ? this.makeNACstarCompletion(aNACstar, nac) : this.makeNACstarCompletionWithVars(aNACstar, nac);
        Debug.println("aNACstar result:  " + result, this);
        return result;
    }

    private boolean checkNACStarCodomain(OrdinaryMorphism aNACstar, OrdinaryMorphism nac) {
        Enumeration e = aNACstar.getSource().getElements();
        while (e.hasMoreElements()) {
            GraphObject nacObj = (GraphObject)e.nextElement();
            if (nac.getInverseImage(nacObj).hasMoreElements()) {
                GraphObject graphObj;
                GraphObject leftObj = (GraphObject)nac.getInverseImage(nacObj).nextElement();
                GraphObject nacStarObj = aNACstar.getImage(nacObj);
                if (nacStarObj == (graphObj = this.getImage(leftObj))) continue;
                return false;
            }
            GraphObject nacStarObj = aNACstar.getImage(nacObj);
            if (!this.getInverseImage(nacStarObj).hasMoreElements()) continue;
            return false;
        }
        return true;
    }

    private boolean checkNACStarVariables(OrdinaryMorphism aNACstar, OrdinaryMorphism nac) {
        Enumeration e = nac.getTarget().getElements();
        while (e.hasMoreElements()) {
            GraphObject nacObj = (GraphObject)e.nextElement();
            if (nac.getInverseImage(nacObj).hasMoreElements()) continue;
            GraphObject nacStarObj = aNACstar.getImage(nacObj);
            ValueTuple valNacObj = (ValueTuple)nacObj.getAttribute();
            ValueTuple valNacStarObj = (ValueTuple)nacStarObj.getAttribute();
            for (int i = 0; i < valNacObj.getSize(); ++i) {
                ValueMember memNacObj = valNacObj.getValueMemberAt(i);
                ValueMember memNacStarObj = valNacStarObj.getValueMemberAt(i);
                if (!memNacObj.isSet() || !memNacObj.getExpr().isVariable()) continue;
                Enumeration e1 = this.getDomain();
                while (e1.hasMoreElements()) {
                    GraphObject imgObj;
                    ValueTuple valImgObj;
                    ValueMember memImgObj;
                    GraphObject leftObj = (GraphObject)e1.nextElement();
                    ValueTuple valLeftObj = (ValueTuple)leftObj.getAttribute();
                    ValueMember memLeftObj = valLeftObj.getValueMemberAt(i);
                    if (memLeftObj == null || !memLeftObj.isSet() || !memLeftObj.getExpr().isVariable() || !memNacObj.getExprAsText().equals(memLeftObj.getExprAsText()) || (memImgObj = (valImgObj = (ValueTuple)(imgObj = this.getImage(leftObj)).getAttribute()).getValueMemberAt(i)).isSet() && memImgObj.getExpr().isVariable() && memNacStarObj.isSet() && memImgObj.getExprAsText().equals(memNacStarObj.getExprAsText())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private OrdinaryMorphism makeNACstarCompletion(OrdinaryMorphism NACstar, OrdinaryMorphism nac) {
        this.errorMsg = "";
        OrdinaryMorphism result = null;
        this.globalNAC = nac.getSize() <= 0;
        while (NACstar.nextCompletion()) {
            if (!this.checkNACStarCodomain(NACstar, nac)) {
                this.unsetVariablesOfNAC((VarTuple)this.getAttrContext().getVariables());
                this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
                continue;
            }
            result = NACstar;
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  failed.";
            CondTuple condTuple = (CondTuple)this.getAttrContext().getConditions();
            if (condTuple.getSize() == 0) {
                this.unsetVariablesOfNAC((VarTuple)this.getAttrContext().getVariables());
                this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
                this.errors.add(this.errorMsg);
                return result;
            }
            Vector condsNAC = this.getConditionsOfNAC(NACstar, nac);
            if (condsNAC.size() == 0) {
                this.unsetVariablesOfNAC((VarTuple)this.getAttrContext().getVariables());
                this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
                return result;
            }
            boolean nacCondTrue = false;
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  is  failed.";
            for (int k = 0; k < condsNAC.size(); ++k) {
                CondMember cm = (CondMember)condsNAC.elementAt(k);
                if (cm.areVariablesSet()) {
                    if (cm.isTrue()) {
                        nacCondTrue = true;
                        this.errorMsg = this.errorMsg + "\n(Attribute condition  [ " + cm.getExprAsText() + " ]  is satisfied.)";
                        this.errors.add(this.errorMsg);
                        continue;
                    }
                    nacCondTrue = false;
                    break;
                }
                nacCondTrue = true;
            }
            if (nacCondTrue) break;
            result = null;
            this.errorMsg = "";
            this.unsetVariablesOfNAC((VarTuple)this.getAttrContext().getVariables());
            this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
        }
        this.unsetVariablesOfNAC((VarTuple)this.getAttrContext().getVariables());
        this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
        return result;
    }

    private Vector getConditionsOfNAC(OrdinaryMorphism currentNACstar, OrdinaryMorphism currentNac) {
        Vector<CondMember> condsNAC = new Vector<CondMember>();
        CondTuple ct = (CondTuple)currentNACstar.getAttrContext().getConditions();
        VarTuple vt = (VarTuple)currentNACstar.getAttrContext().getVariables();
        if (vt.getSize() > 0) {
            int k;
            for (int k2 = 0; k2 < vt.getSize(); ++k2) {
                VarMember vm = vt.getVarMemberAt(k2);
                if (vm.getMark() != 2) continue;
                Enumeration e = currentNACstar.getOriginal().getElements();
                while (e.hasMoreElements()) {
                    GraphObject o = (GraphObject)e.nextElement();
                    ValueTuple value = (ValueTuple)o.getAttribute();
                    Vector v = o.getVariableNamesOfAttribute();
                    if (!v.contains(vm.getName())) continue;
                    GraphObject img = currentNACstar.getImage(o);
                    ValueTuple valueImg = (ValueTuple)img.getAttribute();
                    for (int n = 0; n < value.getSize(); ++n) {
                        ValueMember valm = value.getValueMemberAt(n);
                        if (!valm.isSet() || !valm.getExprAsText().equals(vm.getName())) continue;
                        ValueMember valmImg = valueImg.getValueMemberAt(n);
                        vm.setExprAsText(valmImg.getExprAsText());
                    }
                }
            }
            Vector varNames = currentNac.getImage().getVariableNamesOfAttributes();
            Vector<VarMember> varsOfNAC = new Vector<VarMember>();
            for (k = 0; k < vt.getSize(); ++k) {
                VarMember vm = vt.getVarMemberAt(k);
                if (!varNames.contains(vm.getName()) || varsOfNAC.contains(vm)) continue;
                varsOfNAC.addElement(vm);
            }
            for (k = 0; k < ct.getSize(); ++k) {
                CondMember cm = ct.getCondMemberAt(k);
                Vector condVars = cm.getAllVariables();
                for (int l = 0; l < varsOfNAC.size(); ++l) {
                    VarMember vm = (VarMember)varsOfNAC.elementAt(l);
                    if (cm.getMark() != 2 && cm.getMark() != 3 || !condVars.contains(vm.getName()) || condsNAC.contains(cm)) continue;
                    condsNAC.addElement(cm);
                }
            }
        }
        return condsNAC;
    }

    private OrdinaryMorphism makeNACstarCompletionWithVars(OrdinaryMorphism NACstar, OrdinaryMorphism nac) {
        this.errorMsg = "";
        OrdinaryMorphism result = null;
        this.globalNAC = nac.getSize() <= 0;
        while (NACstar.nextCompletion()) {
            if (!this.checkNACStarCodomain(NACstar, nac)) {
                this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
                continue;
            }
            result = NACstar;
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  failed.";
            CondTuple condTuple = (CondTuple)this.getAttrContext().getConditions();
            if (condTuple.getSize() == 0) {
                this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
                return result;
            }
            Vector condsNAC = this.getConditionsOfNAC(NACstar, nac);
            if (condsNAC.size() == 0) {
                this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
                return result;
            }
            boolean nacCondTrue = false;
            this.errorMsg = "NAC  \"" + nac.getName() + "\"  is  failed.";
            for (int k = 0; k < condsNAC.size(); ++k) {
                CondMember cm = (CondMember)condsNAC.elementAt(k);
                if (cm.areVariablesSet()) {
                    if (cm.isTrue()) {
                        nacCondTrue = true;
                        this.errorMsg = this.errorMsg + "\n(Attribute condition  [ " + cm.getExprAsText() + " ]  is satisfied.)";
                        continue;
                    }
                    nacCondTrue = false;
                    break;
                }
                nacCondTrue = true;
            }
            if (nacCondTrue) break;
            result = null;
            this.errorMsg = "";
            this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
        }
        this.unsetVariablesOfNAC((VarTuple)NACstar.getAttrContext().getVariables());
        return result;
    }

    private void unsetVariablesOfNAC(VarTuple vars) {
        for (int i = 0; i < vars.getSize(); ++i) {
            VarMember vm = vars.getVarMemberAt(i);
            if (vm.getMark() != 2 || vm.isInputParameter()) continue;
            while (vm.getReferenceCount() > 0) {
                vm.undoUnification();
            }
            vm.setExpr(null);
        }
    }

    public boolean satisfiesAttrConditions() {
        CondTuple ct = (CondTuple)this.getAttrContext().getConditions();
        for (int k = 0; k < ct.getSize(); ++k) {
            CondMember cm = ct.getCondMemberAt(k);
            if (cm.getMark() == 2 || cm.getMark() == 3 || cm.isTrue()) continue;
            return false;
        }
        return true;
    }

    private boolean satisfiesIdentification() {
        if (!this.getCompletionStrategy().getProperties().get(0) && this.getCompletionStrategy().getProperties().get(2)) {
            GraphObject xxImg;
            GraphObject xx;
            boolean conserve;
            int k;
            Enumeration en;
            GraphObject x;
            Graph leftSide = this.itsRule.getOriginal();
            Enumeration objects = leftSide.getNodes();
            Vector<GraphObject> v = new Vector<GraphObject>();
            while (objects.hasMoreElements()) {
                GraphObject x2 = (GraphObject)objects.nextElement();
                v.addElement(x2);
            }
            for (int i = 0; i < v.size(); ++i) {
                x = (GraphObject)v.elementAt(i);
                en = this.getInverseImage(this.getImage(x));
                k = 0;
                conserve = true;
                while (en.hasMoreElements()) {
                    xx = (GraphObject)en.nextElement();
                    ++k;
                    xxImg = this.itsRule.getImage(xx);
                    if (xxImg != null) {
                        v.remove(xx);
                        continue;
                    }
                    conserve = false;
                }
                if (k <= true || conserve) continue;
                this.errorMsg = "Identification condition is violated!";
                this.errors.add(this.errorMsg);
                return false;
            }
            objects = leftSide.getArcs();
            v = new Vector();
            while (objects.hasMoreElements()) {
                GraphObject x3 = (GraphObject)objects.nextElement();
                v.addElement(x3);
            }
            for (int i = 0; i < v.size(); ++i) {
                x = (GraphObject)v.elementAt(i);
                en = this.getInverseImage(this.getImage(x));
                k = 0;
                conserve = true;
                while (en.hasMoreElements()) {
                    xx = (GraphObject)en.nextElement();
                    ++k;
                    xxImg = this.itsRule.getImage(xx);
                    if (xxImg != null) {
                        v.remove(xx);
                        continue;
                    }
                    conserve = false;
                }
                if (k <= 1 || conserve) continue;
                this.errorMsg = "Identification condition is violated!";
                this.errors.add(this.errorMsg);
                return false;
            }
        }
        return true;
    }

    public boolean satisfiesDangling() {
        if (this.getCompletionStrategy().getProperties().get(1)) {
            Graph leftSide = this.itsRule.getOriginal();
            Enumeration objects = leftSide.getElements();
            while (objects.hasMoreElements()) {
                GraphObject x = (GraphObject)objects.nextElement();
                if (this.itsRule.getImage(x) != null) continue;
                boolean isOK = true;
                GraphObject y = this.getImage(x);
                if (y != null) {
                    GraphObject a;
                    Enumeration e = y.getIncomingArcs();
                    if (e != null) {
                        while (e.hasMoreElements() && isOK) {
                            a = (GraphObject)e.nextElement();
                            isOK = this.getInverseImage(a).hasMoreElements();
                        }
                    } else {
                        isOK = true;
                    }
                    if (isOK) {
                        e = y.getOutgoingArcs();
                        if (e != null) {
                            while (e.hasMoreElements() && isOK) {
                                a = (GraphObject)e.nextElement();
                                isOK = this.getInverseImage(a).hasMoreElements();
                            }
                        } else {
                            isOK = true;
                        }
                    }
                }
                if (isOK) continue;
                this.errorMsg = "Dangling condition is violated!";
                this.errors.add(this.errorMsg);
                return false;
            }
        }
        return true;
    }

    private boolean checkVariableToNullMappping() {
        GraphObject obj;
        Vector<ValueMember> varToNull = new Vector<ValueMember>(2);
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        Enumeration en = this.getDomain();
        while (en.hasMoreElements()) {
            obj = (GraphObject)en.nextElement();
            GraphObject img = this.getImage(obj);
            ValueTuple vt = (ValueTuple)obj.getAttribute();
            for (int i = 0; i < vt.getNumberOfEntries(); ++i) {
                ValueMember vmObj = vt.getEntryAt(i);
                if (!vmObj.isSet() || !vmObj.getExpr().isVariable()) continue;
                ValueMember vmImg = ((ValueTuple)img.getAttribute()).getEntryAt(i);
                String nullStr = "null";
                if (!vmImg.isSet() || !vmImg.getExprAsText().equals(nullStr)) continue;
                varToNull.add(vars.getEntryAt(vmObj.getExprAsText()));
            }
        }
        en = this.itsRule.getRight().getElements();
        while (en.hasMoreElements()) {
            obj = (GraphObject)en.nextElement();
            ValueTuple vt = (ValueTuple)obj.getAttribute();
            for (int j = 0; j < vt.getNumberOfEntries(); ++j) {
                ValueMember vm = vt.getEntryAt(j);
                if (!vm.isSet() || !vm.getExpr().isComplex()) continue;
                Vector exprVars = vm.getAllVariableNamesOfExpression();
                for (int i = 0; i < varToNull.size(); ++i) {
                    VarMember var = (VarMember)varToNull.get(i);
                    if (!exprVars.contains(var.getName())) continue;
                    return false;
                }
            }
        }
        CondTuple ct = (CondTuple)this.getAttrContext().getConditions();
        for (int j = 0; j < ct.getNumberOfEntries(); ++j) {
            CondMember cm = (CondMember)ct.getEntryAt(j);
            Vector exprVars = cm.getAllVariables();
            for (int i = 0; i < varToNull.size(); ++i) {
                VarMember var = (VarMember)varToNull.get(i);
                if (cm.getExprAsText().indexOf(var.getName() + "==null") == -1 && !exprVars.contains(var.getName())) continue;
            }
        }
        return true;
    }

    private OrdinaryMorphism makeTestStep(Match m2, boolean allowVariables) {
        OrdinaryMorphism co_match = null;
        int oldTypeLevel = m2.getImage().getTypeSet().getLevelOfTypeGraphCheck();
        Step s = new Step();
        try {
            co_match = (OrdinaryMorphism)s.execute(m2, allowVariables);
        }
        catch (TypeException e) {
            this.errorMsg = "Type multiplicity exception during transformation!";
            this.errors.add(this.errorMsg);
            BaseFactory.theFactory().destroyMorphism(co_match);
            co_match = null;
            s = null;
            return null;
        }
        if (co_match != null && oldTypeLevel == 30) {
            m2.getImage().getTypeSet().setLevelOfTypeGraphCheck(oldTypeLevel);
            Collection errors = m2.getImage().getTypeSet().checkType(co_match.getImage(), 30);
            if (!errors.isEmpty()) {
                this.errorMsg = "Type multiplicity exception during transformation!";
                errors.add(this.errorMsg);
                BaseFactory.theFactory().destroyMorphism(co_match);
                co_match = null;
                s = null;
                return null;
            }
        }
        return co_match;
    }

    private boolean isConsistent(OrdinaryMorphism coM, OrdinaryMorphism m) {
        Vector constraints = this.getRule().getConstraints();
        if (!constraints.isEmpty()) {
            boolean good = true;
            for (int i = 0; i < constraints.size(); ++i) {
                Formula f = (Formula)constraints.get(i);
                Vector vec = new Vector();
                String form = f.getAsString(vec);
                Vector<EvalSet> v = new Vector<EvalSet>();
                for (int j = 0; j < vec.size(); ++j) {
                    EvalSet evalset = (EvalSet)vec.get(j);
                    Vector set = evalset.getSet();
                    Vector<AtomApplConstraint> v1 = new Vector<AtomApplConstraint>();
                    for (int k = 0; k < set.size(); ++k) {
                        Vector es = ((EvalSet)set.get(k)).getSet();
                        AtomApplConstraint aaConstr = new AtomApplConstraint(es);
                        v1.add(aaConstr);
                    }
                    v.add(new EvalSet(v1));
                }
                Formula f1 = new Formula(true);
                f1.setFormula(v, form);
                boolean b = f1.eval(new Pair(coM, m));
                if (good &= b) continue;
                this.errorMsg = "Post application conditions are violated \n( " + f1.getName() + ")!";
                this.errors.add(this.errorMsg);
                break;
            }
            return good;
        }
        return true;
    }

    private boolean isGlueAllowed() {
        if (!this.getCompletionStrategy().getProperties().get(0)) {
            boolean injective = false;
            Enumeration e = this.getImage().getElements();
            while (e.hasMoreElements()) {
                GraphObject o = (GraphObject)e.nextElement();
                Enumeration invers = this.getInverseImage(o);
                Vector<GraphObject> origs = new Vector<GraphObject>(2);
                while (invers.hasMoreElements()) {
                    origs.addElement((GraphObject)invers.nextElement());
                }
                if (origs.size() <= 1) continue;
                Vector<GraphObject> ruleImgs = new Vector<GraphObject>(2);
                for (int i = 0; i < origs.size(); ++i) {
                    GraphObject ruleImg = this.getRule().getImage((GraphObject)origs.elementAt(i));
                    if (ruleImg == null) continue;
                    ruleImgs.addElement(ruleImg);
                }
                if (ruleImgs.size() <= 1) continue;
                GraphObject ruleImg = (GraphObject)ruleImgs.elementAt(0);
                ValueTuple imgAttrs = (ValueTuple)ruleImg.getAttribute();
                for (int i = 1; i < ruleImgs.size(); ++i) {
                    GraphObject elem = (GraphObject)ruleImgs.elementAt(i);
                    ValueTuple elemAttrs = (ValueTuple)elem.getAttribute();
                    for (int j = 0; j < imgAttrs.getNumberOfEntries(); ++j) {
                        ValueMember vmImg = imgAttrs.getValueMemberAt(j);
                        ValueMember vmElem = elemAttrs.getValueMemberAt(j);
                        if (vmImg.getExpr() == null && vmElem.getExpr() == null) continue;
                        if (vmImg.getExpr() != null && vmElem.getExpr() != null) {
                            if (vmImg.getExpr().isVariable() && vmElem.getExpr().isVariable() || vmImg.getExpr().getString().equals(vmElem.getExpr().getString())) continue;
                            this.errorMsg = "In objects of the type  \"" + ruleImg.getType().getName() + "\"  attribute values to be glued are not equals.";
                            this.errors.add(this.errorMsg);
                            return false;
                        }
                        if (vmElem.getExpr() == null && vmImg.getExpr() != null && vmImg.getExpr().isVariable() || vmImg.getExpr() == null && vmElem.getExpr() != null && vmElem.getExpr().isVariable()) continue;
                        this.errorMsg = "In objects of the type  \"" + ruleImg.getType().getName() + "\"  attribute values to be glued are not equals.";
                        this.errors.add(this.errorMsg);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public final SubMatch createSubMatch() {
        return this.createSubMatch(this.getRule().createSubRule(), this.getImage().createSubGraph());
    }

    public final SubMatch createSubMatch(SubRule sr, SubGraph host) {
        return new SubMatch(this, sr, host);
    }

    public final SubMatch createSubMatch(SubGraGra sgg, SubRule sr) {
        SubMatch sm = new SubMatch(this, sr, (SubGraph)sgg.getGraph());
        if (sgg != null) {
            sgg.addMatch(sm);
        }
        return sm;
    }

    public final boolean destroySubMatch(SubMatch sm) {
        if (sm != null) {
            sm.dispose();
            return true;
        }
        return false;
    }

    public final Enumeration getSubMatches() {
        return this.itsSubMatches.elements();
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Match", this);
        this.writeMorphism(h);
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("Match", this)) {
            this.readMorphism(h);
            h.close();
        }
    }
}

