/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrMapping;
import agg.attribute.AttrVariableTuple;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ClassResolver;
import agg.util.Change;
import agg.util.Debug;
import agg.util.ExtObservable;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Completion_SimpleBT;
import agg.xt_basis.CopyMemory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinarySubMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.SubGraph;
import agg.xt_basis.SubRule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.Pair;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OrdinaryMorphism
extends ExtObservable
implements Morphism {
    private Vector itsSubMorphs = new Vector(1, 2);
    private transient MorphCompletionStrategy itsCompleter;
    private Dictionary itsAttrMappings;
    private AttrContext itsAttrContext;
    private AttrManager itsAttrManager;
    private boolean itsTouchedFlag = true;
    private boolean itsInteractiveFlag = true;
    private int itsSourceGraphSize = 0;
    protected int itsSize = 0;
    protected Graph itsOrig;
    protected Graph itsImag;
    protected Vector itsDomObjects;
    protected Vector itsCodomObjects;
    private String itsName = "OrdinaryMorph";
    private OrdinaryMorphism itsCoMorph;
    protected String errorMsg;
    protected Vector errors;
    protected boolean enabled = true;
    protected static final AttrContext cKeepContext = null;

    protected OrdinaryMorphism() {
        this(new Graph(), new Graph(), cKeepContext);
    }

    protected OrdinaryMorphism(AttrContext ac) {
        this(new Graph(), new Graph(), ac);
    }

    protected OrdinaryMorphism(Graph orig, Graph img) {
        this(orig, img, cKeepContext);
    }

    public OrdinaryMorphism(Graph orig, Graph img, AttrContext ac) {
        this.itsOrig = orig;
        orig.addUsingMorph(this);
        this.itsImag = img;
        img.addUsingMorph(this);
        this.itsDomObjects = new Vector();
        this.itsCodomObjects = new Vector();
        this.itsAttrMappings = new Hashtable(20);
        this.itsAttrContext = ac;
        this.itsAttrManager = AttrTupleManager.getDefaultManager();
        this.setCompletionStrategy(CompletionStrategySelector.getDefault());
        this.itsTouchedFlag = true;
        this.itsInteractiveFlag = true;
        this.itsSize = 0;
        this.itsSourceGraphSize = this.getSourceGraphSize();
        this.errorMsg = null;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void clearErrorMsg() {
        this.errorMsg = null;
        ((ContextView)this.getAttrContext()).getManager().clearErrorMsg();
        ((ContextView)this.getAttrContext()).clearErrorMsg();
    }

    public final boolean isCommutative(Morphism anOther) {
        if (anOther == this) {
            return true;
        }
        if (anOther.getOriginal().equals(this.getOriginal())) {
            Enumeration allOrigObjects = this.getOriginal().getElements();
            while (allOrigObjects.hasMoreElements()) {
                GraphObject anOrig = (GraphObject)allOrigObjects.nextElement();
                GraphObject anImage1 = this.getImage(anOrig);
                GraphObject anImage2 = anOther.getImage(anOrig);
                if (anImage1 == null) {
                    if (anImage2 == null) continue;
                    return false;
                }
                if (anImage1.equals(anImage2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Match makeMatch(Rule rule) {
        boolean failed = false;
        Match m = BaseFactory.theFactory().createMatch(rule, this.getImage());
        Enumeration elements = this.getDomain();
        while (!failed && elements.hasMoreElements()) {
            try {
                GraphObject grob = (GraphObject)elements.nextElement();
                m.addMapping(grob, this.getImage(grob));
            }
            catch (BadMappingException e) {
                this.errorMsg = e.getMessage();
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
                failed = true;
                m.dispose();
                m = null;
                System.err.println("OrdinaryMorphism.makeMatch: BadMappingException");
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism morphcopy() {
        OrdinaryMorphism ordinaryMorphism = this;
        synchronized (ordinaryMorphism) {
            GraphObject x;
            boolean failed = false;
            Graph sourceOrig = this.getSource();
            Graph targetOrig = this.getTarget();
            Graph sourceCopy = sourceOrig.graphcopy(1);
            Graph targetCopy = targetOrig.graphcopy(2);
            if (sourceCopy == null || targetCopy == null) {
                if (sourceCopy != null) {
                    sourceCopy.dispose();
                }
                if (targetCopy != null) {
                    targetCopy.dispose();
                }
                CopyMemory.UNSET();
                sourceCopy = null;
                targetCopy = null;
                return null;
            }
            OrdinaryMorphism theCopy = BaseFactory.theFactory().createMorphism(sourceCopy, targetCopy);
            Enumeration domainOrig = this.getDomain();
            while (!failed && domainOrig.hasMoreElements()) {
                Node y;
                x = (GraphObject)domainOrig.nextElement();
                if (!x.isNode() || (y = (Node)this.getImage(x)) == null) continue;
                Node xCopy = (Node)CopyMemory.SELECT(x, 1);
                Node yCopy = (Node)CopyMemory.SELECT(y, 2);
                theCopy.addMapping(xCopy, yCopy);
            }
            domainOrig = this.getDomain();
            while (!failed && domainOrig.hasMoreElements()) {
                x = (GraphObject)domainOrig.nextElement();
                if (!x.isArc()) continue;
                Node vtx1 = (Node)((Arc)x).getSource();
                Node vtx2 = (Node)((Arc)x).getTarget();
                Node vtx1Copy = (Node)CopyMemory.SELECT(vtx1, 1);
                Node vtx2Copy = (Node)CopyMemory.SELECT(vtx2, 1);
                Arc y = (Arc)this.getImage(x);
                Node vtx3Copy = null;
                Node vtx4Copy = null;
                if (y != null) {
                    Node vtx3 = (Node)y.getSource();
                    Node vtx4 = (Node)y.getTarget();
                    vtx3Copy = (Node)CopyMemory.SELECT(vtx3, 2);
                    vtx4Copy = (Node)CopyMemory.SELECT(vtx4, 2);
                }
                Arc q = null;
                Enumeration sourceCopyArcs = sourceCopy.getArcs();
                while (sourceCopyArcs.hasMoreElements()) {
                    Arc a = (Arc)sourceCopyArcs.nextElement();
                    if (!((Node)a.getSource()).equals(vtx1Copy) || !((Node)a.getTarget()).equals(vtx2Copy)) continue;
                    q = a;
                }
                Arc z = null;
                if (vtx3Copy != null && vtx4Copy != null) {
                    Enumeration targetCopyArcs = targetCopy.getArcs();
                    while (targetCopyArcs.hasMoreElements()) {
                        Arc a = (Arc)targetCopyArcs.nextElement();
                        if (!((Node)a.getSource()).equals(vtx3Copy) || !((Node)a.getTarget()).equals(vtx4Copy)) continue;
                        z = a;
                    }
                }
                if (q != null && z != null) {
                    theCopy.addMapping(q, z);
                    continue;
                }
                failed = true;
                theCopy.dispose();
                theCopy = null;
                sourceCopy.dispose();
                sourceCopy = null;
                targetCopy.dispose();
                targetCopy = null;
            }
            CopyMemory.UNSET();
            return theCopy;
        }
    }

    public boolean makeDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond) {
        GraphObject elem2;
        Enumeration secondDom;
        GraphObject elem1;
        boolean result;
        if (!this.getOriginal().equals(theFirst.getImage())) {
            return false;
        }
        if (!this.getImage().equals(theSecond.getImage())) {
            return false;
        }
        if (!theFirst.getOriginal().equals(theSecond.getOriginal())) {
            return false;
        }
        if (!theFirst.getDomain().hasMoreElements() && !theSecond.getDomain().hasMoreElements()) {
            return this.nextCompletion();
        }
        Enumeration firstDom = theFirst.getDomain();
        while (firstDom.hasMoreElements()) {
            result = false;
            elem1 = (GraphObject)firstDom.nextElement();
            secondDom = theSecond.getDomain();
            while (secondDom.hasMoreElements()) {
                elem2 = (GraphObject)secondDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        secondDom = theSecond.getDomain();
        while (secondDom.hasMoreElements()) {
            result = false;
            elem1 = (GraphObject)secondDom.nextElement();
            firstDom = theFirst.getDomain();
            while (firstDom.hasMoreElements()) {
                elem2 = (GraphObject)firstDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        Enumeration ownDom = this.getDomain();
        while (ownDom.hasMoreElements()) {
            GraphObject y = (GraphObject)ownDom.nextElement();
            GraphObject z = this.getImage(y);
            Enumeration manyX = theFirst.getInverseImage(y);
            while (manyX.hasMoreElements()) {
                GraphObject x = (GraphObject)manyX.nextElement();
                if (theSecond.getImage(x).equals(z)) continue;
                return false;
            }
        }
        firstDom = theFirst.getDomain();
        while (firstDom.hasMoreElements()) {
            GraphObject x = (GraphObject)firstDom.nextElement();
            GraphObject y = theFirst.getImage(x);
            GraphObject z = theSecond.getImage(x);
            if (z == null || z.equals(this.getImage(y))) continue;
            this.addMapping(y, z);
        }
        return true;
    }

    public boolean makeWeakDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond) {
        if (!theFirst.getDomain().hasMoreElements() && !theSecond.getDomain().hasMoreElements()) {
            boolean result = this.nextCompletion();
            return result;
        }
        Enumeration firstDom = theFirst.getDomain();
        Enumeration ownDom = this.getDomain();
        while (ownDom.hasMoreElements()) {
            GraphObject y = (GraphObject)ownDom.nextElement();
            GraphObject z = this.getImage(y);
            Enumeration manyX = theFirst.getInverseImage(y);
            while (manyX.hasMoreElements()) {
                GraphObject x = (GraphObject)manyX.nextElement();
                if (theSecond.getImage(x).equals(z)) continue;
                return false;
            }
        }
        firstDom = theFirst.getDomain();
        while (firstDom.hasMoreElements()) {
            GraphObject x = (GraphObject)firstDom.nextElement();
            GraphObject y = theFirst.getImage(x);
            GraphObject z = theSecond.getImage(x);
            if (z == null || z.equals(this.getImage(y))) continue;
            this.addMapping(y, z);
        }
        if (!theFirst.getDomain().hasMoreElements() || !theSecond.getDomain().hasMoreElements()) {
            return this.nextCompletion();
        }
        return true;
    }

    public boolean makeFullDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond) {
        GraphObject elem2;
        Enumeration secondDom;
        GraphObject elem1;
        boolean result;
        if (!this.getOriginal().equals(theFirst.getImage())) {
            return false;
        }
        if (!this.getImage().equals(theSecond.getImage())) {
            return false;
        }
        if (!theFirst.getOriginal().equals(theSecond.getOriginal())) {
            return false;
        }
        Enumeration firstDom = theFirst.getOriginal().getElements();
        while (firstDom.hasMoreElements()) {
            result = false;
            elem1 = (GraphObject)firstDom.nextElement();
            secondDom = theSecond.getOriginal().getElements();
            while (secondDom.hasMoreElements()) {
                elem2 = (GraphObject)secondDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        secondDom = theSecond.getOriginal().getElements();
        while (secondDom.hasMoreElements()) {
            result = false;
            elem1 = (GraphObject)secondDom.nextElement();
            firstDom = theFirst.getOriginal().getElements();
            while (firstDom.hasMoreElements()) {
                elem2 = (GraphObject)firstDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        Enumeration ownDom = this.getOriginal().getElements();
        while (ownDom.hasMoreElements()) {
            GraphObject y = (GraphObject)ownDom.nextElement();
            GraphObject z = this.getImage(y);
            if (z == null) continue;
            Enumeration manyX = theFirst.getInverseImage(y);
            while (manyX.hasMoreElements()) {
                GraphObject x = (GraphObject)manyX.nextElement();
                if (theSecond.getImage(x).equals(z)) continue;
                return false;
            }
        }
        firstDom = theFirst.getOriginal().getElements();
        while (firstDom.hasMoreElements()) {
            GraphObject x = (GraphObject)firstDom.nextElement();
            GraphObject y = theFirst.getImage(x);
            GraphObject z = theSecond.getImage(x);
            if (y == null || z == null || z.equals(this.getImage(y))) continue;
            this.addMapping(y, z);
        }
        return true;
    }

    public boolean makeDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond, OrdinaryMorphism theThird) {
        OrdinaryMorphism tmpMorph = theSecond.compose(theThird);
        return this.makeDiagram(theFirst, tmpMorph);
    }

    public boolean makeWeakDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond, OrdinaryMorphism theThird) {
        OrdinaryMorphism tmpMorph = theSecond.compose(theThird);
        return this.makeWeakDiagram(theFirst, tmpMorph);
    }

    public boolean makeFullDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond, OrdinaryMorphism theThird) {
        OrdinaryMorphism tmpMorph = BaseFactory.theFactory().createMorphism(theSecond.getOriginal(), theThird.getImage());
        Enumeration theSecondDom = theSecond.getOriginal().getElements();
        while (theSecondDom.hasMoreElements()) {
            GraphObject theThirdGoImage;
            GraphObject theSecondGo = (GraphObject)theSecondDom.nextElement();
            GraphObject theSecondGoImage = theSecond.getImage(theSecondGo);
            if (theSecondGoImage == null || (theThirdGoImage = theThird.getImage(theSecondGoImage)) == null) continue;
            tmpMorph.addMapping(theSecondGo, theThirdGoImage);
        }
        return this.makeFullDiagram(theFirst, tmpMorph);
    }

    public void dispose() {
        this.itsOrig.removeUsingMorph(this);
        this.itsImag.removeUsingMorph(this);
        this.itsSize = 0;
        this.clear();
        this.clearErrorMsg();
        if (this.itsCoMorph != null) {
            this.itsCoMorph.dispose();
        }
        this.itsCoMorph = null;
        super.dispose();
    }

    public void dispose(boolean disposabledSource, boolean disposabledTarget) {
        this.dispose();
        if (disposabledSource) {
            this.itsOrig.dispose();
            this.itsOrig = null;
        }
        if (disposabledTarget) {
            this.itsImag.dispose();
            this.itsImag = null;
        }
    }

    public final void setName(String n) {
        this.itsName = n;
    }

    public final String getName() {
        return this.itsName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMapping(GraphObject o, GraphObject i) throws BadMappingException {
        if (!(this instanceof OrdinarySubMorphism)) {
            if (!this.getSource().isElement(o)) return;
            if (!this.getTarget().isElement(i)) return;
            if (this.getSubMorphisms().hasMoreElements()) {
                if (!this.mappingObjectsBelongToSameSubMorphism(o, i)) {
                    this.errorMsg = "Mapping is failed! The graph objects don't belong to the same interface object.";
                    if (this.errors == null) throw new BadMappingException(this.errorMsg);
                    this.errors.add(this.errorMsg);
                    throw new BadMappingException(this.errorMsg);
                }
                try {
                    this.doAddMapping(o, i);
                    return;
                }
                catch (BadMappingException exc) {
                    this.errorMsg = exc.getMessage();
                    if (this.errors == null) throw exc;
                    this.errors.add(this.errorMsg);
                    throw exc;
                }
            }
            try {
                this.doAddMapping(o, i);
                return;
            }
            catch (BadMappingException exc) {
                this.errorMsg = exc.getMessage();
                if (this.errors == null) throw exc;
                this.errors.add(this.errorMsg);
                throw exc;
            }
        }
        if (((OrdinarySubMorphism)this).getSuperMorphism().getImage(o) == null) {
            ((OrdinarySubMorphism)this).getSuperMorphism().addMapping(o, i);
            return;
        }
        if (!((OrdinarySubMorphism)this).getSuperMorphism().getImage(o).equals(i)) return;
        try {
            this.doAddMapping(o, i);
            return;
        }
        catch (BadMappingException exc) {
            this.errorMsg = exc.getMessage();
            if (this.errors == null) throw exc;
            this.errors.add(this.errorMsg);
            throw exc;
        }
    }

    public void addMapping(GraphObject o, GraphObject i, boolean mappingPropagation) throws BadMappingException {
        if (!mappingPropagation) {
            this.addMapping(o, i);
            return;
        }
        if (!(this instanceof OrdinarySubMorphism)) {
            if (this.getSource().isElement(o) && this.getTarget().isElement(i)) {
                try {
                    this.doAddMapping(o, i);
                }
                catch (BadMappingException exc) {
                    this.errorMsg = exc.getMessage();
                    if (this.errors != null) {
                        this.errors.add(this.errorMsg);
                    }
                    throw exc;
                }
            }
        } else {
            ((OrdinarySubMorphism)this).getSuperMorphism().addMapping(o, i);
        }
    }

    protected boolean checkType(Type orig, Type image) {
        return orig.isParentOf(image);
    }

    private void doAddMapping(GraphObject orig, GraphObject image) throws BadMappingException {
        GraphObject aPreviousImage;
        if (orig.isNode() != image.isNode()) {
            this.errorMsg = "Cannot map node to edge.";
            if (this.errors != null) {
                this.errors.add(this.errorMsg);
            }
            throw new BadMappingException(this.errorMsg);
        }
        if (!this.checkType(orig.getType(), image.getType())) {
            this.errorMsg = "Objects to map must be of the same type.";
            if (this.errors != null) {
                this.errors.add(this.errorMsg);
            }
            throw new BadMappingException(this.errorMsg);
        }
        if (this instanceof Match && orig instanceof Node) {
            Enumeration origEnum = this.getDomain();
            Match m = (Match)this;
            while (origEnum.hasMoreElements()) {
                GraphObject currentObject = (GraphObject)origEnum.nextElement();
                if (!(currentObject instanceof Node) || currentObject == orig) continue;
                Node currentNode = (Node)currentObject;
                Node currentRuleImage = (Node)m.getRule().getImage(currentNode);
                Node origRuleImage = (Node)m.getRule().getImage(orig);
                Node currentMatchImage = (Node)m.getImage(currentNode);
                if (currentRuleImage == null || currentRuleImage != origRuleImage || currentMatchImage == null || image.getType().compareTo(currentMatchImage.getType())) continue;
                this.errorMsg = "Non injective rules must preserve types.";
                throw new BadMappingException(this.errorMsg);
            }
        }
        if (orig.isArc()) {
            GraphObject aSrc = ((Arc)orig).getSource();
            GraphObject aTar = ((Arc)orig).getTarget();
            if (this.getImage(aSrc) != null && !((Arc)image).getSource().equals(this.getImage(aSrc))) {
                this.errorMsg = "Edge mapping must be source compatible.";
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
                throw new BadMappingException(this.errorMsg);
            }
            if (this.getImage(aTar) != null && !((Arc)image).getTarget().equals(this.getImage(aTar))) {
                this.errorMsg = "Edge mapping must be target compatible.";
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
                throw new BadMappingException(this.errorMsg);
            }
        }
        if ((aPreviousImage = this.getImage(orig)) != null) {
            this.removeMapping(orig);
        }
        try {
            if (((ContextView)this.getAttrContext()).getAllowedMapping() == 1) {
                if (orig != null && image != null && ((ValueTuple)orig.getAttribute()).canMatchTo((ValueTuple)image.getAttribute(), (ContextView)this.getAttrContext())) {
                    this.addAttrMapping(orig.getAttribute(), image.getAttribute());
                    this.itsDomObjects.addElement(orig);
                    this.itsCodomObjects.addElement(image);
                    ++this.itsSize;
                    this.propagateChange(new Change(20, orig));
                    this.itsOrig.propagateChange(new Change(20, orig));
                    this.propagateChange(new Change(20, image));
                    this.itsImag.propagateChange(new Change(20, image));
                }
            } else if (orig != null && image != null) {
                this.addAttrMapping(orig.getAttribute(), image.getAttribute());
                this.itsDomObjects.addElement(orig);
                this.itsCodomObjects.addElement(image);
                ++this.itsSize;
                this.propagateChange(new Change(20, orig));
                this.itsOrig.propagateChange(new Change(20, orig));
                this.propagateChange(new Change(20, image));
                this.itsImag.propagateChange(new Change(20, image));
            }
        }
        catch (BadMappingException exc) {
            this.errorMsg = exc.getMessage();
            if (this.errors != null) {
                this.errors.add(this.errorMsg);
            }
            if (aPreviousImage != null) {
                this.addMapping(orig, aPreviousImage);
            }
            throw exc;
        }
    }

    protected void addAttrMapping(AttrInstance o, AttrInstance i) throws BadMappingException {
        if (this.getAttrContext() != null) {
            try {
                Debug.println("Checking Attribute match of these AttrInstances:\n\t" + o + "\n\t" + i, this);
                Debug.println("AttrContext: " + this.getAttrContext(), this);
                this.itsAttrMappings.put(o, this.getAttrManager().newMapping(this.getAttrContext(), o, i));
            }
            catch (AttrException exc) {
                this.errorMsg = exc.getMessage();
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
                throw new BadMappingException(exc.getMessage());
            }
        }
    }

    protected void removeAttrMapping(AttrInstance o) {
        AttrMapping anAttrMapping = (AttrMapping)this.itsAttrMappings.get(o);
        if (anAttrMapping != null) {
            anAttrMapping.remove();
        }
    }

    private boolean mappingObjectsBelongToSameSubMorphism(GraphObject o, GraphObject i) {
        Enumeration subMorphs = this.getSubMorphisms();
        while (subMorphs.hasMoreElements()) {
            OrdinarySubMorphism subMorph = (OrdinarySubMorphism)subMorphs.nextElement();
            if (subMorph.getSource().isElement(o) && subMorph.getTarget().isElement(i) || !subMorph.getSource().isElement(o) && !subMorph.getTarget().isElement(i)) continue;
            return false;
        }
        return true;
    }

    public void removeMapping(GraphObject o) {
        if (!(this instanceof OrdinarySubMorphism)) {
            if (this.getSource().isElement(o)) {
                if (o.isNode()) {
                    GraphObject aNeighbor;
                    Enumeration anIter = ((Node)o).getIncomingArcs();
                    while (anIter.hasMoreElements()) {
                        aNeighbor = (GraphObject)anIter.nextElement();
                        if (this.getImage(aNeighbor) == null) continue;
                        this.removeMapping(aNeighbor);
                    }
                    anIter = ((Node)o).getOutgoingArcs();
                    while (anIter.hasMoreElements()) {
                        aNeighbor = (GraphObject)anIter.nextElement();
                        if (this.getImage(aNeighbor) == null) continue;
                        this.removeMapping(aNeighbor);
                    }
                }
                this.removeAttrMapping(o.getAttribute());
                int i = this.itsDomObjects.indexOf(o);
                if (i > -1) {
                    GraphObject dom = (GraphObject)this.itsDomObjects.elementAt(i);
                    this.itsDomObjects.removeElementAt(i);
                    this.propagateChange(new Change(21, dom));
                    this.itsOrig.propagateChange(new Change(21, dom));
                    GraphObject codom = (GraphObject)this.itsCodomObjects.elementAt(i);
                    this.itsCodomObjects.removeElementAt(i);
                    this.propagateChange(new Change(21, codom));
                    this.itsImag.propagateChange(new Change(21, codom));
                    --this.itsSize;
                }
            } else if (this.getTarget().isElement(o)) {
                Enumeration en = this.getInverseImage(o);
                while (en.hasMoreElements()) {
                    GraphObject ii = (GraphObject)en.nextElement();
                    this.removeMapping(ii);
                }
            }
        } else {
            ((OrdinarySubMorphism)this).getSuperMorphism().removeMapping(o);
        }
    }

    public final void clear() {
        if (!(this instanceof OrdinarySubMorphism)) {
            this.itsDomObjects.clear();
            this.itsCodomObjects.clear();
            Enumeration e = this.itsAttrMappings.keys();
            while (e.hasMoreElements()) {
                this.itsAttrMappings.remove(e.nextElement());
            }
            this.itsSize = 0;
        } else {
            Enumeration dom = this.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject o = (GraphObject)dom.nextElement();
                ((OrdinarySubMorphism)this).getSuperMorphism().removeMapping(o);
            }
        }
        VarTuple vars = (VarTuple)this.itsAttrContext.getVariables();
        vars.unsetInputParameters();
        this.clearErrorMsg();
    }

    public Graph getOriginal() {
        return this.itsOrig;
    }

    public final Graph getSource() {
        return this.getOriginal();
    }

    public Graph getImage() {
        return this.itsImag;
    }

    public final Graph getTarget() {
        return this.getImage();
    }

    public Enumeration getDomain() {
        if (this instanceof OrdinarySubMorphism) {
            return ((OrdinarySubMorphism)this).getDomain();
        }
        return this.itsDomObjects.elements();
    }

    public Enumeration getCodomain() {
        return this.itsCodomObjects.elements();
    }

    protected Vector getCodomainObjects() {
        return this.itsCodomObjects;
    }

    public GraphObject getImage(GraphObject o) {
        int i = this.itsDomObjects.indexOf(o);
        if (i > -1 && i < this.itsCodomObjects.size()) {
            return (GraphObject)this.itsCodomObjects.elementAt(i);
        }
        return null;
    }

    public Enumeration getInverseImage(GraphObject o) {
        int index;
        Vector invImages = new Vector();
        int i = 0;
        while (i < this.itsCodomObjects.size() && (index = this.itsCodomObjects.indexOf(o, i)) != -1) {
            invImages.addElement(this.itsDomObjects.elementAt(index));
            i = index + 1;
        }
        return invImages.elements();
    }

    public final void setCompletionStrategy(MorphCompletionStrategy sg) {
        Debug.println("CompletionStrategy set with INJECTIVE bit " + (sg.getProperties().get(0) ? "" : "not ") + "set.", this);
        this.itsCompleter = sg;
    }

    public final MorphCompletionStrategy getCompletionStrategy() {
        return this.itsCompleter;
    }

    public boolean canComplete() {
        if (this.itsCompleter.getProperties().get(0) && (this.itsOrig.getSizeOfNodes() > this.itsImag.getSizeOfNodes() || this.itsOrig.getSizeOfArcs() > this.itsImag.getSizeOfArcs())) {
            return false;
        }
        Vector origTypes = this.itsOrig.getUsedTypes();
        Vector imagTypes = this.itsImag.getUsedAndInheritedTypes();
        for (int i = 0; i < origTypes.size(); ++i) {
            if (imagTypes.contains((Type)origTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean nextCompletion() {
        boolean ok = false;
        this.errorMsg = "";
        ok = !(this instanceof OrdinarySubMorphism) ? this.doNextCompletion() : ((OrdinarySubMorphism)this).getSuperMorphism().doNextCompletion();
        if (!(this instanceof OrdinarySubMorphism) && ok) {
            Enumeration subMorphs = this.getSubMorphisms();
            while (subMorphs.hasMoreElements()) {
                OrdinarySubMorphism subMorph = (OrdinarySubMorphism)subMorphs.nextElement();
                Enumeration origs = this.getDomain();
                while (origs.hasMoreElements()) {
                    GraphObject o = (GraphObject)origs.nextElement();
                    GraphObject i = this.getImage(o);
                    if (i == null || !subMorph.getSource().isElement(o) || !subMorph.getTarget().isElement(i)) continue;
                    try {
                        subMorph.addMapping(o, i);
                    }
                    catch (BadMappingException exc) {
                        this.errorMsg = "Bad mapping exception of OrdinarySubMorphism::  " + exc.getMessage();
                        if (this.errors != null) {
                            this.errors.add(this.errorMsg);
                        }
                        return false;
                    }
                }
            }
        }
        if (!ok) {
            String structuredMsg = "Graph structure or attributes failed.";
            AttrTupleManager manager = ((ContextView)this.getAttrContext()).getManager();
            String attrMsg = manager.getErrorMsg();
            if (!attrMsg.equals("")) {
                this.errorMsg = structuredMsg + "\n" + attrMsg;
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
            } else {
                this.errorMsg = structuredMsg;
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
            }
        }
        return ok;
    }

    private boolean doNextCompletion() {
        Debug.println("Completer: " + this.itsCompleter, this);
        if (this.itsTouchedFlag) {
            Debug.println("Oooh! I'm touched!");
            this.itsCompleter.reset();
            this.itsTouchedFlag = false;
        }
        this.itsInteractiveFlag = false;
        boolean b = this.itsCompleter.next(this);
        this.itsInteractiveFlag = true;
        return b;
    }

    public boolean nextCompletionWithConstantsChecking() {
        boolean found = false;
        while (!found && this.nextCompletion()) {
            found = true;
            if (this.checkConstants()) continue;
            this.errorMsg = "Mismatch of attribute values as constants.";
            if (this.errors != null) {
                this.errors.add(this.errorMsg);
            }
            found = false;
        }
        return found;
    }

    private boolean single_nextCompletionWithConstantsChecking() {
        boolean found = false;
        if (this.nextCompletion()) {
            if (this.checkConstants()) {
                found = true;
            } else {
                this.errorMsg = "Mismatch of attribute values as constants.";
                if (this.errors != null) {
                    this.errors.add(this.errorMsg);
                }
                found = false;
            }
        }
        return found;
    }

    public boolean nextCompletionWithConstantsAndVariablesChecking() {
        boolean found = false;
        while (!found && this.nextCompletion()) {
            found = true;
            if (this.checkAll()) continue;
            this.errorMsg = "Mismatch of attribute values as constants or variables.";
            if (this.errors != null) {
                this.errors.add(this.errorMsg);
            }
            found = false;
        }
        return found;
    }

    public final boolean isTotal() {
        return this.getSourceGraphSize() == this.itsDomObjects.size();
    }

    public final AttrContext getAttrContext() {
        return this.itsAttrContext;
    }

    public final void setAttrContext(AttrContext ac) {
        this.itsAttrContext = ac;
    }

    public void adaptAttrContextValues(AttrContext ac) {
        VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
        VarTuple vars = (VarTuple)ac.getVariables();
        for (int i = 0; i < vars.getSize(); ++i) {
            VarMember var = vars.getVarMemberAt(i);
            VarMember itsVar = itsVars.getVarMemberAt(var.getName());
            if (itsVar == null || !var.isSet()) continue;
            itsVar.setExprAsText(var.getExprAsText());
        }
    }

    public void addToAttrContext(VarTuple vars) {
        VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
        for (int i = 0; i < vars.getSize(); ++i) {
            VarMember var = vars.getVarMemberAt(i);
            DeclMember dm = (DeclMember)var.getDeclaration();
            if (itsVars.isDeclared(dm.getTypeName(), dm.getName())) continue;
            itsVars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
        }
    }

    public void addToAttrContext(CondTuple conds) {
        CondTuple itsConds = (CondTuple)this.getAttrContext().getConditions();
        for (int i = 0; i < conds.getSize(); ++i) {
            CondMember cond = conds.getCondMemberAt(i);
            if (itsConds.contains(cond.getExprAsText())) continue;
            itsConds.addCondition(cond.getExprAsText());
        }
    }

    public final AttrManager getAttrManager() {
        return this.itsAttrManager;
    }

    protected synchronized void setChanged() {
        if (this.itsInteractiveFlag) {
            this.itsTouchedFlag = true;
        }
        super.setChanged();
    }

    public void writeMorphism(XMLHelper h) {
        h.openSubTag("Morphism");
        h.addAttr("name", this.getName());
        Enumeration e = this.getDomain();
        while (e.hasMoreElements()) {
            GraphObject s = (GraphObject)e.nextElement();
            h.openSubTag("Mapping");
            h.addObject("orig", s, false);
            h.addObject("image", this.getImage(s), false);
            h.close();
        }
        h.close();
    }

    public void readMorphism(XMLHelper h) {
        if (h.readSubTag("Morphism")) {
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    this.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
    }

    public final OrdinarySubMorphism createSubMorphism() {
        OrdinarySubMorphism aSubMorph = new OrdinarySubMorphism(this, this.getOriginal().createSubGraph(), this.getImage().createSubGraph());
        this.itsSubMorphs.add(aSubMorph);
        return aSubMorph;
    }

    public final OrdinarySubMorphism createSubMorphism(SubGraph orig, SubGraph img) {
        OrdinarySubMorphism aSubMorph = new OrdinarySubMorphism(this, orig, img);
        this.itsSubMorphs.add(aSubMorph);
        return aSubMorph;
    }

    public final boolean destroySubMorphism(OrdinarySubMorphism sm) {
        return this.itsSubMorphs.removeElement(sm);
    }

    public final Enumeration getSubMorphisms() {
        return this.itsSubMorphs.elements();
    }

    public OrdinaryMorphism invert() {
        if (!this.isInjective()) {
            this.errorMsg = "Inverting of non-injective morphism is not possible.";
            return null;
        }
        Graph x = this.getOriginal();
        Graph y = this.getImage();
        OrdinaryMorphism inv = BaseFactory.theFactory().createMorphism(y, x);
        Enumeration domain = this.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject go = (GraphObject)domain.nextElement();
            try {
                inv.addMapping(this.getImage(go), go);
            }
            catch (BadMappingException e) {
                this.errorMsg = e.getMessage();
                e.printStackTrace();
            }
        }
        return inv;
    }

    public OrdinaryMorphism simplecopy() {
        Graph src = this.getOriginal();
        Graph tgt = this.getImage();
        OrdinaryMorphism output = BaseFactory.theFactory().createMorphism(src, tgt);
        Enumeration mappedObjects = this.getDomain();
        while (mappedObjects.hasMoreElements()) {
            GraphObject go = (GraphObject)mappedObjects.nextElement();
            output.addMapping(go, this.getImage(go));
        }
        return output;
    }

    public boolean isIsomorphicTo(OrdinaryMorphism h) {
        Enumeration dom = this.getDomain();
        Vector hDomain = new Vector();
        Enumeration hd = h.getDomain();
        while (hd.hasMoreElements()) {
            hDomain.addElement(hd.nextElement());
        }
        while (dom.hasMoreElements()) {
            GraphObject go = (GraphObject)dom.nextElement();
            if (hDomain.contains(go)) {
                if (!this.getImage(go).equals(h.getImage(go))) {
                    return false;
                }
                hDomain.removeElement(go);
                continue;
            }
            return false;
        }
        return hDomain.size() == 0;
    }

    public boolean isIsomorphicTo(OrdinaryMorphism h, OrdinaryMorphism targetIso) {
        if (this.getSource() != h.getSource()) {
            System.out.println("OrdinaryMorphism.isIsomorphicTo:: FAILED:: this and h have different source graphs");
            return false;
        }
        if (h.getTarget() != targetIso.getTarget()) {
            System.out.println("OrdinaryMorphism.isIsomorphicTo:: FAILED:: targetIso and h have different target graphs");
            return false;
        }
        Enumeration e = this.getSource().getElements();
        while (e.hasMoreElements()) {
            GraphObject i2;
            GraphObject o = (GraphObject)e.nextElement();
            GraphObject i1 = targetIso.getImage(this.getImage(o));
            if (i1 == (i2 = h.getImage(o))) continue;
            return false;
        }
        return true;
    }

    public boolean isPartialIsomorphicTo(OrdinaryMorphism h) {
        Enumeration dom = this.getDomain();
        Vector hDomain = new Vector();
        Enumeration hd = h.getDomain();
        while (hd.hasMoreElements()) {
            hDomain.addElement(hd.nextElement());
        }
        while (dom.hasMoreElements()) {
            GraphObject go = (GraphObject)dom.nextElement();
            if (!hDomain.contains(go) || this.getImage(go).equals(h.getImage(go))) continue;
            return false;
        }
        return true;
    }

    public boolean isSurjective() {
        Enumeration nonMapped = this.nonMappedImages();
        return !nonMapped.hasMoreElements();
    }

    public boolean isInjective() {
        Enumeration codomain = this.getCodomain();
        while (codomain.hasMoreElements()) {
            GraphObject go = (GraphObject)codomain.nextElement();
            Enumeration inverseImages = this.getInverseImage(go);
            int i = 0;
            while (inverseImages.hasMoreElements()) {
                ++i;
                inverseImages.nextElement();
            }
            if (i > 1) {
                return false;
            }
            i = 0;
        }
        return true;
    }

    public boolean isBijective() {
        return this.isInjective() && this.isSurjective();
    }

    public Enumeration nonMappedOriginals() {
        Vector<GraphObject> nonMapped = new Vector<GraphObject>();
        Vector mapped = new Vector();
        Graph o = this.getOriginal();
        Enumeration domain = this.getDomain();
        while (domain.hasMoreElements()) {
            mapped.addElement(domain.nextElement());
        }
        Enumeration gos = o.getElements();
        while (gos.hasMoreElements()) {
            GraphObject go = (GraphObject)gos.nextElement();
            if (mapped.contains(go)) continue;
            nonMapped.addElement(go);
        }
        return nonMapped.elements();
    }

    public Enumeration nonMappedImages() {
        Vector<GraphObject> nonMapped = new Vector<GraphObject>();
        Vector mapped = new Vector();
        Graph i = this.getImage();
        Enumeration codomain = this.getCodomain();
        while (codomain.hasMoreElements()) {
            mapped.addElement(codomain.nextElement());
        }
        Enumeration gos = i.getElements();
        while (gos.hasMoreElements()) {
            GraphObject go = (GraphObject)gos.nextElement();
            if (mapped.contains(go)) continue;
            nonMapped.addElement(go);
        }
        return nonMapped.elements();
    }

    public OrdinaryMorphism compose(OrdinaryMorphism input) {
        OrdinaryMorphism output = BaseFactory.theFactory().createMorphism(this.getOriginal(), input.getImage());
        Enumeration thisDom = this.getDomain();
        while (thisDom.hasMoreElements()) {
            GraphObject thisGo = (GraphObject)thisDom.nextElement();
            GraphObject thisGoImage = this.getImage(thisGo);
            GraphObject inputGoImage = input.getImage(thisGoImage);
            if (inputGoImage == null) continue;
            output.addMapping(thisGo, inputGoImage);
        }
        return output;
    }

    public OrdinaryMorphism completeDiagram(OrdinaryMorphism input) {
        if (!input.isInjective()) {
            this.errorMsg = "Completting with non-injective morphism is not possible";
            return null;
        }
        OrdinaryMorphism compl = BaseFactory.theFactory().createMorphism(input.getImage(), this.getImage());
        Enumeration inpDom = input.getDomain();
        while (inpDom.hasMoreElements()) {
            GraphObject inpGo = (GraphObject)inpDom.nextElement();
            GraphObject inpImg = input.getImage(inpGo);
            GraphObject thisImgGo = this.getImage(inpGo);
            compl.addMapping(inpImg, thisImgGo);
            if (compl.getImage(inpImg) != null) continue;
            BaseFactory.theFactory().destroyMorphism(compl);
            return null;
        }
        return compl;
    }

    public Enumeration intersectCoDomains(OrdinaryMorphism input) {
        Vector<GraphObject> intersection = new Vector<GraphObject>();
        Enumeration inpCodom = input.getCodomain();
        Enumeration codomain = this.getCodomain();
        Vector codVector = new Vector();
        while (codomain.hasMoreElements()) {
            codVector.addElement(codomain.nextElement());
        }
        while (inpCodom.hasMoreElements()) {
            GraphObject g = (GraphObject)inpCodom.nextElement();
            if (!codVector.contains(g)) continue;
            intersection.addElement(g);
        }
        return intersection.elements();
    }

    public boolean checkConstants() {
        Graph origGraph = this.getOriginal();
        Enumeration elems = origGraph.getElements();
        if (!elems.hasMoreElements()) {
            return true;
        }
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valOrig.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberImage;
                HandlerExpr exprImage;
                HandlerExpr exprOrig;
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                if (!valOrig.isValueSetAt(name) || (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) == null || !exprOrig.isConstant() || !valImage.isValueSetAt(name) || (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) == null || !exprImage.isConstant() || valMemberOrig.toString().equals(valMemberImage.toString())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkVariables() {
        Graph origGraph = this.getOriginal();
        Enumeration elems = origGraph.getElements();
        if (!elems.hasMoreElements()) {
            return true;
        }
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valOrig.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberImage;
                HandlerExpr exprImage;
                HandlerExpr exprOrig;
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                if (!valOrig.isValueSetAt(name) || (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) == null || !exprOrig.isVariable() || !valImage.isValueSetAt(name) || (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) == null || !exprImage.isVariable() || valMemberOrig.toString().equals(valMemberImage.toString())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkAll() {
        Graph origGraph = this.getOriginal();
        Enumeration elems = origGraph.getElements();
        if (!elems.hasMoreElements()) {
            return true;
        }
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valOrig.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberImage;
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                if (!valOrig.isValueSetAt(name) || !(valMemberOrig = valOrig.getValueMemberAt(name)).isSet() || !valImage.isValueSetAt(name) || !(valMemberImage = valImage.getValueMemberAt(name)).isSet() || valMemberOrig.getExprAsText().equals(valMemberImage.getExprAsText())) continue;
                return false;
            }
        }
        return true;
    }

    public void makeAttributeContext() {
        String varType;
        String varName;
        ValueMember valMem;
        String name;
        int i;
        int n;
        ValueTuple val;
        GraphObject o;
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        Enumeration elems = this.getSource().getElements();
        while (elems.hasMoreElements()) {
            o = (GraphObject)elems.nextElement();
            val = (ValueTuple)o.getAttribute();
            n = val.getNumberOfEntries();
            for (i = 0; i < n; ++i) {
                name = val.getNameAsString(i);
                valMem = val.getValueMemberAt(name);
                if (!val.isValueSetAt(name) || !valMem.isSet() || !valMem.getExpr().isVariable() || vars.getVarMemberAt(varName = valMem.getExprAsText()) != null) continue;
                varType = valMem.getDeclaration().getTypeName();
                vars.declare(valMem.getDeclaration().getHandler(), varType, varName);
            }
        }
        elems = this.getTarget().getElements();
        while (elems.hasMoreElements()) {
            o = (GraphObject)elems.nextElement();
            val = (ValueTuple)o.getAttribute();
            n = val.getNumberOfEntries();
            for (i = 0; i < n; ++i) {
                name = val.getNameAsString(i);
                valMem = val.getValueMemberAt(name);
                if (!val.isValueSetAt(name) || !valMem.isSet() || !valMem.getExpr().isVariable() || vars.getVarMemberAt(varName = valMem.getExprAsText()) != null) continue;
                varType = valMem.getDeclaration().getTypeName();
                vars.declare(valMem.getDeclaration().getHandler(), varType, varName);
            }
        }
    }

    public void fillUpOriginalAttrs() {
        Graph origGraph = this.getOriginal();
        Enumeration elems = origGraph.getElements();
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            if (image == null) continue;
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valOrig.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberImage;
                HandlerExpr exprImage;
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                HandlerExpr exprOrig = null;
                if (valOrig.isValueSetAt(name)) {
                    valMemberOrig = valOrig.getValueMemberAt(name);
                    exprOrig = valMemberOrig.getExpr();
                }
                if (exprOrig != null && exprOrig.isConstant() || !valImage.isValueSetAt(name) || (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) == null && !exprImage.isConstant()) continue;
                valOrig.setExprValueAt(valMemberImage.getExprAsText(), name);
                valOrig.getValueMemberAt(name).setTransient(true);
                valOrig.getValueMemberAt(name).checkValidity();
            }
        }
    }

    public void fillUpImageAttrs() {
        Graph origGraph = this.getOriginal();
        Enumeration elems = origGraph.getElements();
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            if (image == null) continue;
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valImage.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberOrig;
                HandlerExpr exprOrig;
                String name = valImage.getNameAsString(i);
                ValueMember valMemberImage = null;
                HandlerExpr exprImage = null;
                if (valImage.isValueSetAt(name)) {
                    valMemberImage = valImage.getValueMemberAt(name);
                    exprImage = valMemberImage.getExpr();
                }
                if (exprImage != null && exprImage.isConstant() || !valOrig.isValueSetAt(name) || (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) == null && !exprOrig.isConstant()) continue;
                valImage.setExprValueAt(valMemberOrig.getExprAsText(), name);
                valImage.getValueMemberAt(name).setTransient(true);
                valImage.getValueMemberAt(name).checkValidity();
            }
        }
    }

    public void fillUpAllOriginalAttrs() {
        Enumeration elems = this.getOriginal().getElements();
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            if (image == null) {
                Enumeration elems1 = this.getImage().getElements();
                while (elems1.hasMoreElements()) {
                    GraphObject og = (GraphObject)elems1.nextElement();
                    if (!this.checkType(orig.getType(), image.getType())) continue;
                    image = og;
                    break;
                }
            }
            if (image == null) continue;
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valOrig.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberImage;
                HandlerExpr exprImage;
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                HandlerExpr exprOrig = null;
                if (valOrig.isValueSetAt(name)) {
                    valMemberOrig = valOrig.getValueMemberAt(name);
                    exprOrig = valMemberOrig.getExpr();
                }
                if (!valImage.isValueSetAt(name) || (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) == null && !exprImage.isConstant()) continue;
                valOrig.setExprValueAt(valMemberImage.getExprAsText(), name);
            }
        }
    }

    public void fillUpAllImageAttrs() {
        Enumeration elems = this.getOriginal().getElements();
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            GraphObject image = this.getImage(orig);
            if (image == null) {
                Enumeration elems1 = this.getImage().getElements();
                while (elems1.hasMoreElements()) {
                    GraphObject og = (GraphObject)elems1.nextElement();
                    if (!this.checkType(orig.getType(), image.getType())) continue;
                    image = og;
                    break;
                }
            }
            if (image == null) continue;
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valImage.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                ValueMember valMemberOrig;
                HandlerExpr exprOrig;
                String name = valImage.getNameAsString(i);
                ValueMember valMemberImage = null;
                HandlerExpr exprImage = null;
                if (valImage.isValueSetAt(name)) {
                    valMemberImage = valImage.getValueMemberAt(name);
                    exprImage = valMemberImage.getExpr();
                }
                if (!valOrig.isValueSetAt(name) || (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) == null && !exprOrig.isConstant()) continue;
                valImage.setExprValueAt(valMemberOrig.getExprAsText(), name);
                valImage.getValueMemberAt(name).setTransient(true);
            }
        }
    }

    public void unsetOriginalAttrsIfExpression() {
        Graph origGraph = this.getOriginal();
        Enumeration elems = origGraph.getElements();
        while (elems.hasMoreElements()) {
            GraphObject orig = (GraphObject)elems.nextElement();
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            int n = valOrig.getNumberOfEntries();
            for (int i = 0; i < n; ++i) {
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                HandlerExpr exprOrig = null;
                if (valOrig.isValueSetAt(name)) {
                    valMemberOrig = valOrig.getValueMemberAt(name);
                    exprOrig = valMemberOrig.getExpr();
                }
                if (exprOrig == null || !exprOrig.isComplex()) continue;
                valMemberOrig.setExpr(null);
            }
        }
    }

    public void fillUpAttrContext(AttrContext other) {
        if (other == null || this.getAttrContext() == null) {
            return;
        }
        VarTuple avt = (VarTuple)this.getAttrContext().getVariables();
        VarTuple avtOther = (VarTuple)other.getVariables();
        int nn = avtOther.getNumberOfEntries();
        for (int i = 0; i < nn; ++i) {
            VarMember avmOther = avtOther.getVarMemberAt(i);
            String name = avtOther.getNameAsString(i);
            VarMember avm = avt.getVarMemberAt(name);
            if (avm == null || !avmOther.isSet() || !avmOther.getExpr().isConstant()) continue;
            avm.setExprAsText(avmOther.getExprAsText());
        }
    }

    public void copyAttrContext(AttrContext other) {
        if (other == null || this.getAttrContext() == null) {
            return;
        }
        ContextView context = (ContextView)this.getAttrContext();
        ContextView contextOther = (ContextView)other;
        VarTuple avt = (VarTuple)context.getVariables();
        VarTuple avtOther = (VarTuple)contextOther.getVariables();
        int nn = avtOther.getNumberOfEntries();
        for (int i = 0; i < nn; ++i) {
            VarMember avmOther = avtOther.getVarMemberAt(i);
            String name = avtOther.getNameAsString(i);
            VarMember avm = avt.getVarMemberAt(name);
            if (avm != null) {
                if (avmOther.isSet() && avmOther.getExpr().isConstant()) {
                    avm.setExprAsText(avmOther.getExprAsText());
                }
                if (!avmOther.isInputParameter()) continue;
                avm.setInputParameter(true);
                continue;
            }
            DeclMember dm = (DeclMember)avmOther.getDeclaration();
            avt.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
            VarMember newMember = avt.getVarMemberAt(dm.getName());
            if (newMember != null && avmOther.getExpr() != null && avmOther.getExpr().isConstant()) {
                ((ValueMember)newMember).setExprAsText(avmOther.getExprAsText());
            }
            if (!avmOther.isInputParameter()) continue;
            avt.getVarMemberAt(dm.getName()).setInputParameter(true);
        }
    }

    public Hashtable getUsageOfInputParameters(AttrContext attrContext) {
        Hashtable ht = new Hashtable();
        Vector<Type> tmp = new Vector<Type>();
        if (this instanceof SubRule) {
            // empty if block
        }
        if (attrContext == null) {
            return ht;
        }
        VarTuple avt = (VarTuple)attrContext.getVariables();
        if (avt == null) {
            return ht;
        }
        for (int i = 0; i < avt.getSize(); ++i) {
            ValueMember vm;
            int j;
            ValueTuple vt;
            GraphObject go;
            VarMember avm = avt.getVarMemberAt(i);
            if (avm.getExpr() == null) {
                return ht;
            }
            Vector<Pair> v = new Vector<Pair>();
            if (!avm.isInputParameter()) continue;
            Enumeration en = this.getSource().getElements();
            while (en.hasMoreElements()) {
                go = (GraphObject)en.nextElement();
                vt = (ValueTuple)go.getAttribute();
                if (vt == null) {
                    return ht;
                }
                for (j = 0; j < vt.getSize(); ++j) {
                    vm = vt.getValueMemberAt(j);
                    if (vm.getExpr() == null || !vm.getExpr().isVariable() || !vm.getExprAsText().equals(avm.getDeclaration().getName())) continue;
                    v.addElement(new Pair(vm, go.getType()));
                    tmp.addElement(go.getType());
                }
            }
            en = this.getTarget().getElements();
            while (en.hasMoreElements()) {
                go = (GraphObject)en.nextElement();
                vt = (ValueTuple)go.getAttribute();
                if (vt == null) {
                    return ht;
                }
                for (j = 0; j < vt.getSize(); ++j) {
                    vm = vt.getValueMemberAt(j);
                    if (vm.getExpr() == null || !vm.getExpr().isVariable() || !vm.getExprAsText().equals(avm.getDeclaration().getName()) || !tmp.isEmpty() && tmp.contains(go.getType())) continue;
                    v.addElement(new Pair(vm, go.getType()));
                    tmp.addElement(go.getType());
                }
            }
            if (v.size() == 0) continue;
            ht.put(avm, v);
        }
        return ht;
    }

    public Enumeration getOverlappings(Object other, boolean left, boolean union) {
        return this.getOverlappingsVector(other, left, union).elements();
    }

    public Vector getOverlappingsVector(Object other, boolean left, boolean union) {
        Vector<Pair> oSet = new Vector<Pair>();
        int minGraphSize = 0;
        minGraphSize = union ? 0 : 1;
        Graph left2 = null;
        if (other instanceof OrdinaryMorphism && left) {
            left2 = ((OrdinaryMorphism)other).getSource();
        } else if (other instanceof OrdinaryMorphism && !left) {
            left2 = ((OrdinaryMorphism)other).getTarget();
        } else if (other instanceof Graph) {
            left2 = (Graph)other;
        }
        for (int sizeOfInclusions = left2.getSize(); sizeOfInclusions >= minGraphSize; --sizeOfInclusions) {
            Enumeration overlapping = this.getOverlappings(other, left, sizeOfInclusions, union);
            while (overlapping.hasMoreElements()) {
                oSet.addElement((Pair)overlapping.nextElement());
            }
        }
        return oSet;
    }

    public Enumeration getOverlappings(Object other, boolean left, int sizeOfInclusions, boolean union) {
        return this.getOverlappingsVector(other, left, sizeOfInclusions, union).elements();
    }

    public Vector getOverlappingsVector(Object other, boolean left, int sizeOfInclusions, boolean union) {
        Vector<Pair> oSet = new Vector<Pair>();
        Vector subs = new Vector();
        Enumeration itsGOs = null;
        itsGOs = left ? this.getSource().getElements() : this.getTarget().getElements();
        Vector<GraphObject> itsGOSet = new Vector<GraphObject>();
        boolean nextMatch = true;
        int minGraphSize = union ? 0 : 1;
        while (itsGOs.hasMoreElements()) {
            itsGOSet.addElement((GraphObject)itsGOs.nextElement());
        }
        if (sizeOfInclusions < minGraphSize) {
            itsGOSet.clear();
            itsGOSet = null;
            return oSet;
        }
        boolean withIsomorphicInclusions = true;
        subs = this.getSource().generateAllSubgraphsWithInclusionsOfSize(sizeOfInclusions, itsGOSet, subs, withIsomorphicInclusions);
        boolean injective = true;
        Completion_InjCSP strategy = new Completion_InjCSP();
        for (int j = 0; j < subs.size(); ++j) {
            OrdinaryMorphism h = (OrdinaryMorphism)subs.elementAt(j);
            Pair rulePair = BaseFactory.theFactory().constructIsomorphicRule(h);
            Rule r = (Rule)rulePair.first;
            OrdinaryMorphism tmpG = (OrdinaryMorphism)((Pair)rulePair.second).second;
            AttrContext ac = r.getAttrContext();
            AttrVariableTuple avt = ac.getVariables();
            AttrSession.logAttrInstance(AttrSession.logTrace, avt, "");
            AttrSession.logAttrContext(AttrSession.logTrace, ac, "Rulecontext");
            int co = 1;
            Completion_SimpleBT localStrategy = new Completion_SimpleBT(true);
            nextMatch = true;
            while (nextMatch) {
                OrdinaryMorphism rStar = null;
                if (other instanceof OrdinaryMorphism && left) {
                    rStar = ((OrdinaryMorphism)other).getSource().isoToCopy(2);
                } else if (other instanceof OrdinaryMorphism && !left) {
                    rStar = ((OrdinaryMorphism)other).getTarget().isoToCopy(2);
                } else if (other instanceof Graph) {
                    rStar = ((Graph)other).isoToCopy(2);
                }
                Match m = BaseFactory.theFactory().createMatch(r, rStar.getImage(), true, "1");
                m.setCompletionStrategy(localStrategy);
                for (int k = 1; k <= co; ++k) {
                    nextMatch = m.nextCompletion();
                    Debug.printlnGraph(rStar.getImage(), "Arbeitsgraph rStar.getImage()", Debug.PARSING);
                    Debug.printlnMorph(h, "Morphismus fuer Regel", Debug.PARSING);
                    Debug.printlnMorph(m, "Match", Debug.PARSING);
                }
                if (nextMatch && m.isValid(true)) {
                    Step s = new Step();
                    try {
                        OrdinaryMorphism ms = null;
                        OrdinaryMorphism morph = (OrdinaryMorphism)s.execute(m, true);
                        if (morph != null) {
                            ms = morph;
                        }
                        Debug.printlnGraph(rStar.getImage(), "Arbeitsgraph rStar.getImage()", Debug.PARSING);
                        if (ms != null) {
                            OrdinaryMorphism mStar = null;
                            tmpG.setCompletionStrategy(strategy);
                            mStar = tmpG.compose(ms);
                            BaseFactory.theFactory().destroyMorphism(ms);
                            morph = null;
                            ms = null;
                            if (mStar != null && rStar != null) {
                                Rule r1 = null;
                                Match m1 = null;
                                Pair p = null;
                                if (this instanceof Rule) {
                                    r1 = (Rule)this;
                                    m1 = BaseFactory.theFactory().createMatch(r1, mStar.getTarget());
                                    m1.setCompletionStrategy(strategy);
                                    if (!m1.nextCompletion() || !m1.isValid(true)) {
                                        BaseFactory.theFactory().destroyMorphism(m1);
                                        m1 = null;
                                    }
                                }
                                Rule r2 = null;
                                Match m2 = null;
                                if (other instanceof Rule) {
                                    r2 = (Rule)other;
                                    m2 = BaseFactory.theFactory().createMatch(r2, mStar.getTarget());
                                    m2.setCompletionStrategy(strategy);
                                    if (!m2.nextCompletion() || !m2.isValid(true)) {
                                        BaseFactory.theFactory().destroyMorphism(m2);
                                        m2 = null;
                                    }
                                }
                                if (this instanceof Rule && other instanceof Rule) {
                                    if (m1 != null && m2 != null) {
                                        p = new Pair(mStar, rStar);
                                        boolean isIsomorphic = false;
                                        if (!this.isIsomorphicOverlapping(oSet, p)) {
                                            oSet.addElement(p);
                                        } else {
                                            isIsomorphic = true;
                                        }
                                        BaseFactory.theFactory().destroyMorphism(m1);
                                        m1 = null;
                                        BaseFactory.theFactory().destroyMorphism(m2);
                                        m2 = null;
                                        if (isIsomorphic) {
                                            p = null;
                                        }
                                    }
                                } else if (other instanceof Rule) {
                                    if (m2 != null) {
                                        p = new Pair(mStar, rStar);
                                        boolean isIsomorphic = false;
                                        if (!this.isIsomorphicOverlapping(oSet, p)) {
                                            oSet.addElement(p);
                                        } else {
                                            isIsomorphic = true;
                                        }
                                        BaseFactory.theFactory().destroyMorphism(m2);
                                        m2 = null;
                                        if (isIsomorphic) {
                                            p = null;
                                        }
                                    }
                                } else if (this instanceof Rule) {
                                    if (m1 != null) {
                                        p = new Pair(mStar, rStar);
                                        boolean isIsomorphic = false;
                                        if (!this.isIsomorphicOverlapping(oSet, p)) {
                                            oSet.addElement(p);
                                        } else {
                                            isIsomorphic = true;
                                        }
                                        BaseFactory.theFactory().destroyMorphism(m1);
                                        m1 = null;
                                        if (isIsomorphic) {
                                            p = null;
                                        }
                                    }
                                } else {
                                    p = new Pair(mStar, rStar);
                                    if (!this.isIsomorphicOverlapping(oSet, p)) {
                                        oSet.addElement(p);
                                    } else {
                                        p = null;
                                    }
                                }
                                if (p == null) {
                                    Graph tmp = rStar.getSource();
                                    BaseFactory.theFactory().destroyMorphism(mStar);
                                    mStar = null;
                                    BaseFactory.theFactory().destroyMorphism(rStar);
                                    rStar = null;
                                }
                            } else {
                                Graph tmp = rStar.getSource();
                                BaseFactory.theFactory().destroyMorphism(rStar);
                                rStar = null;
                            }
                        }
                    }
                    catch (TypeException e) {
                        // empty catch block
                    }
                    s = null;
                    ++co;
                } else {
                    nextMatch = false;
                    Graph tmp = rStar.getSource();
                    BaseFactory.theFactory().destroyMorphism(rStar);
                    rStar = null;
                }
                m.dispose();
                m = null;
            }
            subs.removeElement(h);
            --j;
            ((MorphCompletionStrategy)localStrategy).reset();
            localStrategy = null;
            OrdinaryMorphism h1 = (OrdinaryMorphism)((Pair)rulePair.second).first;
            OrdinaryMorphism h2 = (OrdinaryMorphism)((Pair)rulePair.second).second;
            Graph tmp1 = r.getSource();
            Graph tmp2 = r.getTarget();
            Graph tmp3 = h.getSource();
            h1.dispose();
            h2.dispose();
            r.dispose();
            h.dispose();
            tmpG.dispose();
            tmp1.dispose();
            tmp1 = null;
            tmp2.dispose();
            tmp2 = null;
            tmp3.dispose();
            tmp3 = null;
            r = null;
            h = null;
            h1 = null;
            h2 = null;
            tmpG = null;
            rulePair = null;
            System.gc();
        }
        return oSet;
    }

    private boolean isIsomorphicOverlapping(Vector overlapGraphs, Pair overlapPair) {
        Graph overlapGraph = ((OrdinaryMorphism)overlapPair.first).getTarget();
        for (int j = 0; j < overlapGraphs.size(); ++j) {
            Pair pj = (Pair)overlapGraphs.elementAt(j);
            Graph gj = ((OrdinaryMorphism)pj.first).getTarget();
            if (!gj.isIsomorphicWith(overlapGraph) || !((OrdinaryMorphism)pj.first).isIsomorphicTo((OrdinaryMorphism)overlapPair.first) || !((OrdinaryMorphism)pj.second).isIsomorphicTo((OrdinaryMorphism)overlapPair.second)) continue;
            return true;
        }
        return false;
    }

    public void setCoMorphism(OrdinaryMorphism aCoMorph) {
        this.itsCoMorph = aCoMorph;
    }

    public OrdinaryMorphism getCoMorphism() {
        return this.itsCoMorph;
    }

    public void showMe() {
        System.out.println("********");
        System.out.println("myOriginal :   " + this.getOriginal());
        System.out.println("myImage    :   " + this.getImage());
        System.out.println("********");
    }

    public void showVariables() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        vars.showVariables();
    }

    public int getSize() {
        return this.itsSize;
    }

    public boolean compareTo(OrdinaryMorphism morph) {
        String errMsgHolder = null;
        if (!this.getSource().compareTo(morph.getSource())) {
            errMsgHolder = errMsgHolder + "LHS is different";
            return false;
        }
        if (!this.getTarget().compareTo(morph.getTarget())) {
            errMsgHolder = errMsgHolder + "RHS is different";
            return false;
        }
        Enumeration e = morph.getDomain();
        Vector<GraphObject> another = new Vector<GraphObject>();
        while (e.hasMoreElements()) {
            another.add((GraphObject)e.nextElement());
        }
        if (this.itsDomObjects.size() != another.size()) {
            return false;
        }
        block1: for (int i = 0; i < this.itsDomObjects.size(); ++i) {
            GraphObject obj = (GraphObject)this.itsDomObjects.elementAt(i);
            GraphObject img = this.getImage(obj);
            for (int j = another.size() - 1; j >= 0; --j) {
                GraphObject obj1 = (GraphObject)another.elementAt(j);
                if (!obj.compareTo(obj1)) continue;
                GraphObject img1 = morph.getImage(obj1);
                if (img == null && img1 == null) {
                    another.remove(obj1);
                    continue block1;
                }
                if (img != null && img1 == null || img == null && img1 != null || !img.compareTo(img1)) continue;
                another.remove(obj1);
                continue block1;
            }
        }
        if (another.size() != 0) {
            errMsgHolder = errMsgHolder + "Morphism mapping is different";
            return false;
        }
        return true;
    }

    public Vector getVariableDeclarations() {
        Pair pj;
        int j;
        boolean found;
        Pair p;
        String t;
        String n;
        ValueMember vm;
        int k;
        ValueTuple vt;
        AttrInstance attr;
        GraphObject o;
        Vector<Pair> varDecls = new Vector<Pair>(2);
        Graph g = this.getOriginal();
        Enumeration en = g.getElements();
        while (en.hasMoreElements()) {
            o = (GraphObject)en.nextElement();
            attr = o.getAttribute();
            vt = (ValueTuple)attr;
            for (k = 0; k < vt.getSize(); ++k) {
                vm = vt.getValueMemberAt(k);
                if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                n = vm.getExprAsText();
                t = vm.getDeclaration().getTypeName();
                p = new Pair(t, n);
                found = false;
                for (j = 0; j < varDecls.size(); ++j) {
                    pj = (Pair)varDecls.elementAt(j);
                    if (!t.equals((String)pj.first) || !n.equals((String)pj.second)) continue;
                    found = true;
                }
                if (found) continue;
                varDecls.addElement(p);
            }
        }
        g = this.getImage();
        en = g.getElements();
        while (en.hasMoreElements()) {
            o = (GraphObject)en.nextElement();
            attr = o.getAttribute();
            vt = (ValueTuple)attr;
            for (k = 0; k < vt.getSize(); ++k) {
                vm = vt.getValueMemberAt(k);
                if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                n = vm.getExprAsText();
                t = vm.getDeclaration().getTypeName();
                p = new Pair(t, n);
                found = false;
                for (j = 0; j < varDecls.size(); ++j) {
                    pj = (Pair)varDecls.elementAt(j);
                    if (!t.equals((String)pj.first) || !n.equals((String)pj.second)) continue;
                    found = true;
                }
                if (found) continue;
                varDecls.addElement(p);
            }
        }
        en = g.getElements();
        while (en.hasMoreElements()) {
            o = (GraphObject)en.nextElement();
            attr = o.getAttribute();
            vt = (ValueTuple)attr;
            for (k = 0; k < vt.getSize(); ++k) {
                Vector vec;
                vm = vt.getValueMemberAt(k);
                if (!vm.isSet() || !vm.getExpr().isComplex() || (vec = vm.getAllVariableNamesOfExpression()).size() == 0) continue;
                for (int l = 0; l < vec.size(); ++l) {
                    p = null;
                    String n2 = (String)vec.elementAt(l);
                    String t2 = "";
                    VarMember var = this.getAttrContext().getVariables().getVarMemberAt(n2);
                    if (var != null && var.getDeclaration() != null) {
                        t2 = var.getDeclaration().getTypeName();
                        p = new Pair(t2, n2);
                    } else {
                        String className = this.isClassName(n2);
                        if (className != null) {
                            t2 = className;
                            p = new Pair(t2, n2);
                        } else {
                            p = new Pair(t2, n2);
                        }
                    }
                    if (p == null) continue;
                    boolean found2 = false;
                    for (int j2 = 0; j2 < varDecls.size(); ++j2) {
                        Pair pj2 = (Pair)varDecls.elementAt(j2);
                        if (!t2.equals((String)pj2.first) || !n2.equals((String)pj2.second)) continue;
                        found2 = true;
                    }
                    if (found2) continue;
                    varDecls.addElement(p);
                }
            }
        }
        return varDecls;
    }

    public String isClassName(String name) {
        String result = null;
        ClassResolver classResolver = new ClassResolver();
        Class c = classResolver.forName(name);
        if (c != null) {
            result = c.getName();
        }
        return result;
    }

    public Vector getUsedTypes() {
        GraphObject o;
        Vector<Type> vec = new Vector<Type>();
        Enumeration en = this.itsOrig.getElements();
        while (en.hasMoreElements()) {
            o = (GraphObject)en.nextElement();
            if (vec.contains(o.getType())) continue;
            vec.add(o.getType());
        }
        en = this.itsImag.getElements();
        while (en.hasMoreElements()) {
            o = (GraphObject)en.nextElement();
            if (vec.contains(o.getType())) continue;
            vec.add(o.getType());
        }
        return vec;
    }

    protected int getSourceGraphSize() {
        this.itsSourceGraphSize = 0;
        if (this.getOriginal() != null) {
            Enumeration anEnum = this.getOriginal().getNodes();
            while (anEnum.hasMoreElements()) {
                anEnum.nextElement();
                ++this.itsSourceGraphSize;
            }
            anEnum = this.getOriginal().getArcs();
            while (anEnum.hasMoreElements()) {
                anEnum.nextElement();
                ++this.itsSourceGraphSize;
            }
        }
        return this.itsSourceGraphSize;
    }

    protected final void propagateChange(Change ch) {
        this.setChanged();
        this.notifyObservers(ch);
    }

    protected boolean areSameVariablesUsed() {
        AttrContext ac = this.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        Hashtable<VarMember, Boolean> used = new Hashtable<VarMember, Boolean>(avt.getSize());
        for (int i = 0; i < avt.getSize(); ++i) {
            VarMember var = avt.getVarMemberAt(i);
            used.put(var, new Boolean(false));
        }
        Vector<VarMember> result = new Vector<VarMember>();
        Enumeration e = this.itsOrig.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            for (int k = 0; k < vt.getSize(); ++k) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                VarMember var = avt.getVarMemberAt(vm.getExprAsText());
                if (!((Boolean)used.get(var)).booleanValue()) {
                    used.put(var, new Boolean(true));
                    continue;
                }
                if (result.contains(var)) continue;
                result.add(var);
            }
        }
        return result.size() != 0;
    }
}

