/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrInstance;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.SubGraph;
import java.util.Enumeration;
import java.util.Vector;

public class OrdinarySubMorphism
extends OrdinaryMorphism {
    private OrdinaryMorphism itsSuperMorph;
    private SubGraph itsSubOrig;
    private SubGraph itsSubImg;
    private Vector itsDomObjects;
    private Vector itsCodomObjects;

    protected OrdinarySubMorphism(OrdinaryMorphism supermorph) {
        this(supermorph, null, null);
    }

    public OrdinarySubMorphism(OrdinaryMorphism supermorph, SubGraph orig, SubGraph img) {
        super(orig, img, supermorph.getAttrContext());
        this.itsSubOrig = orig;
        this.itsSubImg = img;
        this.itsDomObjects = new Vector();
        this.itsCodomObjects = new Vector();
        this.itsSuperMorph = supermorph;
        if (orig != null) {
            Enumeration allOrigObjects = orig.getElements();
            while (allOrigObjects.hasMoreElements()) {
                GraphObject anObj = (GraphObject)allOrigObjects.nextElement();
                this.makeCommute(anObj);
            }
        }
    }

    private final void makeCommute(GraphObject obj) {
        GraphObject anImg = this.itsSuperMorph.getImage(obj);
        if (anImg != null) {
            if (!this.itsSubImg.isElement(anImg)) {
                this.itsSubImg.addObject(anImg);
            }
            this.addMapping(obj, anImg);
        }
    }

    public final OrdinaryMorphism getSuperMorphism() {
        return this.itsSuperMorph;
    }

    public Graph getOriginal() {
        return this.itsSubOrig;
    }

    public Graph getImage() {
        return this.itsSubImg;
    }

    public Enumeration getDomain() {
        return this.itsDomObjects.elements();
    }

    public Enumeration getCodomain() {
        return this.itsCodomObjects.elements();
    }

    public GraphObject getImage(GraphObject o) {
        GraphObject result = null;
        int i = this.itsDomObjects.indexOf(o);
        if (i > -1) {
            result = (GraphObject)this.itsCodomObjects.elementAt(i);
        }
        return result;
    }

    public Enumeration getInverseImage(GraphObject o) {
        int index;
        Vector invImages = new Vector();
        int i = 0;
        while (i < this.itsCodomObjects.size() && (index = this.itsCodomObjects.indexOf(o, i)) != -1) {
            invImages.addElement(this.itsDomObjects.elementAt(index));
            i = index + 1;
        }
        return invImages.elements();
    }

    public void addMapping(GraphObject o, GraphObject i) throws BadMappingException {
        if (this.itsSuperMorph.getImage(o) != i) {
            this.itsSuperMorph.addMapping(o, i);
        }
        this.itsDomObjects.addElement(o);
        this.itsCodomObjects.addElement(i);
    }

    public void removeMapping(GraphObject o) {
        this.itsSuperMorph.removeMapping(o);
        this.itsDomObjects.remove(o);
        this.itsCodomObjects.remove(this.getImage(o));
    }

    protected void addAttrMapping(AttrInstance o, AttrInstance i) {
        this.itsSuperMorph.addAttrMapping(o, i);
    }

    protected void removeAttrMapping(AttrInstance o) {
        this.itsSuperMorph.removeAttrMapping(o);
    }
}

