/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.Convert;
import agg.cons.EvalSet;
import agg.cons.Formula;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.SubGraGra;
import agg.xt_basis.SubGraph;
import agg.xt_basis.SubRule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Rule
extends OrdinaryMorphism
implements XMLObject {
    protected Vector itsNACs = new Vector(1, 1);
    protected Vector itsSubRules = new Vector(1, 2);
    protected int layer;
    protected boolean triggerOfLayer = false;
    protected String errorMsg;
    protected Vector itsUsedAtomics;
    protected Vector itsUsedFormulas;
    protected transient Vector setNames;
    protected transient Vector constraints;
    protected transient Vector atom_conds;
    protected transient boolean generatePostConstraints;
    protected transient boolean isApplicable;
    protected transient Vector doneMatches;
    protected transient boolean isReady;
    protected transient boolean isDeleting;
    protected transient boolean isCreating;
    protected transient Vector preserved;
    protected transient Vector deleted;
    protected transient Vector created;

    protected Rule() {
        this.setName("Rule");
        this.getOriginal().setName("Left");
        this.getImage().setName("Right");
        AttrContext aRuleContext = this.getAttrManager().newContext(0);
        this.setAttrContext(aRuleContext);
        AttrContext leftContext = this.getAttrManager().newLeftContext(aRuleContext);
        this.getOriginal().setAttrContext(leftContext);
        AttrContext rightContext = this.getAttrManager().newRightContext(aRuleContext);
        this.getImage().setAttrContext(rightContext);
        this.itsUsedAtomics = new Vector();
        this.itsUsedFormulas = new Vector();
        this.constraints = new Vector();
        this.atom_conds = new Vector();
        this.generatePostConstraints = true;
        this.isApplicable = true;
        this.doneMatches = new Vector();
    }

    protected Rule(TypeSet types) {
        this();
        this.getOriginal().setTypeSet(types);
        this.getImage().setTypeSet(types);
    }

    protected Rule(Graph left, Graph right) {
        super(left, right);
        this.setName("Rule");
        this.getOriginal().setName("Left");
        this.getImage().setName("Right");
        AttrContext aRuleContext = this.getAttrManager().newContext(0);
        this.setAttrContext(aRuleContext);
        AttrContext leftContext = this.getAttrManager().newLeftContext(aRuleContext);
        this.getOriginal().setAttrContext(leftContext);
        AttrContext rightContext = this.getAttrManager().newRightContext(aRuleContext);
        this.getImage().setAttrContext(rightContext);
        this.itsUsedAtomics = new Vector();
        this.itsUsedFormulas = new Vector();
        this.constraints = new Vector();
        this.atom_conds = new Vector();
        this.generatePostConstraints = true;
        this.isApplicable = true;
        this.doneMatches = new Vector();
    }

    public final Graph getLeft() {
        return this.getOriginal();
    }

    public final Graph getRight() {
        return this.getImage();
    }

    public boolean isApplicable() {
        return this.isApplicable;
    }

    public void setApplicable(boolean applicable) {
        this.isApplicable = applicable;
    }

    public OrdinaryMorphism createNAC() {
        OrdinaryMorphism aNAC = new OrdinaryMorphism(this.getLeft(), new Graph(this.getLeft().getTypeSet()), this.getLeft().getAttrContext());
        this.itsNACs.addElement(aNAC);
        AttrContext nacContext = this.getLeft().getAttrContext();
        aNAC.getImage().setAttrContext(nacContext);
        aNAC.getImage().setNacGraph(true);
        return aNAC;
    }

    public boolean addNAC(OrdinaryMorphism aNAC) {
        if (!this.itsNACs.contains(aNAC)) {
            this.itsNACs.addElement(aNAC);
            return true;
        }
        return false;
    }

    public void destroyNAC(OrdinaryMorphism nac) {
        this.itsNACs.removeElement(nac);
        nac.getImage().dispose();
    }

    public final Enumeration getNACs() {
        return this.itsNACs.elements();
    }

    public OrdinaryMorphism getNAC(String name) {
        for (int i = 0; i < this.itsNACs.size(); ++i) {
            OrdinaryMorphism nac = (OrdinaryMorphism)this.itsNACs.get(i);
            if (!nac.getName().equals(name)) continue;
            return nac;
        }
        return null;
    }

    public final boolean removeNAC(OrdinaryMorphism nac) {
        return this.itsNACs.removeElement(nac);
    }

    public boolean destroyObjectsOfType(Type t) {
        if (this.getLeft().destroyObjectsOfType(t) && this.getRight().destroyObjectsOfType(t)) {
            for (int j = 0; j < this.itsNACs.size(); ++j) {
                OrdinaryMorphism nac = (OrdinaryMorphism)this.itsNACs.get(j);
                if (nac.getTarget().destroyObjectsOfType(t)) continue;
                return false;
            }
            Vector atom_conds = this.getAtomApplConds();
            for (int i = 0; i < atom_conds.size(); ++i) {
                Vector v = ((EvalSet)atom_conds.get(i)).getSet();
                for (int j = 0; j < v.size(); ++j) {
                    Vector v1 = ((EvalSet)v.get(j)).getSet();
                    for (int k = 0; k < v1.size(); ++k) {
                        AtomApplCond aac = (AtomApplCond)v1.get(k);
                        OrdinaryMorphism cond = aac.getPreCondition();
                        OrdinaryMorphism tm = aac.getT();
                        OrdinaryMorphism qm = aac.getQ();
                        cond.getSource().destroyObjectsOfType(t);
                        cond.getTarget().destroyObjectsOfType(t);
                        tm.getTarget().destroyObjectsOfType(t);
                        qm.getSource().destroyObjectsOfType(t);
                    }
                }
            }
        }
        return true;
    }

    public Vector destroyObjectsOfTypes(Vector types) {
        Vector<String> failed = new Vector<String>(5);
        for (int i = 0; i < types.size(); ++i) {
            Type t = (Type)types.get(i);
            if (this.destroyObjectsOfType(t)) continue;
            String s = "Rule:  " + this.getName() + "   Type:  " + t.getName();
            failed.add(s);
        }
        return failed;
    }

    public Rule getClone() {
        return BaseFactory.theFactory().cloneRule(this);
    }

    public final OrdinaryMorphism getMorphism() {
        return this;
    }

    public Vector getConstraints() {
        return this.constraints;
    }

    public void addConstraint(Formula f) {
        this.constraints.add(f);
    }

    protected boolean checkType(Type orig, Type image) {
        return orig.compareTo(image);
    }

    public String convertUsedFormulas() {
        int j;
        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(true);
        String msg = "";
        if (this.itsUsedAtomics.size() <= 0 || this.itsUsedFormulas.size() <= 0) {
            msg = "Post application condition are not created. \nMaybe they are not needed \nbecause the formula is always true.";
            return msg;
        }
        boolean broken = false;
        Vector<EvalSet> fin = new Vector<EvalSet>();
        Vector<String> names = new Vector<String>();
        this.constraints = new Vector();
        this.setAtomApplConds(null, null);
        for (j = 0; j < this.itsUsedAtomics.size(); ++j) {
            AtomConstraint a = (AtomConstraint)this.itsUsedAtomics.elementAt(j);
            if (!a.isValid()) {
                msg = "Atomic  \"" + a.getAtomicName() + "\"  is not valid";
                this.itsUsedAtomics = new Vector();
                this.itsUsedFormulas = new Vector();
                return msg;
            }
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(true);
            Convert conv = new Convert(this, a);
            Vector v = conv.convert();
            EvalSet set = new EvalSet(v);
            fin.add(set);
            names.add(a.getAtomicName());
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        }
        this.setAtomApplConds(fin, names);
        for (j = 0; j < this.itsUsedFormulas.size(); ++j) {
            Formula f = (Formula)this.itsUsedFormulas.elementAt(j);
            Vector v = new Vector();
            String s = f.getAsString(v);
            Vector v2 = new Vector();
            for (int k = 0; k < v.size(); ++k) {
                int k2;
                Object e = v.get(k);
                for (k2 = 0; k2 < this.itsUsedAtomics.size(); ++k2) {
                    if (this.itsUsedAtomics.get(k2) != e) continue;
                    v2.add(fin.get(k2));
                    break;
                }
                if (k2 != this.itsUsedAtomics.size()) continue;
                System.err.println("Rule.convertUsedFormulas: Inconsistent set of atomics");
            }
            Formula f2 = new Formula(v2, s);
            this.addConstraint(f2);
        }
        return msg;
    }

    public void setUsedFormulas(Vector usedFormulas) {
        if (usedFormulas.isEmpty()) {
            return;
        }
        this.itsUsedFormulas = usedFormulas;
        this.itsUsedAtomics = new Vector();
        for (int i = 0; i < this.itsUsedFormulas.size(); ++i) {
            Formula f = (Formula)this.itsUsedFormulas.get(i);
            Vector vec = new Vector();
            String form = f.getAsString(vec);
            for (int j = 0; j < vec.size(); ++j) {
                AtomConstraint ac = (AtomConstraint)vec.get(j);
                this.itsUsedAtomics.addElement(ac);
            }
        }
    }

    public Vector getUsedAtomics() {
        return this.itsUsedAtomics;
    }

    public Vector getUsedFormulas() {
        return this.itsUsedFormulas;
    }

    public void clearConstraints() {
        this.itsUsedAtomics = new Vector();
        this.itsUsedFormulas = new Vector();
        this.constraints = new Vector();
        this.setAtomApplConds(null, null);
    }

    public void setAtomApplConds(Vector v, Vector names) {
        this.atom_conds = v == null ? new Vector() : v;
        this.setNames = names == null ? new Vector() : names;
        if (this.setNames.size() < this.atom_conds.size()) {
            for (int i = this.setNames.size(); i < this.atom_conds.size(); ++i) {
                this.setNames.add("Unknown Name " + i);
            }
        }
        this.setNames.setSize(this.atom_conds.size());
    }

    public Vector getAtomApplConds() {
        return this.atom_conds;
    }

    public Vector getNames() {
        return this.setNames;
    }

    public void removeConstraint(EvalSet constraint) {
        if (this.atom_conds.contains(constraint)) {
            int i = this.atom_conds.indexOf(constraint);
            this.atom_conds.removeElement(constraint);
            this.setNames.removeElementAt(i);
        }
    }

    public void removeAtomApplCond(AtomApplCond atom) {
        int i = 0;
        while (i < this.atom_conds.size()) {
            Vector v = ((EvalSet)this.atom_conds.get(i)).getSet();
            int j = 0;
            while (j < v.size()) {
                Vector v1 = ((EvalSet)v.get(j)).getSet();
                int k = 0;
                while (k < v1.size()) {
                    AtomApplCond aac = (AtomApplCond)v1.get(k);
                    if (atom.equals(aac)) {
                        v1.removeElement(atom);
                        k = v1.size();
                        continue;
                    }
                    ++k;
                }
                if (v1.size() == 0) {
                    v.removeElementAt(j);
                    j = v.size();
                    continue;
                }
                ++j;
            }
            if (v.size() == 0) {
                this.atom_conds.removeElementAt(i);
                this.setNames.removeElementAt(i);
                i = this.atom_conds.size();
                continue;
            }
            ++i;
        }
    }

    public void removeApplConditions() {
        this.clearConstraints();
    }

    public void setTriggerForLayer(boolean trigger) {
        this.triggerOfLayer = trigger;
    }

    public boolean isTriggerOfLayer() {
        return this.triggerOfLayer;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int l) {
        this.layer = l;
    }

    public boolean isUsingType(GraphObject t) {
        if (this.getLeft().isUsingType(t)) {
            return true;
        }
        if (this.getRight().isUsingType(t)) {
            return true;
        }
        for (int i = 0; i < this.itsNACs.size(); ++i) {
            if (!((OrdinaryMorphism)this.itsNACs.elementAt(i)).getTarget().isUsingType(t)) continue;
            return true;
        }
        return false;
    }

    public final SubRule createSubRule() {
        SubRule sr = new SubRule(this, this.getLeft().createSubGraph(), this.getRight().createSubGraph());
        this.itsSubRules.addElement(sr);
        return sr;
    }

    public final SubRule createSubRule(SubGraph left, SubGraph right) {
        SubRule sr = new SubRule(this, left, right);
        this.itsSubRules.addElement(sr);
        return sr;
    }

    public final SubRule createSubRule(SubGraGra sgg) {
        SubRule sr = new SubRule(this, new SubGraph(this.getLeft()), new SubGraph(this.getRight()));
        this.itsSubRules.addElement(sr);
        if (sgg != null) {
            sgg.addRule(sr);
        }
        return sr;
    }

    public final boolean destroySubRule(SubRule sr) {
        if (this.itsSubRules.contains(sr)) {
            this.itsSubRules.remove(sr);
            return true;
        }
        return false;
    }

    public final Enumeration getSubRules() {
        return this.itsSubRules.elements();
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Rule", this);
        if (!this.enabled) {
            h.addAttr("enabled", "false");
        }
        if (this.triggerOfLayer) {
            h.addAttr("trigger", "true");
        }
        AttrContext context = this.getAttrContext();
        h.addObject("", context.getVariables(), true);
        h.addObject("", this.getSource(), true);
        h.addObject("", this.getTarget(), true);
        this.writeMorphism(h);
        Enumeration e = this.getNACs();
        AttrConditionTuple condt = context.getConditions();
        int num = condt.getNumberOfEntries();
        if (e.hasMoreElements() || num > 0 || this.itsUsedAtomics.size() > 0) {
            h.openSubTag("ApplCondition");
            while (e.hasMoreElements()) {
                OrdinaryMorphism m = (OrdinaryMorphism)e.nextElement();
                h.openSubTag("NAC");
                h.addObject("", m.getTarget(), true);
                m.writeMorphism(h);
                h.close();
            }
            if (num > 0) {
                h.openSubTag("AttrCondition");
                h.addObject("", condt, true);
                h.close();
            }
            if (this.itsUsedAtomics.size() > 0 && this.itsUsedFormulas.size() > 0) {
                h.openSubTag("PostApplicationCondition");
                for (int i = 0; i < this.itsUsedFormulas.size(); ++i) {
                    Formula f = (Formula)this.itsUsedFormulas.elementAt(i);
                    h.openSubTag("FormulaRef");
                    h.addObject("f", f, false);
                    h.close();
                }
                h.close();
            }
            h.close();
        }
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "layer");
        h.addAttr("TagValue", this.layer);
        h.close();
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("Rule", this)) {
            String attr_enabled = h.readAttr("enabled");
            this.enabled = attr_enabled == null || !attr_enabled.equals("false");
            String attr_trigger = h.readAttr("trigger");
            this.triggerOfLayer = attr_trigger != null && attr_trigger.equals("true");
            h.enrichObject(this.getAttrContext().getVariables());
            h.getObject("", this.getSource(), true);
            h.getObject("", this.getTarget(), true);
            this.readMorphism(h);
            this.getSource().setName("LeftOf_" + this.getName());
            this.getTarget().setName("RightOf_" + this.getName());
            if (h.readSubTag("ApplCondition")) {
                while (h.readSubTag("NAC")) {
                    OrdinaryMorphism nac = this.createNAC();
                    h.getObject("", nac.getTarget(), true);
                    nac.readMorphism(h);
                    h.close();
                }
                if (h.readSubTag("AttrCondition")) {
                    AttrConditionTuple condt = this.getAttrContext().getConditions();
                    if (condt != null) {
                        h.enrichObject(condt);
                    }
                    h.close();
                }
                if (h.readSubTag("PostApplicationCondition")) {
                    Vector<Formula> tmpFormulas = new Vector<Formula>();
                    while (h.readSubTag("FormulaRef")) {
                        Formula f = new Formula(true);
                        f.setName("");
                        Formula f1 = (Formula)h.getObject("f", null, false);
                        if (f1 != null) {
                            tmpFormulas.addElement(f1);
                        }
                        h.close();
                    }
                    h.close();
                    this.setUsedFormulas(tmpFormulas);
                    this.convertUsedFormulas();
                }
                h.close();
            }
            if (h.readSubTag("TaggedValue")) {
                int v = 0;
                String t = h.readAttr("Tag");
                int v1 = h.readIAttr("Value");
                int v2 = h.readIAttr("TagValue");
                if (v1 > 0) {
                    v = v1;
                } else if (v2 > 0) {
                    v = v2;
                }
                if (t.equals("layer")) {
                    this.layer = v;
                }
                h.close();
            }
            h.close();
            this.isApplicable = true;
        }
    }

    public Rule invertSimplex() {
        if (!this.isInjective()) {
            return null;
        }
        Rule inverse = new Rule();
        Graph lgraph = this.getLeft();
        Graph rgraph = this.getRight();
        Graph linverse = inverse.getLeft();
        Graph rinverse = inverse.getRight();
        OrdinaryMorphism lmorph = new OrdinaryMorphism(lgraph, rinverse);
        OrdinaryMorphism rmorph = new OrdinaryMorphism(rgraph, linverse);
        Enumeration rnodes = rgraph.getNodes();
        while (rnodes.hasMoreElements()) {
            Node rNode = (Node)rnodes.nextElement();
            Node linverseNode = null;
            try {
                linverseNode = linverse.createNode(rNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            rmorph.addMapping(rNode, linverseNode);
        }
        Enumeration lnodes = lgraph.getNodes();
        while (lnodes.hasMoreElements()) {
            Node lNode = (Node)lnodes.nextElement();
            Node rinverseNode = null;
            try {
                rinverseNode = rinverse.createNode(lNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            lmorph.addMapping(lNode, rinverseNode);
            GraphObject rn = this.getImage(lNode);
            if (rn == null) continue;
            inverse.addMapping(rmorph.getImage(rn), rinverseNode);
        }
        Enumeration rarcs = rgraph.getArcs();
        while (rarcs.hasMoreElements()) {
            Arc rArc = (Arc)rarcs.nextElement();
            Node linverseSource = (Node)rmorph.getImage(rArc.getSource());
            Node linverseTarget = (Node)rmorph.getImage(rArc.getTarget());
            Arc linverseArc = null;
            try {
                linverseArc = linverse.createArc(rArc.getType(), linverseSource, linverseTarget);
                rmorph.addMapping(rArc, linverseArc);
            }
            catch (TypeException ex) {}
        }
        Enumeration larcs = lgraph.getArcs();
        while (larcs.hasMoreElements()) {
            GraphObject ra;
            Arc lArc = (Arc)larcs.nextElement();
            Node rinverseSource = (Node)lmorph.getImage(lArc.getSource());
            Node rinverseTarget = (Node)lmorph.getImage(lArc.getTarget());
            Arc rinverseArc = null;
            try {
                rinverseArc = rinverse.createArc(lArc.getType(), rinverseSource, rinverseTarget);
                lmorph.addMapping(lArc, rinverseArc);
            }
            catch (TypeException ex) {
                // empty catch block
            }
            if ((ra = this.getImage(lArc)) == null) continue;
            inverse.addMapping(rmorph.getImage(ra), rinverseArc);
        }
        return inverse;
    }

    public Pair invertComplex() {
        if (!this.isInjective()) {
            return null;
        }
        Rule inverse = new Rule();
        Graph lgraph = this.getLeft();
        Graph rgraph = this.getRight();
        Graph linverse = inverse.getLeft();
        Graph rinverse = inverse.getRight();
        OrdinaryMorphism lmorph = new OrdinaryMorphism(lgraph, rinverse);
        OrdinaryMorphism rmorph = new OrdinaryMorphism(rgraph, linverse);
        Enumeration rnodes = rgraph.getNodes();
        while (rnodes.hasMoreElements()) {
            Node rNode = (Node)rnodes.nextElement();
            Node linverseNode = null;
            try {
                linverseNode = linverse.createNode(rNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            rmorph.addMapping(rNode, linverseNode);
        }
        Enumeration lnodes = lgraph.getNodes();
        while (lnodes.hasMoreElements()) {
            Node lNode = (Node)lnodes.nextElement();
            Node rinverseNode = null;
            try {
                rinverseNode = rinverse.createNode(lNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            lmorph.addMapping(lNode, rinverseNode);
            GraphObject rn = this.getImage(lNode);
            if (rn == null) continue;
            inverse.addMapping(rmorph.getImage(rn), rinverseNode);
        }
        Enumeration rarcs = rgraph.getArcs();
        while (rarcs.hasMoreElements()) {
            Arc rArc = (Arc)rarcs.nextElement();
            Node linverseSource = (Node)rmorph.getImage(rArc.getSource());
            Node linverseTarget = (Node)rmorph.getImage(rArc.getTarget());
            Arc linverseArc = null;
            try {
                linverseArc = linverse.createArc(rArc.getType(), linverseSource, linverseTarget);
                rmorph.addMapping(rArc, linverseArc);
            }
            catch (TypeException ex) {}
        }
        Enumeration larcs = lgraph.getArcs();
        while (larcs.hasMoreElements()) {
            GraphObject ra;
            Arc lArc = (Arc)larcs.nextElement();
            Node rinverseSource = (Node)lmorph.getImage(lArc.getSource());
            Node rinverseTarget = (Node)lmorph.getImage(lArc.getTarget());
            Arc rinverseArc = null;
            try {
                rinverseArc = rinverse.createArc(lArc.getType(), rinverseSource, rinverseTarget);
                lmorph.addMapping(lArc, rinverseArc);
            }
            catch (TypeException ex) {
                // empty catch block
            }
            if ((ra = this.getImage(lArc)) == null) continue;
            inverse.addMapping(rmorph.getImage(ra), rinverseArc);
        }
        Pair information = new Pair(lmorph, rmorph);
        return new Pair(inverse, information);
    }

    public Match getMatch() {
        Match match = null;
        GraGra gra = null;
        Enumeration gragras = BaseFactory.theFactory().getGraGras();
        while (gragras.hasMoreElements() && !(gra = (GraGra)gragras.nextElement()).isElement(this)) {
        }
        if (gra != null && gra.getMatches(this).hasMoreElements()) {
            match = (Match)gra.getMatches(this).nextElement();
        }
        return match;
    }

    public boolean compareTo(Rule r) {
        CondTuple condOther;
        VarTuple varOther;
        String errMsgHolder = null;
        if (!this.compareTo((OrdinaryMorphism)r)) {
            errMsgHolder = errMsgHolder + "Rule content is different.";
            return false;
        }
        Enumeration e = r.getNACs();
        Vector<OrdinaryMorphism> another = new Vector<OrdinaryMorphism>();
        while (e.hasMoreElements()) {
            another.add((OrdinaryMorphism)e.nextElement());
        }
        if (this.itsNACs.size() != another.size()) {
            errMsgHolder = errMsgHolder + "Number of NACs is different.";
            return false;
        }
        OrdinaryMorphism nac = null;
        block1: for (int i = 0; i < this.itsNACs.size(); ++i) {
            nac = (OrdinaryMorphism)this.itsNACs.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                OrdinaryMorphism nac1 = (OrdinaryMorphism)another.elementAt(j);
                if (!nac.compareTo(nac1)) continue;
                another.remove(nac1);
                continue block1;
            }
        }
        if (another.size() != 0) {
            errMsgHolder = errMsgHolder + "NAC:  " + nac.getName() + "  is different.";
            return false;
        }
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        if (!var.compareTo(varOther = (VarTuple)r.getAttrContext().getVariables())) {
            errMsgHolder = errMsgHolder + "Variable rule context is different.";
            return false;
        }
        CondTuple cond = (CondTuple)this.getAttrContext().getConditions();
        if (!cond.compareTo(condOther = (CondTuple)r.getAttrContext().getConditions())) {
            errMsgHolder = errMsgHolder + "Conditional rule context is different.";
            return false;
        }
        return true;
    }

    public final void showTree() {
        System.out.println("\n-" + this);
        Enumeration subrs = this.getSubRules();
        while (subrs.hasMoreElements()) {
            SubRule sr = (SubRule)subrs.nextElement();
            System.out.println("--" + sr + "  -->  " + sr.getSuperRule());
        }
        this.getLeft().showTree();
        this.getRight().showTree();
    }

    public Vector getInputParameters() {
        Vector<VarMember> inputParams = new Vector<VarMember>(1);
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        for (int i = 0; i < var.getNumberOfEntries(); ++i) {
            VarMember varm = var.getVarMemberAt(i);
            if (!varm.isInputParameter()) continue;
            inputParams.addElement(varm);
        }
        return inputParams;
    }

    public boolean areNACsValid() {
        Enumeration en = this.getNACs();
        if (en.hasMoreElements()) {
            OrdinaryMorphism nac = (OrdinaryMorphism)en.nextElement();
            return this.isNACValid(nac);
        }
        return true;
    }

    public boolean isNACValid(OrdinaryMorphism nac) {
        return true;
    }

    public boolean isReadyToTransform() {
        ValueMember vm;
        int k;
        ValueTuple vt;
        AttrInstance attr;
        GraphObject o;
        this.isReady = false;
        Vector<String> abstractTypeNames = new Vector<String>(1);
        Enumeration enumer = this.getRight().getElements();
        while (enumer.hasMoreElements()) {
            GraphObject o2 = (GraphObject)enumer.nextElement();
            Enumeration inverse = this.getInverseImage(o2);
            if (inverse.hasMoreElements() || !o2.getType().isAbstract()) continue;
            abstractTypeNames.add(o2.getType().getName());
        }
        if (!abstractTypeNames.isEmpty()) {
            this.errorMsg = "RHS: abstract node found:  " + abstractTypeNames.toString() + "\nThe RHS of the rule should only use concrete types for creating new nodes.";
            return false;
        }
        AttrContext ac = this.getAttrContext();
        AttrVariableTuple avt = ac.getVariables();
        AttrConditionTuple act = ac.getConditions();
        this.errorMsg = "";
        Vector varDecls = this.getVariableDeclarations();
        Enumeration en = this.getNACs();
        while (en.hasMoreElements()) {
            OrdinaryMorphism nac = (OrdinaryMorphism)en.nextElement();
            Graph ng = nac.getImage();
            Enumeration en1 = ng.getElements();
            while (en1.hasMoreElements()) {
                o = (GraphObject)en1.nextElement();
                attr = o.getAttribute();
                vt = (ValueTuple)attr;
                for (k = 0; k < vt.getSize(); ++k) {
                    vm = vt.getValueMemberAt(k);
                    if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                    String n = vm.getExprAsText();
                    String t = vm.getDeclaration().getTypeName();
                    Pair p = new Pair(t, n);
                    boolean found = false;
                    for (int j = 0; j < varDecls.size(); ++j) {
                        Pair pj = (Pair)varDecls.elementAt(j);
                        if (!t.equals((String)pj.first) || !n.equals((String)pj.second)) continue;
                        found = true;
                    }
                    if (found) continue;
                    varDecls.addElement(p);
                }
            }
        }
        for (int j = 0; j < varDecls.size(); ++j) {
            Pair pj = (Pair)varDecls.elementAt(j);
            for (int jj = j + 1; jj < varDecls.size(); ++jj) {
                Pair pjj = (Pair)varDecls.elementAt(jj);
                if (!((String)pj.second).equals((String)pjj.second) || ((String)pj.first).equals((String)pjj.first)) continue;
                this.errorMsg = "Variable :  " + (String)pj.second + "   has multiple (or has not any) type declaration.\nIt isn't allowed. Please correct this mistake.";
                return false;
            }
        }
        Graph g = this.getRight();
        Enumeration e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject o3 = (GraphObject)e.nextElement();
            Enumeration inverse = this.getInverseImage(o3);
            attr = o3.getAttribute();
            vt = (ValueTuple)attr;
            for (k = 0; k < vt.getSize(); ++k) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet()) {
                    if (vm.getExpr().isVariable()) {
                        Vector leftVars;
                        VarMember var = avt.getVarMemberAt(vm.getExprAsText());
                        if (var == null) {
                            this.errorMsg = "Variable :  " + vm.getExprAsText() + "   is not declared.";
                            return false;
                        }
                        if (var.isInputParameter() || (leftVars = this.getOriginal().getVariableNamesOfAttributes()).contains(var.getName())) continue;
                        this.errorMsg = "Variable :  " + var.getName() + "   in the RHS of the rule should be an input parameter \nor already declared in the LHS.";
                        return false;
                    }
                    if (!vm.getExpr().isComplex()) continue;
                    if (!vm.isValid()) {
                        this.errorMsg = "Not all attributes in the RHS of the rule are correct.\nPlease check expression :  " + vm.getExprAsText();
                        return false;
                    }
                    Vector vec = vm.getAllVariableNamesOfExpression();
                    Vector vecLeft = this.getLeft().getVariableNamesOfAttributes();
                    for (int l = 0; l < vec.size(); ++l) {
                        VarMember m;
                        String n = (String)vec.elementAt(l);
                        boolean found = false;
                        for (int ll = 0; ll < vecLeft.size(); ++ll) {
                            String nn = (String)vecLeft.elementAt(ll);
                            if (!n.equals(nn)) continue;
                            found = true;
                        }
                        if (found || (m = avt.getVarMemberAt(n)) == null || m.isInputParameter()) continue;
                        this.errorMsg = "Not all attributes in the RHS of the rule are correct.\nPlease check variable :  " + n;
                        return false;
                    }
                    continue;
                }
                if (inverse.hasMoreElements()) continue;
                this.errorMsg = "Not all attributes in the RHS of the rule are set.";
                return false;
            }
        }
        for (int i = 0; i < varDecls.size(); ++i) {
            Pair p = (Pair)varDecls.elementAt(i);
            String typeName1 = (String)p.first;
            boolean isClass1 = false;
            String className1 = this.isClassName(typeName1);
            if (className1 != null) {
                isClass1 = true;
            }
            boolean isClass2 = false;
            String className2 = null;
            String typeName2 = "";
            String varName = (String)p.second;
            VarMember varm = ((VarTuple)avt).getVarMemberAt(varName);
            if (varm == null) {
                className2 = this.isClassName(varName);
                if (className2 != null) {
                    typeName2 = className2;
                }
            } else {
                if (varm.getDeclaration() == null) {
                    this.errorMsg = "Variable: " + varName + "  isn't declared!";
                    return false;
                }
                typeName2 = varm.getDeclaration().getTypeName();
                className2 = this.isClassName(typeName2);
            }
            if (className2 != null) {
                isClass2 = true;
            }
            if (isClass1 && isClass2) {
                if (!className1.equals(className2)) {
                    this.errorMsg = "Variable: " + varName + "  has wrong type." + "\nIt should be :  " + className1 + " .";
                    return false;
                }
                if (typeName1.equals(typeName2)) continue;
                String packageName = className1.substring(0, className1.lastIndexOf("."));
                if (packageName.equals("java.lang")) {
                    varm.getDeclaration().setType(typeName1);
                    continue;
                }
                this.errorMsg = "Variable: " + varName + "  has wrong type." + "\nIt should be :  " + typeName1 + " .";
                return false;
            }
            if (isClass1 || isClass2 || typeName1.equals(typeName2)) continue;
            this.errorMsg = "Variable: " + varName + "  has wrong type." + "\nIt should be :  " + typeName1 + " .";
            return false;
        }
        g = this.getRight();
        e = g.getElements();
        while (e.hasMoreElements()) {
            GraphObject o4 = (GraphObject)e.nextElement();
            ValueTuple vt2 = (ValueTuple)o4.getAttribute();
            for (int k2 = 0; k2 < vt2.getSize(); ++k2) {
                ValueMember vm2 = vt2.getValueMemberAt(k2);
                if (!vm2.isSet() || !vm2.getExpr().isVariable()) continue;
                VarMember var = avt.getVarMemberAt(vm2.getExprAsText());
                var.setMark(1);
            }
        }
        Enumeration eNACs = this.getNACs();
        while (eNACs.hasMoreElements()) {
            g = ((OrdinaryMorphism)eNACs.nextElement()).getImage();
            e = g.getElements();
            while (e.hasMoreElements()) {
                o = (GraphObject)e.nextElement();
                ValueTuple vt3 = (ValueTuple)o.getAttribute();
                for (int k3 = 0; k3 < vt3.getSize(); ++k3) {
                    ValueMember vm3 = vt3.getValueMemberAt(k3);
                    if (!vm3.isSet() || !vm3.getExpr().isVariable()) continue;
                    VarMember var = avt.getVarMemberAt(vm3.getExprAsText());
                    var.setMark(2);
                }
            }
        }
        g = this.getLeft();
        e = g.getElements();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            ValueTuple vt4 = (ValueTuple)o.getAttribute();
            for (int k4 = 0; k4 < vt4.getSize(); ++k4) {
                ValueMember vm4 = vt4.getValueMemberAt(k4);
                if (!vm4.isSet() || !vm4.getExpr().isVariable()) continue;
                VarMember var = avt.getVarMemberAt(vm4.getExprAsText());
                var.setMark(0);
            }
        }
        for (int k5 = 0; k5 < ((CondTuple)act).getSize(); ++k5) {
            CondMember cm = ((CondTuple)act).getCondMemberAt(k5);
            if (cm.getExpr() == null) {
                this.errorMsg = "Condition:  " + cm + "  is not defined.";
                return false;
            }
            if (!cm.isValid()) {
                this.errorMsg = "Condition:  " + cm + "  is not valid.\nPlease check variables of it.";
                return false;
            }
            Vector vars = cm.getAllVariables();
            boolean mixed = false;
            String name0 = (String)vars.elementAt(0);
            VarMember var0 = null;
            if (((VarTuple)avt).isDeclared(name0)) {
                var0 = avt.getVarMemberAt((String)vars.elementAt(0));
                int mark = var0.getMark();
                for (int j = 1; j < vars.size(); ++j) {
                    String name = (String)vars.elementAt(j);
                    if (((VarTuple)avt).isDeclared(name)) {
                        VarMember var = avt.getVarMemberAt(name);
                        if (var.getMark() == mark || var.getMark() != 2 && mark != 2) continue;
                        mixed = true;
                        continue;
                    }
                    this.errorMsg = "Variable: " + name + "\nof condition: " + cm.getExprAsText() + "\nis not declared.";
                    return false;
                }
                if (mixed) {
                    cm.setMark(3);
                    continue;
                }
                if (mixed || mark != 2) continue;
                cm.setMark(2);
                continue;
            }
            this.errorMsg = "Variable: " + name0 + "\nof condition: " + cm.getExprAsText() + "\nis not declared.";
            return false;
        }
        this.isReady = true;
        Enumeration el = this.getLeft().getElements();
        while (el.hasMoreElements()) {
            GraphObject grob = (GraphObject)el.nextElement();
            if (this.getImage(grob) != null) continue;
            this.isDeleting = true;
            break;
        }
        Enumeration er = this.getRight().getElements();
        while (er.hasMoreElements()) {
            GraphObject grob = (GraphObject)er.nextElement();
            if (this.getInverseImage(grob).hasMoreElements()) continue;
            this.isCreating = true;
            break;
        }
        this.preserved = this.findPreservedElements();
        this.created = this.findCreatedElements();
        this.deleted = this.findDeletedElements();
        return true;
    }

    public boolean isCreating() {
        if (this.isReady) {
            return this.isCreating;
        }
        this.created = this.findCreatedElements();
        this.isCreating = !this.created.isEmpty();
        return this.isCreating;
    }

    public Vector getObjectsToCreate() {
        return this.findCreatedElements();
    }

    public int getNumberOfObjectsToCreate() {
        return this.findCreatedElements().size();
    }

    public boolean isDeleting() {
        if (this.isReady) {
            return this.isDeleting;
        }
        this.deleted = this.findDeletedElements();
        this.isDeleting = !this.deleted.isEmpty();
        return this.isDeleting;
    }

    public Vector getObjectsToDelete() {
        return this.findDeletedElements();
    }

    public int getNumberOfObjectsToDelete() {
        return this.findDeletedElements().size();
    }

    public Vector getPreservedElements() {
        if (this.isReady) {
            return this.preserved;
        }
        this.preserved = this.findPreservedElements();
        return this.preserved;
    }

    public Vector getCreatedElements() {
        if (this.isReady) {
            return this.created;
        }
        this.created = this.findCreatedElements();
        return this.created;
    }

    public Vector getDeletedElements() {
        if (this.isReady) {
            return this.deleted;
        }
        this.deleted = this.findDeletedElements();
        return this.deleted;
    }

    private Vector findPreservedElements() {
        Vector vec = new Vector();
        Enumeration en = this.getDomain();
        while (en.hasMoreElements()) {
            vec.addElement(en.nextElement());
        }
        return vec;
    }

    private Vector findCreatedElements() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        Enumeration en = this.getRight().getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            if (this.getInverseImage(o).hasMoreElements()) continue;
            vec.addElement(o);
        }
        this.isCreating = !vec.isEmpty();
        return vec;
    }

    private Vector findDeletedElements() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        Enumeration en = this.getLeft().getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            if (this.getImage(o) != null) continue;
            vec.addElement(o);
        }
        this.isDeleting = !vec.isEmpty();
        return vec;
    }

    protected boolean differentVariablesUsed(Graph g, Enumeration nacs) {
        AttrContext ac = this.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        Hashtable<VarMember, Boolean> used = new Hashtable<VarMember, Boolean>(avt.getSize());
        for (int i = 0; i < avt.getSize(); ++i) {
            VarMember var = avt.getVarMemberAt(i);
            used.put(var, new Boolean(false));
        }
        Enumeration e = g.getElements();
        while (nacs.hasMoreElements()) {
            used = new Hashtable(avt.getSize());
            for (int i = 0; i < avt.getSize(); ++i) {
                VarMember var = avt.getVarMemberAt(i);
                used.put(var, new Boolean(false));
            }
            OrdinaryMorphism m = (OrdinaryMorphism)nacs.nextElement();
            e = m.getTarget().getElements();
            while (e.hasMoreElements()) {
                GraphObject o = (GraphObject)e.nextElement();
                AttrInstance attr = o.getAttribute();
                ValueTuple vt = (ValueTuple)attr;
                if (!m.getInverseImage(o).hasMoreElements()) continue;
                GraphObject orig = (GraphObject)m.getInverseImage(o).nextElement();
                ValueTuple vtOrig = (ValueTuple)orig.getAttribute();
                for (int k = 0; k < vt.getSize(); ++k) {
                    ValueMember vm = vt.getValueMemberAt(k);
                    ValueMember vmOrig = vtOrig.getValueMemberAt(k);
                    if (!vmOrig.isSet() || !vm.isSet() || !vmOrig.getExpr().isVariable() || !vm.getExpr().isVariable() || vmOrig.getExprAsText().equals(vm.getExprAsText())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean areSameVariablesUsed() {
        AttrContext ac = this.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        Hashtable<VarMember, Boolean> used = new Hashtable<VarMember, Boolean>(avt.getSize());
        for (int i = 0; i < avt.getSize(); ++i) {
            VarMember var = avt.getVarMemberAt(i);
            used.put(var, new Boolean(false));
        }
        Vector<VarMember> result = new Vector<VarMember>();
        Enumeration e = this.getLeft().getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            for (int k = 0; k < vt.getSize(); ++k) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                VarMember var = avt.getVarMemberAt(vm.getExprAsText());
                if (!((Boolean)used.get(var)).booleanValue()) {
                    used.put(var, new Boolean(true));
                    continue;
                }
                if (result.contains(var)) continue;
                result.add(var);
            }
        }
        return result.size() != 0;
    }

    protected void restoreVariableDeclaration() {
        VarTuple vart = (VarTuple)this.getAttrContext().getVariables();
        Enumeration en = this.getImage().getElements();
        while (en.hasMoreElements()) {
            GraphObject o = (GraphObject)en.nextElement();
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            for (int k = 0; k < vt.getSize(); ++k) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    String n = vm.getExprAsText();
                    String t = vm.getDeclaration().getTypeName();
                    VarMember varm = vart.getVarMemberAt(n);
                    String t_varm = "";
                    if (varm != null) {
                        t_varm = varm.getDeclaration().getTypeName();
                    }
                    if (varm != null && t.equals(t_varm)) continue;
                    vart.declare(vm.getDeclaration().getHandler(), t, n);
                    continue;
                }
                if (vm.isSet() && !vm.getExpr().isComplex()) continue;
            }
        }
        en = this.getNACs();
        while (en.hasMoreElements()) {
            OrdinaryMorphism nac = (OrdinaryMorphism)en.nextElement();
            Graph ng = nac.getImage();
            Enumeration en1 = ng.getElements();
            while (en1.hasMoreElements()) {
                GraphObject o = (GraphObject)en1.nextElement();
                AttrInstance attr = o.getAttribute();
                ValueTuple vt = (ValueTuple)attr;
                for (int k = 0; k < vt.getSize(); ++k) {
                    ValueMember vm = vt.getValueMemberAt(k);
                    if (!vm.isSet() || !vm.getExpr().isVariable()) continue;
                    String n = vm.getExprAsText();
                    String t = vm.getDeclaration().getTypeName();
                    VarMember varm = vart.getVarMemberAt(n);
                    String t_varm = "";
                    if (varm != null) {
                        t_varm = varm.getDeclaration().getTypeName();
                    }
                    if (varm != null && t.equals(t_varm)) continue;
                    vart.declare(vm.getDeclaration().getHandler(), t, n);
                }
            }
        }
    }

    public Vector getUsedTypes() {
        Vector vec = super.getUsedTypes();
        Enumeration e = this.itsNACs.elements();
        while (e.hasMoreElements()) {
            OrdinaryMorphism n = (OrdinaryMorphism)e.nextElement();
            Enumeration en = n.getTarget().getElements();
            while (en.hasMoreElements()) {
                GraphObject o = (GraphObject)en.nextElement();
                if (vec.contains(o.getType())) continue;
                vec.add(o.getType());
            }
        }
        return vec;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected void addAppliedMatch(OrdinaryMorphism m) {
        OrdinaryMorphism mcopy = m.morphcopy();
        this.doneMatches.add(mcopy);
    }

    protected boolean isDone(OrdinaryMorphism m) {
        for (int i = 0; i < this.doneMatches.size(); ++i) {
            OrdinaryMorphism mi = (OrdinaryMorphism)this.doneMatches.elementAt(i);
            if (!mi.compareTo(m)) continue;
            return true;
        }
        return false;
    }

    protected void removeAppliedMatches() {
        this.doneMatches.removeAllElements();
    }
}

