/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.xt_basis.Rule;
import com.objectspace.jgl.HashSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RuleLayer {
    private Hashtable ruleLayer;
    private Enumeration rules;
    private Vector rulesVec;

    public RuleLayer(Enumeration rules) {
        this.rules = rules;
        this.rulesVec = new Vector(0);
        while (rules.hasMoreElements()) {
            this.rulesVec.addElement(rules.nextElement());
        }
        this.initRuleLayer();
    }

    public RuleLayer(Vector rules) {
        this.rulesVec = rules;
        this.rules = this.rulesVec.elements();
        this.initRuleLayer();
    }

    public void setLayer(Rule rule, int layer) {
        rule.setLayer(layer);
        this.ruleLayer.put(rule, new Integer(layer));
    }

    private void initRuleLayer() {
        this.ruleLayer = new Hashtable();
        for (int i = 0; i < this.rulesVec.size(); ++i) {
            Object rule = this.rulesVec.elementAt(i);
            if (rule instanceof Rule) {
                this.ruleLayer.put(rule, new Integer(((Rule)rule).getLayer()));
                continue;
            }
            if (!(rule instanceof String)) continue;
            this.ruleLayer.put(rule, new Integer(0));
        }
    }

    public Hashtable getRuleLayer() {
        return this.ruleLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration keys = this.getRuleLayer().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer layer = (Integer)this.getRuleLayer().get(key);
            if (layer >= startLayer) continue;
            startLayer = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable invertLayer() {
        Hashtable<Integer, HashSet> inverted = new Hashtable<Integer, HashSet>();
        Enumeration keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)this.ruleLayer.get(key);
            HashSet invertedValue = (HashSet)inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Rule:\t\tLayer:\n";
        Enumeration keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)this.ruleLayer.get(key);
            resultString = resultString + ((Rule)key).getName() + "\t\t" + value.toString() + "    " + ((Rule)key).getLayer() + "\n";
        }
        return resultString;
    }
}

