/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrSession;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.ColimDiagram;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.OrdinarySubMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.SubGraGra;
import agg.xt_basis.SubGraph;
import agg.xt_basis.SubMatch;
import agg.xt_basis.SubRule;
import agg.xt_basis.TypeException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class Step {
    public final Morphism execute(Match match) throws TypeException {
        return this.execute(match, false);
    }

    public final Morphism execute(Match match, boolean allowVariables) throws TypeException {
        int oldTypeLevel = match.getImage().getTypeSet().getLevelOfTypeGraphCheck();
        if (oldTypeLevel == 30) {
            match.getImage().getTypeSet().setLevelOfTypeGraphCheck(20);
        }
        Rule rule = match.getRule();
        Graph aHostGraph = match.getImage();
        ColimDiagram aPushoutDiagram = new ColimDiagram(aHostGraph);
        aPushoutDiagram.addNode(aHostGraph);
        aPushoutDiagram.addNode(rule.getOriginal());
        aPushoutDiagram.addNode(rule.getImage());
        aPushoutDiagram.addEdge(rule);
        aPushoutDiagram.addEdge(match);
        AttrContext ac = match.getAttrManager().newContext(0);
        OrdinaryMorphism aMatchStar = new OrdinaryMorphism(rule.getImage(), aHostGraph, ac);
        aPushoutDiagram.requestEdge(aMatchStar);
        match.getAttrContext().freeze();
        try {
            aPushoutDiagram.computeColimit();
            Collection errors = null;
            if (oldTypeLevel > 0) {
                errors = match.getImage().getTypeSet().checkType(aMatchStar.getImage());
            }
            if (oldTypeLevel == 30) {
                match.getImage().getTypeSet().setLevelOfTypeGraphCheck(oldTypeLevel);
            }
            if (errors != null && !errors.isEmpty()) {
                aMatchStar = null;
                throw new TypeException("Type graph check is failed.");
            }
            try {
                Step.computeAttributes(aMatchStar, match.getAttrContext(), allowVariables);
            }
            catch (AttrImplException ex1) {
                match.getAttrContext().defreeze();
                match.getRule().restoreVariableDeclaration();
                aPushoutDiagram.undoColimit();
                aMatchStar = null;
                throw new TypeException(ex1.getMessage());
            }
            match.getAttrContext().defreeze();
            if (aMatchStar != null) {
                match.setCoMorphism(aMatchStar);
                this.propagateDelete(match.getRule());
                this.propagateCreate(match, aMatchStar);
                this.propagateMappings(match, aMatchStar);
            }
        }
        catch (TypeException ex) {
            if (oldTypeLevel == 30) {
                match.getImage().getTypeSet().setLevelOfTypeGraphCheck(oldTypeLevel);
            }
            throw ex;
        }
        match.getRule().restoreVariableDeclaration();
        return aMatchStar;
    }

    private static final void computeAttributes(Morphism matchstar, AttrContext context, boolean allowVariables) throws AttrImplException {
        Enumeration anObjIter = matchstar.getCodomain();
        while (anObjIter.hasMoreElements()) {
            GraphObject aHostObject = (GraphObject)anObjIter.nextElement();
            Enumeration anInvImage = matchstar.getInverseImage(aHostObject);
            if (anInvImage.hasMoreElements()) {
                GraphObject aRuleObject = (GraphObject)anInvImage.nextElement();
                AttrInstance rai = aRuleObject.getAttribute();
                AttrInstance ai = aHostObject.getAttribute();
                AttrSession.logAttrInstance(AttrSession.logTrace, ai, "Step:Graph_attribut");
                AttrSession.logAttrInstance(AttrSession.logTrace, rai, "Step:Regel_attribut");
                AttrSession.logAttrContext(AttrSession.logTrace, context, "Step: context");
                if (!allowVariables) {
                    ai.apply(rai, context);
                    continue;
                }
                ai.apply(rai, context, allowVariables);
                continue;
            }
            System.out.println("Step.computeAttributes: Something's going wrong here...");
        }
    }

    private void propagateCreate(Match aMatch, OrdinaryMorphism aCoMatch) {
        GraphObject orig;
        int i;
        Rule r = aMatch.getRule();
        if (!r.getSubRules().hasMoreElements()) {
            return;
        }
        Enumeration gragras = BaseFactory.theFactory().getGraGras();
        GraGra gra = null;
        boolean found = false;
        while (gragras.hasMoreElements() && !found) {
            gra = (GraGra)gragras.nextElement();
            if (!gra.isElement(r)) continue;
            found = true;
        }
        if (gra == null) {
            return;
        }
        Vector<GraphObject> newObjs = new Vector<GraphObject>(1);
        Enumeration objs = r.getRight().getElements();
        while (objs.hasMoreElements()) {
            GraphObject obj = (GraphObject)objs.nextElement();
            Enumeration inverseImage = r.getInverseImage(obj);
            if (inverseImage.hasMoreElements()) continue;
            newObjs.addElement(obj);
        }
        Vector<GraphObject> newArcs = new Vector<GraphObject>();
        for (i = 0; i < newObjs.size(); ++i) {
            orig = (GraphObject)newObjs.elementAt(i);
            if (orig.isArc()) {
                newArcs.addElement(orig);
                continue;
            }
            this.propagateCreate(orig, aCoMatch.getImage(orig), r.getSubRules(), gra.getSubGraGras());
        }
        for (i = 0; i < newArcs.size(); ++i) {
            orig = (GraphObject)newArcs.elementAt(i);
            this.propagateCreate(orig, aCoMatch.getImage(orig), r.getSubRules(), gra.getSubGraGras());
        }
    }

    private void propagateCreate(GraphObject orig, GraphObject image, Enumeration subRules, Enumeration subGraGras) {
        Vector<SubRule> objSubRules = new Vector<SubRule>(1);
        while (subRules.hasMoreElements()) {
            SubRule sr = (SubRule)subRules.nextElement();
            if (!sr.getRight().isElement(orig)) continue;
            objSubRules.addElement(sr);
        }
        while (subGraGras.hasMoreElements()) {
            SubGraGra gra = (SubGraGra)subGraGras.nextElement();
            for (int i = 0; i < objSubRules.size(); ++i) {
                SubRule sr = (SubRule)objSubRules.elementAt(i);
                if (!gra.isElement(sr)) continue;
                if (!gra.getGraph().isElement(image)) {
                    ((SubGraph)gra.getGraph()).addObject(image);
                }
                i = objSubRules.size();
            }
        }
    }

    private void propagateDelete(Rule r) {
        Enumeration gragras = BaseFactory.theFactory().getGraGras();
        GraGra gra = null;
        boolean found = false;
        while (gragras.hasMoreElements() && !found) {
            gra = (GraGra)gragras.nextElement();
            if (!gra.isElement(r)) continue;
            found = true;
        }
        if (gra == null) {
            return;
        }
        if (!gra.getSubGraGras().hasMoreElements()) {
            return;
        }
        this.propagateDelete(gra);
    }

    private void propagateDelete(GraGra gra) {
        Enumeration subGraGras = gra.getSubGraGras();
        while (subGraGras.hasMoreElements()) {
            SubGraGra sgra = (SubGraGra)subGraGras.nextElement();
            SubGraph g = (SubGraph)sgra.getGraph();
            Enumeration en2 = g.getElements();
            while (en2.hasMoreElements()) {
                GraphObject o = (GraphObject)en2.nextElement();
                boolean has = false;
                Enumeration e = gra.getGraph().getElements();
                while (e.hasMoreElements()) {
                    GraphObject o1 = (GraphObject)e.nextElement();
                    if (!o1.equals(o)) continue;
                    has = true;
                }
                if (has) continue;
                g.removeObject(o);
            }
        }
    }

    private void createCoSubMatches(Rule aRule, OrdinaryMorphism aCoMatch) {
        Enumeration subRules = aRule.getSubRules();
        while (subRules.hasMoreElements()) {
            SubRule sr = (SubRule)subRules.nextElement();
            SubMatch sm = (SubMatch)sr.getMatch();
            this.createCoSubMatch(sr, sm, aCoMatch);
        }
    }

    private OrdinarySubMorphism createCoSubMatch(SubRule aSubRule, SubMatch aSubMatch, OrdinaryMorphism aCoMatch) {
        if (aCoMatch == null || aSubRule == null || aSubMatch == null) {
            return null;
        }
        OrdinarySubMorphism aCoSubMatch = new OrdinarySubMorphism(aCoMatch, (SubGraph)aSubRule.getTarget(), (SubGraph)aSubMatch.getTarget());
        aCoSubMatch.setName("submatch_star.morph");
        aSubMatch.setCoMorphism(aCoSubMatch);
        return aCoSubMatch;
    }

    private void propagateMappings(Match aMatch, OrdinaryMorphism aCoMatch) {
        Rule r = aMatch.getRule();
        if (!r.getSubRules().hasMoreElements()) {
            return;
        }
        this.createCoSubMatches(r, aCoMatch);
        Enumeration objs = aCoMatch.getSource().getElements();
        while (objs.hasMoreElements()) {
            GraphObject orig = (GraphObject)objs.nextElement();
            if (aCoMatch.getImage(orig) == null) continue;
            this.propagateMapping(orig, aCoMatch.getImage(orig), aMatch.getSubMatches());
        }
    }

    private void propagateMapping(GraphObject orig, GraphObject image, Enumeration subMatches) {
        while (subMatches.hasMoreElements()) {
            SubMatch sub = (SubMatch)subMatches.nextElement();
            OrdinarySubMorphism coSubMatch = (OrdinarySubMorphism)sub.getCoMorphism();
            if (coSubMatch == null) {
                return;
            }
            if (!coSubMatch.getSource().isElement(orig) || !coSubMatch.getTarget().isElement(image)) continue;
            coSubMatch.addMapping(orig, image);
        }
    }
}

