/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import java.util.Enumeration;
import java.util.Vector;

public class SubGraph
extends Graph {
    private Graph itsSuperGraph;
    private Vector itsNodes;
    private Vector itsArcs;
    private String itsName;

    public SubGraph(Graph supergraph) {
        super(supergraph.getTypeSet());
        this.itsSuperGraph = supergraph;
        this.itsNodes = new Vector(15, 30);
        this.itsArcs = new Vector(15, 30);
    }

    public final void dispose() {
        this.itsSuperGraph = null;
        super.dispose();
    }

    public final Graph getSuperGraph() {
        return this.itsSuperGraph;
    }

    public boolean isElement(GraphObject obj) {
        boolean res = false;
        if (obj instanceof Node) {
            res = this.itsNodes.contains(obj);
        }
        if (obj instanceof Arc) {
            res = this.itsArcs.contains(obj);
        }
        return res;
    }

    public Enumeration getNodes() {
        return this.itsNodes.elements();
    }

    public Enumeration getArcs() {
        return this.itsArcs.elements();
    }

    public Enumeration getElements() {
        int i;
        Vector elems = new Vector();
        for (i = 0; i < this.itsNodes.size(); ++i) {
            elems.addElement(this.itsNodes.elementAt(i));
        }
        for (i = 0; i < this.itsArcs.size(); ++i) {
            elems.addElement(this.itsArcs.elementAt(i));
        }
        return elems.elements();
    }

    public final void addObject(GraphObject obj) {
        if (this.isElement(obj)) {
            return;
        }
        if (obj != null) {
            if (obj.isArc()) {
                if (!this.isElement(((Arc)obj).getSource())) {
                    this.addObject(((Arc)obj).getSource());
                }
                if (!this.isElement(((Arc)obj).getTarget())) {
                    this.addObject(((Arc)obj).getTarget());
                }
                this.itsArcs.addElement(obj);
            } else {
                this.itsNodes.addElement(obj);
            }
        }
    }

    public final boolean removeObject(GraphObject obj) {
        if (obj == null) {
            return false;
        }
        Enumeration anEnum = obj.getIncomingArcs();
        while (anEnum.hasMoreElements()) {
            this.removeObject((GraphObject)anEnum.nextElement());
        }
        anEnum = obj.getOutgoingArcs();
        while (anEnum.hasMoreElements()) {
            this.removeObject((GraphObject)anEnum.nextElement());
        }
        boolean aFlag = obj instanceof Arc ? this.itsArcs.removeElement(obj) : this.itsNodes.removeElement(obj);
        return aFlag;
    }
}

