/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrType;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeGraphArc;
import agg.xt_basis.TypeGraphNode;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeImpl
implements Type {
    private boolean isAbstract = false;
    private String itsStringRepr;
    private Type itsParent;
    private Vector<Type> itsParents = new Vector(5);
    private AttrType itsAttrType;
    private String additionalRepr;
    private HashMap edgeTypeGraphObjects = null;
    private boolean typeGraphObjectDefined = false;
    private Node nodeTypeGraphObject = null;
    private TypeGraphNode typeGraphNode;
    private Vector usingGraphObjects = new Vector();

    protected TypeImpl(AttrType at, String stringRepr) {
        this.itsAttrType = at;
        this.itsStringRepr = stringRepr;
        this.additionalRepr = "";
        if (this.itsParents == null) {
            this.itsParents = new Vector(5);
        }
    }

    protected TypeImpl(AttrType at) {
        this(at, "");
    }

    @Override
    public String convertToKey() {
        String attrTypeAsStr = "";
        DeclTuple dt = (DeclTuple)this.itsAttrType;
        int size = dt.getSize();
        for (int i = 0; i < size; ++i) {
            DeclMember dm = (DeclMember)dt.getMemberAt(i);
            attrTypeAsStr = dm.getTypeName() + ":" + dm.getName();
        }
        String key = this.itsStringRepr + ":" + attrTypeAsStr + ":" + this.additionalRepr;
        return key;
    }

    protected void adaptTypeAttribute(Type type) {
        DeclTuple declTuple = (DeclTuple)this.getAttrType();
        DeclTuple otherTuple = (DeclTuple)type.getAttrType();
        for (int i = 0; i < otherTuple.getSize(); ++i) {
            DeclMember otherMem = (DeclMember)otherTuple.getMemberAt(i);
            if (otherMem.getHoldingTuple() != otherTuple) continue;
            String otherName = otherMem.getName();
            String otherType = otherMem.getTypeName();
            boolean nameFound = false;
            boolean conflict = false;
            DeclMember mem = null;
            for (int j = 0; j < declTuple.getSize(); ++j) {
                mem = (DeclMember)declTuple.getMemberAt(j);
                if (mem.getHoldingTuple() != declTuple) continue;
                if (mem.getName().equals(otherName)) {
                    nameFound = true;
                    if (!mem.getTypeName().equals(otherType)) {
                        conflict = true;
                        break;
                    }
                    mem = null;
                    break;
                }
                mem = null;
            }
            if (nameFound && conflict && mem != null && mem.getHoldingTuple() == declTuple) {
                mem.setName(mem.getName() + "?");
                declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherType, otherName);
                continue;
            }
            if (nameFound) continue;
            DeclMember m = (DeclMember)declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherType, otherName);
        }
    }

    protected void checkDoubleAttributeType() {
        DeclTuple declTuple = (DeclTuple)this.getAttrType();
        for (int i = 0; i < declTuple.getSize(); ++i) {
            DeclMember memi = (DeclMember)declTuple.getMemberAt(i);
            String n = memi.getName();
            String t = memi.getTypeName();
            boolean nameFound = false;
            boolean conflict = false;
            DeclMember memj = null;
            for (int j = i + 1; j < declTuple.getSize(); ++j) {
                memj = (DeclMember)declTuple.getMemberAt(j);
                if (memj.getName().equals(n)) {
                    nameFound = true;
                    conflict = true;
                }
                if (nameFound && conflict) {
                    memj.setName(memj.getName() + "?");
                }
                nameFound = false;
                conflict = false;
            }
        }
    }

    @Override
    public boolean compareTo(Type t) {
        if (!this.getStringRepr().equals(t.getStringRepr())) {
            return false;
        }
        if (!this.getAdditionalRepr().equals(t.getAdditionalRepr())) {
            return false;
        }
        if (((DeclTuple)this.getAttrType()).getSize() != ((DeclTuple)t.getAttrType()).getSize()) {
            return false;
        }
        return this.getAttrType().compareTo(t.getAttrType());
    }

    @Override
    public void setAbstract(boolean b) {
        this.isAbstract = b;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isChildOf(Type t) {
        Type currentAncestor = this;
        if (currentAncestor.getStringRepr().equals(t.getStringRepr()) && currentAncestor.getAdditionalRepr().equals(t.getAdditionalRepr()) && currentAncestor.getAttrType().compareTo(t.getAttrType())) {
            return true;
        }
        for (int i = 0; i < this.getParents().size(); ++i) {
            currentAncestor = this.getParents().get(i);
            if (!currentAncestor.isChildOf(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isParentOf(Type t) {
        Type currentAncestor = t;
        if (currentAncestor.getStringRepr().equals(this.getStringRepr()) && currentAncestor.getAdditionalRepr().equals(this.getAdditionalRepr()) && currentAncestor.getAttrType().compareTo(this.getAttrType())) {
            return true;
        }
        for (int i = 0; i < t.getParents().size(); ++i) {
            currentAncestor = t.getParents().get(i);
            if (!this.isParentOf(currentAncestor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRelatedTo(Type t) {
        if (this.compareTo(t)) {
            return true;
        }
        for (int i = 0; i < this.getParents().size(); ++i) {
            Type oldestAncestor = this.getParents().get(i);
            if (oldestAncestor.isParentOf(t)) {
                return true;
            }
            if (!oldestAncestor.isRelatedTo(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector<Type> getAllParents() {
        Vector<Type> myAllParents = new Vector<Type>();
        myAllParents.add(this);
        for (int i = 0; i < this.getParents().size(); ++i) {
            Type currentAncestor = this.getParents().get(i);
            myAllParents.add(currentAncestor);
            Vector moreParents = currentAncestor.getAllParents();
            for (int j = 0; j < moreParents.size(); ++j) {
                Type p = (Type)moreParents.get(j);
                if (myAllParents.contains(p)) continue;
                myAllParents.add(p);
            }
        }
        return myAllParents;
    }

    public void showRelatives() {
        System.out.println("Type Relatives of  \"" + this.getName() + "\"   size: " + this.itsParents.size());
        for (int i = 0; i < this.itsParents.size(); ++i) {
            Type p = this.itsParents.get(i);
            System.out.print("\"" + p.getName() + "\", ");
        }
        System.out.println("\n***************************");
    }

    public void showAllRelatives() {
        Vector<Type> v = this.getAllParents();
        System.out.println("Type Relatives of  \"" + this.getName() + "\"   size: " + v.size());
        for (int i = 0; i < v.size(); ++i) {
            Type p = v.get(i);
            System.out.print("\"" + p.getName() + "\", ");
        }
        System.out.println("\n***************************");
    }

    @Override
    public final String getStringRepr() {
        return this.itsStringRepr;
    }

    @Override
    public final void setStringRepr(String n) {
        this.itsStringRepr = n;
    }

    @Override
    public final Type getParent() {
        return this.itsParent;
    }

    @Override
    public final Vector<Type> getParents() {
        return this.itsParents;
    }

    @Override
    public final void setParent(Type t) {
        if (t == null && this.itsParent != null) {
            this.removeParent(this.itsParent);
            return;
        }
        this.addParent(t);
    }

    @Override
    public final void addParent(Type t) {
        if (t != null && !this.itsParents.contains(t)) {
            this.itsParents.add(t);
            this.itsParent = t;
            DeclTuple myDeclTuple = (DeclTuple)this.itsAttrType;
            myDeclTuple.addParent((DeclTuple)t.getAttrType());
        }
    }

    public Vector<String> checkDoubleAttributeName(Type otherType) {
        Vector<String> v = new Vector<String>(5, 5);
        DeclTuple otherDecl = (DeclTuple)otherType.getAttrType();
        DeclTuple myDecl = (DeclTuple)this.getAttrType();
        for (int i = 0; i < otherDecl.getNumberOfEntries(); ++i) {
            if (myDecl.isLegalName(otherDecl.getNameAsString(i)) <= 0) continue;
            v.add(otherDecl.getNameAsString(i));
        }
        return v;
    }

    @Override
    public final void removeParent(Type t) {
        if (t != null && this.itsParents.contains(t)) {
            this.itsParents.remove(t);
            DeclTuple myDeclTuple = (DeclTuple)this.itsAttrType;
            myDeclTuple.removeParent((DeclTuple)t.getAttrType());
        }
        this.itsParent = !this.itsParents.isEmpty() ? this.itsParents.lastElement() : null;
    }

    @Override
    public final AttrType getAttrType() {
        return this.itsAttrType;
    }

    @Override
    public String getAdditionalRepr() {
        return this.additionalRepr;
    }

    @Override
    public void setAdditionalRepr(String repr) {
        this.additionalRepr = repr.equals("NODE") ? ":RECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:" : (repr.equals("EDGE") ? ":SOLID_LINE:java.awt.Color[r=0,g=0,b=0]::[EDGE]:" : repr);
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        String n = this.getStringRepr();
        if (this.getAdditionalRepr() != null && !this.getAdditionalRepr().equals("")) {
            n = n + "%" + this.getAdditionalRepr();
        }
        if (n.indexOf("[NODE]") != -1) {
            h.addEnumeration("", this.getParents().elements(), true);
            h.openNewElem("NodeType", this);
        } else if (n.indexOf("[EDGE]") != -1) {
            h.openNewElem("EdgeType", this);
        } else {
            h.openNewElem("Type", this);
        }
        h.addAttr("name", n);
        if (this.isAbstract) {
            h.addAttr("abstract", "true");
        }
        if (n.indexOf("[NODE]") != -1) {
            Type p = null;
            if (!this.itsParents.isEmpty()) {
                p = this.itsParents.get(0);
            }
            h.addObject("parent", p, false);
            for (int i = 1; i < this.itsParents.size(); ++i) {
                p = this.itsParents.get(i);
                h.addObject("parent" + i, p, false);
            }
        }
        if (this.itsAttrType != null) {
            h.addObject("", this.itsAttrType, true);
        }
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("NodeType", this) || h.isTag("EdgeType", this) || h.isTag("Type", this)) {
            int i;
            String n = h.readAttr("name");
            this.isAbstract = false;
            String str = h.readAttr("abstract");
            if (str != null && str.equals("true")) {
                this.isAbstract = true;
            }
            if ((i = n.indexOf(37)) != -1) {
                int indx;
                String a = n.substring(i + 1);
                if (n.indexOf("[NODE]") != -1) {
                    Type p = (Type)h.getObjectRef("parent", null);
                    if (p != null) {
                        this.addParent(p);
                    }
                    int pi = 1;
                    while ((p = (Type)h.getObjectRef("parent" + pi, null)) != null) {
                        this.addParent(p);
                        ++pi;
                    }
                    int indx2 = a.indexOf(":");
                    if (indx2 >= 0 && indx2 + 1 < a.length()) {
                        String s = a.substring(a.indexOf(":") + 1);
                        int j = 0;
                        j = 1;
                        while (!s.equals("") && (indx2 = s.indexOf(":")) >= 0 && indx2 + 1 < s.length()) {
                            String ss;
                            s = ss = s.substring(s.indexOf(":") + 1);
                            ++j;
                        }
                        if (indx2 >= 0) {
                            ++j;
                        }
                        if (j > 2 && j < 5) {
                            String aa;
                            a = aa = a.substring(0, a.indexOf(":[NODE]")) + "::[NODE]:";
                        }
                    }
                } else if (n.indexOf("[EDGE]") != -1 && (indx = a.indexOf(":")) >= 0 && indx + 1 < a.length()) {
                    String s = a.substring(a.indexOf(":") + 1);
                    int j = 0;
                    j = 1;
                    while (!s.equals("") && (indx = s.indexOf(":")) >= 0 && indx + 1 < s.length()) {
                        String ss;
                        s = ss = s.substring(s.indexOf(":") + 1);
                        ++j;
                    }
                    if (indx >= 0) {
                        ++j;
                    }
                    if (j > 2 && j < 5) {
                        String aa;
                        a = aa = a.substring(0, a.indexOf(":[EDGE]")) + "::[EDGE]:";
                    }
                }
                n = n.substring(0, i);
                this.setAdditionalRepr(a);
            }
            this.setStringRepr(n);
            h.enrichObject(this.itsAttrType);
            h.close();
        }
    }

    @Override
    public String getName() {
        String stringRepr = this.getStringRepr();
        if ("".equals(stringRepr)) {
            return "unnamed";
        }
        return stringRepr;
    }

    private String getNameForType(Type type) {
        String stringRepr = type.getStringRepr();
        if ("".equals(stringRepr)) {
            return "unnamed";
        }
        return stringRepr;
    }

    @Override
    public TypeError check(GraphObject nodeOrArc, int level) {
        if (level == 0) {
            return null;
        }
        if (nodeOrArc instanceof Node) {
            return this.check((Node)nodeOrArc, level);
        }
        if (nodeOrArc instanceof Arc) {
            return this.check((Arc)nodeOrArc, level);
        }
        throw new IllegalArgumentException("parameter must be of type Node or Arc.");
    }

    public TypeError check(Node node, int level) {
        if (this.nodeTypeGraphObject != null) {
            if (level == 10) {
                return null;
            }
            if (level == 20) {
                int sourceMax = this.typeGraphNode.getSourceMax();
                int count = this.typeGraphNode.getSize(node.getContext());
                if (sourceMax != -1 && (count > sourceMax || !this.usingGraphObjects.contains(node) && count + 1 > sourceMax)) {
                    return new TypeError(25, "- Too many nodes of type \"" + this.getNameForType(this) + "\".\nThere are only " + sourceMax + " allowed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
            } else if (level == 30) {
                Type otherNodeType;
                Type arcType;
                Arc typeGraphArc;
                int sourceMax = this.typeGraphNode.getSourceMax();
                int count = this.typeGraphNode.getSize(node.getContext());
                if (sourceMax != -1 && (count > sourceMax || !this.usingGraphObjects.contains(node) && count + 1 > sourceMax)) {
                    return new TypeError(25, "- Too many nodes of type \"" + this.getNameForType(this) + "\".\nThere are only " + sourceMax + " allowed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
                int sourceMin = this.typeGraphNode.getSourceMin();
                if (sourceMin != -1 && this.usingGraphObjects.contains(node) && count < sourceMin) {
                    return new TypeError(24, "- Not enough nodes of type \"" + this.getNameForType(this) + "\".\nThere are at least " + sourceMin + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
                Enumeration types = this.nodeTypeGraphObject.getIncomingArcs();
                while (types.hasMoreElements()) {
                    typeGraphArc = (Arc)types.nextElement();
                    arcType = typeGraphArc.getType();
                    sourceMin = arcType.getSourceMin(otherNodeType = typeGraphArc.getSource().getType(), this);
                    if (sourceMin == -1) continue;
                    Enumeration arcs = node.getIncomingArcs();
                    count = 0;
                    Arc arc = null;
                    while (arcs.hasMoreElements()) {
                        arc = (Arc)arcs.nextElement();
                        if (!arc.getType().equals(arcType) || !arc.getSource().getType().isRelatedTo(otherNodeType)) continue;
                        ++count;
                    }
                    if (count >= sourceMin) continue;
                    if (arc != null) {
                        return new TypeError(23, "- Not enough edges of type \"" + this.getNameForType(arcType) + "\" start at a node of type \"" + this.getNameForType(otherNodeType) + "\" and end at a node of type \"" + this.getNameForType(node.getType()) + "\".\nThere are at least " + sourceMin + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                    }
                    return new TypeError(23, "- Not enough edges of type \"" + this.getNameForType(arcType) + "\" start at a node of type \"" + this.getNameForType(otherNodeType) + "\" and end at a node of type \"" + this.getNameForType(node.getType()) + "\".\nThere are at least " + sourceMin + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
                types = this.nodeTypeGraphObject.getOutgoingArcs();
                while (types.hasMoreElements()) {
                    typeGraphArc = (Arc)types.nextElement();
                    arcType = typeGraphArc.getType();
                    int targetMin = arcType.getTargetMin(this, otherNodeType = typeGraphArc.getTarget().getType());
                    if (targetMin == -1) continue;
                    Enumeration arcs = node.getOutgoingArcs();
                    count = 0;
                    Arc arc = null;
                    while (arcs.hasMoreElements()) {
                        arc = (Arc)arcs.nextElement();
                        if (!arc.getType().equals(arcType) || !arc.getTarget().getType().isRelatedTo(otherNodeType)) continue;
                        ++count;
                    }
                    if (count >= targetMin) continue;
                    if (arc != null) {
                        return new TypeError(23, "- Not enough edges of type \"" + this.getNameForType(arcType) + "\" start at a node of type \"" + this.getNameForType(node.getType()) + "\" and end at a node of type \"" + this.getNameForType(otherNodeType) + "\".\nThere are at least " + targetMin + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                    }
                    return new TypeError(23, "- Not enough edges of type \"" + this.getNameForType(arcType) + "\" start at a node of type \"" + this.getNameForType(node.getType()) + "\" and end at a node of type \"" + this.getNameForType(otherNodeType) + "\".\nThere are at least " + targetMin + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
            }
            return null;
        }
        return new TypeError(21, "The type graph does not contain a node type with name \"" + this.getName() + "\".", node, this);
    }

    public TypeError check(Arc arc, int level) {
        Type sourceType = arc.getSource().getType();
        Type targetType = arc.getTarget().getType();
        Type mySrcType = arc.getSource().getType();
        Type myTarType = arc.getTarget().getType();
        Vector mySrcParents = sourceType.getAllParents();
        Vector myTarParents = targetType.getAllParents();
        TypeGraphArc subType = null;
        if (this.edgeTypeGraphObjects != null) {
            for (int i = 0; i < mySrcParents.size() && subType == null; ++i) {
                mySrcType = (Type)mySrcParents.get(i);
                HashMap targets = (HashMap)this.edgeTypeGraphObjects.get(mySrcType);
                if (targets == null) continue;
                for (int j = 0; j < myTarParents.size() && (subType = (TypeGraphArc)targets.get(myTarType = (Type)myTarParents.get(j))) == null; ++j) {
                }
            }
        }
        if (subType != null && subType.existsTypeGraphObject()) {
            if (level == 10) {
                return null;
            }
            int count = 0;
            Arc actArc = null;
            Enumeration arcs = null;
            int sourceMax = subType.getSourceMax();
            int targetMax = subType.getTargetMax();
            if (targetMax != -1) {
                arcs = arc.getSource().getOutgoingArcs();
                while (arcs.hasMoreElements() && targetMax >= count) {
                    actArc = (Arc)arcs.nextElement();
                    if (!actArc.getType().equals(this) || !targetType.isRelatedTo(actArc.getTarget().getType())) continue;
                    ++count;
                }
                if (count > targetMax) {
                    String isOrAre = "is";
                    if (targetMax != 1) {
                        isOrAre = "are";
                    }
                    if (actArc != null) {
                        return new TypeError(22, "- Too many edges of type \"" + this.getName() + "\" end at the node of type \"" + targetType.getName() + "\".\nThere " + isOrAre + " only " + targetMax + " allowed ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                    }
                    return new TypeError(22, "- Too many edges of type \"" + this.getName() + "\" end at the green marked node.\nThere " + isOrAre + " only " + targetMax + " allowed ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                }
            }
            if (sourceMax != -1) {
                arcs = arc.getTarget().getIncomingArcs();
                count = 0;
                actArc = null;
                while (arcs.hasMoreElements() && sourceMax >= count) {
                    actArc = (Arc)arcs.nextElement();
                    if (!actArc.getType().equals(this) || !sourceType.isRelatedTo(actArc.getSource().getType())) continue;
                    ++count;
                }
                if (count > sourceMax) {
                    String isOrAre = "is";
                    if (sourceMax != 1) {
                        isOrAre = "are";
                    }
                    if (actArc != null) {
                        return new TypeError(22, "- Too many edges of type \"" + this.getName() + "\" start at the node of type \"" + sourceType.getName() + "\".\nThere " + isOrAre + " only " + sourceMax + " allowed ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                    }
                    return new TypeError(22, "- Too many edges of type \"" + this.getName() + "\" start at the green marked node.\nThere " + isOrAre + " only " + sourceMax + " allowed ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                }
            }
            return null;
        }
        return new TypeError(21, "- The type graph does not contain an edge type with name \"" + this.getName() + "\" \nbetween node type \"" + this.getNameForType(sourceType) + "\" and \"" + this.getNameForType(targetType) + "\".", arc, this);
    }

    public TypeError checkIfEdgeCreatable(Node src, Node tar, int level) {
        TypeGraphArc subType;
        HashMap targets;
        if (level == 0 || level == 10) {
            return null;
        }
        Type sourceType = src.getType();
        Type targetType = tar.getType();
        if (this.edgeTypeGraphObjects != null && (targets = (HashMap)this.edgeTypeGraphObjects.get(sourceType)) != null && (subType = (TypeGraphArc)targets.get(targetType)) != null && subType.existsTypeGraphObject()) {
            int sourceMax;
            int targetMax = subType.getTargetMax();
            if (targetMax != -1) {
                Enumeration arcs = tar.getIncomingArcs();
                int count = 0;
                Arc actArc = null;
                while (arcs.hasMoreElements() && targetMax >= count) {
                    actArc = (Arc)arcs.nextElement();
                    if (!actArc.getType().equals(this) || !actArc.getTarget().getType().equals(targetType)) continue;
                    ++count;
                }
                if (count > targetMax) {
                    String isOrAre = "is";
                    if (targetMax != 1) {
                        isOrAre = "are";
                    }
                    if (actArc != null) {
                        return new TypeError(22, "Too many edges of type \"" + this.getName() + "\" end at the node of type \"" + actArc.getTarget().getType().getName() + "\" (green marked node).\nThere " + isOrAre + " only " + targetMax + " allowed ( graph \"" + actArc.getContext().getName() + "\" ).", src, this);
                    }
                    return new TypeError(22, "Too many edges of type \"" + this.getName() + "\" end at the green marked node.\nThere " + isOrAre + " only " + targetMax + " allowed ( graph \"" + actArc.getContext().getName() + "\" ).", src, this);
                }
            }
            if ((sourceMax = subType.getSourceMax()) != -1) {
                Enumeration arcs = src.getOutgoingArcs();
                int count = 0;
                Arc actArc = null;
                while (arcs.hasMoreElements() && sourceMax >= count) {
                    actArc = (Arc)arcs.nextElement();
                    if (!actArc.getType().equals(this) || !actArc.getSource().getType().equals(sourceType)) continue;
                    ++count;
                }
                if (count > sourceMax) {
                    String isOrAre = "is";
                    if (sourceMax != 1) {
                        isOrAre = "are";
                    }
                    if (actArc != null) {
                        return new TypeError(22, "Too many edges of type \"" + this.getName() + "\" start at the node of type \"" + actArc.getSource().getType().getName() + "\" (green marked node).\nThere " + isOrAre + " only " + sourceMax + " allowed ( graph \"" + actArc.getContext().getName() + "\" ).", tar, this);
                    }
                    return new TypeError(22, "Too many edges of type \"" + this.getName() + "\" start at the green marked node.\nThere " + isOrAre + " only " + sourceMax + " allowed ( graph \"" + actArc.getContext().getName() + "\" ).", tar, this);
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean addTypeGraphObject(GraphObject nodeOrArc) {
        if (!nodeOrArc.getContext().isTypeGraph()) {
            return false;
        }
        if (nodeOrArc instanceof Arc) {
            Type targetType;
            this.typeGraphObjectDefined = true;
            Type sourceType = ((Arc)nodeOrArc).getSource().getType();
            TypeGraphArc subType = this.getTypeGraphArc(sourceType, targetType = ((Arc)nodeOrArc).getTarget().getType());
            return subType.addTypeGraphObject();
        }
        if (this.nodeTypeGraphObject != null) {
            return false;
        }
        this.typeGraphObjectDefined = true;
        this.nodeTypeGraphObject = (Node)nodeOrArc;
        if (this.typeGraphNode == null) {
            this.typeGraphNode = new TypeGraphNode();
        }
        this.typeGraphNode.addTypeGraphObject();
        return true;
    }

    @Override
    public boolean removeTypeGraphObject(GraphObject nodeOrArc) {
        if (nodeOrArc == null || nodeOrArc.getContext() == null) {
            return false;
        }
        boolean allowedToRemove = false;
        if (nodeOrArc.getContext().getTypeSet().getLevelOfTypeGraphCheck() <= 0) {
            allowedToRemove = true;
        } else if (nodeOrArc.isNode() && this.usingGraphObjects.isEmpty()) {
            TypeImpl oldestAncestor = this;
            allowedToRemove = true;
        } else {
            allowedToRemove = nodeOrArc.isArc() ? (this.usingGraphObjects.isEmpty() ? true : this.getTypeGraphArc(((Arc)nodeOrArc).getSource().getType(), ((Arc)nodeOrArc).getTarget().getType()).isUseless()) : false;
        }
        if (allowedToRemove) {
            if (nodeOrArc instanceof Arc) {
                if (this.edgeTypeGraphObjects == null) {
                    return true;
                }
                Type sourceType = ((Arc)nodeOrArc).getSource().getType();
                Type targetType = ((Arc)nodeOrArc).getTarget().getType();
                HashMap targets = (HashMap)this.edgeTypeGraphObjects.get(sourceType);
                if (targets == null) {
                    return true;
                }
                TypeGraphArc subType = (TypeGraphArc)targets.get(targetType);
                if (subType == null) {
                    return true;
                }
                subType.removeTypeGraphObject();
                targets.remove(targetType);
                if (targets.isEmpty()) {
                    this.edgeTypeGraphObjects.remove(sourceType);
                    if (this.edgeTypeGraphObjects.isEmpty()) {
                        this.edgeTypeGraphObjects = null;
                        this.typeGraphObjectDefined = false;
                    }
                }
                return true;
            }
            if (this.nodeTypeGraphObject == null) {
                return true;
            }
            this.typeGraphObjectDefined = false;
            this.nodeTypeGraphObject = null;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllTypeGraphObjects() {
        if (this.edgeTypeGraphObjects != null) {
            Iterator iter = this.edgeTypeGraphObjects.values().iterator();
            while (iter.hasNext()) {
                HashMap actMap = (HashMap)iter.next();
                for (TypeGraphArc subType : actMap.values()) {
                    subType.forceRemoveTypeGraphObject();
                    if (!subType.isUseless()) continue;
                }
                if (!actMap.isEmpty()) continue;
                iter.remove();
            }
        }
        if (this.typeGraphNode != null) {
            this.typeGraphNode.forceRemoveTypeGraphObject();
        }
        this.nodeTypeGraphObject = null;
        this.typeGraphObjectDefined = false;
    }

    @Override
    public void addUsingGraphObject(GraphObject nodeOrArc) {
        if (!(nodeOrArc.getContext() != null && nodeOrArc.getContext().isTypeGraph() || this.usingGraphObjects.contains(nodeOrArc))) {
            this.usingGraphObjects.add(nodeOrArc);
        }
        if (nodeOrArc instanceof Arc) {
            Type sourceType = ((Arc)nodeOrArc).getSource().getType();
            Type targetType = ((Arc)nodeOrArc).getTarget().getType();
            this.getTypeGraphArc(sourceType, targetType).addUsingGraphObject(nodeOrArc);
        } else if (nodeOrArc instanceof Node) {
            this.getTypeGraphNode().addUsingGraphObject(nodeOrArc, nodeOrArc.getContext());
        }
    }

    @Override
    public void addUsingGraphObject(GraphObject nodeOrArc, Graph g) {
        if (g == null) {
            return;
        }
        if (!g.isTypeGraph() && !this.usingGraphObjects.contains(nodeOrArc)) {
            this.usingGraphObjects.add(nodeOrArc);
        }
        if (nodeOrArc instanceof Arc) {
            Type sourceType = ((Arc)nodeOrArc).getSource().getType();
            Type targetType = ((Arc)nodeOrArc).getTarget().getType();
            this.getTypeGraphArc(sourceType, targetType).addUsingGraphObject(nodeOrArc);
        } else if (nodeOrArc instanceof Node) {
            this.getTypeGraphNode().addUsingGraphObject(nodeOrArc, g);
        }
    }

    @Override
    public void removeUsingGraphObject(GraphObject nodeOrArc) {
        if (this.usingGraphObjects.contains(nodeOrArc)) {
            this.usingGraphObjects.remove(nodeOrArc);
        }
        if (nodeOrArc instanceof Arc) {
            Type sourceType = ((Arc)nodeOrArc).getSource().getType();
            Type targetType = ((Arc)nodeOrArc).getTarget().getType();
            TypeGraphArc subTypeArc = this.getTypeGraphArc(sourceType, targetType);
            subTypeArc.removeUsingGraphObject(nodeOrArc);
            if (this.edgeTypeGraphObjects == null) {
                return;
            }
            HashMap targets = (HashMap)this.edgeTypeGraphObjects.get(sourceType);
            if (targets == null) {
                return;
            }
            TypeGraphArc subType = (TypeGraphArc)targets.get(targetType);
            if (subType == null) {
                return;
            }
            subType.removeUsingGraphObject(nodeOrArc);
        } else if (this.typeGraphNode != null) {
            this.typeGraphNode.removeUsingGraphObject(nodeOrArc, nodeOrArc.getContext());
        }
    }

    @Override
    public void setSourceMin(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setSourceMin(value);
    }

    @Override
    public void setSourceMax(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setSourceMax(value);
    }

    @Override
    public void setTargetMin(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setTargetMin(value);
    }

    @Override
    public void setTargetMax(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setTargetMax(value);
    }

    @Override
    public int getSourceMin(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getSourceMin();
    }

    @Override
    public int getSourceMax(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getSourceMax();
    }

    @Override
    public int getTargetMin(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getTargetMin();
    }

    @Override
    public int getTargetMax(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getTargetMax();
    }

    @Override
    public void setSourceMin(int value) {
        this.getTypeGraphNode().setSourceMin(value);
    }

    @Override
    public void setSourceMax(int value) {
        this.getTypeGraphNode().setSourceMax(value);
    }

    @Override
    public int getSourceMin() {
        return this.getTypeGraphNode().getSourceMin();
    }

    @Override
    public int getSourceMax() {
        return this.getTypeGraphNode().getSourceMax();
    }

    protected TypeGraphArc getTypeGraphArc(Type sourceType, Type targetType) {
        Type mySrcType = sourceType;
        Type myTarType = targetType;
        Vector mySrcParents = sourceType.getAllParents();
        Vector myTarParents = targetType.getAllParents();
        HashMap targets = null;
        TypeGraphArc subType = null;
        if (this.edgeTypeGraphObjects == null) {
            this.edgeTypeGraphObjects = new HashMap();
        }
        for (int i = 0; i < mySrcParents.size(); ++i) {
            mySrcType = (Type)mySrcParents.get(i);
            targets = (HashMap)this.edgeTypeGraphObjects.get(mySrcType);
            if (targets == null) continue;
            for (int j = 0; j < myTarParents.size(); ++j) {
                myTarType = (Type)myTarParents.get(j);
                subType = (TypeGraphArc)targets.get(myTarType);
                if (subType == null) continue;
                return subType;
            }
        }
        if (targets == null) {
            if (this.edgeTypeGraphObjects.get(sourceType) == null) {
                targets = new HashMap();
                this.edgeTypeGraphObjects.put(sourceType, targets);
                subType = new TypeGraphArc();
                targets.put(targetType, subType);
            } else {
                targets = (HashMap)this.edgeTypeGraphObjects.get(sourceType);
            }
        }
        if (subType == null) {
            subType = new TypeGraphArc();
            targets.put(targetType, subType);
        }
        return subType;
    }

    protected TypeGraphArc getSimilarTypeGraphArc(Type sourceType, Type targetType) {
        for (Type srct : this.edgeTypeGraphObjects.keySet()) {
            if (!srct.compareTo(sourceType)) continue;
            HashMap targetsMap = (HashMap)this.edgeTypeGraphObjects.get(srct);
            for (Type tart : targetsMap.keySet()) {
                if (!tart.compareTo(targetType)) continue;
                TypeGraphArc subType = (TypeGraphArc)targetsMap.get(tart);
                return subType;
            }
        }
        return null;
    }

    public boolean hasTypeGraphArc() {
        return this.edgeTypeGraphObjects != null;
    }

    public boolean hasTypeGraphArc(Type sourceType, Type targetType) {
        if (this.edgeTypeGraphObjects == null) {
            return false;
        }
        HashMap targets = (HashMap)this.edgeTypeGraphObjects.get(sourceType);
        if (targets == null) {
            return false;
        }
        TypeGraphArc subType = (TypeGraphArc)targets.get(targetType);
        return subType != null;
    }

    public boolean hasTypeGraphArc(GraphObject sourceType, GraphObject targetType) {
        return this.hasTypeGraphArc(sourceType.getType(), targetType.getType());
    }

    protected HashMap getArcTypeGraphObjects() {
        return this.edgeTypeGraphObjects;
    }

    public boolean compareTypeGraphArcs(Type t) {
        if (this.edgeTypeGraphObjects == null && ((TypeImpl)t).getArcTypeGraphObjects() == null) {
            return true;
        }
        if (this.edgeTypeGraphObjects != null && ((TypeImpl)t).getArcTypeGraphObjects() != null) {
            if (!this.edgeTypeGraphObjects.isEmpty() && !((TypeImpl)t).getArcTypeGraphObjects().isEmpty()) {
                for (Type srct : this.edgeTypeGraphObjects.keySet()) {
                    HashMap targetsMap = (HashMap)this.edgeTypeGraphObjects.get(srct);
                    for (Type tart : targetsMap.keySet()) {
                        TypeGraphArc subType = (TypeGraphArc)targetsMap.get(tart);
                        TypeGraphArc subType_t = ((TypeImpl)t).getSimilarTypeGraphArc(srct, tart);
                        if (subType_t == null) continue;
                        return false;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public boolean compareTypeGraphArcsMultiplicity(Type t) {
        if (this.edgeTypeGraphObjects == null && ((TypeImpl)t).getArcTypeGraphObjects() == null) {
            return true;
        }
        if (this.edgeTypeGraphObjects != null && ((TypeImpl)t).getArcTypeGraphObjects() != null) {
            if (!this.edgeTypeGraphObjects.isEmpty() && !((TypeImpl)t).getArcTypeGraphObjects().isEmpty()) {
                for (Type srct : this.edgeTypeGraphObjects.keySet()) {
                    HashMap targetsMap = (HashMap)this.edgeTypeGraphObjects.get(srct);
                    for (Type tart : targetsMap.keySet()) {
                        TypeGraphArc subType = (TypeGraphArc)targetsMap.get(tart);
                        TypeGraphArc subType_t = ((TypeImpl)t).getSimilarTypeGraphArc(srct, tart);
                        if (subType_t == null) continue;
                        if (subType.getSourceMax() != subType_t.getSourceMax()) {
                            return false;
                        }
                        if (subType.getSourceMin() != subType_t.getSourceMin()) {
                            return false;
                        }
                        if (subType.getTargetMin() != subType_t.getTargetMin()) {
                            return false;
                        }
                        return subType.getTargetMax() == subType_t.getTargetMax();
                    }
                }
            }
            return false;
        }
        return false;
    }

    protected TypeGraphNode getTypeGraphNode() {
        if (this.typeGraphObjectDefined) {
            return this.typeGraphNode;
        }
        this.typeGraphNode = new TypeGraphNode();
        return this.typeGraphNode;
    }

    public boolean hasTypeGraphNode() {
        return this.typeGraphObjectDefined;
    }

    public boolean isTypeGraphNodeUsed() {
        return this.typeGraphObjectDefined && this.typeGraphNode != null && this.typeGraphNode.isUsed();
    }

    @Override
    public Node getTypeGraphNodeObject() {
        return this.nodeTypeGraphObject;
    }

    @Override
    public boolean isTypeGraphObjectDefined() {
        return this.typeGraphObjectDefined;
    }

    @Override
    public TypeError checkIfRemovableFromSource(GraphObject node, Arc arc, int level) {
        Type otherNodeType;
        if (level != 30) {
            return null;
        }
        if (!arc.getContext().isCompleteGraph()) {
            return null;
        }
        Type arcType = arc.getType();
        int minValue = arcType.getSourceMin(this, otherNodeType = arc.getTarget().getType());
        if (minValue != -1) {
            Enumeration arcs = node.getOutgoingArcs();
            int count = 0;
            while (arcs.hasMoreElements()) {
                Arc actArc = (Arc)arcs.nextElement();
                if (!actArc.getType().equals(arcType) || !actArc.getTarget().getType().equals(otherNodeType)) continue;
                ++count;
            }
            if (count - 1 < minValue) {
                return new TypeError(23, "Not enough edges of type \"" + this.getNameForType(arcType) + "\"" + " start at the source node  " + "\"" + this.getNameForType(arc.getSource().getType()) + "\"." + "\nThere are at least " + minValue + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
            }
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromTarget(GraphObject node, Arc arc, int level) {
        Type otherNodeType;
        if (level != 30) {
            return null;
        }
        if (!arc.getContext().isCompleteGraph()) {
            return null;
        }
        Type arcType = arc.getType();
        int minValue = arcType.getTargetMin(otherNodeType = arc.getSource().getType(), this);
        if (minValue != -1) {
            Enumeration arcs = node.getIncomingArcs();
            int count = 0;
            while (arcs.hasMoreElements()) {
                Arc actArc = (Arc)arcs.nextElement();
                if (!actArc.getType().equals(arcType) || !actArc.getSource().getType().equals(otherNodeType)) continue;
                ++count;
            }
            if (count - 1 < minValue) {
                return new TypeError(23, "Not enough edges of type \"" + this.getNameForType(arcType) + "\"" + " end at the target node  " + "\"" + this.getNameForType(arc.getTarget().getType()) + "\"." + "\nThere are at least " + minValue + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
            }
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovable(Node node, int level) {
        int count;
        if (level != 30) {
            return null;
        }
        if (!node.getContext().isCompleteGraph()) {
            return null;
        }
        int minValue = ((TypeImpl)node.getType()).getTypeGraphNode().getSourceMin();
        if (minValue != -1 && (count = ((TypeImpl)node.getType()).getTypeGraphNode().getSize(node.getContext())) - 1 < minValue) {
            return new TypeError(23, "Not enough node of type \"" + this.getNameForType(this) + "\"" + " .\nThere are at least " + minValue + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
        }
        return null;
    }
}

