/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrTypeMember;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueTuple;
import agg.cons.AtomConstraint;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraphArc;
import agg.xt_basis.TypeGraphNode;
import agg.xt_basis.TypeImpl;
import com.objectspace.jgl.Pair;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSet {
    public static final int UNDEFINED = -1;
    public static final int DISABLED = 0;
    public static final int ENABLED = 10;
    public static final int ENABLED_MAX = 20;
    public static final int ENABLED_MAX_MIN = 30;
    public static final int ENABLED_MIN = 40;
    public static final Collection SUCCESS = new Vector(0);
    Vector<Type> types = new Vector();
    Type inheritanceType;
    AttrInstance inheritanceAttr;
    Vector inheritanceArcs = new Vector();
    Graph typeGraph = null;
    AttrManager attrManager = AttrTupleManager.getDefaultManager();
    boolean typeGraphIsProofed = false;
    int typeGraphLevel = 0;
    boolean newTypeGraphObjectImported = false;

    public boolean isEmpty() {
        return this.types.size() == 0;
    }

    public final Enumeration<Type> getTypes() {
        return this.types.elements();
    }

    public final Vector<Arc> getInheritanceArcs() {
        return this.inheritanceArcs;
    }

    public boolean hasInheritance() {
        return !this.inheritanceArcs.isEmpty();
    }

    public boolean usesInheritance() {
        return this.hasInheritance();
    }

    public Type getTypeForName(String name) {
        for (int i = 0; i < this.types.size(); ++i) {
            Type t = this.types.elementAt(i);
            if (!t.getStringRepr().equals(name)) continue;
            return t;
        }
        return null;
    }

    public Type getSimilarType(Type t) {
        for (int i = 0; i < this.types.size(); ++i) {
            Type ti = this.types.elementAt(i);
            if (!ti.getName().equals(t.getName()) || !ti.compareTo(t)) continue;
            return ti;
        }
        return null;
    }

    public Node getTypeGraphNode(Type t) {
        return ((TypeImpl)t).getTypeGraphNodeObject();
    }

    public Arc getTypeGraphArc(Type t, Type source, Type target) {
        Vector v;
        Arc typeArc = null;
        TypeGraphArc tga = ((TypeImpl)t).getTypeGraphArc(source, target);
        if (tga != null && !(v = this.typeGraph.getElementsOfTypeAsVector(t, source, target)).isEmpty()) {
            typeArc = (Arc)v.firstElement();
        }
        return typeArc;
    }

    public Graph getTypeGraph() {
        return this.typeGraph;
    }

    public void setTypeGraph(Graph typeGraph) {
        if (typeGraph != null) {
            if (!this.compareTo(typeGraph.getTypeSet())) {
                throw new RuntimeException("Setting type graph failed. It uses not defined types.");
            }
            if (this != typeGraph.getTypeSet()) {
                typeGraph.setTypeSet(this);
            }
        }
        this.typeGraph = typeGraph;
        this.typeGraphIsProofed = false;
    }

    public void adaptTypes(TypeSet otherTypeSet, boolean all) {
        Type type;
        Vector<Pair> v = new Vector<Pair>(5);
        Enumeration<Type> othertypes = otherTypeSet.getTypes();
        while (othertypes.hasMoreElements()) {
            int i;
            Type t = othertypes.nextElement();
            Type similar = this.getTypeForName(t.getName());
            if (!all) {
                if (similar != null) continue;
                type = this.adoptType(t);
                for (i = 0; i < t.getParents().size(); ++i) {
                    v.add(new Pair(type, t.getParents().get(i)));
                }
                continue;
            }
            type = this.adoptType(t);
            for (i = 0; i < t.getParents().size(); ++i) {
                v.add(new Pair(type, t.getParents().get(i)));
            }
        }
        for (int i = 0; i < v.size(); ++i) {
            Pair pair = (Pair)v.get(i);
            type = (Type)pair.first;
            Type par = (Type)pair.second;
            this.addInheritanceRelation(type, this.getTypeForName(par.getName()));
        }
    }

    public void adaptTypes(Enumeration otherTypes, boolean all) {
        Type type;
        Vector<Pair> v = new Vector<Pair>(5);
        while (otherTypes.hasMoreElements()) {
            int i;
            Type t = (Type)otherTypes.nextElement();
            Type similar = this.getTypeForName(t.getName());
            if (!all) {
                if (similar != null) continue;
                type = this.adoptType(t);
                for (i = 0; i < t.getParents().size(); ++i) {
                    v.add(new Pair(type, t.getParents().get(i)));
                }
                continue;
            }
            type = this.adoptType(t);
            for (i = 0; i < t.getParents().size(); ++i) {
                v.add(new Pair(type, t.getParents().get(i)));
            }
        }
        for (int i = 0; i < v.size(); ++i) {
            Pair pair = (Pair)v.get(i);
            type = (Type)pair.first;
            Type par = (Type)pair.second;
            this.addInheritanceRelation(type, this.getTypeForName(par.getName()));
        }
    }

    private void adaptTypeInheritance(Graph tGraph, Vector typesToAdapt, Hashtable oldInheritance) {
        if (tGraph == null || this.typeGraph == null || !this.typeGraph.getNodes().hasMoreElements() || typesToAdapt.isEmpty()) {
            return;
        }
        Enumeration e = this.typeGraph.getNodes();
        while (e.hasMoreElements()) {
            Node tn;
            Node n = (Node)e.nextElement();
            Type t = n.getType();
            Type t1 = tGraph.getTypeSet().getTypeForName(t.getName());
            if (t1 == null || !typesToAdapt.contains(t1) || (tn = tGraph.getTypeSet().getTypeGraphNode(t1)) == null) continue;
            if (!t1.getParents().isEmpty()) {
                for (int i = 0; i < t1.getParents().size(); ++i) {
                    Type p1i = t1.getParents().get(i);
                    this.addInheritanceRelation(t, this.getTypeForName(p1i.getName()));
                }
            } else if (oldInheritance.get(t) != null) {
                Vector v = (Vector)oldInheritance.get(t);
                for (int i = 0; i < v.size(); ++i) {
                    Type pi = (Type)v.get(i);
                    this.addInheritanceRelation(t, pi);
                }
            } else {
                this.removeAllInheritanceRelations(t);
            }
            ((ValueTuple)n.getAttribute()).refreshParents();
        }
    }

    private void adaptTypeMultiplicity(Graph tGraph, Vector typesToAdapt) {
        Type t;
        if (tGraph == null || this.typeGraph == null || !this.typeGraph.getNodes().hasMoreElements()) {
            return;
        }
        Enumeration e = this.typeGraph.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            t = n.getType();
            Type t1 = tGraph.getTypeSet().getTypeForName(t.getName());
            if (t1 == null || !typesToAdapt.contains(t1)) continue;
            if (t.getSourceMax() != -1 && (t1.getSourceMax() == -1 || t1.getSourceMax() > t.getSourceMax())) {
                t.setSourceMax(t1.getSourceMax());
            }
            if (t.getSourceMin() == -1 || t1.getSourceMin() == -1 && t1.getSourceMin() <= t.getSourceMin()) continue;
            t.setSourceMin(t1.getSourceMin());
        }
        e = this.typeGraph.getArcs();
        while (e.hasMoreElements()) {
            TypeGraphArc subt1;
            Arc a1;
            Arc a = (Arc)e.nextElement();
            t = a.getType();
            Type src_t = a.getSource().getType();
            Type tar_t = a.getTarget().getType();
            TypeGraphArc subt = ((TypeImpl)t).getTypeGraphArc(src_t, tar_t);
            Type t1 = tGraph.getTypeSet().getTypeForName(t.getName());
            Type src_t1 = tGraph.getTypeSet().getTypeForName(src_t.getName());
            Type tar_t1 = tGraph.getTypeSet().getTypeForName(tar_t.getName());
            if (t1 == null || src_t1 == null || tar_t1 == null || !typesToAdapt.contains(t1) || (a1 = this.getTypeGraphArc(t1, src_t1, tar_t1)) == null || (subt1 = ((TypeImpl)t1).getTypeGraphArc(src_t1, tar_t1)) == null) continue;
            if (subt.getSourceMin() != -1 && (subt1.getSourceMin() != -1 || subt1.getSourceMin() > subt.getSourceMin())) {
                subt.setSourceMin(subt1.getSourceMin());
            }
            if (subt.getSourceMax() != -1 && (subt1.getSourceMax() != -1 || subt1.getSourceMax() > subt.getSourceMax())) {
                subt.setSourceMax(subt1.getSourceMax());
            }
            if (subt.getTargetMin() != -1 && (subt1.getTargetMin() != -1 || subt1.getTargetMin() > subt.getTargetMin())) {
                subt.setTargetMin(subt1.getTargetMin());
            }
            if (subt.getTargetMax() == -1 || subt1.getTargetMax() == -1 && subt1.getTargetMax() <= subt.getTargetMax()) continue;
            subt.setTargetMax(subt1.getTargetMax());
        }
    }

    private void adaptClans() {
        if (this.typeGraph == null || !this.typeGraph.getNodes().hasMoreElements()) {
            return;
        }
        Enumeration e = this.typeGraph.getNodes();
        while (e.hasMoreElements()) {
            Pair srcTtarT;
            Vector tmp;
            Arc a;
            Node cn;
            Node n = (Node)e.nextElement();
            Type t = n.getType();
            Vector<Type> clan = this.getClan(t);
            Vector<Node> clanNodes = new Vector<Node>(5);
            for (int i = 0; i < clan.size(); ++i) {
                Type ct = clan.get(i);
                ((TypeImpl)ct).checkDoubleAttributeType();
                cn = this.typeGraph.getTypeSet().getTypeGraphNode(ct);
                if (cn == null) continue;
                clanNodes.add(cn);
            }
            Vector<Arc> clanArcs = new Vector<Arc>(5);
            for (int i = 0; i < clanNodes.size(); ++i) {
                cn = (Node)clanNodes.get(i);
                Enumeration arcs = cn.getIncomingArcs();
                while (arcs.hasMoreElements()) {
                    a = (Arc)arcs.nextElement();
                    if (a.isInheritance() || clanArcs.contains(a) || (Node)a.getSource() == n || !clanNodes.contains((Node)a.getSource())) continue;
                    clanArcs.add(a);
                }
                arcs = cn.getOutgoingArcs();
                while (arcs.hasMoreElements()) {
                    a = (Arc)arcs.nextElement();
                    if (a.isInheritance() || clanArcs.contains(a) || (Node)a.getTarget() == n || !clanNodes.contains((Node)a.getTarget())) continue;
                    clanArcs.add(a);
                }
            }
            Vector<Arc> arcsToDelete = new Vector<Arc>(5);
            int nn = clanArcs.size();
            for (int k = 0; nn > 0 && k < nn; ++k) {
                a = (Arc)clanArcs.get(k);
                boolean found = false;
                for (int j = k + 1; j < clanArcs.size(); ++j) {
                    Arc aj = (Arc)clanArcs.get(j);
                    if (!aj.getType().getName().equals(a.getType().getName())) continue;
                    found = true;
                    arcsToDelete.add(aj);
                    clanArcs.remove(aj);
                    --j;
                }
                if (found) {
                    arcsToDelete.add(a);
                }
                nn = clanArcs.size();
            }
            Hashtable<Type, Vector> table = new Hashtable<Type, Vector>(5, 5.0f);
            for (int i = 0; i < arcsToDelete.size(); ++i) {
                Arc a2 = (Arc)arcsToDelete.get(i);
                tmp = new Vector(3);
                srcTtarT = new Pair(a2.getSource().getType(), a2.getTarget().getType());
                TypeGraphArc subt = ((TypeImpl)t).getTypeGraphArc(a2.getSource().getType(), a2.getTarget().getType());
                Pair srcMult = new Pair(new Integer(subt.getSourceMin()), new Integer(subt.getSourceMax()));
                Pair tarMult = new Pair(new Integer(subt.getTargetMin()), new Integer(subt.getTargetMax()));
                tmp.add(srcTtarT);
                tmp.add(srcMult);
                tmp.add(tarMult);
                table.put(a2.getType(), tmp);
                try {
                    this.typeGraph.destroyArc(a2);
                    continue;
                }
                catch (TypeException exc) {
                    // empty catch block
                }
            }
            if (table.isEmpty()) continue;
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                Type arcT = (Type)keys.nextElement();
                tmp = (Vector)table.get(arcT);
                srcTtarT = (Pair)tmp.get(0);
                Pair srcMult = (Pair)tmp.get(1);
                Pair tarMult = (Pair)tmp.get(2);
                Type srcT = (Type)srcTtarT.first;
                Type tarT = (Type)srcTtarT.second;
                Node src = this.typeGraph.getTypeSet().getTypeGraphNode(srcT);
                Node tar = this.typeGraph.getTypeSet().getTypeGraphNode(tarT);
                try {
                    Arc a3 = this.typeGraph.createArc(arcT, src, tar);
                    TypeGraphArc subt = ((TypeImpl)arcT).getTypeGraphArc(src.getType(), tar.getType());
                    subt.setSourceMin((Integer)srcMult.first);
                    subt.setSourceMax((Integer)srcMult.second);
                    subt.setTargetMin((Integer)tarMult.first);
                    subt.setTargetMax((Integer)tarMult.second);
                }
                catch (TypeException exc) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean importTypeGraph(Graph tGraph, boolean rewrite) {
        boolean conflicting;
        boolean all = true;
        Vector differentAttribute = new Vector(5);
        Vector differentInheritance = new Vector(5);
        Hashtable<Type, Vector<Type>> oldInheritance = new Hashtable<Type, Vector<Type>>(5, 5.0f);
        Vector differentMultiplicity = new Vector(5);
        Vector typesToAdd = new Vector(5);
        boolean bl = conflicting = !this.compareTypes(tGraph.getTypeSet(), differentAttribute, differentInheritance, differentMultiplicity, typesToAdd);
        if (conflicting && this.typeGraphLevel != 0) {
            System.out.println("Import Type Graph failed \nbecause there are conflicts between the type graph objects! \nType Graph check should be disabled before.");
            return false;
        }
        if (this.typeGraph != null) {
            if (!rewrite) {
                if (conflicting) {
                    System.out.println("Import Type Graph failed \nbecause there are conflicts between the type graph objects!");
                    return false;
                }
                this.adaptTypes(tGraph.getTypeSet().getTypes(), !all);
                if (this.typeGraph.addCopyOfGraph(tGraph, false)) {
                    this.refreshInheritanceArcs();
                    return true;
                }
                System.out.println("Import Type Graph failed! Something gone wrong!");
                return false;
            }
            if (!rewrite) return false;
            for (int i = 0; i < differentInheritance.size(); ++i) {
                Type other_t = (Type)differentInheritance.get(i);
                Type t = this.getTypeForName(other_t.getName());
                Vector v = this.typeGraph.getElementsOfTypeAsVector(t);
                if (v.isEmpty() || !((GraphObject)v.firstElement()).isNode() || t.getParents().isEmpty()) continue;
                oldInheritance.put(t, t.getParents());
            }
            if (this.typeGraph.addCopyOfGraph(tGraph, true)) {
                this.adaptTypeAttribute(differentAttribute);
                this.adaptTypeInheritance(tGraph, differentInheritance, oldInheritance);
                this.adaptTypeMultiplicity(tGraph, differentMultiplicity);
                this.adaptClans();
                return true;
            }
            System.out.println("Import Type Graph failed! Something gone wrong!");
            return false;
        }
        if (!rewrite) {
            if (conflicting) {
                System.out.println("Import Type Graph failed \nbecause there are conflicts between the type graph objects!");
                return false;
            }
            this.adaptTypes(tGraph.getTypeSet().getTypes(), !all);
            this.typeGraph = tGraph.copy(this);
            this.typeGraph.setName("TypeGraph");
            this.refreshInheritanceArcs();
            return true;
        }
        this.createTypeGraph();
        if (this.typeGraph.addCopyOfGraph(tGraph, false)) {
            this.adaptTypeAttribute(differentAttribute);
            return true;
        }
        System.out.println("Import Type Graph failed! Something gone wrong!");
        return false;
    }

    public Graph createTypeGraph() {
        this.typeGraph = new Graph(this);
        this.typeGraph.setName("TypeGraph");
        this.typeGraphIsProofed = false;
        this.checkTypeGraph();
        return this.typeGraph;
    }

    public void clearTypeGraph() {
        if (this.typeGraph != null && !this.typeGraph.isEmpty() && this.typeGraphLevel == 0) {
            Enumeration e = this.typeGraph.getNodes();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                this.removeAllInheritanceRelations(n.getType());
            }
            for (int i = 0; i < this.inheritanceArcs.size(); ++i) {
                Arc a = (Arc)this.inheritanceArcs.get(i);
                this.removeAllInheritanceRelations(((Node)a.getSource()).getType());
            }
            this.inheritanceArcs.clear();
            this.typeGraph.clear();
        }
    }

    public final Type createType() {
        TypeImpl aType = new TypeImpl(this.attrManager.newType());
        this.types.add(aType);
        return aType;
    }

    public void addType(Type newType) {
        this.types.add(newType);
    }

    public Type adoptType(Type t) {
        TypeImpl type = new TypeImpl(this.attrManager.newType());
        DeclTuple declTuple = (DeclTuple)type.getAttrType();
        DeclTuple otherTuple = (DeclTuple)t.getAttrType();
        boolean failed = false;
        for (int i = 0; i < otherTuple.getSize(); ++i) {
            AttrTypeMember dmnew;
            DeclMember dm = (DeclMember)otherTuple.getMemberAt(i);
            if (dm.getHoldingTuple() != otherTuple || (dmnew = declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherTuple.getTypeAsString(i), otherTuple.getNameAsString(i))) != null) continue;
            failed = true;
            break;
        }
        if (!failed) {
            type.setStringRepr(t.getStringRepr());
            type.setAdditionalRepr(t.getAdditionalRepr());
            this.types.add(type);
        } else {
            type = null;
        }
        return type;
    }

    private boolean adaptTypeAttribute(Type type) {
        Type myType = this.getTypeForName(type.getName());
        if (myType != null) {
            ((TypeImpl)myType).adaptTypeAttribute(type);
        }
        return true;
    }

    private void adaptTypeAttribute(Vector typesToAdapt) {
        boolean conflict = false;
        for (int i = 0; i < typesToAdapt.size(); ++i) {
            Type other_t = (Type)typesToAdapt.get(i);
            conflict = this.adaptTypeAttribute(other_t);
        }
    }

    public boolean containsType(Type type) {
        for (int i = 0; i < this.types.size(); ++i) {
            Type t = this.types.get(i);
            if (!t.isRelatedTo(type)) continue;
            return true;
        }
        return false;
    }

    public void destroyType(Type type) throws TypeException {
        if (this.typeGraphLevel != 0 && type.isTypeGraphObjectDefined()) {
            throw new TypeException(new TypeError(4, "There is at least one type graph object defined for \"" + this.getNameForType(type) + "\" type." + "\nRemove it before you remove the type.", type, this.getTypeGraph()));
        }
        Vector<Type> clan = this.getClan(type);
        for (int i = 0; i < clan.size(); ++i) {
            Type t = clan.get(i);
            this.addInheritanceRelation(t, null);
        }
        this.types.remove(type);
    }

    public AttrManager getAttrManager() {
        return this.attrManager;
    }

    private String getNameForType(Type type) {
        String stringRepr = type.getStringRepr();
        if ("".equals(stringRepr)) {
            return "unnamed";
        }
        return stringRepr;
    }

    TypeError checkTypeInTypeGraph(Arc arc, int typeGraphLevel) {
        return arc.getType().check(arc, typeGraphLevel);
    }

    TypeError checkTypeInTypeGraph(Node node, int typeGraphLevel) {
        TypeError ActError = this.checkMultiplicity(node, typeGraphLevel);
        if (ActError == null) {
            return node.getType().check(node, typeGraphLevel);
        }
        return ActError;
    }

    public Collection checkTypeGraph() {
        Type actType;
        this.typeGraphIsProofed = false;
        Vector<TypeError> errors = new Vector<TypeError>();
        if (this.typeGraph == null) {
            errors.add(new TypeError(1, "The current grammar does not contain a type graph."));
            return errors;
        }
        Enumeration en = this.types.elements();
        while (en.hasMoreElements()) {
            actType = en.nextElement();
            actType.removeAllTypeGraphObjects();
        }
        en = this.typeGraph.getElements();
        while (en.hasMoreElements()) {
            GraphObject actGraphObject = (GraphObject)en.nextElement();
            actType = actGraphObject.getType();
            if (actType.addTypeGraphObject(actGraphObject)) continue;
            TypeError newError = actGraphObject instanceof Node ? new TypeError(3, "The type graph contains already a node type \"" + this.getNameForType(actType) + "\".", actGraphObject, actType) : new TypeError(3, "The type graph contains already an edge type \"" + this.getNameForType(actType) + "\" between node types \"" + this.getNameForType(((Arc)actGraphObject).getSource().getType()) + "\" and \"" + this.getNameForType(((Arc)actGraphObject).getTarget().getType()) + "\".", actGraphObject, actType);
            newError.setContainingGraph(this.typeGraph);
            errors.add(newError);
        }
        if (errors.isEmpty()) {
            this.typeGraphIsProofed = true;
        }
        return errors;
    }

    public TypeError addTypeGraphObject(GraphObject newObject) {
        if (!this.typeGraphIsProofed) {
            return null;
        }
        Type actType = newObject.getType();
        if (!actType.addTypeGraphObject(newObject)) {
            TypeError error = newObject instanceof Node ? new TypeError(3, "The type graph contains already a node type \"" + this.getNameForType(actType) + "\".", newObject, actType) : new TypeError(3, "The type graph contains already an edge type \"" + this.getNameForType(actType) + "\" between node types \"" + this.getNameForType(((Arc)newObject).getSource().getType()) + "\" and \"" + this.getNameForType(((Arc)newObject).getTarget().getType()) + "\".", newObject, actType);
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        return null;
    }

    public TypeError addInheritanceRelation(Type child, Type parent) {
        if (this.typeGraph == null || parent == null) {
            return null;
        }
        if (this.inheritanceType == null) {
            this.inheritanceType = new TypeImpl(this.attrManager.newType());
        }
        if (this.inheritanceAttr == null) {
            this.inheritanceAttr = this.attrManager.newInstance(this.inheritanceType.getAttrType());
        }
        if (child == parent) {
            TypeError error = new TypeError(26, "reflexive inheritance relation is not allowed");
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        if (child.getAllParents().contains(parent)) {
            TypeError error = new TypeError(26, "this parent is already an ancestor");
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        for (int i = 0; i < parent.getParents().size(); ++i) {
            Type pi = parent.getParents().get(i);
            if (!pi.getAllParents().contains(child)) continue;
            TypeError error = new TypeError(26, "cyclic inheritance relation is not allowed");
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        Vector<String> doubleNames = ((TypeImpl)child).checkDoubleAttributeName(parent);
        if (!doubleNames.isEmpty()) {
            TypeError error = new TypeError(26, "attribute name should be unique \ndouble name  " + doubleNames.toString());
            error.setContainingGraph(this.typeGraph);
            return error;
        }
        child.addParent(parent);
        Node childNode = null;
        Node parentNode = null;
        Enumeration en = this.typeGraph.getNodes();
        while (en.hasMoreElements()) {
            Node currentNode = (Node)en.nextElement();
            if (currentNode.getType() == child) {
                childNode = currentNode;
            }
            if (currentNode.getType() != parent) continue;
            parentNode = currentNode;
        }
        if (childNode != null && parentNode != null) {
            Arc inheritArc = new Arc(this.inheritanceAttr, this.inheritanceType, childNode, parentNode, this.typeGraph);
            inheritArc.setInheritance(true);
            this.inheritanceArcs.add(inheritArc);
        }
        this.refreshInheritanceClan(child, parent, true);
        this.checkOtherDirectParents(child, parent);
        return null;
    }

    private void checkOtherDirectParents(Type child, Type p) {
        for (int i = 1; i < p.getAllParents().size(); ++i) {
            Type pi = (Type)p.getAllParents().get(i);
            if (!child.getParents().contains(pi)) continue;
            this.removeInheritanceRelation(child, pi);
        }
    }

    public boolean removeAllInheritanceRelations(Type child) {
        if (!child.getParents().isEmpty()) {
            for (int i = 0; i < child.getParents().size(); ++i) {
                Type p = child.getParents().get(i);
                this.removeInheritanceRelation(child, p);
            }
        }
        return true;
    }

    public boolean removeInheritanceRelation(Type child, Type parent) {
        if (this.typeGraph == null || parent == null) {
            return false;
        }
        if (child == parent) {
            return false;
        }
        if (child.getParents().contains(parent)) {
            Arc inArc = null;
            for (int i = 0; i < this.inheritanceArcs.size(); ++i) {
                Arc currentArc = (Arc)this.inheritanceArcs.get(i);
                if (currentArc.getSource().getType() != child || currentArc.getTarget().getType() != parent) continue;
                inArc = currentArc;
                break;
            }
            if (inArc != null) {
                try {
                    this.typeGraph.destroyArc(inArc, false);
                    this.inheritanceArcs.remove(inArc);
                    child.removeParent(parent);
                    this.refreshInheritanceClan(child, parent, false);
                    return true;
                }
                catch (TypeException exc) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void refreshInheritanceArcs() {
        this.inheritanceArcs.clear();
        if (this.inheritanceType == null) {
            this.inheritanceType = new TypeImpl(this.attrManager.newType());
        }
        if (this.inheritanceAttr == null) {
            this.inheritanceAttr = this.attrManager.newInstance(this.inheritanceType.getAttrType());
        }
        if (this.typeGraph != null) {
            Enumeration en = this.typeGraph.getNodes();
            while (en.hasMoreElements()) {
                Node currentNode = (Node)en.nextElement();
                Type currentType = currentNode.getType();
                for (int i = 0; i < currentType.getParents().size(); ++i) {
                    Type parentType = currentType.getParents().get(i);
                    Enumeration en2 = this.typeGraph.getNodes();
                    while (en2.hasMoreElements()) {
                        Node parentNode = (Node)en2.nextElement();
                        if (parentNode.getType() != parentType) continue;
                        Arc inheritArc = new Arc(this.inheritanceAttr, this.inheritanceType, currentNode, parentNode, null);
                        inheritArc.setInheritance(true);
                        this.inheritanceArcs.add(inheritArc);
                    }
                }
            }
        }
    }

    public Vector<Type> getClan(Type t) {
        Vector<Type> childTypes = new Vector<Type>(1);
        Enumeration<Type> possibleTypes = this.types.elements();
        while (possibleTypes.hasMoreElements()) {
            Type currentType = possibleTypes.nextElement();
            if (!t.isParentOf(currentType)) continue;
            childTypes.add(currentType);
        }
        return childTypes;
    }

    public boolean isClanUsed(Type t) {
        boolean used = false;
        Vector<Type> clan = this.getClan(t);
        for (int i = 0; i < clan.size() && !used; ++i) {
            Type child = clan.get(i);
            if (!((TypeImpl)child).isTypeGraphNodeUsed()) continue;
            used = true;
        }
        return used;
    }

    private void refreshInheritanceClan(Type t) {
        this.refreshInheritanceClan(t, null, false);
    }

    private void refreshInheritanceClan(Type t, Type p, boolean afterAdd) {
        Vector<Type> clan = this.getClan(t);
        for (int i = 0; i < clan.size(); ++i) {
            Type child = clan.get(i);
            if (child == t) continue;
            if (p != null && child.getParents().contains(p)) {
                this.removeInheritanceRelation(child, p);
            }
            DeclTuple myDeclTuple = (DeclTuple)child.getAttrType();
            if (afterAdd) {
                myDeclTuple.refreshParentsAfterAdd();
                continue;
            }
            myDeclTuple.refreshParentsAfterRemove();
        }
    }

    public void refreshInheritance() {
        for (int j = 0; j < this.types.size(); ++j) {
            Type t = this.types.get(j);
            this.refreshInheritanceClan(t);
        }
        this.refreshInheritanceArcs();
    }

    public TypeError removeTypeGraphObject(GraphObject oldObject) {
        Type actType = oldObject.getType();
        if (!actType.removeTypeGraphObject(oldObject)) {
            if (this.typeGraphLevel == 0) {
                return null;
            }
            if (!(oldObject instanceof Arc) || !this.inheritanceArcs.contains((Arc)oldObject)) {
                TypeError error = new TypeError(4, "\nThe type \"" + this.getNameForType(actType) + "\" cannot be deleted from the type graph," + "\nbecause at least one graph object uses it." + "\nPlease disable the type graph before delete a type.", oldObject, actType);
                error.setContainingGraph(this.typeGraph);
                return error;
            }
        }
        return null;
    }

    public Collection checkType(Graph graph) {
        Vector errors = new Vector();
        this.checkTypeSet(graph, errors);
        if (this.typeGraph == null || this.typeGraphLevel == 0) {
            return errors;
        }
        int actTypeGraphLevel = this.typeGraphLevel;
        if (!(this.typeGraphLevel != 30 && this.typeGraphLevel != 40 || graph.isCompleteGraph())) {
            actTypeGraphLevel = 20;
        }
        this.checkTypeGraph(graph, actTypeGraphLevel, errors);
        this.checkNodes(graph, actTypeGraphLevel, errors);
        this.checkArcs(graph, actTypeGraphLevel, errors);
        return errors;
    }

    private Vector checkTypeSet(Graph graph, Vector errors) {
        if (!this.equals(graph.getTypeSet())) {
            GraphObject act;
            Enumeration en = graph.getArcs();
            while (en.hasMoreElements()) {
                act = (GraphObject)en.nextElement();
                if (this.types.contains(act.getType())) continue;
                errors.add(new TypeError(11, "The edge type \"" + this.getNameForType(act.getType()) + "\" used is not part of the grammars type set ( graph \"" + graph.getName() + "\" ).", act.getType()));
            }
            en = graph.getNodes();
            while (en.hasMoreElements()) {
                act = (GraphObject)en.nextElement();
                if (this.types.contains(act.getType())) continue;
                errors.add(new TypeError(11, "The node type \"" + this.getNameForType(act.getType()) + "\" used is not part of the grammars type set ( graph \"" + graph.getName() + "\" ).", act.getType()));
            }
        }
        return errors;
    }

    private TypeError checkMultiplicity(Node n, int currentTypeGraphLevel) {
        TypeError actError = null;
        Type nodeType = n.getType();
        for (int i = 0; i < nodeType.getAllParents().size(); ++i) {
            Type t = (Type)nodeType.getAllParents().get(i);
            int count = 0;
            int minValue = t.getSourceMin();
            int maxValue = t.getSourceMax();
            Vector<Type> clan = this.getClan(t);
            for (Type member : clan) {
                count += ((TypeImpl)member).getTypeGraphNode().getSize(n.getContext());
            }
            if ((currentTypeGraphLevel == 30 || currentTypeGraphLevel == 20) && maxValue > 0 && count > maxValue) {
                actError = new TypeError(25, "Too many nodes of type \"" + this.getNameForType(t) + "\".\nThere are only " + maxValue + " allowed ( graph \"" + n.getContext().getName() + "\" ).", n, t);
                actError.setContainingGraph(n.getContext());
                return actError;
            }
            if (currentTypeGraphLevel != 30 || !n.getContext().isCompleteGraph() || count >= minValue) continue;
            actError = new TypeError(24, "Not enough nodes of type \"" + this.getNameForType(t) + "\".\nThere are at least " + minValue + " needed ( graph \"" + n.getContext().getName() + "\" ).", n, t);
            actError.setContainingGraph(n.getContext());
            return actError;
        }
        return null;
    }

    private Vector checkTypeGraph(Graph graph, int actTypeGraphLevel, Vector errors) {
        TypeError actError = null;
        if (actTypeGraphLevel == 30 || actTypeGraphLevel == 20) {
            Enumeration en = this.typeGraph.getNodes();
            Node actNode = null;
            while (en.hasMoreElements()) {
                actNode = (Node)en.nextElement();
                actError = this.checkMultiplicity(actNode, actTypeGraphLevel);
                if (actError == null) continue;
                errors.add(actError);
            }
            return errors;
        }
        return errors;
    }

    private Vector checkNodes(Graph graph, int actTypeGraphLevel, Vector errors) {
        TypeError actError = null;
        Enumeration en = graph.getNodes();
        while (en.hasMoreElements()) {
            Node actNode = (Node)en.nextElement();
            actError = this.checkTypeInTypeGraph(actNode, actTypeGraphLevel);
            if (actError == null) continue;
            actError.setContainingGraph(graph);
            errors.add(actError);
        }
        return errors;
    }

    private Vector checkArcs(Graph graph, int actTypeGraphLevel, Vector errors) {
        TypeError actError = null;
        Enumeration en = graph.getArcs();
        while (en.hasMoreElements()) {
            Arc actArc = (Arc)en.nextElement();
            actError = this.checkTypeInTypeGraph(actArc, actTypeGraphLevel);
            if (actError == null) continue;
            actError.setContainingGraph(graph);
            errors.add(actError);
        }
        return errors;
    }

    protected Collection checkType(Graph graph, int typeGraphCheckLevel) {
        Vector errors = new Vector();
        if (this.typeGraph == null || typeGraphCheckLevel == 0) {
            return errors;
        }
        int actTypeGraphLevel = typeGraphCheckLevel;
        if (!(typeGraphCheckLevel != 30 && typeGraphCheckLevel != 40 || graph.isCompleteGraph())) {
            actTypeGraphLevel = 20;
        }
        this.checkTypeGraph(graph, actTypeGraphLevel, errors);
        this.checkNodes(graph, actTypeGraphLevel, errors);
        this.checkArcs(graph, actTypeGraphLevel, errors);
        return errors;
    }

    public Collection checkType(Rule rule) {
        Vector errors = new Vector();
        errors.addAll(this.checkType(rule.getOriginal()));
        errors.addAll(this.checkType(rule.getImage()));
        Enumeration nacs = rule.getNACs();
        while (nacs.hasMoreElements()) {
            OrdinaryMorphism actNAC = (OrdinaryMorphism)nacs.nextElement();
            errors.addAll(this.checkType(actNAC.getOriginal()));
            errors.addAll(this.checkType(actNAC.getImage()));
        }
        return errors;
    }

    public Collection checkType(AtomConstraint atomic) {
        Vector errors = new Vector();
        errors.addAll(this.checkType(atomic.getOriginal()));
        Enumeration cons = atomic.getConclusions();
        while (cons.hasMoreElements()) {
            OrdinaryMorphism actCon = (OrdinaryMorphism)cons.nextElement();
            errors.addAll(this.checkType(actCon.getImage()));
        }
        return errors;
    }

    public Collection checkType(OrdinaryMorphism morphism) {
        Vector errors = new Vector();
        errors.addAll(this.checkType(morphism.getOriginal()));
        errors.addAll(this.checkType(morphism.getImage()));
        return errors;
    }

    public TypeError checkType(Arc arc, boolean isComplete) {
        if (this.typeGraphLevel == 0 || this.typeGraphLevel == -1) {
            return null;
        }
        if (!isComplete && this.typeGraphLevel == 30) {
            return this.checkTypeInTypeGraph(arc, 20);
        }
        return this.checkTypeInTypeGraph(arc, this.typeGraphLevel);
    }

    public TypeError checkType(Node node, boolean isComplete) {
        if (this.typeGraphLevel == 0) {
            return null;
        }
        if (!isComplete && this.typeGraphLevel == 30) {
            return this.checkTypeInTypeGraph(node, 20);
        }
        return this.checkTypeInTypeGraph(node, this.typeGraphLevel);
    }

    public TypeError checkType(GraphObject object) {
        if (object instanceof Node) {
            return this.checkType((Node)object, false);
        }
        if (object instanceof Arc) {
            return this.checkType((Arc)object, false);
        }
        return null;
    }

    public Collection setLevelOfTypeGraphCheck(int level) {
        Collection errors;
        if (level != 0 && !this.typeGraphIsProofed && !(errors = this.checkTypeGraph()).isEmpty()) {
            return errors;
        }
        this.typeGraphLevel = level;
        return SUCCESS;
    }

    public int getLevelOfTypeGraphCheck() {
        return this.typeGraphLevel;
    }

    public void disableTypeGraphCheck() {
        this.setLevelOfTypeGraphCheck(0);
    }

    public Collection enableTypeGraphCheck() {
        return this.setLevelOfTypeGraphCheck(20);
    }

    public boolean compareTo(TypeSet ts) {
        if (ts == this) {
            return true;
        }
        Enumeration<Type> e = ts.getTypes();
        Vector<Type> another = new Vector<Type>();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.types.size() != another.size()) {
            return false;
        }
        block1: for (int i = 0; i < this.types.size(); ++i) {
            Type t = this.types.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                Type t1 = (Type)another.elementAt(j);
                if (!t.compareTo(t1)) continue;
                another.remove(t1);
                continue block1;
            }
        }
        if (another.size() != 0) {
            return false;
        }
        if (this.typeGraph == null && ts.getTypeGraph() == null) {
            return true;
        }
        if (this.typeGraph != null && ts.getTypeGraph() == null) {
            return false;
        }
        if (this.typeGraph == null && ts.getTypeGraph() != null) {
            return false;
        }
        return this.typeGraph.compareTo(ts.getTypeGraph());
    }

    public boolean compareTypes(TypeSet ts) {
        return this.compareTypes(ts, new Vector(), new Vector(), new Vector(), new Vector());
    }

    public boolean compareTypes(TypeSet ts, Vector differentAttribute, Vector differentInheritance, Vector differentMultiplicity) {
        return this.compareTypes(ts, differentAttribute, differentInheritance, differentMultiplicity, new Vector());
    }

    public boolean isNewTypeGraphObjectImported() {
        return this.newTypeGraphObjectImported;
    }

    private boolean compareTypes(TypeSet ts, Vector differentAttribute, Vector differentInheritance, Vector differentMultiplicity, Vector typesToAdd) {
        if (ts == this) {
            return true;
        }
        differentInheritance.clear();
        differentAttribute.clear();
        differentMultiplicity.clear();
        typesToAdd.clear();
        boolean conflict = false;
        Vector<Type> another = new Vector<Type>();
        Enumeration<Type> e = ts.getTypes();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        block1: for (int i = 0; i < this.types.size(); ++i) {
            Type t = this.types.elementAt(i);
            for (int j = 0; j < another.size(); ++j) {
                Type t1 = (Type)another.elementAt(j);
                if (!t.getName().equals(t1.getName())) continue;
                if (!t.compareTo(t1)) {
                    if (!differentAttribute.contains(t1)) {
                        differentAttribute.add(t1);
                    }
                    conflict = true;
                }
                if (((TypeImpl)t).getTypeGraphNodeObject() != null && ((TypeImpl)t1).getTypeGraphNodeObject() != null) {
                    if (!t.getParents().isEmpty() && !t1.getParents().isEmpty()) {
                        Vector t1Parents;
                        Type tAncestor = t;
                        Type t1Ancestor = t1;
                        Vector tParents = t.getAllParents();
                        if (!this.compareParents(tParents, t1Parents = t1.getAllParents())) {
                            conflict = true;
                            if (!differentInheritance.contains(t1)) {
                                differentInheritance.add(t1);
                            }
                        }
                    } else if (!t.getParents().isEmpty() || !t1.getParents().isEmpty()) {
                        conflict = true;
                        if (!differentInheritance.contains(t1)) {
                            differentInheritance.add(t1);
                        }
                    }
                    if (((TypeImpl)t1).getTypeGraphNodeObject() != null && ((TypeImpl)t1).getTypeGraphNodeObject() != null) {
                        if (((TypeImpl)t).getSourceMax() != ((TypeImpl)t1).getSourceMax()) {
                            conflict = true;
                            if (!differentMultiplicity.contains(t1)) {
                                differentMultiplicity.add(t1);
                            }
                        } else if (((TypeImpl)t).getSourceMin() != ((TypeImpl)t1).getSourceMin()) {
                            conflict = true;
                            if (!differentMultiplicity.contains(t1)) {
                                differentMultiplicity.add(t1);
                            }
                        }
                    }
                } else if (((TypeImpl)t).hasTypeGraphArc() && ((TypeImpl)t1).hasTypeGraphArc()) {
                    if (!((TypeImpl)t).compareTypeGraphArcs(t1) && !typesToAdd.contains(t1)) {
                        typesToAdd.add(t1);
                    }
                    if (!((TypeImpl)t).compareTypeGraphArcsMultiplicity(t1)) {
                        conflict = true;
                        if (!differentMultiplicity.contains(t1)) {
                            differentMultiplicity.add(t1);
                        }
                    }
                } else if (((TypeImpl)t1).hasTypeGraphNode()) {
                    if (!typesToAdd.contains(t1)) {
                        typesToAdd.add(t1);
                    } else if (((TypeImpl)t1).hasTypeGraphArc() && !typesToAdd.contains(t1)) {
                        typesToAdd.add(t1);
                    }
                }
                another.remove(t1);
                continue block1;
            }
        }
        if (typesToAdd.isEmpty()) {
            for (int j = 0; j < another.size(); ++j) {
                Type t1 = (Type)another.elementAt(j);
                if (!((TypeImpl)t1).hasTypeGraphNode()) continue;
                if (!typesToAdd.contains(t1)) {
                    typesToAdd.add(t1);
                    continue;
                }
                if (!((TypeImpl)t1).hasTypeGraphArc() || typesToAdd.contains(t1)) continue;
                typesToAdd.add(t1);
            }
        }
        this.newTypeGraphObjectImported = !typesToAdd.isEmpty();
        return !conflict;
    }

    private boolean compareParents(Vector<Type> allParents1, Vector<Type> allParents2) {
        int nm = allParents1.size();
        for (int i = 1; i < nm; ++i) {
            Type p2;
            Type p1 = allParents1.get(i);
            if (p1.compareTo(p2 = allParents2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(TypeSet ts) {
        if (ts == this) {
            return true;
        }
        Enumeration<Type> e = ts.getTypes();
        Vector<Type> another = new Vector<Type>();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.types.size() < another.size()) {
            return false;
        }
        block1: for (int i = 0; i < this.types.size(); ++i) {
            Type ti = this.types.elementAt(i);
            for (int j = another.size() - 1; j >= 0; --j) {
                Type tj = (Type)another.elementAt(j);
                if (!ti.compareTo(tj)) continue;
                another.remove(tj);
                continue block1;
            }
        }
        if (another.size() != 0) {
            another.clear();
            another = null;
            return false;
        }
        another = null;
        return this.typeGraph == null || ts.getTypeGraph() == null || this.typeGraph.contains(ts.getTypeGraph());
    }

    public TypeError checkIfRemovable(Node node) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        TypeError error = node.getType().checkIfRemovable(node, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfRemovable(Arc arc) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        GraphObject node = arc.getSource();
        TypeError error = node.getType().checkIfRemovableFromSource(node, arc, this.typeGraphLevel);
        if (error != null) {
            return error;
        }
        node = arc.getTarget();
        error = node.getType().checkIfRemovableFromTarget(node, arc, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfRemovableFromSource(Arc arc) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        GraphObject node = arc.getSource();
        TypeError error = node.getType().checkIfRemovableFromSource(node, arc, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfRemovableFromTarget(Arc arc) {
        if (this.typeGraphLevel != 30) {
            return null;
        }
        GraphObject node = arc.getTarget();
        TypeError error = node.getType().checkIfRemovableFromTarget(node, arc, this.typeGraphLevel);
        return error;
    }

    public TypeError checkIfEdgeCreatable(Type type, Node src, Node tar) {
        if (this.typeGraphLevel == 0 || this.typeGraphLevel == 10) {
            return null;
        }
        return ((TypeImpl)type).checkIfEdgeCreatable(src, tar, this.typeGraphLevel);
    }

    public void showTypeNodes() {
        if (this.typeGraph == null) {
            return;
        }
        Enumeration en = this.typeGraph.getNodes();
        while (en.hasMoreElements()) {
            Node actNode = (Node)en.nextElement();
            TypeImpl t = (TypeImpl)actNode.getType();
            TypeGraphNode tgn = t.getTypeGraphNode();
            tgn.show();
        }
    }
}

