/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.BooleanBuffer;
import com.objectspace.jgl.adapters.BooleanIterator;
import java.util.Enumeration;

public class BooleanArray
extends ArrayAdapter {
    boolean[] array;
    static final long serialVersionUID = 4845979743797699221L;

    public BooleanArray() {
        this(new boolean[0]);
    }

    public BooleanArray(BooleanArray booleanArray) {
        this(booleanArray.array);
    }

    public BooleanArray(BooleanBuffer booleanBuffer) {
        this(booleanBuffer.get());
    }

    public BooleanArray(boolean[] blArray) {
        this.array = blArray;
    }

    public synchronized Object clone() {
        return new BooleanArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "boolean[]");
    }

    public boolean equals(Object object) {
        return object instanceof BooleanArray && this.equals((BooleanArray)object) || object instanceof BooleanBuffer && this.equals((BooleanBuffer)object);
    }

    public boolean equals(BooleanArray booleanArray) {
        return this.equals(booleanArray.array);
    }

    public boolean equals(BooleanBuffer booleanBuffer) {
        return this.equals(booleanBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(boolean[] blArray) {
        boolean[] blArray2 = blArray;
        synchronized (blArray2) {
            if (this.array.length != blArray.length) {
                return false;
            }
            int n = 0;
            while (n < blArray.length) {
                if (this.array[n] != blArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    public boolean[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized BooleanIterator begin() {
        return new BooleanIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized BooleanIterator end() {
        return new BooleanIterator(this, this.array.length);
    }

    public Object at(int n) {
        return new Boolean(this.booleanAt(n));
    }

    public synchronized boolean booleanAt(int n) {
        return this.array[n];
    }

    public void put(int n, Object object) {
        this.put(n, (Boolean)object);
    }

    public synchronized void put(int n, boolean bl) {
        this.array[n] = bl;
    }
}

