/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.ShortArray;
import com.objectspace.jgl.adapters.ShortIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class ShortBuffer
implements Sequence {
    static final short defaultValue = 0;
    short[] storage;
    int length;
    static final long serialVersionUID = -3820709907774768265L;

    public ShortBuffer() {
        this.clear();
    }

    public ShortBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an ShortBuffer with a negative size");
        }
        this.length = n;
        this.storage = new short[this.length];
    }

    public ShortBuffer(int n, short s) {
        this(n);
        int n2 = 0;
        while (n2 < this.length) {
            this.storage[n2] = s;
            ++n2;
        }
    }

    public ShortBuffer(short[] sArray) {
        this(sArray, true);
    }

    ShortBuffer(short[] sArray, boolean bl) {
        short[] sArray2 = sArray;
        synchronized (sArray2) {
            this.length = sArray.length;
            if (bl) {
                this.storage = new short[this.length];
                System.arraycopy(sArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = sArray;
            }
            return;
        }
    }

    public ShortBuffer(ShortBuffer shortBuffer) {
        this(shortBuffer.storage);
    }

    public synchronized Object clone() {
        return new ShortBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof ShortBuffer && this.equals((ShortBuffer)object) || object instanceof ShortArray && this.equals((ShortArray)object);
    }

    public boolean equals(ShortBuffer shortBuffer) {
        return this.equals(new ShortArray(shortBuffer.storage));
    }

    public synchronized boolean equals(ShortArray shortArray) {
        return shortArray.equals(this.storage);
    }

    public boolean equals(short[] sArray) {
        return this.equals(new ShortArray(sArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "ShortBuffer");
    }

    public synchronized void copy(ShortBuffer shortBuffer) {
        if (this == shortBuffer) {
            return;
        }
        ShortBuffer shortBuffer2 = shortBuffer;
        synchronized (shortBuffer2) {
            if (shortBuffer.length > this.storage.length) {
                this.storage = shortBuffer.get();
            } else {
                System.arraycopy(shortBuffer.storage, 0, this.storage, 0, shortBuffer.length);
                int n = shortBuffer.length;
                while (n < this.length) {
                    this.storage[n] = 0;
                    ++n;
                }
            }
            this.length = shortBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(short[] sArray) {
        short[] sArray2 = sArray;
        synchronized (sArray2) {
            System.arraycopy(this.storage, 0, sArray, 0, Math.min(this.length, sArray.length));
            return;
        }
    }

    public synchronized short[] get() {
        short[] sArray = new short[this.length];
        this.copyTo(sArray);
        return sArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n) {
        return new Short(this.shortAt(n));
    }

    public synchronized short shortAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public synchronized void put(int n, Object object) {
        this.put(n, ((Number)object).shortValue());
    }

    public synchronized void put(int n, short s) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = s;
    }

    public synchronized void clear() {
        this.storage = new short[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof ShortIterator)) {
            throw new IllegalArgumentException("Enumeration not an ShortIterator");
        }
        if (((ShortIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this ShortBuffer ");
        }
        Serializable serializable = (ShortIterator)enumeration;
        serializable = new Short(serializable.buffer[serializable.index]);
        this.remove(((ShortIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Short s = new Short(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = 0;
        return s;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof ShortIterator) || !(enumeration2 instanceof ShortIterator)) {
                    throw new IllegalArgumentException("Enumeration not an ShortIterator");
                }
                if (((ShortIterator)enumeration).buffer != this.storage) break block4;
                ShortIterator shortIterator = (ShortIterator)enumeration;
                ShortIterator shortIterator2 = (ShortIterator)enumeration2;
                if (!(shortIterator2 instanceof ShortIterator) || shortIterator.buffer != shortIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((ShortIterator)enumeration).index, ((ShortIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = 0;
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("ShortBuffer is empty");
        }
        Short s = new Short(this.storage[--this.length]);
        this.storage[this.length] = 0;
        return s;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).shortValue());
        return null;
    }

    public synchronized void add(short s) {
        if (this.length == this.storage.length) {
            short[] sArray = this.getNextStorage(1);
            this.copyTo(sArray);
            this.storage = sArray;
        }
        this.storage[this.length++] = s;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).shortValue());
    }

    public void pushBack(short s) {
        this.add(s);
    }

    public ShortIterator insert(ShortIterator shortIterator, Object object) {
        return this.insert(shortIterator, ((Number)object).shortValue());
    }

    public ShortIterator insert(ShortIterator shortIterator, short s) {
        this.insert(shortIterator.index, s);
        return new ShortIterator(this, shortIterator.index);
    }

    public void insert(int n, Object object) {
        this.insert(n, ((Number)object).shortValue());
    }

    public synchronized void insert(int n, short s) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            short[] sArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, sArray, 0, n);
            System.arraycopy(this.storage, n, sArray, n + 1, this.length - n);
            this.storage = sArray;
        }
        this.storage[n] = s;
        ++this.length;
    }

    public void insert(ShortIterator shortIterator, int n, Object object) {
        this.insert(shortIterator, n, ((Number)object).shortValue());
    }

    public void insert(ShortIterator shortIterator, int n, short s) {
        this.insert(shortIterator.index, n, s);
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, ((Number)object).shortValue());
    }

    public synchronized void insert(int n, int n2, short s) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            short[] sArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, sArray, 0, n);
            System.arraycopy(this.storage, n, sArray, n + n2, this.length - n);
            this.storage = sArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.storage[n3] = s;
            ++n3;
        }
        this.length += n2;
    }

    public void insert(ShortIterator shortIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(shortIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            short[] sArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, sArray, 0, n);
            System.arraycopy(this.storage, n, sArray, n + n2, this.length - n);
            this.storage = sArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public synchronized void swap(ShortBuffer shortBuffer) {
        ShortBuffer shortBuffer2 = shortBuffer;
        synchronized (shortBuffer2) {
            int n = this.length;
            short[] sArray = this.storage;
            this.length = shortBuffer.length;
            this.storage = shortBuffer.storage;
            shortBuffer.length = n;
            shortBuffer.storage = sArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized ShortIterator begin() {
        return new ShortIterator(this, 0);
    }

    public synchronized ShortIterator end() {
        return new ShortIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            short[] sArray = new short[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, sArray, 0, this.length);
            }
            this.storage = sArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("ShortBuffer is empty");
        }
        Short s = new Short(this.storage[0]);
        this.remove(0);
        return s;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(short s) {
        this.insert(0, s);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        short s = ((Number)object).shortValue();
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(s);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public synchronized int remove(int n, int n2, Object object) {
        ((Number)object).shortValue();
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        ShortIterator shortIterator = new ShortIterator(this, n);
        ShortIterator shortIterator2 = new ShortIterator(this, n2 + 1);
        ShortIterator shortIterator3 = (ShortIterator)Algorithms.Removing.remove(shortIterator, shortIterator2, object);
        return this.remove(shortIterator3.index, n2);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).shortValue(), ((Number)object2).shortValue());
    }

    public int replace(short s, short s2) {
        return this.replace(0, this.length - 1, s, s2);
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, ((Number)object).shortValue(), ((Number)object2).shortValue());
    }

    public synchronized int replace(int n, int n2, short s, short s2) {
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = 0;
        while (n < n2) {
            if (this.storage[n] == s) {
                this.storage[n] = s2;
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int count(Object object) {
        return this.count(((Number)object).shortValue());
    }

    public int count(short s) {
        return this.count(0, this.length - 1, s);
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, ((Number)object).shortValue());
    }

    public synchronized int count(int n, int n2, short s) {
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = 0;
        while (n < n2) {
            if (this.storage[n] == s) {
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).shortValue());
    }

    public int indexOf(short s) {
        return this.indexOf(0, this.length - 1, s);
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, ((Number)object).shortValue());
    }

    public synchronized int indexOf(int n, int n2, short s) {
        if (n2 < n) {
            return -1;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        while (n < n2) {
            if (this.storage[n] == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
            return;
        }
        if (this.length < n) {
            this.insert(this.length, n - this.length, (short)0);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).shortValue());
    }

    public boolean contains(short s) {
        return this.indexOf(s) != -1;
    }

    private short[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        short[] sArray = new short[n2];
        return sArray;
    }

    static short asShort(Object object) {
        return ((Number)object).shortValue();
    }
}

